/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfTiTi;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import mathematics.metrics.EuclidianSquared;
import mathematics.metrics.Metric;
import tracking.surfTiTi.DetectAndDescribe;
import tracking.surfTiTi.Homography;
import tracking.surfTiTi.IntegralImage;
import tracking.surfTiTi.InterestPoint;
import tracking.surfTiTi.Matcher;
import tracking.surfTiTi.Parameters;

public class Surf {
    private List<InterestPoint> list = null;
    private List<InterestPoint> movielist = null;
    private IntegralImage intimg = null;
    public DetectAndDescribe detdes = null;
    public Matcher matcher = new Matcher();
    private Homography homography = new Homography();
    public Parameters params = null;
    private int nbGlobalPoints = -1;
    public Map<InterestPoint, InterestPoint> matchedPoints = null;
    private double[][] distancespoints = null;
    private Metric metric = new EuclidianSquared();

    public Surf(int order, double sigma) {
        this.detdes = new DetectAndDescribe(order, sigma);
    }

    public Map<InterestPoint, InterestPoint> run(BufferedImage image, int distancesecurity, float descriptorsecurity, boolean reducedlist, boolean doReverseComparison, boolean computehomography) {
        if (this.list == null) {
            throw new IllegalArgumentException("Initialisation or Read method required before use run method.");
        }
        if (this.intimg == null) {
            this.intimg = new IntegralImage(image);
        } else {
            this.intimg.Compute(image);
        }
        this.movielist = this.detdes.detectAndDescribeInterestPoints(this.intimg, this.params, distancesecurity, descriptorsecurity, reducedlist ? this.nbGlobalPoints : 0);
        this.matchedPoints = this.matcher.findMathes(this.list, this.movielist, this.params, doReverseComparison);
        if (computehomography) {
            this.homography.Compute(this.matchedPoints);
        }
        return this.matchedPoints;
    }

    public void Read(InputStream fis) throws Exception {
        int i2;
        Scanner in = new Scanner(fis);
        in.nextInt();
        in.nextInt();
        int order = in.nextInt();
        double sigma = Double.valueOf(in.next());
        int size = in.nextInt();
        this.nbGlobalPoints = in.nextInt();
        in.nextInt();
        in.nextInt();
        this.list = new Vector<InterestPoint>(size);
        for (i2 = 0; i2 < size; ++i2) {
            this.list.add(new InterestPoint(in));
            this.list.get((int)i2).number = i2;
        }
        this.params = new Parameters(in);
        this.distancespoints = new double[size][size];
        i2 = 0;
        while (i2 < this.list.size()) {
            InterestPoint p1 = this.list.get(i2);
            for (int j = i2 + 1; j < this.list.size(); ++j) {
                InterestPoint p2 = this.list.get(j);
                double d = this.metric.Distance((double)p1.x, (double)p1.y, 0.0, (double)p2.x, (double)p2.y, 0.0);
                this.distancespoints[j][i2] = d;
                this.distancespoints[i2][j] = d;
            }
            p1.number = i2++;
        }
        this.detdes = new DetectAndDescribe(order, sigma);
    }
}

