/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfTiTi;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;

public class Parameters {
    public static final String programVersion = "SURF TiTi v2013-02-15";
    private int[][] filterSizes = new int[][]{{9, 15, 21, 27}, {15, 27, 39, 51}, {27, 51, 75, 99}, {51, 99, 147, 195}};
    private int[] maxFilterSizes = new int[]{27, 51, 99, 195};
    private int octaves = 4;
    private int layers = 4;
    private float threshold = 0.005f;
    private int initStep = 2;
    private int stepIncFactor = 2;
    private boolean upright = false;
    private boolean addCoordinates = false;
    private int descSize = -1;
    public int lineWidth = 1;

    public Parameters() {
    }

    public Parameters(int descsize, int octaves, int layers, float threshold, int initStep, int stepIncFactor, boolean upright, boolean addCoordinates, int lineWidth) {
        if (descsize % 4 != 0) {
            throw new IllegalArgumentException("descsize is not a multiple of 4.");
        }
        this.descSize = this.validate(descsize, 4, 64);
        this.octaves = this.validate(octaves, 3, 4);
        this.layers = this.validate(layers, 3, 4);
        this.threshold = this.validate(threshold, 0.0f, 1.0f);
        this.initStep = this.validate(initStep, 1, 6);
        this.stepIncFactor = this.validate(stepIncFactor, 1, 6);
        this.upright = upright;
        this.addCoordinates = addCoordinates;
        if (addCoordinates) {
            this.descSize += 2;
        }
        this.lineWidth = this.validate(lineWidth, 0, 5);
    }

    public Parameters(Parameters p) {
        this(p.descSize, p.octaves, p.layers, p.threshold, p.initStep, p.stepIncFactor, p.upright, p.addCoordinates, p.lineWidth);
    }

    public Parameters(Scanner in) {
        this(in.nextInt(), in.nextInt(), in.nextInt(), Float.valueOf(in.next()).floatValue(), in.nextInt(), in.nextInt(), in.nextBoolean(), in.nextBoolean(), in.nextInt());
    }

    public void Write(DataOutputStream out) throws UnsupportedEncodingException, IOException {
        out.write((this.descSize - (this.addCoordinates ? 2 : 0) + "\t" + this.octaves + "\t" + this.layers + "\t" + this.threshold + "\t" + this.initStep + "\t" + this.stepIncFactor + "\t" + this.upright + "\t" + this.addCoordinates + "\t" + this.lineWidth + "\n").getBytes("ASCII"));
    }

    public String toString() {
        return this.descSize - (this.addCoordinates ? 2 : 0) + "\t" + this.octaves + "\t" + this.layers + "\t" + this.threshold + "\t" + this.initStep + "\t" + this.stepIncFactor + "\t" + this.upright + "\t" + this.addCoordinates + "\t" + this.lineWidth + "\n";
    }

    private float validate(float val, float lowerBound, float upperBound) {
        if (val < lowerBound) {
            return lowerBound;
        }
        if (val > upperBound) {
            return upperBound;
        }
        return val;
    }

    private int validate(int val, int lowerBound, int upperBound) {
        if (val < lowerBound) {
            return lowerBound;
        }
        if (val > upperBound) {
            return upperBound;
        }
        return val;
    }

    public int getOctaves() {
        return this.octaves;
    }

    public int getLayers() {
        return this.layers;
    }

    public int getFilterSize(int octave, int layer) {
        return this.filterSizes[octave][layer];
    }

    public int getMaxFilterSize(int octave) {
        return this.maxFilterSizes[octave];
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public int getInitStep() {
        return this.initStep;
    }

    public int getStepIncFactor() {
        return this.stepIncFactor;
    }

    public boolean isUpright() {
        return this.upright;
    }

    public boolean addCoordinates() {
        return this.addCoordinates;
    }

    public int getDescSize() {
        return this.descSize;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }
}

