/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfTiTi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tracking.surfTiTi.InterestPoint;
import tracking.surfTiTi.Parameters;

public class Matcher {
    private int OriginalMapSize = 500;
    private Map<InterestPoint, InterestPoint> mp = new HashMap<InterestPoint, InterestPoint>(this.OriginalMapSize, 0.75f);
    private Map<InterestPoint, InterestPoint> mprev = new HashMap<InterestPoint, InterestPoint>(this.OriginalMapSize, 0.75f);
    private Map<InterestPoint, InterestPoint> resboth = new HashMap<InterestPoint, InterestPoint>(this.OriginalMapSize, 0.75f);
    public float sensitivity = 0.65f;
    public boolean Reallocate = false;

    public Map<InterestPoint, InterestPoint> findMathes(List<InterestPoint> ipts1, List<InterestPoint> ipts2, Parameters params, boolean doReverseComparison) {
        this.findMatches(ipts1, ipts2, params);
        if (doReverseComparison) {
            this.findReverseMatches(ipts2, ipts1, params);
            this.resboth.clear();
            Iterator<Map.Entry<InterestPoint, InterestPoint>> iter = this.mp.entrySet().iterator();
            Iterator<Map.Entry<InterestPoint, InterestPoint>> iterReverse = null;
            while (iter.hasNext()) {
                Map.Entry<InterestPoint, InterestPoint> entry = iter.next();
                InterestPoint p1 = entry.getKey();
                InterestPoint p2 = entry.getValue();
                boolean found = false;
                iterReverse = this.mprev.entrySet().iterator();
                while (!found && iterReverse.hasNext()) {
                    Map.Entry<InterestPoint, InterestPoint> entryReverse = iterReverse.next();
                    InterestPoint p3 = entryReverse.getKey();
                    InterestPoint p4 = entryReverse.getValue();
                    if (p1.number != p4.number || p2.number != p3.number) continue;
                    this.resboth.put(p1, p2);
                    found = true;
                }
            }
            return this.resboth;
        }
        return this.mp;
    }

    private void findMatches(List<InterestPoint> ipts1, List<InterestPoint> ipts2, Parameters params) {
        InterestPoint p1 = null;
        InterestPoint p2 = null;
        InterestPoint bestMatch = null;
        int descSize = params.getDescSize();
        if (this.Reallocate) {
            this.mp = new HashMap<InterestPoint, InterestPoint>(this.OriginalMapSize, 0.75f);
        } else {
            this.mp.clear();
        }
        for (int x = 0; x < ipts1.size(); ++x) {
            float secondBest = Float.MAX_VALUE;
            float bestDistance = Float.MAX_VALUE;
            bestMatch = null;
            p1 = ipts1.get(x);
            float[] v1 = p1.descriptor;
            for (int y = 0; y < ipts2.size(); ++y) {
                p2 = ipts2.get(y);
                if (p1.sign != p2.sign) continue;
                float distance = 0.0f;
                float[] v2 = p2.descriptor;
                for (int i2 = 0; i2 < descSize; ++i2) {
                    float delta = v1[i2] - v2[i2];
                    if (!(secondBest <= (distance += delta * delta))) continue;
                    i2 = descSize;
                }
                v2 = null;
                if (distance < bestDistance) {
                    secondBest = bestDistance;
                    bestDistance = distance;
                    bestMatch = p2;
                    continue;
                }
                if (!(distance < secondBest)) continue;
                secondBest = distance;
            }
            if (bestDistance < this.sensitivity * secondBest) {
                this.mp.put(p1, bestMatch);
            }
            v1 = null;
        }
    }

    private void findReverseMatches(List<InterestPoint> ipts1, List<InterestPoint> ipts2, Parameters params) {
        InterestPoint p1 = null;
        InterestPoint p2 = null;
        InterestPoint bestMatch = null;
        int descSize = params.getDescSize();
        this.mprev.clear();
        for (int x = 0; x < ipts1.size(); ++x) {
            float secondBest = Float.MAX_VALUE;
            float bestDistance = Float.MAX_VALUE;
            bestMatch = null;
            p1 = ipts1.get(x);
            float[] v1 = p1.descriptor;
            for (int y = 0; y < ipts2.size(); ++y) {
                p2 = ipts2.get(y);
                if (p1.sign != p2.sign) continue;
                float distance = 0.0f;
                float[] v2 = p2.descriptor;
                for (int i2 = 0; i2 < descSize; ++i2) {
                    float delta = v1[i2] - v2[i2];
                    if (!(secondBest <= (distance += delta * delta))) continue;
                    i2 = descSize;
                }
                if (distance < bestDistance) {
                    secondBest = bestDistance;
                    bestDistance = distance;
                    bestMatch = p2;
                    continue;
                }
                if (!(distance < secondBest)) continue;
                secondBest = distance;
            }
            if (!(bestDistance < this.sensitivity * secondBest)) continue;
            this.mprev.put(p1, bestMatch);
        }
    }
}

