/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfTiTi;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class IntegralImage {
    private float[] data = null;
    private int Width;
    private int Height;
    private int Size;
    private int WidthMinus1;
    private int HeightMinus1;

    public IntegralImage() {
    }

    public IntegralImage(BufferedImage image) {
        this.Compute(image);
    }

    public void Compute(BufferedImage image) {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        if (this.data == null || this.data.length != image.getRaster().getDataBuffer().getSize()) {
            this.Size = image.getRaster().getDataBuffer().getSize();
            this.data = null;
            this.data = new float[this.Size];
            this.Width = image.getWidth();
            this.Height = image.getHeight();
            this.WidthMinus1 = this.Width - 1;
            this.HeightMinus1 = this.Height - 1;
        }
        switch (image.getType()) {
            case 10: {
                byte[] srcbyte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < this.Height; ++y) {
                    int x = 0;
                    while (x < this.Width) {
                        int v = srcbyte[pos] & 0xFF;
                        this.data[pos] = v;
                        if ((float)v < min) {
                            min = v;
                        } else if (max < (float)v) {
                            max = v;
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        float scale = 1.0f / (max - min);
        ArrayArithmetic.Subtract((float[])this.data, (float)min, (float[])this.data);
        ArrayComparator.Compare((float[])this.data, (String)">=", (float)0.0f, (float[])this.data, (float)0.0f, (float[])this.data);
        ArrayArithmetic.Multiply((float[])this.data, (float)scale, (float[])this.data);
        ArrayComparator.Compare((float[])this.data, (String)"<=", (float)1.0f, (float[])this.data, (float)1.0f, (float[])this.data);
        this.ComputeIntegralImage();
    }

    private void ComputeIntegralImage() {
        int pos;
        float rowSum = this.data[0];
        for (pos = 1; pos < this.Width; ++pos) {
            this.data[pos] = rowSum += this.data[pos];
        }
        int posprev = 0;
        for (int y = 1; y < this.Height; ++y) {
            rowSum = 0.0f;
            int x = 0;
            while (x < this.Width) {
                this.data[pos] = (rowSum += this.data[pos]) + this.data[posprev];
                ++x;
                ++pos;
                ++posprev;
            }
        }
    }

    public float area(int x, int y, int width, int height) {
        int x2 = --x + width;
        int y2 = --y + height;
        if (this.WidthMinus1 < x) {
            x = this.WidthMinus1;
        }
        if (this.HeightMinus1 < y) {
            y = this.HeightMinus1;
        }
        if (this.WidthMinus1 < x2) {
            x2 = this.WidthMinus1;
        }
        if (this.HeightMinus1 < y2) {
            y2 = this.HeightMinus1;
        }
        float A = x < 0 || y < 0 ? 0.0f : this.data[x + y * this.Width];
        float B = x2 < 0 || y < 0 ? 0.0f : this.data[x2 + y * this.Width];
        float C = x < 0 || y2 < 0 ? 0.0f : this.data[x + y2 * this.Width];
        float D = x2 < 0 || y2 < 0 ? 0.0f : this.data[x2 + y2 * this.Width];
        return D - B - C + A;
    }

    public float areafast(int x, int y, int width, int height) {
        int x2 = --x + width;
        int y2 = --y + height;
        float A = this.data[x + y * this.Width];
        float B = this.data[x2 + y * this.Width];
        float C = this.data[x + y2 * this.Width];
        float D = this.data[x2 + y2 * this.Width];
        return D - B - C + A;
    }

    public float[] getData() {
        return this.data;
    }

    public float get(int x, int y) {
        return this.data[x + y * this.Width];
    }

    public int Width() {
        return this.Width;
    }

    public int Height() {
        return this.Height;
    }

    public int getWidth() {
        return this.Width;
    }

    public int getHeight() {
        return this.Height;
    }
}

