/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfTiTi;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import mathematics.Geometry2D;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import tracking.surfTiTi.InterestPoint;
import tracking.texturetracker.tt_matrix.TT_Matrix;

public class Homography {
    private TT_Matrix Q = new TT_Matrix(3, 3);
    private TT_Matrix P = new TT_Matrix(3, 3);
    private TT_Matrix Q4 = new TT_Matrix(3, 1);
    private TT_Matrix P4 = new TT_Matrix(3, 1);
    private TT_Matrix V = new TT_Matrix(3, 1);
    private TT_Matrix R = new TT_Matrix(3, 1);
    private TT_Matrix W = new TT_Matrix(3, 3);
    private TT_Matrix tmp1_3x3_T = new TT_Matrix(3, 3);
    private TT_Matrix tmp2_3x3_T = new TT_Matrix(3, 3);
    public TT_Matrix corner1;
    public TT_Matrix corner2;
    public TT_Matrix corner3;
    public TT_Matrix corner4;
    private TT_Matrix p = new TT_Matrix(3, 1);
    public int nbHomography = 0;
    public TT_Matrix T = new TT_Matrix(3, 3);
    public Point[] object = new Point3DF[4];
    public Point[] movie = new Point3DF[4];
    private double[] score = null;
    private int[] bestcomb = null;
    private int[][] combinaison = null;

    public void Compute(Map<InterestPoint, InterestPoint> matchedPoints) {
        if (matchedPoints.size() < 4) {
            return;
        }
        ++this.nbHomography;
        int n = 0;
        int nb = 0;
        if (matchedPoints.entrySet().size() > 4) {
            Vector<InterestPoint> l = new Vector<InterestPoint>(113);
            for (Map.Entry<InterestPoint, InterestPoint> pair : matchedPoints.entrySet()) {
                l.add(pair.getValue());
            }
            this.AnglesQuadruples(l);
            for (Map.Entry<InterestPoint, InterestPoint> pair : matchedPoints.entrySet()) {
                if (n == this.bestcomb[nb]) {
                    this.object[nb] = new Point3DF(pair.getKey().xnorm, pair.getKey().ynorm, 1.0);
                    this.movie[nb] = new Point3DF(pair.getValue().x, pair.getValue().y, 1.0);
                    if (++nb == 4) break;
                }
                ++n;
            }
        } else {
            for (Map.Entry<InterestPoint, InterestPoint> pair : matchedPoints.entrySet()) {
                this.object[nb] = new Point3DF(pair.getKey().xnorm, pair.getKey().ynorm, 1.0);
                this.movie[nb] = new Point3DF(pair.getValue().x, pair.getValue().y, 1.0);
                if (++nb != 4) continue;
                break;
            }
        }
        if (!this.CollineationMatrix(this.object, this.movie, this.T)) {
            --this.nbHomography;
            return;
        }
        this.p.set(0, 0, -1.0);
        this.p.set(1, 0, 1.0);
        this.p.set(2, 0, 1.0);
        this.corner1 = this.T.times(this.p);
        this.p.set(0, 0, 1.0);
        this.p.set(1, 0, 1.0);
        this.corner2 = this.T.times(this.p);
        this.p.set(0, 0, 1.0);
        this.p.set(1, 0, -1.0);
        this.corner3 = this.T.times(this.p);
        this.p.set(0, 0, -1.0);
        this.p.set(1, 0, -1.0);
        this.corner4 = this.T.times(this.p);
        this.corner1.set(0, 0, this.corner1.get(0, 0) / this.corner1.get(2, 0));
        this.corner1.set(1, 0, this.corner1.get(1, 0) / this.corner1.get(2, 0));
        this.corner2.set(0, 0, this.corner2.get(0, 0) / this.corner2.get(2, 0));
        this.corner2.set(1, 0, this.corner2.get(1, 0) / this.corner2.get(2, 0));
        this.corner3.set(0, 0, this.corner3.get(0, 0) / this.corner3.get(2, 0));
        this.corner3.set(1, 0, this.corner3.get(1, 0) / this.corner3.get(2, 0));
        this.corner4.set(0, 0, this.corner4.get(0, 0) / this.corner4.get(2, 0));
        this.corner4.set(1, 0, this.corner4.get(1, 0) / this.corner4.get(2, 0));
    }

    private boolean CollineationMatrix(Point[] object, Point[] movie, TT_Matrix T) {
        try {
            TT_Matrix tmp1_3x3 = null;
            TT_Matrix tmp2_3x3 = null;
            for (int i2 = 0; i2 < 3; ++i2) {
                this.Q.set(i2, 0, object[i2].getX());
                this.Q.set(i2, 1, object[i2].getY());
                this.Q.set(i2, 2, object[i2].getZ());
                this.P.set(i2, 0, movie[i2].getX());
                this.P.set(i2, 1, movie[i2].getY());
                this.P.set(i2, 2, movie[i2].getZ());
            }
            this.Q4.set(0, 0, object[3].getX());
            this.Q4.set(1, 0, object[3].getY());
            this.Q4.set(2, 0, object[3].getZ());
            this.P4.set(0, 0, movie[3].getX());
            this.P4.set(1, 0, movie[3].getY());
            this.P4.set(2, 0, movie[3].getZ());
            tmp1_3x3 = this.P.inverse();
            tmp2_3x3 = this.Q.inverse();
            this.Transpose(tmp1_3x3, this.tmp1_3x3_T);
            this.Transpose(tmp2_3x3, this.tmp2_3x3_T);
            this.Multiply(this.tmp1_3x3_T, this.P4, this.V);
            this.Multiply(this.tmp2_3x3_T, this.Q4, this.R);
            this.Identity(this.W);
            double tmp = this.R.get(2, 0) / this.V.get(2, 0);
            this.W.set(0, 0, this.V.get(0, 0) / this.R.get(0, 0) * tmp);
            this.W.set(1, 1, this.V.get(1, 0) / this.R.get(1, 0) * tmp);
            this.Multiply(tmp2_3x3, this.W, tmp1_3x3);
            this.Multiply(tmp1_3x3, this.P, tmp2_3x3);
            this.Transpose(tmp2_3x3, T);
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            return false;
        }
        return true;
    }

    private void AnglesQuadruples(List<InterestPoint> list) {
        int t;
        int z;
        int y;
        int x;
        int nb = 0;
        Point3DF A = new Point3DF();
        Point3DF B = new Point3DF();
        Point3DF C = new Point3DF();
        Point3DF D = new Point3DF();
        for (x = 0; x < list.size() - 3; ++x) {
            for (y = x + 1; y < list.size() - 2; ++y) {
                for (z = y + 1; z < list.size() - 1; ++z) {
                    for (t = z + 1; t < list.size(); ++t) {
                        ++nb;
                    }
                }
            }
        }
        if (this.score == null || this.score.length != nb) {
            this.score = null;
            this.score = new double[nb];
            this.combinaison = null;
            this.combinaison = new int[nb][4];
        }
        nb = 0;
        for (x = 0; x < list.size() - 3; ++x) {
            A.setXYZ(list.get((int)x).x, list.get((int)x).y, 0.0);
            for (y = x + 1; y < list.size() - 2; ++y) {
                B.setXYZ(list.get((int)y).x, list.get((int)y).y, 0.0);
                for (z = y + 1; z < list.size() - 1; ++z) {
                    C.setXYZ(list.get((int)z).x, list.get((int)z).y, 0.0);
                    for (t = z + 1; t < list.size(); ++t) {
                        double a4tmp3;
                        double a4tmp2;
                        double a3tmp3;
                        double a3tmp2;
                        double a2tmp3;
                        double a2tmp2;
                        double a1tmp3;
                        double a1tmp2;
                        D.setXYZ(list.get((int)t).x, list.get((int)t).y, 0.0);
                        this.combinaison[nb][0] = x;
                        this.combinaison[nb][1] = y;
                        this.combinaison[nb][2] = z;
                        this.combinaison[nb][3] = t;
                        double a1tmp1 = Math.abs(Geometry2D.AngleBAC(A, (Point)B, C, true));
                        if (Math.abs(180.0 - a1tmp1) < a1tmp1 || Math.abs(360.0 - a1tmp1) < a1tmp1) {
                            a1tmp1 = Math.min(Math.abs(180.0 - a1tmp1), Math.abs(360.0 - a1tmp1));
                        }
                        if (Math.abs(180.0 - (a1tmp2 = Math.abs(Geometry2D.AngleBAC(B, (Point)A, C, true)))) < a1tmp2 || Math.abs(360.0 - a1tmp2) < a1tmp2) {
                            a1tmp2 = Math.min(Math.abs(180.0 - a1tmp2), Math.abs(360.0 - a1tmp2));
                        }
                        if (Math.abs(180.0 - (a1tmp3 = Math.abs(Geometry2D.AngleBAC(A, (Point)C, B, true)))) < a1tmp3 || Math.abs(360.0 - a1tmp3) < a1tmp3) {
                            a1tmp3 = Math.min(Math.abs(180.0 - a1tmp3), Math.abs(360.0 - a1tmp3));
                        }
                        double a1 = Math.min(a1tmp1, Math.min(a1tmp2, a1tmp3));
                        double a2tmp1 = Math.abs(Geometry2D.AngleBAC(A, (Point)B, D, true));
                        if (Math.abs(180.0 - a2tmp1) < a2tmp1 || Math.abs(360.0 - a2tmp1) < a2tmp1) {
                            a2tmp1 = Math.min(Math.abs(180.0 - a2tmp1), Math.abs(360.0 - a2tmp1));
                        }
                        if (Math.abs(180.0 - (a2tmp2 = Math.abs(Geometry2D.AngleBAC(B, (Point)A, D, true)))) < a2tmp2 || Math.abs(360.0 - a2tmp2) < a2tmp2) {
                            a2tmp2 = Math.min(Math.abs(180.0 - a2tmp2), Math.abs(360.0 - a2tmp2));
                        }
                        if (Math.abs(180.0 - (a2tmp3 = Math.abs(Geometry2D.AngleBAC(A, (Point)D, B, true)))) < a2tmp3 || Math.abs(360.0 - a2tmp3) < a2tmp3) {
                            a2tmp3 = Math.min(Math.abs(180.0 - a2tmp3), Math.abs(360.0 - a2tmp3));
                        }
                        double a2 = Math.min(a2tmp1, Math.min(a2tmp2, a2tmp3));
                        double a3tmp1 = Math.abs(Geometry2D.AngleBAC(A, (Point)C, D, true));
                        if (Math.abs(180.0 - a3tmp1) < a3tmp1 || Math.abs(360.0 - a3tmp1) < a3tmp1) {
                            a3tmp1 = Math.min(Math.abs(180.0 - a3tmp1), Math.abs(360.0 - a3tmp1));
                        }
                        if (Math.abs(180.0 - (a3tmp2 = Math.abs(Geometry2D.AngleBAC(C, (Point)A, D, true)))) < a3tmp2 || Math.abs(360.0 - a3tmp2) < a3tmp2) {
                            a3tmp2 = Math.min(Math.abs(180.0 - a3tmp2), Math.abs(360.0 - a3tmp2));
                        }
                        if (Math.abs(180.0 - (a3tmp3 = Math.abs(Geometry2D.AngleBAC(A, (Point)D, C, true)))) < a3tmp3 || Math.abs(360.0 - a3tmp3) < a3tmp3) {
                            a3tmp3 = Math.min(Math.abs(180.0 - a3tmp3), Math.abs(360.0 - a3tmp3));
                        }
                        double a3 = Math.min(a3tmp1, Math.min(a3tmp2, a3tmp3));
                        double a4tmp1 = Math.abs(Geometry2D.AngleBAC(B, (Point)C, D, true));
                        if (Math.abs(180.0 - a4tmp1) < a4tmp1 || Math.abs(360.0 - a4tmp1) < a4tmp1) {
                            a4tmp1 = Math.min(Math.abs(180.0 - a4tmp1), Math.abs(360.0 - a4tmp1));
                        }
                        if (Math.abs(180.0 - (a4tmp2 = Math.abs(Geometry2D.AngleBAC(C, (Point)B, D, true)))) < a4tmp2 || Math.abs(360.0 - a4tmp2) < a4tmp2) {
                            a4tmp2 = Math.min(Math.abs(180.0 - a4tmp2), Math.abs(360.0 - a4tmp2));
                        }
                        if (Math.abs(180.0 - (a4tmp3 = Math.abs(Geometry2D.AngleBAC(B, (Point)D, C, true)))) < a4tmp3 || Math.abs(360.0 - a4tmp3) < a4tmp3) {
                            a4tmp3 = Math.min(Math.abs(180.0 - a4tmp3), Math.abs(360.0 - a4tmp3));
                        }
                        double a4 = Math.min(a4tmp1, Math.min(a4tmp2, a4tmp3));
                        this.score[nb++] = Math.min(Math.min(a1, a2), Math.min(a3, a4));
                    }
                }
            }
        }
        int best = 0;
        for (x = 1; x < nb; ++x) {
            if (!(this.score[best] < this.score[x])) continue;
            best = x;
        }
        this.bestcomb = this.combinaison[best];
    }

    public void computeNormalisedCoordinates(InterestPoint img, float width, float height) {
        img.xnorm = 2.0f * img.x / width - 1.0f;
        img.ynorm = 2.0f * img.y / height - 1.0f;
    }

    private void Multiply(TT_Matrix m1, TT_Matrix m2, TT_Matrix result) {
        for (int i2 = 0; i2 < result.getRowDimension(); ++i2) {
            for (int j = 0; j < result.getColumnDimension(); ++j) {
                double res = 0.0;
                for (int k = 0; k < m1.getColumnDimension(); ++k) {
                    res += m1.get(i2, k) * m2.get(k, j);
                }
                result.set(i2, j, res);
            }
        }
    }

    private void Identity(TT_Matrix m) {
        for (int i2 = 0; i2 < m.getRowDimension(); ++i2) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                m.set(i2, j, i2 == j ? 1.0 : 0.0);
            }
        }
    }

    private void Transpose(TT_Matrix m, TT_Matrix res) {
        for (int i2 = 0; i2 < m.getRowDimension(); ++i2) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                res.set(i2, j, m.get(j, i2));
            }
        }
    }
}

