/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfTiTi;

import Jama.Matrix;
import displays.Colors;
import ij.process.ImageProcessor;
import imageTiTi.ImageDrawer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mathematics.primitives.pointsTiTi.Point;
import tracking.surfTiTi.Detection;
import tracking.surfTiTi.InterestPoint;
import tracking.surfTiTi.Parameters;

public class Drawer {
    private ImageDrawer imdraw = new ImageDrawer();

    public void drawInterestPoints(BufferedImage img, List<InterestPoint> ipts, Parameters params, float[] pointcolor, float[] orientationcolor) {
        for (InterestPoint ipt : ipts) {
            this.drawInterestPoint(img, params, ipt, pointcolor, orientationcolor);
        }
    }

    public void drawInterestPoint(BufferedImage img, Parameters p, InterestPoint ipt, float[] pointcolor, float[] orientationcolor) {
        int order = p.getLineWidth();
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        if (orientationcolor != null) {
            float ori = ipt.orientation;
            float co = (float)Math.cos(ori);
            float si = (float)Math.sin(ori);
            float s = ipt.strength * 10000.0f;
            ImageDrawer.Line(img, x, y, Math.round(s * co + (float)x), Math.round(s * si + (float)y), order, orientationcolor);
        }
        ImageDrawer.Point(img, x, y, order + 1, pointcolor);
    }

    public void drawMatching(BufferedImage img, Parameters p, Map<InterestPoint, InterestPoint> matching, boolean reverse, float[] pointcolorsrc, float[] pointcolordest, float[] orientationcolor, float[] linecolor) {
        Set<Map.Entry<InterestPoint, InterestPoint>> set = matching.entrySet();
        for (Map.Entry<InterestPoint, InterestPoint> couple : set) {
            if (reverse) {
                this.drawMatching(img, p, couple.getValue(), couple.getKey(), pointcolordest, pointcolorsrc, orientationcolor, linecolor);
            } else {
                this.drawMatching(img, p, couple.getKey(), couple.getValue(), pointcolorsrc, pointcolordest, orientationcolor, linecolor);
            }
            couple = null;
        }
        Iterator<Map.Entry<InterestPoint, InterestPoint>> couples = null;
        set = null;
    }

    public void drawMatching(BufferedImage img, Parameters p, InterestPoint ipsrc, InterestPoint ipdest, float[] pointcolorsrc, float[] pointcolordest, float[] orientationcolor, float[] linecolor) {
        int order = p.getLineWidth();
        int x = Math.round(ipsrc.x);
        int y = Math.round(ipsrc.y);
        int gapx = Math.round(ipdest.x - ipsrc.x);
        int gapy = Math.round(ipdest.y - ipsrc.y);
        this.drawInterestPoint(img, p, ipsrc, pointcolorsrc, orientationcolor);
        this.drawInterestPoint(img, p, ipdest, pointcolordest, orientationcolor);
        ImageDrawer.Line(img, x, y, x + gapx, y + gapy, order - 1 < 0 ? 0 : order - 1, linecolor);
    }

    public void drawPoint(BufferedImage img, Parameters p, Point ipt, float[] color) {
        int order = p.getLineWidth();
        int x = (int)Math.round(ipt.getX());
        int y = (int)Math.round(ipt.getY());
        ImageDrawer.Point(img, x, y, order, color);
    }

    public void drawLine(BufferedImage img, Parameters p, Matrix ipt1, Matrix ipt2) {
        int order = p.getLineWidth();
        int x1 = (int)Math.round(ipt1.get(0, 0));
        int y1 = (int)Math.round(ipt1.get(0, 1));
        int x2 = (int)Math.round(ipt2.get(0, 0));
        int y2 = (int)Math.round(ipt2.get(0, 1));
        ImageDrawer.Line(img, x1, y1, x2, y2, order, Colors.GREEN);
    }

    public void drawLine2(BufferedImage img, Parameters p, Matrix ipt1, Matrix ipt2, float[] color) {
        int order = p.getLineWidth();
        int x1 = (int)Math.round(ipt1.get(0, 0));
        int y1 = (int)Math.round(ipt1.get(1, 0));
        int x2 = (int)Math.round(ipt2.get(0, 0));
        int y2 = (int)Math.round(ipt2.get(1, 0));
        ImageDrawer.Line(img, x1, y1, x2, y2, order, color);
    }

    public void drawSingleInterestPoint(ImageProcessor img, InterestPoint ipt, boolean orientation) {
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        float ori = ipt.orientation;
        float co = (float)Math.cos(ori);
        float si = (float)Math.sin(ori);
        float s = ipt.strength * 10000.0f;
        img.setLineWidth(1);
        img.setColor(Color.yellow);
        img.drawLine(x, y, Math.round(s * co + (float)x), Math.round(s * si + (float)y));
        img.setLineWidth(3);
        if (ipt.sign) {
            img.setColor(Color.red);
        } else {
            img.setColor(Color.blue);
        }
        img.drawDot(x, y);
    }

    public void drawResearchWindow(BufferedImage img, Parameters p, Detection detector) {
        ImageDrawer.Line(img, detector.startx, detector.starty, detector.endx, detector.starty, p.getLineWidth(), Colors.PURPLE);
        ImageDrawer.Line(img, detector.endx, detector.starty, detector.endx, detector.endy, p.getLineWidth(), Colors.PURPLE);
        ImageDrawer.Line(img, detector.endx, detector.endy, detector.startx, detector.endy, p.getLineWidth(), Colors.PURPLE);
        ImageDrawer.Line(img, detector.startx, detector.endy, detector.startx, detector.starty, p.getLineWidth(), Colors.PURPLE);
    }
}

