/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfTiTi;

import java.util.ArrayList;
import java.util.List;
import mathematics.metrics.EuclidianSquared;
import mathematics.metrics.Metric;
import tracking.surfTiTi.IntegralImage;
import tracking.surfTiTi.InterestPoint;
import tracking.surfTiTi.Parameters;

public class Detection {
    private float[][][] det = null;
    private float[][][] trace = null;
    public int startx;
    public int starty;
    public int endx;
    public int endy;
    private static Metric metric = new EuclidianSquared();
    public int DetectionLimit = 2500;
    public float cste = 0.13333334f;
    private float[][] A = new float[3][3];

    public List<InterestPoint> fastHessian(IntegralImage img, Parameters p, int securitydistance) {
        if (this.det == null || this.det.length != p.getLayers() || this.det[0].length != img.Width() || this.det[0][0].length != img.Height()) {
            this.det = new float[p.getLayers()][img.Width()][img.Height()];
            this.trace = new float[p.getLayers()][img.Width()][img.Height()];
            this.starty = 0;
            this.startx = 0;
            this.endx = img.Width();
            this.endy = img.Height();
        }
        ArrayList<InterestPoint> res = new ArrayList<InterestPoint>(500);
        float[] X = new float[3];
        int nb = 0;
        int octave = 0;
        int step = p.getInitStep();
        while (octave < p.getOctaves()) {
            int x;
            int y;
            int layer;
            int margin = p.getMaxFilterSize(octave) >> 1;
            int marginx = this.startx + margin;
            int marginy = this.starty + margin;
            int xBound = this.endx - margin;
            int yBound = this.endy - margin;
            for (layer = 0; layer < p.getLayers(); ++layer) {
                int w = p.getFilterSize(octave, layer);
                int L = w / 3;
                int L2 = (L << 1) - 1;
                int wHalf = w >> 1;
                int LHalf = L >> 1;
                int Lminus1 = L - 1;
                float filterArea = w * w;
                for (y = marginy; y < yBound; y += step) {
                    for (x = marginx; x < xBound; x += step) {
                        float Dxx = img.area(x - wHalf, y - Lminus1, w, L2) - img.area(x - LHalf, y - Lminus1, L, L2) * 3.0f;
                        float Dyy = img.area(x - Lminus1, y - wHalf, L2, w) - img.area(x - Lminus1, y - LHalf, L2, L) * 3.0f;
                        float Dxy = img.area(x - L, y - L, L, L) - img.area(x + 1, y - L, L, L) + img.area(x + 1, y + 1, L, L) - img.area(x - L, y + 1, L, L);
                        this.det[layer][x][y] = (Dxx /= filterArea) * (Dyy /= filterArea) - 0.81f * (Dxy /= filterArea) * Dxy;
                        this.trace[layer][x][y] = Dxx + Dyy;
                    }
                }
            }
            margin += step;
            xBound -= step;
            yBound -= step;
            for (layer = 1; layer < p.getLayers() - 1; ++layer) {
                int filterSize = p.getFilterSize(octave, layer);
                int filterSizeIncrement = filterSize - p.getFilterSize(octave, layer - 1);
                for (y = marginy; y < yBound; y += step) {
                    for (x = marginx; x < xBound; x += step) {
                        float v = this.det[layer][x][y];
                        if (v < p.getThreshold() || !this.isLocalMaximum(v, this.det, layer, x, y, step) || !this.interpolatePoint(this.det, layer, x, y, step, X)) continue;
                        float xInterp = (float)x + X[0] * (float)step;
                        float yInterp = (float)y + X[1] * (float)step;
                        float scale = ((float)filterSize + X[2] * (float)filterSizeIncrement) * this.cste;
                        if (!(scale >= 1.0f) || !(0.0f <= xInterp) || !(xInterp < (float)img.Width()) || !(0.0f <= yInterp) || !(yInterp < (float)img.Height())) continue;
                        res.add(new InterestPoint(p.getDescSize(), xInterp, yInterp, this.det[layer][x][y], this.trace[layer][x][y], scale, nb++));
                    }
                }
            }
            ++octave;
            step *= p.getStepIncFactor();
        }
        System.out.println("original size = " + res.size());
        if (0 < this.DetectionLimit) {
            this.DeleteRandomly(res);
        }
        if (0 < securitydistance) {
            Detection.DeleteCloseInterestPointDistance(res, securitydistance);
        }
        return res;
    }

    public void DeleteRandomly(List<InterestPoint> list) {
        while (this.DetectionLimit < list.size()) {
            list.remove((int)(Math.random() * (double)list.size()));
        }
    }

    public static void DeleteCloseInterestPointDistance(List<InterestPoint> list, double security) {
        for (int x = 0; x < list.size() - 1; ++x) {
            InterestPoint px = list.get(x);
            int y = x + 1;
            while (y < list.size()) {
                InterestPoint py = list.get(y);
                if (metric.Distance((double)px.x, (double)px.y, 0.0, (double)py.x, (double)py.y, 0.0) < security) {
                    if (px.strength < py.strength) {
                        list.remove(x);
                        y = x + 1;
                        px = list.get(x);
                    } else {
                        list.remove(y);
                    }
                } else {
                    ++y;
                }
                py = null;
            }
            px = null;
        }
    }

    private boolean isLocalMaximum(float v, float[][][] det, int s, int x, int y, int step) {
        float[][] l = det[s - 1];
        float[][] m = det[s];
        float[][] u = det[s + 1];
        int px = x - step;
        int nx = x + step;
        int py = y - step;
        int ny = y + step;
        return v >= l[px][py] && v >= l[px][y] && v >= l[px][ny] && v >= l[x][py] && v >= l[x][y] && v >= l[x][ny] && v >= l[nx][py] && v >= l[nx][y] && v >= l[nx][ny] && v >= m[px][py] && v >= m[px][y] && v >= m[px][ny] && v >= m[x][py] && v >= m[x][ny] && v >= m[nx][py] && v >= m[nx][y] && v >= m[nx][ny] && v >= u[px][py] && v >= u[px][y] && v >= u[px][ny] && v >= u[x][py] && v >= u[x][y] && v >= u[x][ny] && v >= u[nx][py] && v >= u[nx][y] && v >= u[nx][ny];
    }

    private boolean interpolatePoint(float[][][] det, int i2, int x, int y, int step, float[] X) {
        float[][] l = det[i2 - 1];
        float[][] m = det[i2];
        float[][] u = det[i2 + 1];
        int px = x - step;
        int nx = x + step;
        int py = y - step;
        int ny = y + step;
        float dx = -(m[nx][y] - m[px][y]) / 2.0f;
        float dy = -(m[x][ny] - m[x][py]) / 2.0f;
        float ds = -(u[x][y] - l[x][y]) / 2.0f;
        float[] b = new float[]{dx, dy, ds};
        float v2 = 2.0f * m[x][y];
        float dxx = m[px][y] - v2 + m[nx][y];
        float dxy = (m[nx][ny] - m[px][ny] - m[nx][py] + m[px][py]) / 4.0f;
        float dxs = (u[nx][y] - u[px][y] - l[nx][y] + l[px][y]) / 4.0f;
        float dyx = dxy;
        float dyy = m[x][py] - v2 + m[x][ny];
        float dys = (u[x][ny] - u[x][py] - l[x][ny] + l[x][py]) / 4.0f;
        float dsx = dxs;
        float dsy = dys;
        float dss = l[x][y] - v2 + u[x][y];
        this.A[0][0] = dxx;
        this.A[0][1] = dxy;
        this.A[0][2] = dxs;
        this.A[1][0] = dyx;
        this.A[1][1] = dyy;
        this.A[1][2] = dys;
        this.A[2][0] = dsx;
        this.A[2][1] = dsy;
        this.A[2][2] = dss;
        return this.solve(this.A, b, X);
    }

    public boolean solve(float[][] A, float[] B, float[] X) {
        float a = A[0][0];
        float b = A[0][1];
        float c = A[0][2];
        float d = A[1][0];
        float e = A[1][1];
        float f = A[1][2];
        float g = A[2][0];
        float h = A[2][1];
        float i2 = A[2][2];
        float r = B[0];
        float s = B[1];
        float t = B[2];
        float detA = this.det(a, b, c, d, e, f, g, h, i2);
        if (Float.compare(detA, 0.0f) == 0) {
            return false;
        }
        float detX1 = this.det(r, b, c, s, e, f, t, h, i2);
        float detX2 = this.det(a, r, c, d, s, f, g, t, i2);
        float detX3 = this.det(a, b, r, d, e, s, g, h, t);
        X[0] = detX1 / detA;
        X[1] = detX2 / detA;
        X[2] = detX3 / detA;
        return true;
    }

    private float det(float a, float b, float c, float d, float e, float f, float g, float h, float i2) {
        return a * (e * i2 - f * h) + b * (f * g - d * i2) + c * (d * h - e * g);
    }
}

