/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfTiTi;

import java.util.List;
import java.util.PriorityQueue;
import mathematics.metrics.EuclidianSquared;
import mathematics.metrics.Metric;
import tracking.surfTiTi.Description;
import tracking.surfTiTi.Detection;
import tracking.surfTiTi.IntegralImage;
import tracking.surfTiTi.InterestPoint;
import tracking.surfTiTi.Parameters;

public class DetectAndDescribe {
    public Description descriptor = null;
    public Detection detector = null;
    private static Metric metric = new EuclidianSquared();
    private PriorityQueue<InterestPoint> queue = new PriorityQueue(1000);

    public DetectAndDescribe(int order, double sigma) {
        this.descriptor = new Description(order, sigma);
        this.detector = new Detection();
    }

    public List<InterestPoint> detectAndDescribeInterestPoints(IntegralImage intImg, Parameters p) {
        return this.detectAndDescribeInterestPoints(intImg, p, 0, 0.0f, 0);
    }

    public List<InterestPoint> detectAndDescribeInterestPoints(IntegralImage intImg, Parameters p, int securitydistance, float securitycharacteristics, int reducedlist) {
        List<InterestPoint> ipts = this.detector.fastHessian(intImg, p, securitydistance);
        if (!p.isUpright()) {
            for (InterestPoint ipt : ipts) {
                this.descriptor.computeAndSetOrientation(ipt, intImg);
            }
        }
        for (InterestPoint ipt : ipts) {
            this.descriptor.computeAndSetDescriptor(ipt, intImg, p);
        }
        if (0.0f < securitycharacteristics) {
            DetectAndDescribe.DeleteCloseInterestPointCharacteristics(ipts, securitycharacteristics);
        }
        if (0 < reducedlist) {
            this.ReducedList(ipts, reducedlist);
        }
        return ipts;
    }

    public static void DeleteCloseInterestPointCharacteristics(List<InterestPoint> list, double security) {
        for (int x = 0; x < list.size() - 1; ++x) {
            InterestPoint px = list.get(x);
            int y = x + 1;
            while (y < list.size()) {
                InterestPoint py = list.get(y);
                if (metric.Distance(px.descriptor, py.descriptor) < security) {
                    if (px.strength < py.strength) {
                        list.remove(x);
                        y = x + 1;
                        px = list.get(x);
                        continue;
                    }
                    list.remove(y);
                    continue;
                }
                ++y;
            }
        }
    }

    private void ReducedList(List<InterestPoint> list, int size) {
        int i2;
        if (list.size() <= size) {
            return;
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            this.queue.add(list.get(i2));
        }
        list.clear();
        for (i2 = 0; i2 < size; ++i2) {
            list.add(this.queue.poll());
        }
        this.queue.clear();
    }
}

