/*
 * Decompiled with CFR 0.152.
 */
package tracking.surfTiTi;

import arrayTiTi.ArrayArithmetic;
import tracking.surfTiTi.IntegralImage;
import tracking.surfTiTi.InterestPoint;
import tracking.surfTiTi.Parameters;

public class Description {
    private final float pi = (float)Math.PI;
    private final float pipi = (float)Math.PI * 2;
    private int order = -1;
    private int squareorder = -1;
    private float[][] gaussmask = null;
    private int[] id = null;
    private int[] orderdx = null;
    private int[] orderdy = null;
    private float[] resX = null;
    private float[] resY = null;
    private float[] Ang = null;
    private float[] exp = new float[10000];
    private float[] arctan = new float[10000];

    public Description(int order, double sigma) {
        int dy;
        int dx;
        if (order < 1) {
            throw new IllegalArgumentException("order < 1");
        }
        this.order = order;
        this.squareorder = order * order;
        this.id = new int[(order << 1) + 1];
        for (int i2 = 0; i2 <= order; ++i2) {
            int n = i2;
            this.id[order - i2] = n;
            this.id[order + i2] = n;
        }
        int size = 0;
        for (dx = -order; dx <= order; ++dx) {
            for (dy = -order; dy <= order; ++dy) {
                if (dx * dx + dy * dy >= this.squareorder) continue;
                ++size;
            }
        }
        this.resX = new float[size];
        this.resY = new float[size];
        this.Ang = new float[size];
        this.orderdx = new int[size];
        this.orderdy = new int[size];
        size = 0;
        for (dx = -order; dx <= order; ++dx) {
            for (dy = -order; dy <= order; ++dy) {
                if (dx * dx + dy * dy >= this.squareorder) continue;
                this.orderdx[size] = dx;
                this.orderdy[size++] = dy;
            }
        }
        this.CreateMask(order, sigma);
        for (int i3 = 0; i3 < this.exp.length; ++i3) {
            this.exp[i3] = (float)Math.exp(-((double)i3) / 1000.0);
            this.arctan[i3] = (float)Math.atan((double)i3 / 1000.0);
        }
    }

    public void computeAndSetDescriptor(InterestPoint ipt, IntegralImage intImg, Parameters p) {
        float si;
        float co;
        if (p.isUpright()) {
            co = 1.0f;
            si = 0.0f;
        } else {
            co = (float)Math.cos(ipt.orientation);
            si = (float)Math.sin(ipt.orientation);
        }
        int count = 0;
        float[] desc = ipt.descriptor;
        int ix = 0;
        int jx = 0;
        int xs = 0;
        int ys = 0;
        float gauss_s1 = 0.0f;
        float gauss_s2 = 0.0f;
        float rx = 0.0f;
        float ry = 0.0f;
        float rrx = 0.0f;
        float rry = 0.0f;
        float len = 0.0f;
        float scale = ipt.scale;
        float scale25 = 2.5f * scale;
        int scale2 = Math.round(scale) << 1;
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        int j = 0;
        float cx = -0.5f;
        float cy = 0.0f;
        for (int i2 = -8; i2 < 12; i2 += 9) {
            i2 -= 4;
            cx += 1.0f;
            cy = -0.5f;
            for (j = -8; j < 12; j += 9) {
                float mdy = 0.0f;
                float mdx = 0.0f;
                float dy = 0.0f;
                float dx = 0.0f;
                cy += 1.0f;
                ix = i2 + 5;
                jx = (j -= 4) + 5;
                xs = Math.round((float)x + scale * ((float)(-jx) * si + (float)ix * co));
                ys = Math.round((float)y + scale * ((float)jx * co + (float)ix * si));
                int i9 = i2 + 9;
                int j9 = j + 9;
                for (int k = i2; k < i9; ++k) {
                    for (int l = j; l < j9; ++l) {
                        int sample_x = Math.round((float)x + scale * ((float)(-l) * si + (float)k * co));
                        int sample_y = Math.round((float)y + scale * ((float)l * co + (float)k * si));
                        gauss_s1 = this.gaussian(xs - sample_x, ys - sample_y, scale25);
                        rx = this.haarX(intImg, sample_x, sample_y, scale2);
                        ry = this.haarY(intImg, sample_x, sample_y, scale2);
                        rrx = gauss_s1 * (-rx * si + ry * co);
                        rry = gauss_s1 * (rx * co + ry * si);
                        dx += rrx;
                        dy += rry;
                        mdx += Math.abs(rrx);
                        mdy += Math.abs(rry);
                    }
                }
                gauss_s2 = this.gaussian(cx - 2.0f, cy - 2.0f, 1.5f);
                desc[count++] = dx * gauss_s2;
                desc[count++] = dy * gauss_s2;
                desc[count++] = mdx * gauss_s2;
                desc[count++] = mdy * gauss_s2;
                len += (dx * dx + dy * dy + mdx * mdx + mdy * mdy) * gauss_s2 * gauss_s2;
                if (count < p.getDescSize()) continue;
            }
        }
        len = (float)Math.sqrt(len);
        ArrayArithmetic.Divide((float[])desc, (float)len, (float[])desc);
        if (p.addCoordinates()) {
            desc[count++] = ipt.x / (float)intImg.Width();
            desc[count++] = ipt.y / (float)intImg.Height();
        }
        desc = null;
    }

    public void computeAndSetOrientation(InterestPoint ipt, IntegralImage intImg) {
        int x = Math.round(ipt.x);
        int y = Math.round(ipt.y);
        int s = Math.round(ipt.scale);
        int waveletSize = 4 * s;
        float gauss = 0.0f;
        for (int i2 = 0; i2 < this.orderdx.length; ++i2) {
            int dx = this.orderdx[i2];
            int dy = this.orderdy[i2];
            gauss = this.gaussmask[this.id[dx + this.order]][this.id[dy + this.order]];
            this.resX[i2] = gauss * this.haarX(intImg, x + dx * s, y + dy * s, waveletSize);
            this.resY[i2] = gauss * this.haarY(intImg, x + dx * s, y + dy * s, waveletSize);
            this.Ang[i2] = this.getAngle(this.resX[i2], this.resY[i2]);
        }
        float windowSize = 1.0471976f;
        float step = 0.15f;
        float sumX = 0.0f;
        float sumY = 0.0f;
        float current = 0.0f;
        float max = 0.0f;
        float orientation = 0.0f;
        float ang1 = 0.0f;
        float ang2 = ang1 + 1.0471976f;
        while (ang1 < (float)Math.PI * 2) {
            sumY = 0.0f;
            sumX = 0.0f;
            for (int k = 0; k < this.Ang.length; ++k) {
                if (!(ang1 <= this.Ang[k] && this.Ang[k] < ang2) && (!(ang1 <= this.Ang[k] + (float)Math.PI * 2) || !(this.Ang[k] + (float)Math.PI * 2 < ang2))) continue;
                sumX += this.resX[k];
                sumY += this.resY[k];
            }
            current = sumX * sumX + sumY * sumY;
            if (current > max) {
                max = current;
                orientation = this.getAngle(sumX, sumY);
            }
            ang1 += 0.15f;
            ang2 += 0.15f;
        }
        ipt.orientation = orientation;
    }

    private float gaussian(float x, float y, float sig) {
        float s = 2.0f * sig * sig;
        int n = (int)((x * x + y * y) / s * 1000.0f);
        if (n >= this.exp.length) {
            return 0.0f;
        }
        return this.exp[n] / ((float)Math.PI * s);
    }

    private float haarX(IntegralImage img, int x, int y, int w) {
        int wHalf = w >> 1;
        return img.area(x, y - wHalf, wHalf, w) - img.area(x - wHalf, y - wHalf, wHalf, w);
    }

    private float haarY(IntegralImage img, int x, int y, int w) {
        int wHalf = w >> 1;
        return img.area(x - wHalf, y, w, wHalf) - img.area(x - wHalf, y - wHalf, w, wHalf);
    }

    private float getAngle(float x, float y) {
        if (Math.abs(y / x * 1000.0f) >= (float)this.arctan.length) {
            if (x >= 0.0f && y >= 0.0f) {
                return 1.5707964f;
            }
            if (x < 0.0f && y >= 0.0f) {
                return 1.5707964f;
            }
            if (x < 0.0f && y < 0.0f) {
                return 4.712389f;
            }
            if (x >= 0.0f && y < 0.0f) {
                return 4.712389f;
            }
            return 0.0f;
        }
        if (x >= 0.0f && y >= 0.0f) {
            return this.arctan[(int)(y / x * 1000.0f)];
        }
        if (x < 0.0f && y >= 0.0f) {
            return (float)Math.PI - this.arctan[-((int)(y / x * 1000.0f))];
        }
        if (x < 0.0f && y < 0.0f) {
            return (float)Math.PI + this.arctan[(int)(y / x * 1000.0f)];
        }
        if (x >= 0.0f && y < 0.0f) {
            return (float)Math.PI * 2 - this.arctan[(int)(-y / x * 1000.0f)];
        }
        return 0.0f;
    }

    public void CreateMask(int radius, double sigma) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Bad value of radius: " + radius);
        }
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Bad value of sigma: " + sigma);
        }
        double Sum2 = 0.0;
        double div = 2.0 * sigma * sigma;
        this.gaussmask = new float[2 * radius + 1][2 * radius + 1];
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                double d2 = (double)(y * y + x * x) / div;
                double Val = Math.exp(-d2);
                this.gaussmask[y + radius][x + radius] = (float)Val;
                Sum2 += Val;
            }
        }
        ArrayArithmetic.Divide((float[][])this.gaussmask, (float)((float)Sum2), (float[][])this.gaussmask);
    }
}

