/*
 * Decompiled with CFR 0.152.
 */
package stackTiTi;

import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;

public final class StackTools {
    public static boolean isOkay(BufferedImage[] stack) {
        for (int i2 = 1; i2 < stack.length; ++i2) {
            if (ImageTools.areDimensionsAndTypeEqual((BufferedImage)stack[0], (BufferedImage)stack[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean areDimensionsAndTypeEqual(BufferedImage[] im1, BufferedImage[] im2) {
        if (!StackTools.isOkay(im1)) {
            return false;
        }
        if (!StackTools.isOkay(im2)) {
            return false;
        }
        if (im1.length != im2.length) {
            return false;
        }
        if (im1[0].getType() != im2[0].getType()) {
            return false;
        }
        return im1[0].getType() != 0 || im1[0].getRaster().getDataBuffer().getDataType() == im2[0].getRaster().getDataBuffer().getDataType();
    }

    public static boolean areDimensionsEqual(BufferedImage[] im1, BufferedImage[] im2) {
        for (int i2 = 0; i2 < im1.length; ++i2) {
            if (ImageTools.areDimensionsEqual((BufferedImage)im1[i2], (BufferedImage)im2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(BufferedImage[] stack1, BufferedImage[] stack2) {
        if (stack1.length != stack2.length) {
            return false;
        }
        for (int i2 = 0; i2 < stack1.length; ++i2) {
            if (ImageTools.areEqual((BufferedImage)stack1[i2], (BufferedImage)stack2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlack(BufferedImage[] stack) {
        for (int i2 = 0; i2 < stack.length; ++i2) {
            if (ImageTools.isBlack((BufferedImage)stack[i2])) continue;
            return false;
        }
        return true;
    }
}

