/*
 * Decompiled with CFR 0.152.
 */
package stackTiTi;

import imageTiTi.ImageOperations;
import imageTiTi.ImageTransformations;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import stackTiTi.StackNew;
import stackTiTi.StackTools;

public final class StackOperations {
    public static BufferedImage[] Differences(BufferedImage[] stack1, BufferedImage[] stack2) {
        BufferedImage[] result = StackNew.Same(stack1);
        StackOperations.Differences(stack1, stack2, result);
        return result;
    }

    public static void Differences(BufferedImage[] stack1, BufferedImage[] stack2, BufferedImage[] result) {
        if (stack1.length != stack2.length) {
            throw new IllegalArgumentException("Stacks have different number of images.");
        }
        for (int i2 = 0; i2 < stack1.length; ++i2) {
            ImageOperations.Differences((BufferedImage)stack1[i2], (BufferedImage)stack2[i2], (BufferedImage)result[i2]);
        }
    }

    public static BufferedImage[] RotateX090(BufferedImage[] stack) {
        BufferedImage[] result = StackNew.New(stack[0].getWidth(), stack.length, stack[0].getHeight(), stack[0].getType());
        StackOperations.RotateX090(stack, result);
        return result;
    }

    public static void RotateX090(BufferedImage[] stack, BufferedImage[] result) {
        int sizex = stack[0].getWidth();
        int sizey = stack[0].getHeight();
        int sizez = stack.length;
        if (sizex != result[0].getWidth() || sizey != result.length || sizez != result[0].getHeight()) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        block0 : switch (stack[0].getType()) {
            case 10: {
                int posr = 0;
                int z = 0;
                while (z < sizez) {
                    byte[] bbstack = ((DataBufferByte)stack[z].getRaster().getDataBuffer()).getData();
                    int poss = 0;
                    int y = 0;
                    while (y < sizey) {
                        byte[] bbres = ((DataBufferByte)result[sizey - 1 - y].getRaster().getDataBuffer()).getData();
                        System.arraycopy(bbstack, poss, bbres, posr, sizex);
                        bbres = null;
                        ++y;
                        poss += sizex;
                    }
                    bbstack = null;
                    ++z;
                    posr += sizex;
                }
                break;
            }
            case 11: {
                int posr = 0;
                int z = 0;
                while (z < sizez) {
                    short[] sbstack = ((DataBufferUShort)stack[z].getRaster().getDataBuffer()).getData();
                    int poss = 0;
                    int y = 0;
                    while (y < sizey) {
                        short[] sbres = ((DataBufferUShort)result[sizey - 1 - y].getRaster().getDataBuffer()).getData();
                        System.arraycopy(sbstack, poss, sbres, posr, sizex);
                        sbres = null;
                        ++y;
                        poss += sizex;
                    }
                    sbstack = null;
                    ++z;
                    posr += sizex;
                }
                break;
            }
            case 0: {
                switch (stack[0].getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int posr = 0;
                        int z = 0;
                        while (z < sizez) {
                            int[] ibstack = ((DataBufferInt)stack[z].getRaster().getDataBuffer()).getData();
                            int poss = 0;
                            int y = 0;
                            while (y < sizey) {
                                int[] ibres = ((DataBufferInt)result[sizey - 1 - y].getRaster().getDataBuffer()).getData();
                                System.arraycopy(ibstack, poss, ibres, posr, sizex);
                                ibres = null;
                                ++y;
                                poss += sizex;
                            }
                            ibstack = null;
                            ++z;
                            posr += sizex;
                        }
                        break block0;
                    }
                    case 4: {
                        int posr = 0;
                        int z = 0;
                        while (z < sizez) {
                            float[] fbstack = ((DataBufferFloat)stack[z].getRaster().getDataBuffer()).getData();
                            int poss = 0;
                            int y = 0;
                            while (y < sizey) {
                                float[] fbres = ((DataBufferFloat)result[sizey - 1 - y].getRaster().getDataBuffer()).getData();
                                System.arraycopy(fbstack, poss, fbres, posr, sizex);
                                fbres = null;
                                ++y;
                                poss += sizex;
                            }
                            fbstack = null;
                            ++z;
                            posr += sizex;
                        }
                        break block0;
                    }
                    case 5: {
                        int posr = 0;
                        int z = 0;
                        while (z < sizez) {
                            double[] dbstack = ((DataBufferDouble)stack[z].getRaster().getDataBuffer()).getData();
                            int poss = 0;
                            int y = 0;
                            while (y < sizey) {
                                double[] dbres = ((DataBufferDouble)result[sizey - 1 - y].getRaster().getDataBuffer()).getData();
                                System.arraycopy(dbstack, poss, dbres, posr, sizex);
                                dbres = null;
                                ++y;
                                poss += sizex;
                            }
                            dbstack = null;
                            ++z;
                            posr += sizex;
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("DataBuffer type not supported.");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage[] RotateX180(BufferedImage[] stack) {
        BufferedImage[] result = StackNew.Same(stack);
        StackOperations.RotateX180(stack, result);
        return result;
    }

    public static void RotateX180(BufferedImage[] stack, BufferedImage[] result) {
        int sizex = stack[0].getWidth();
        int sizey = stack[0].getHeight();
        int sizez = stack.length;
        if (!StackTools.areDimensionsAndTypeEqual(stack, result)) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        block0 : switch (stack[0].getType()) {
            case 10: {
                for (int z = 0; z < sizez; ++z) {
                    byte[] bbstack = ((DataBufferByte)stack[z].getRaster().getDataBuffer()).getData();
                    byte[] bbres = ((DataBufferByte)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                    int poss = 0;
                    int y = 0;
                    int posr = bbres.length - sizex;
                    while (y < sizey) {
                        System.arraycopy(bbstack, poss, bbres, posr, sizex);
                        ++y;
                        poss += sizex;
                        posr -= sizex;
                    }
                    bbres = null;
                    bbstack = null;
                }
                break;
            }
            case 11: {
                for (int z = 0; z < sizez; ++z) {
                    short[] sbstack = ((DataBufferUShort)stack[z].getRaster().getDataBuffer()).getData();
                    short[] sbres = ((DataBufferUShort)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                    int poss = 0;
                    int y = 0;
                    int posr = sbres.length - sizex;
                    while (y < sizey) {
                        System.arraycopy(sbstack, poss, sbres, posr, sizex);
                        ++y;
                        poss += sizex;
                        posr -= sizex;
                    }
                    sbres = null;
                    sbstack = null;
                }
                break;
            }
            case 0: {
                switch (stack[0].getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        for (int z = 0; z < sizez; ++z) {
                            int[] ibstack = ((DataBufferInt)stack[z].getRaster().getDataBuffer()).getData();
                            int[] ibres = ((DataBufferInt)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                            int poss = 0;
                            int y = 0;
                            int posr = ibres.length - sizex;
                            while (y < sizey) {
                                System.arraycopy(ibstack, poss, ibres, posr, sizex);
                                ++y;
                                poss += sizex;
                                posr -= sizex;
                            }
                            ibres = null;
                            ibstack = null;
                        }
                        break block0;
                    }
                    case 4: {
                        for (int z = 0; z < sizez; ++z) {
                            float[] fbstack = ((DataBufferFloat)stack[z].getRaster().getDataBuffer()).getData();
                            float[] fbres = ((DataBufferFloat)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                            int poss = 0;
                            int y = 0;
                            int posr = fbres.length - sizex;
                            while (y < sizey) {
                                System.arraycopy(fbstack, poss, fbres, posr, sizex);
                                ++y;
                                poss += sizex;
                                posr -= sizex;
                            }
                            fbres = null;
                            fbstack = null;
                        }
                        break block0;
                    }
                    case 5: {
                        for (int z = 0; z < sizez; ++z) {
                            double[] dbstack = ((DataBufferDouble)stack[z].getRaster().getDataBuffer()).getData();
                            double[] dbres = ((DataBufferDouble)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                            int poss = 0;
                            int y = 0;
                            int posr = dbres.length - sizex;
                            while (y < sizey) {
                                System.arraycopy(dbstack, poss, dbres, posr, sizex);
                                ++y;
                                poss += sizex;
                                posr -= sizex;
                            }
                            dbres = null;
                            dbstack = null;
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("DataBuffer type not supported.");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage[] RotateX270(BufferedImage[] stack) {
        BufferedImage[] result = StackNew.New(stack[0].getWidth(), stack.length, stack[0].getHeight(), stack[0].getType());
        StackOperations.RotateX270(stack, result);
        return result;
    }

    public static void RotateX270(BufferedImage[] stack, BufferedImage[] result) {
        int sizex = stack[0].getWidth();
        int sizey = stack[0].getHeight();
        int sizez = stack.length;
        if (sizex != result[0].getWidth() || sizey != result.length || sizez != result[0].getHeight()) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        block0 : switch (stack[0].getType()) {
            case 10: {
                int z = 0;
                int posr = sizex * sizez - sizex;
                while (z < sizez) {
                    byte[] bbstack = ((DataBufferByte)stack[z].getRaster().getDataBuffer()).getData();
                    int y = 0;
                    int poss = 0;
                    while (y < sizey) {
                        byte[] bbres = ((DataBufferByte)result[y].getRaster().getDataBuffer()).getData();
                        System.arraycopy(bbstack, poss, bbres, posr, sizex);
                        bbres = null;
                        ++y;
                        poss += sizex;
                    }
                    bbstack = null;
                    ++z;
                    posr -= sizex;
                }
                break;
            }
            case 11: {
                int z = 0;
                int posr = sizex * sizez - sizex;
                while (z < sizez) {
                    short[] sbstack = ((DataBufferUShort)stack[z].getRaster().getDataBuffer()).getData();
                    int y = 0;
                    int poss = 0;
                    while (y < sizey) {
                        short[] sbres = ((DataBufferUShort)result[y].getRaster().getDataBuffer()).getData();
                        System.arraycopy(sbstack, poss, sbres, posr, sizex);
                        sbres = null;
                        ++y;
                        poss += sizex;
                    }
                    sbstack = null;
                    ++z;
                    posr -= sizex;
                }
                break;
            }
            case 0: {
                switch (stack[0].getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int z = 0;
                        int posr = sizex * sizez - sizex;
                        while (z < sizez) {
                            int[] ibstack = ((DataBufferInt)stack[z].getRaster().getDataBuffer()).getData();
                            int y = 0;
                            int poss = 0;
                            while (y < sizey) {
                                int[] ibres = ((DataBufferInt)result[y].getRaster().getDataBuffer()).getData();
                                System.arraycopy(ibstack, poss, ibres, posr, sizex);
                                ibres = null;
                                ++y;
                                poss += sizex;
                            }
                            ibstack = null;
                            ++z;
                            posr -= sizex;
                        }
                        break block0;
                    }
                    case 4: {
                        int z = 0;
                        int posr = sizex * sizez - sizex;
                        while (z < sizez) {
                            float[] fbstack = ((DataBufferFloat)stack[z].getRaster().getDataBuffer()).getData();
                            int y = 0;
                            int poss = 0;
                            while (y < sizey) {
                                float[] fbres = ((DataBufferFloat)result[y].getRaster().getDataBuffer()).getData();
                                System.arraycopy(fbstack, poss, fbres, posr, sizex);
                                fbres = null;
                                ++y;
                                poss += sizex;
                            }
                            fbstack = null;
                            ++z;
                            posr -= sizex;
                        }
                        break block0;
                    }
                    case 5: {
                        int z = 0;
                        int posr = sizex * sizez - sizex;
                        while (z < sizez) {
                            double[] dbstack = ((DataBufferDouble)stack[z].getRaster().getDataBuffer()).getData();
                            int y = 0;
                            int poss = 0;
                            while (y < sizey) {
                                double[] dbres = ((DataBufferDouble)result[y].getRaster().getDataBuffer()).getData();
                                System.arraycopy(dbstack, poss, dbres, posr, sizex);
                                dbres = null;
                                ++y;
                                poss += sizex;
                            }
                            dbstack = null;
                            ++z;
                            posr -= sizex;
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("DataBuffer type not supported.");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage[] RotateY090(BufferedImage[] stack) {
        BufferedImage[] result = StackNew.New(stack.length, stack[0].getHeight(), stack[0].getWidth(), stack[0].getType());
        StackOperations.RotateY090(stack, result);
        return result;
    }

    public static void RotateY090(BufferedImage[] stack, BufferedImage[] result) {
        int sizex = stack[0].getWidth();
        int sizey = stack[0].getHeight();
        int sizez = stack.length;
        if (sizex != result.length || sizey != result[0].getHeight() || sizez != result[0].getWidth()) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        block0 : switch (stack[0].getType()) {
            case 10: {
                for (int z = 0; z < sizez; ++z) {
                    byte[] bbstack = ((DataBufferByte)stack[z].getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < sizex; ++x) {
                        byte[] bbres = ((DataBufferByte)result[sizex - 1 - x].getRaster().getDataBuffer()).getData();
                        int y = 0;
                        int poss = x;
                        int posr = z;
                        while (y < sizey) {
                            bbres[posr] = bbstack[poss];
                            ++y;
                            poss += sizex;
                            posr += sizez;
                        }
                        bbres = null;
                    }
                    bbstack = null;
                }
                break;
            }
            case 11: {
                for (int z = 0; z < sizez; ++z) {
                    short[] sbstack = ((DataBufferUShort)stack[z].getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < sizex; ++x) {
                        short[] sbres = ((DataBufferUShort)result[sizex - 1 - x].getRaster().getDataBuffer()).getData();
                        int y = 0;
                        int poss = x;
                        int posr = z;
                        while (y < sizey) {
                            sbres[posr] = sbstack[poss];
                            ++y;
                            poss += sizex;
                            posr += sizez;
                        }
                        sbres = null;
                    }
                    sbstack = null;
                }
                break;
            }
            case 0: {
                switch (stack[0].getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        for (int z = 0; z < sizez; ++z) {
                            int[] ibstack = ((DataBufferInt)stack[z].getRaster().getDataBuffer()).getData();
                            for (int x = 0; x < sizex; ++x) {
                                int[] ibres = ((DataBufferInt)result[sizex - 1 - x].getRaster().getDataBuffer()).getData();
                                int y = 0;
                                int poss = x;
                                int posr = z;
                                while (y < sizey) {
                                    ibres[posr] = ibstack[poss];
                                    ++y;
                                    poss += sizex;
                                    posr += sizez;
                                }
                                ibres = null;
                            }
                            ibstack = null;
                        }
                        break block0;
                    }
                    case 4: {
                        for (int z = 0; z < sizez; ++z) {
                            float[] fbstack = ((DataBufferFloat)stack[z].getRaster().getDataBuffer()).getData();
                            for (int x = 0; x < sizex; ++x) {
                                float[] fbres = ((DataBufferFloat)result[sizex - 1 - x].getRaster().getDataBuffer()).getData();
                                int y = 0;
                                int poss = x;
                                int posr = z;
                                while (y < sizey) {
                                    fbres[posr] = fbstack[poss];
                                    ++y;
                                    poss += sizex;
                                    posr += sizez;
                                }
                                fbres = null;
                            }
                            fbstack = null;
                        }
                        break block0;
                    }
                    case 5: {
                        for (int z = 0; z < sizez; ++z) {
                            double[] dbstack = ((DataBufferDouble)stack[z].getRaster().getDataBuffer()).getData();
                            for (int x = 0; x < sizex; ++x) {
                                double[] dbres = ((DataBufferDouble)result[sizex - 1 - x].getRaster().getDataBuffer()).getData();
                                int y = 0;
                                int poss = x;
                                int posr = z;
                                while (y < sizey) {
                                    dbres[posr] = dbstack[poss];
                                    ++y;
                                    poss += sizex;
                                    posr += sizez;
                                }
                                dbres = null;
                            }
                            dbstack = null;
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("DataBuffer type not supported.");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage[] RotateY180(BufferedImage[] stack) {
        BufferedImage[] result = StackNew.Same(stack);
        StackOperations.RotateY180(stack, result);
        return result;
    }

    public static void RotateY180(BufferedImage[] stack, BufferedImage[] result) {
        int sizex = stack[0].getWidth();
        int sizey = stack[0].getHeight();
        int sizez = stack.length;
        if (!StackTools.areDimensionsAndTypeEqual(stack, result)) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        block0 : switch (stack[0].getType()) {
            case 10: {
                for (int z = 0; z < sizez; ++z) {
                    byte[] bbstack = ((DataBufferByte)stack[z].getRaster().getDataBuffer()).getData();
                    byte[] bbres = ((DataBufferByte)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                    int poss = 0;
                    for (int y = 0; y < sizey; ++y) {
                        int x = 0;
                        int posr = poss + sizex - 1;
                        while (x < sizex) {
                            bbres[posr] = bbstack[poss++];
                            ++x;
                            --posr;
                        }
                    }
                    bbres = null;
                    bbstack = null;
                }
                break;
            }
            case 11: {
                for (int z = 0; z < sizez; ++z) {
                    short[] sbstack = ((DataBufferUShort)stack[z].getRaster().getDataBuffer()).getData();
                    short[] sbres = ((DataBufferUShort)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                    int poss = 0;
                    for (int y = 0; y < sizey; ++y) {
                        int x = 0;
                        int posr = poss + sizex - 1;
                        while (x < sizex) {
                            sbres[posr] = sbstack[poss++];
                            ++x;
                            --posr;
                        }
                    }
                    sbres = null;
                    sbstack = null;
                }
                break;
            }
            case 0: {
                switch (stack[0].getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        for (int z = 0; z < sizez; ++z) {
                            int[] ibstack = ((DataBufferInt)stack[z].getRaster().getDataBuffer()).getData();
                            int[] ibres = ((DataBufferInt)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                            int poss = 0;
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                int posr = poss + sizex - 1;
                                while (x < sizex) {
                                    ibres[posr] = ibstack[poss++];
                                    ++x;
                                    --posr;
                                }
                            }
                            ibres = null;
                            ibstack = null;
                        }
                        break block0;
                    }
                    case 4: {
                        for (int z = 0; z < sizez; ++z) {
                            float[] fbstack = ((DataBufferFloat)stack[z].getRaster().getDataBuffer()).getData();
                            float[] fbres = ((DataBufferFloat)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                            int poss = 0;
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                int posr = poss + sizex - 1;
                                while (x < sizex) {
                                    fbres[posr] = fbstack[poss++];
                                    ++x;
                                    --posr;
                                }
                            }
                            fbres = null;
                            fbstack = null;
                        }
                        break block0;
                    }
                    case 5: {
                        for (int z = 0; z < sizez; ++z) {
                            double[] dbstack = ((DataBufferDouble)stack[z].getRaster().getDataBuffer()).getData();
                            double[] dbres = ((DataBufferDouble)result[sizez - 1 - z].getRaster().getDataBuffer()).getData();
                            int poss = 0;
                            for (int y = 0; y < sizey; ++y) {
                                int x = 0;
                                int posr = poss + sizex - 1;
                                while (x < sizex) {
                                    dbres[posr] = dbstack[poss++];
                                    ++x;
                                    --posr;
                                }
                            }
                            dbres = null;
                            dbstack = null;
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("DataBuffer type not supported.");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage[] RotateY270(BufferedImage[] stack) {
        BufferedImage[] result = StackNew.New(stack.length, stack[0].getHeight(), stack[0].getWidth(), stack[0].getType());
        StackOperations.RotateY270(stack, result);
        return result;
    }

    public static void RotateY270(BufferedImage[] stack, BufferedImage[] result) {
        int sizex = stack[0].getWidth();
        int sizey = stack[0].getHeight();
        int sizez = stack.length;
        if (sizex != result.length || sizey != result[0].getHeight() || sizez != result[0].getWidth()) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        block0 : switch (stack[0].getType()) {
            case 10: {
                for (int z = 0; z < sizez; ++z) {
                    byte[] bbstack = ((DataBufferByte)stack[z].getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < sizex; ++x) {
                        byte[] bbres = ((DataBufferByte)result[x].getRaster().getDataBuffer()).getData();
                        int y = 0;
                        int poss = x;
                        int posr = sizez - 1 - z;
                        while (y < sizey) {
                            bbres[posr] = bbstack[poss];
                            ++y;
                            poss += sizex;
                            posr += sizez;
                        }
                        bbres = null;
                    }
                    bbstack = null;
                }
                break;
            }
            case 11: {
                for (int z = 0; z < sizez; ++z) {
                    short[] sbstack = ((DataBufferUShort)stack[z].getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < sizex; ++x) {
                        short[] sbres = ((DataBufferUShort)result[x].getRaster().getDataBuffer()).getData();
                        int y = 0;
                        int poss = x;
                        int posr = sizez - 1 - z;
                        while (y < sizey) {
                            sbres[posr] = sbstack[poss];
                            ++y;
                            poss += sizex;
                            posr += sizez;
                        }
                        sbres = null;
                    }
                    sbstack = null;
                }
                break;
            }
            case 0: {
                switch (stack[0].getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        for (int z = 0; z < sizez; ++z) {
                            int[] ibstack = ((DataBufferInt)stack[z].getRaster().getDataBuffer()).getData();
                            for (int x = 0; x < sizex; ++x) {
                                int[] ibres = ((DataBufferInt)result[x].getRaster().getDataBuffer()).getData();
                                int y = 0;
                                int poss = x;
                                int posr = sizez - 1 - z;
                                while (y < sizey) {
                                    ibres[posr] = ibstack[poss];
                                    ++y;
                                    poss += sizex;
                                    posr += sizez;
                                }
                                ibres = null;
                            }
                            ibstack = null;
                        }
                        break block0;
                    }
                    case 4: {
                        for (int z = 0; z < sizez; ++z) {
                            float[] fbstack = ((DataBufferFloat)stack[z].getRaster().getDataBuffer()).getData();
                            for (int x = 0; x < sizex; ++x) {
                                float[] fbres = ((DataBufferFloat)result[x].getRaster().getDataBuffer()).getData();
                                int y = 0;
                                int poss = x;
                                int posr = sizez - 1 - z;
                                while (y < sizey) {
                                    fbres[posr] = fbstack[poss];
                                    ++y;
                                    poss += sizex;
                                    posr += sizez;
                                }
                                fbres = null;
                            }
                            fbstack = null;
                        }
                        break block0;
                    }
                    case 5: {
                        for (int z = 0; z < sizez; ++z) {
                            double[] dbstack = ((DataBufferDouble)stack[z].getRaster().getDataBuffer()).getData();
                            for (int x = 0; x < sizex; ++x) {
                                double[] dbres = ((DataBufferDouble)result[x].getRaster().getDataBuffer()).getData();
                                int y = 0;
                                int poss = x;
                                int posr = sizez - 1 - z;
                                while (y < sizey) {
                                    dbres[posr] = dbstack[poss];
                                    ++y;
                                    poss += sizex;
                                    posr += sizez;
                                }
                                dbres = null;
                            }
                            dbstack = null;
                        }
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("DataBuffer type not supported.");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage[] RotateZ090(BufferedImage[] stack) {
        BufferedImage[] result = StackNew.New(stack[0].getHeight(), stack[0].getWidth(), stack.length, stack[0].getType());
        StackOperations.RotateZ090(stack, result);
        return result;
    }

    public static void RotateZ090(BufferedImage[] stack, BufferedImage[] result) {
        for (int z = 0; z < stack.length; ++z) {
            ImageTransformations.Rotate90(stack[z], result[z]);
        }
    }

    public static BufferedImage[] RotateZ180(BufferedImage[] stack) {
        BufferedImage[] result = StackNew.New(stack[0].getWidth(), stack[0].getHeight(), stack.length, stack[0].getType());
        StackOperations.RotateZ180(stack, result);
        return result;
    }

    public static void RotateZ180(BufferedImage[] stack, BufferedImage[] result) {
        for (int z = 0; z < stack.length; ++z) {
            ImageTransformations.Rotate180(stack[z], result[z]);
        }
    }

    public static BufferedImage[] RotateZ270(BufferedImage[] stack) {
        BufferedImage[] result = StackNew.New(stack[0].getHeight(), stack[0].getWidth(), stack.length, stack[0].getType());
        StackOperations.RotateZ270(stack, result);
        return result;
    }

    public static void RotateZ270(BufferedImage[] stack, BufferedImage[] result) {
        for (int z = 0; z < stack.length; ++z) {
            ImageTransformations.Rotate270(stack[z], result[z]);
        }
    }

    public static BufferedImage[] Contour2D(BufferedImage[] stack, boolean EightConnex) {
        BufferedImage[] result = StackNew.Same(stack);
        StackOperations.Contour2D(stack, EightConnex, result);
        return result;
    }

    public static void Contour2D(BufferedImage[] stack, boolean EightConnex, BufferedImage[] result) {
        if (stack.length != result.length) {
            throw new IllegalArgumentException("source.length != result.length");
        }
        for (int i2 = 0; i2 < stack.length; ++i2) {
            ImageOperations.Contour((BufferedImage)stack[i2], (boolean)EightConnex, (BufferedImage)result[i2]);
        }
    }
}

