/*
 * Decompiled with CFR 0.152.
 */
package stackTiTi;

import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;

public final class StackNew {
    public static BufferedImage[] New(int SizeX, int SizeY, int SizeZ, int Type2) {
        BufferedImage[] stack = new BufferedImage[SizeZ];
        for (int z = 0; z < SizeZ; ++z) {
            stack[z] = new BufferedImage(SizeX, SizeY, Type2);
        }
        return stack;
    }

    public static BufferedImage[] New(BufferedImage image, int SizeZ) {
        BufferedImage[] stack = new BufferedImage[SizeZ];
        for (int z = 0; z < SizeZ; ++z) {
            stack[z] = ImageNew.Same((BufferedImage)image);
        }
        return stack;
    }

    public static BufferedImage[] Clone(BufferedImage[] src) {
        BufferedImage[] results = new BufferedImage[src.length];
        for (int i2 = 0; i2 < src.length; ++i2) {
            results[i2] = ImageNew.Clone((BufferedImage)src[i2]);
        }
        return results;
    }

    public static void Copy(BufferedImage[] sources, BufferedImage[] destinations) {
        if (sources.length != destinations.length) {
            throw new IllegalArgumentException("Stacks have different numbers of images.");
        }
        for (int i2 = 0; i2 < sources.length; ++i2) {
            ImageNew.Copy((BufferedImage)sources[i2], (BufferedImage)destinations[i2]);
        }
    }

    public static BufferedImage[] Same(BufferedImage[] src) {
        BufferedImage[] same = new BufferedImage[src.length];
        for (int i2 = 0; i2 < src.length; ++i2) {
            same[i2] = ImageNew.Same((BufferedImage)src[i2]);
        }
        return same;
    }

    public static BufferedImage[] Same(BufferedImage[] src, int type) {
        BufferedImage[] same = new BufferedImage[src.length];
        for (int i2 = 0; i2 < src.length; ++i2) {
            same[i2] = ImageNew.Same((BufferedImage)src[i2], (int)type);
        }
        return same;
    }

    public static BufferedImage[] Same(int width, int height, int depth, BufferedImage[] src) {
        BufferedImage[] same = new BufferedImage[depth];
        for (int i2 = 0; i2 < src.length; ++i2) {
            same[i2] = ImageNew.Same((int)width, (int)height, (BufferedImage)src[i2]);
        }
        return same;
    }

    public static BufferedImage[] SameFloat(BufferedImage[] src) {
        BufferedImage[] same = new BufferedImage[src.length];
        for (int i2 = 0; i2 < src.length; ++i2) {
            same[i2] = ImageNew.SameFloat((BufferedImage)src[i2]);
        }
        return same;
    }

    public static BufferedImage[] SameDouble(BufferedImage[] src) {
        BufferedImage[] same = new BufferedImage[src.length];
        for (int i2 = 0; i2 < src.length; ++i2) {
            same[i2] = ImageNew.SameDouble((BufferedImage)src[i2]);
        }
        return same;
    }

    public static BufferedImage[] SameInteger(BufferedImage[] src) {
        BufferedImage[] same = new BufferedImage[src.length];
        for (int i2 = 0; i2 < src.length; ++i2) {
            same[i2] = ImageNew.SameInteger((BufferedImage)src[i2]);
        }
        return same;
    }

    public static BufferedImage[] SubStack(BufferedImage[] source, int MinX, int MinY, int MinZ, int MaxX, int MaxY, int MaxZ) {
        BufferedImage[] result = StackNew.New(MaxX - MinX + 1, MaxY - MinY + 1, MaxZ - MinZ + 1, source[0].getType());
        StackNew.SubStack(source, MinX, MinY, MinZ, MaxX, MaxY, MaxZ, result);
        return result;
    }

    public static void SubStack(BufferedImage[] source, int MinX, int MinY, int MinZ, int MaxX, int MaxY, int MaxZ, BufferedImage[] result) {
        StackNew.SubStackWHD(source, MinX, MinY, MinZ, MaxX - MinX + 1, MaxY - MinY + 1, MaxZ - MinZ + 1, result);
    }

    public static BufferedImage[] SubStackWHD(BufferedImage[] source, int StartX, int StartY, int StartZ, int Width, int Height, int Depth) {
        BufferedImage[] result = StackNew.Same(Width, Height, Depth, source);
        StackNew.SubStackWHD(source, StartX, StartY, StartZ, Width, Height, Depth, result);
        return result;
    }

    public static void SubStackWHD(BufferedImage[] source, int StartX, int StartY, int StartZ, int Width, int Height, int Depth, BufferedImage[] result) {
        if (result[0].getWidth() != Width || result[0].getHeight() != Height || result.length != Depth) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        for (int z = 0; z < Depth; ++z) {
            ImageNew.SubImageWH((BufferedImage)source[StartZ + z], (int)StartX, (int)StartY, (int)Width, (int)Height, (BufferedImage)result[z]);
        }
    }

    public static BufferedImage[] Random(BufferedImage reference, int nbImages) {
        BufferedImage[] stack = new BufferedImage[nbImages];
        for (int i2 = 0; i2 < nbImages; ++i2) {
            stack[i2] = ImageNew.Random((BufferedImage)reference);
        }
        return stack;
    }

    public static BufferedImage[] Random(int width, int height, int nbImages, int type) {
        BufferedImage[] stack = new BufferedImage[nbImages];
        for (int i2 = 0; i2 < nbImages; ++i2) {
            stack[i2] = ImageNew.Random((int)width, (int)height, (int)type);
        }
        return stack;
    }
}

