/*
 * Decompiled with CFR 0.152.
 */
package stackTiTi;

import displays.Display;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.Opener;
import imageJ.IJInterfacor;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import loci.common.DebugTools;
import loci.formats.FormatException;
import loci.plugins.BF;
import loci.plugins.in.ImporterOptions;
import stackTiTi.GifEncoder;
import stackTiTi.StackTools;
import utils.strings.IntGenerator;
import utils.strings.StringToolsImageDV;

public class StackIO {
    public static BufferedImage[] ReadImageSequence(String folder, FilenameFilter fnf) throws IOException {
        File[] images = fnf != null ? new File(folder).listFiles(fnf) : new File(folder).listFiles();
        BufferedImage[] result = StackIO.ReadImageSequence(images);
        images = null;
        return result;
    }

    public static BufferedImage[] ReadImageSequence(File[] images) throws IOException {
        Arrays.sort(images);
        if (images.length == 0) {
            throw new IllegalArgumentException("No images found.");
        }
        BufferedImage[] stack = new BufferedImage[images.length];
        stack[0] = ImageIO.Read(images[0]);
        for (int i2 = 1; i2 < images.length; ++i2) {
            stack[i2] = ImageIO.Read(images[i2]);
            if (ImageTools.areDimensionsAndTypeEqual((BufferedImage)stack[i2], (BufferedImage)stack[0])) continue;
            throw new IOException("Images have different type or dimensions.");
        }
        return stack;
    }

    public static BufferedImage[] ReadStack(String FileName) throws IOException {
        System.out.print("Reading Stack '" + FileName + "'");
        System.out.flush();
        Opener opener = new Opener();
        ImagePlus imp = opener.openImage(FileName);
        int width = imp.getWidth();
        int height = imp.getHeight();
        System.out.print(" (" + imp.getImageStackSize() + " image(s) , " + width + "x" + height + " <=> " + width * height + " pixels, Type " + StringToolsImageDV.NameOfType((int)imp.getBufferedImage().getType()) + " on " + imp.getBufferedImage().getColorModel().getPixelSize() + " bits)... ");
        System.out.flush();
        boolean written = false;
        BufferedImage[] stack = new BufferedImage[imp.getImageStackSize()];
        for (int s = 0; s < stack.length; ++s) {
            stack[s] = imp.getImageStack().getProcessor(s + 1).getBufferedImage();
            if (stack[s].getType() == 10 || stack[s].getType() == 11) continue;
            if (!written) {
                System.out.print("converting on 8 bits...");
                written = true;
            }
            BufferedImage im = new BufferedImage(width, height, 10);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    im.getRaster().setSample(x, y, 0, stack[s].getRaster().getSample(x, y, 0));
                }
            }
            stack[s] = null;
            stack[s] = im;
        }
        System.out.println(" successfully.");
        System.out.flush();
        imp = null;
        opener = null;
        return stack;
    }

    public static BufferedImage[] ReadRaw(String FileName, int Width, int Height, int nbImages, int Type2) throws IOException {
        FileInfo fi = new FileInfo();
        fi.fileFormat = 1;
        fi.width = Width;
        fi.height = Height;
        fi.fileName = FileName;
        fi.nImages = nbImages;
        switch (Type2) {
            case 10: 
            case 12: {
                fi.fileType = 0;
                break;
            }
            case 11: {
                fi.fileType = 2;
                break;
            }
            case 4: 
            case 5: {
                fi.fileType = 10;
                break;
            }
            case 1: {
                fi.fileType = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported : " + StringToolsImageDV.NameOfType((int)Type2));
            }
        }
        return StackIO.ReadRaw(FileName, fi);
    }

    public static BufferedImage[] ReadRaw(String FileName, FileInfo fileinfo) throws IOException {
        System.out.print("Reading Raw image '" + FileName + "'");
        ImagePlus imp = new FileOpener(fileinfo).open(false);
        System.out.print(" (" + imp.getWidth() + "x" + imp.getHeight() + " <=> " + imp.getWidth() * imp.getHeight() + " pixels, Type " + StringToolsImageDV.NameOfType((int)imp.getBufferedImage().getType()) + " on " + imp.getBufferedImage().getColorModel().getPixelSize() + " bits)...");
        System.out.flush();
        BufferedImage[] stack = new BufferedImage[imp.getImageStackSize()];
        for (int i2 = 0; i2 < imp.getImageStackSize(); ++i2) {
            stack[i2] = IJInterfacor.ImageProcessorToBufferedImage(imp.getImageStack().getProcessor(i2 + 1));
        }
        System.out.println(" successfully.");
        System.out.flush();
        return stack;
    }

    public static BufferedImage[] ReadStackBioFormat(String FileName) throws IOException {
        System.out.print("Reading stack (Bio-Format) '" + FileName + "'");
        System.out.flush();
        DebugTools.enableLogging((String)"OFF");
        ImporterOptions io = new ImporterOptions();
        io.setWindowless(true);
        io.setQuiet(true);
        io.setId(FileName);
        io.setShowMetadata(false);
        ImagePlus[] images = null;
        try {
            images = BF.openImagePlus((ImporterOptions)io);
        }
        catch (FormatException e) {
            throw new IOException(e.getMessage());
        }
        if (images == null) {
            throw new IOException("Cannot read the file.");
        }
        if (images.length != 1) {
            throw new IOException("More than 1 image detected.");
        }
        io = null;
        ImageStack imstack = images[0].getStack();
        BufferedImage im = IJInterfacor.ImageProcessorToBufferedImage(imstack.getProcessor(1));
        System.out.print(imstack.getSize() + "slices (" + im.getWidth() + "x" + im.getHeight() + " <=> " + im.getWidth() * im.getHeight() + " pixels on " + im.getRaster().getNumBands() + " channel" + (1 < im.getRaster().getNumBands() ? "s" : "") + ", Type " + StringToolsImageDV.NameOfType((int)im.getType()) + ", DataBuffer" + StringToolsImageDV.NameOfDataBufferType((int)im.getRaster().getDataBuffer().getDataType()) + " on " + im.getColorModel().getPixelSize() + " bits)...");
        BufferedImage[] stack = new BufferedImage[imstack.getSize()];
        for (int i2 = 0; i2 < stack.length; ++i2) {
            stack[i2] = IJInterfacor.ImageProcessorToBufferedImage(imstack.getProcessor(i2 + 1));
        }
        block1 : switch (im.getType()) {
            case 2: {
                System.out.print(" converting to type 4BYTE_ABGR...");
                for (BufferedImage stack1 : stack) {
                    ImageConverter.IntToByte((BufferedImage)stack1);
                }
                break;
            }
            case 1: 
            case 4: {
                System.out.print(" converting to type 3BYTE_BGR...");
                for (BufferedImage stack1 : stack) {
                    ImageConverter.IntToByte((BufferedImage)stack1);
                }
                break;
            }
            case 13: {
                int channel = im.getRaster().getNumBands();
                switch (channel) {
                    case 1: {
                        int s;
                        float max = 0.0f;
                        BufferedImage[] bufferedImageArray = stack;
                        int n = bufferedImageArray.length;
                        for (int j = 0; j < n; ++j) {
                            BufferedImage stack1;
                            im = stack1 = bufferedImageArray[j];
                            for (int i3 = 0; i3 < im.getColorModel().getColorSpace().getNumComponents(); ++i3) {
                                max = Math.max(max, im.getColorModel().getColorSpace().getMaxValue(i3));
                            }
                            im = null;
                        }
                        if (max == 1.0f) {
                            System.out.print(" converting to type TYPE_BYTE_BINARY...");
                            for (s = 0; s < stack.length; ++s) {
                                stack[s] = ImageConverter.Universal((BufferedImage)stack[s], (int)12);
                            }
                        } else {
                            System.out.print(" converting to type TYPE_BYTE_GRAY...");
                            for (s = 0; s < stack.length; ++s) {
                                stack[s] = ImageConverter.Universal((BufferedImage)stack[s], (int)10);
                            }
                        }
                        break block1;
                    }
                    case 3: {
                        int s;
                        System.out.print(" converting to type 3BYTE_BGR...");
                        for (s = 0; s < stack.length; ++s) {
                            stack[s] = ImageConverter.Universal((BufferedImage)stack[s], (int)5);
                        }
                        break block1;
                    }
                    case 4: {
                        int s;
                        System.out.print(" converting to type TYPE_4BYTE_ABGR...");
                        for (s = 0; s < stack.length; ++s) {
                            stack[s] = ImageConverter.Universal((BufferedImage)stack[s], (int)6);
                        }
                        break block1;
                    }
                    default: {
                        throw new IOException("TYPE_BYTE_INDEXED image, and number of channels/bands not supported.");
                    }
                }
            }
        }
        while (imstack.getSize() != 0) {
            imstack.deleteLastSlice();
        }
        System.out.println(" successfully.");
        System.out.flush();
        return stack;
    }

    public static void WriteAsGif(BufferedImage[] images, double fps, int Transparency2, String path) {
        if (!StackTools.isOkay(images)) {
            throw new IllegalArgumentException("Some images have different dimensions and/or types.");
        }
        ImageIO.verbose = true;
        System.out.print("Writing image '" + path + "'... (" + images[0].getWidth() + "x" + images[0].getHeight() + " <=> " + images[0].getWidth() * images[0].getHeight() + " pixels on " + images[0].getRaster().getNumBands() + " channel" + (1 < images[0].getRaster().getNumBands() ? "s" : "") + ", Type " + StringToolsImageDV.NameOfType((int)images[0].getType()) + ", DataBuffer" + StringToolsImageDV.NameOfDataBufferType((int)images[0].getRaster().getDataBuffer().getDataType()) + " on " + images[0].getColorModel().getPixelSize() + " bits)...");
        System.out.flush();
        ImagePlus tmp = new ImagePlus();
        GifEncoder ge = new GifEncoder();
        if (fps <= 0.2) {
            fps = 0.2;
        }
        if (60.0 < fps) {
            fps = 60.0;
        }
        ge.setDelay((int)(1.0 / fps * 1000.0));
        if (0 <= Transparency2 && Transparency2 <= 255) {
            ge.transparent = true;
            ge.transIndex = Transparency2;
        }
        ge.start(path);
        for (BufferedImage image : images) {
            tmp.setProcessor(null, IJInterfacor.BufferedImageToImageProcessor(image));
            ge.addFrame(tmp);
        }
        ge.finish();
        System.out.println(" successfully.");
        System.out.flush();
    }

    public static void WriteImageSequence(BufferedImage[] images, String directory, String prefix, int Format2) throws IOException {
        ImageIO.verbose = true;
        System.out.println("Writing image sequence '" + prefix + "':");
        System.out.flush();
        String ext = ImageIO.TypeToExtension(Format2);
        IntGenerator ig = new IntGenerator(0, images.length);
        for (BufferedImage image : images) {
            System.out.print("\t");
            ImageIO.Write(image, directory + "/" + prefix + ig.Next() + "." + ext, Format2);
        }
        System.out.println("Successfully.");
        System.out.flush();
        ig = null;
        ext = null;
    }

    public static void WriteImageSequence(BufferedImage[] images, File[] files, String directory, String prefix, int Format2) throws IOException {
        ImageIO.verbose = true;
        System.out.println("Writing image sequence '" + prefix + "':");
        System.out.flush();
        String ext = ImageIO.TypeToExtension(Format2);
        for (int i2 = 0; i2 < images.length; ++i2) {
            System.out.print("\t");
            ImageIO.Write(images[i2], directory + "/" + prefix + files[i2].getName().substring(0, files[i2].getName().lastIndexOf(46)) + "." + ext, Format2);
        }
        System.out.println("Successfully.");
        System.out.flush();
        ext = null;
    }

    public static void ReadStack_Crop_SaveGif(String folderpath, FilenameFilter fnf, Comparator<File> cmpf, int minx, int miny, int maxx, int maxy, String name, int fps, int transparency) throws IOException {
        int i2;
        Object[] file = new File(folderpath).listFiles(fnf);
        if (file.length == 0) {
            throw new IllegalArgumentException("Any image found.");
        }
        if (cmpf == null) {
            Arrays.sort(file);
        } else {
            Arrays.sort(file, cmpf);
        }
        BufferedImage[] crops = new BufferedImage[file.length];
        for (i2 = 0; i2 < crops.length; ++i2) {
            BufferedImage im = ImageIO.Read(((File)file[i2]).getAbsoluteFile());
            crops[i2] = ImageNew.SubImage((BufferedImage)im, (int)minx, (int)miny, (int)maxx, (int)maxy);
            im = null;
        }
        StackIO.WriteAsGif(crops, fps, transparency, name);
        for (i2 = 0; i2 < crops.length; ++i2) {
            crops[i2] = null;
        }
        crops = null;
        file = null;
    }

    public static void Display(List<BufferedImage> images, Display display) {
        for (int i2 = 0; i2 < images.size(); ++i2) {
            display.Image(images.get(i2), "Image " + i2, 1.0);
        }
    }

    public static void Display(BufferedImage[] images) {
        for (int i2 = 0; i2 < images.length; ++i2) {
            ImageIO.Display(images[i2], "Image " + i2, " ");
        }
    }
}

