/*
 * Decompiled with CFR 0.152.
 */
package stackTiTi;

import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public final class StackFeatures {
    private long Integral = -1L;
    private double IntegralDouble = -1.0;
    private long Size = 0L;
    private double Average = 0.0;
    private double Minimum = 0.0;
    private double Maximum = 0.0;
    private final ImageFeatures IF = new ImageFeatures();

    public long Counter(BufferedImage[] images, int channel, int ForbiddenValue) {
        long count = 0L;
        for (BufferedImage image : images) {
            count += this.IF.Counter(image, channel, ForbiddenValue);
        }
        this.Size = count;
        return count;
    }

    public long Counter(BufferedImage[] images, double ForbiddenValue) {
        long count = 0L;
        for (BufferedImage image : images) {
            count += this.IF.Counter(image, ForbiddenValue);
        }
        this.Size = count;
        return count;
    }

    public void Integral(BufferedImage[] images) {
        int count = 0;
        long integral = 0L;
        double integraldouble = 0.0;
        switch (images[0].getRaster().getDataBuffer().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (BufferedImage image : images) {
                    this.IF.Integral(image);
                    integral += this.IF.Integral();
                    count = (int)((long)count + this.IF.Size());
                }
                this.Integral = integral;
                break;
            }
            case 4: 
            case 5: {
                for (BufferedImage image : images) {
                    this.IF.Integral(image);
                    integraldouble += this.IF.IntegralDouble();
                    count = (int)((long)count + this.IF.Size());
                }
                this.IntegralDouble = integraldouble;
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
        this.Size = count;
    }

    public long Integral(BufferedImage[] images, int ForbiddenValue) {
        int count = 0;
        long integral = 0L;
        for (BufferedImage image : images) {
            integral += this.IF.Integral(image, ForbiddenValue);
            count = (int)((long)count + this.IF.Size());
        }
        this.Integral = integral;
        this.Size = count;
        return this.Integral;
    }

    public double Integral(BufferedImage[] images, double ForbiddenValue) {
        int count = 0;
        double integraldouble = 0.0;
        for (BufferedImage image : images) {
            integraldouble += this.IF.Integral(image, ForbiddenValue);
            count = (int)((long)count + this.IF.Size());
        }
        this.IntegralDouble = integraldouble;
        this.Size = count;
        return this.IntegralDouble;
    }

    public double Average(BufferedImage[] images) {
        long integral = 0L;
        double integraldouble = 0.0;
        long size = 0L;
        double average = 0.0;
        switch (images[0].getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        switch (images[0].getRaster().getDataBuffer().getDataType()) {
            case 0: 
            case 1: 
            case 3: {
                for (BufferedImage image : images) {
                    average += this.IF.Average(image) / (double)images.length;
                    integral += this.IF.Integral();
                    size += this.IF.Size();
                }
                this.Integral = integral;
                break;
            }
            case 4: 
            case 5: {
                for (BufferedImage image : images) {
                    average += this.IF.Average(image) / (double)images.length;
                    integraldouble += this.IF.IntegralDouble();
                    size += this.IF.Size();
                }
                this.IntegralDouble = integraldouble;
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
        this.Average = average;
        this.Size = size;
        return this.Average;
    }

    public double Average(BufferedImage[] images, int ForbiddenValue) {
        int i2;
        long[] integrals = new long[images.length];
        long size = 0L;
        for (i2 = 0; i2 < images.length; ++i2) {
            integrals[i2] = this.IF.Integral(images[i2], ForbiddenValue);
            size += this.IF.Size();
        }
        this.Average = 0.0;
        this.Integral = 0L;
        for (i2 = 0; i2 < images.length; ++i2) {
            this.Average += (double)integrals[i2] / (double)size;
            this.Integral += integrals[i2];
        }
        this.Size = size;
        integrals = null;
        return this.Average;
    }

    public double Average(BufferedImage[] images, double ForbiddenValue) {
        int i2;
        double[] integrals = new double[images.length];
        long size = 0L;
        for (i2 = 0; i2 < images.length; ++i2) {
            integrals[i2] = this.IF.Integral(images[i2], ForbiddenValue);
            size += this.IF.Size();
        }
        this.Average = 0.0;
        this.IntegralDouble = 0.0;
        for (i2 = 0; i2 < images.length; ++i2) {
            this.Average += integrals[i2] / (double)size;
            this.IntegralDouble += integrals[i2];
        }
        this.Size = size;
        integrals = null;
        return this.Average;
    }

    public double Average(BufferedImage[] images, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        long[] integrals = new long[images.length];
        double[] integralsdouble = new double[images.length];
        long size = 0L;
        switch (images[0].getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        this.IntegralDouble = 0.0;
        this.Average = 0.0;
        this.Integral = 0L;
        switch (images[0].getRaster().getDataBuffer().getDataType()) {
            case 0: 
            case 1: 
            case 3: {
                int i2;
                for (i2 = FromZ; i2 < EndZ; ++i2) {
                    this.IF.Integral(images[i2], FromX, EndX, FromY, EndY);
                    integrals[i2] = this.IF.Integral();
                    size += this.IF.Size();
                }
                for (i2 = FromZ; i2 < EndZ; ++i2) {
                    this.Average += (double)integrals[i2] / (double)size;
                    this.Integral += integrals[i2];
                }
                break;
            }
            case 4: 
            case 5: {
                int i3;
                for (i3 = FromZ; i3 < EndZ; ++i3) {
                    this.IF.Integral(images[i3], FromX, EndX, FromY, EndY);
                    integralsdouble[i3] = this.IF.IntegralDouble();
                    size += this.IF.Size();
                }
                for (i3 = FromZ; i3 < EndZ; ++i3) {
                    this.Average += integralsdouble[i3] / (double)size;
                    this.Integral = (long)((double)this.Integral + integralsdouble[i3]);
                }
                break;
            }
        }
        this.Size = size;
        integrals = null;
        integralsdouble = null;
        return this.Average;
    }

    public double Average(BufferedImage[] images, int ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int i2;
        long[] integrals = new long[images.length];
        long size = 0L;
        for (i2 = FromZ; i2 < EndZ; ++i2) {
            integrals[i2] = this.IF.Integral(images[i2], ForbiddenValue, FromX, EndX, FromY, EndY);
            size += this.IF.Size();
        }
        this.Average = 0.0;
        this.Integral = 0L;
        for (i2 = FromZ; i2 < EndZ; ++i2) {
            this.Average += (double)integrals[i2] / (double)size;
            this.Integral += integrals[i2];
        }
        this.Size = size;
        integrals = null;
        return this.Average;
    }

    public double Average(BufferedImage[] images, double ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) {
        int i2;
        double[] integrals = new double[images.length];
        long size = 0L;
        for (i2 = FromZ; i2 < EndZ; ++i2) {
            integrals[i2] = this.IF.Integral(images[i2], ForbiddenValue, FromX, EndX, FromY, EndY);
            size += this.IF.Size();
        }
        this.Average = 0.0;
        this.IntegralDouble = 0.0;
        for (i2 = FromZ; i2 < EndZ; ++i2) {
            this.Average += integrals[i2] / (double)size;
            this.IntegralDouble += integrals[i2];
        }
        this.Size = size;
        integrals = null;
        return this.Average;
    }

    public double Average(File[] images) throws IOException {
        int i2;
        long[] integrals = new long[images.length];
        double[] integralsdouble = new double[images.length];
        long size = 0L;
        BufferedImage image = null;
        for (i2 = 0; i2 < images.length; ++i2) {
            image = null;
            image = ImageIO.Read(images[i2]);
            this.IF.Integral(image);
            switch (image.getRaster().getDataBuffer().getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    integrals[i2] = this.IF.Integral();
                    break;
                }
                case 4: 
                case 5: {
                    integralsdouble[i2] = this.IF.IntegralDouble();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                }
            }
            size += this.IF.Size();
        }
        this.IntegralDouble = 0.0;
        this.Average = 0.0;
        this.Integral = 0L;
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (i2 = 0; i2 < images.length; ++i2) {
                    this.Average += (double)integrals[i2] / (double)size;
                    this.Integral += integrals[i2];
                }
                break;
            }
            case 4: 
            case 5: {
                for (i2 = 0; i2 < images.length; ++i2) {
                    this.Average += integralsdouble[i2] / (double)size;
                    this.IntegralDouble += integralsdouble[i2];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
        this.Size = size;
        image = null;
        integrals = null;
        integralsdouble = null;
        return this.Average;
    }

    public double Average(File[] images, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) throws IOException {
        int i2;
        long[] integrals = new long[images.length];
        double[] integralsdouble = new double[images.length];
        long size = 0L;
        BufferedImage image = null;
        for (i2 = FromZ; i2 < EndZ; ++i2) {
            image = null;
            image = ImageIO.Read(images[i2]);
            this.IF.Integral(image, FromX, EndX, FromY, EndY);
            switch (image.getRaster().getDataBuffer().getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    integrals[i2] = this.IF.Integral();
                    break;
                }
                case 4: 
                case 5: {
                    integralsdouble[i2] = this.IF.IntegralDouble();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                }
            }
            size += this.IF.Size();
        }
        this.IntegralDouble = 0.0;
        this.Average = 0.0;
        this.Integral = 0L;
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (i2 = FromZ; i2 < EndZ; ++i2) {
                    this.Average += (double)integrals[i2] / (double)size;
                    this.Integral += integrals[i2];
                }
                break;
            }
            case 4: 
            case 5: {
                for (i2 = FromZ; i2 < EndZ; ++i2) {
                    this.Average += integralsdouble[i2] / (double)size;
                    this.IntegralDouble += integralsdouble[i2];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
        image = null;
        integrals = null;
        integralsdouble = null;
        this.Size = size;
        return this.Average;
    }

    public double Average(File[] images, int ForbiddenValue) throws IOException {
        int i2;
        long[] integrals = new long[images.length];
        long size = 0L;
        BufferedImage image = null;
        for (i2 = 0; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            integrals[i2] = this.IF.Integral(image, ForbiddenValue);
            size += this.IF.Size();
            image = null;
        }
        this.Average = 0.0;
        this.Integral = 0L;
        for (i2 = 0; i2 < images.length; ++i2) {
            this.Average += (double)integrals[i2] / (double)size;
            this.Integral += integrals[i2];
        }
        this.Size = size;
        integrals = null;
        return this.Average;
    }

    public double Average(File[] images, double ForbiddenValue) throws IOException {
        int i2;
        double[] integrals = new double[images.length];
        long size = 0L;
        BufferedImage image = null;
        for (i2 = 0; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            integrals[i2] = this.IF.Integral(image, ForbiddenValue);
            size += this.IF.Size();
            image = null;
        }
        this.Average = 0.0;
        this.IntegralDouble = 0.0;
        for (i2 = 0; i2 < images.length; ++i2) {
            this.Average += integrals[i2] / (double)size;
            this.IntegralDouble += integrals[i2];
        }
        this.Size = size;
        integrals = null;
        return this.Average;
    }

    public double Average(File[] images, int ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) throws IOException {
        int i2;
        long[] integrals = new long[images.length];
        double[] integralsdouble = new double[images.length];
        long size = 0L;
        BufferedImage image = null;
        for (i2 = FromZ; i2 < EndZ; ++i2) {
            image = null;
            image = ImageIO.Read(images[i2]);
            this.IF.Integral(image, ForbiddenValue, FromX, EndX, FromY, EndY);
            switch (image.getRaster().getDataBuffer().getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    integrals[i2] = this.IF.Integral();
                    break;
                }
                case 4: 
                case 5: {
                    integralsdouble[i2] = this.IF.IntegralDouble();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                }
            }
            size += this.Size;
        }
        this.IntegralDouble = 0.0;
        this.Average = 0.0;
        this.Integral = 0L;
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (i2 = FromZ; i2 < EndZ; ++i2) {
                    this.Average += (double)integrals[i2] / (double)size;
                    this.Integral += integrals[i2];
                }
                break;
            }
            case 4: 
            case 5: {
                for (i2 = FromZ; i2 < EndZ; ++i2) {
                    this.Average += integralsdouble[i2] / (double)size;
                    this.IntegralDouble += integralsdouble[i2];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
        image = null;
        integrals = null;
        integralsdouble = null;
        this.Size = size;
        return this.Average;
    }

    public double Average(File[] images, double ForbiddenValue, int FromX, int EndX, int FromY, int EndY, int FromZ, int EndZ) throws IOException {
        int i2;
        long[] integrals = new long[images.length];
        double[] integralsdouble = new double[images.length];
        long size = 0L;
        BufferedImage image = null;
        for (i2 = FromZ; i2 < EndZ; ++i2) {
            image = null;
            image = ImageIO.Read(images[i2]);
            this.IF.Integral(image, ForbiddenValue, FromX, EndX, FromY, EndY);
            switch (image.getRaster().getDataBuffer().getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    integrals[i2] = this.IF.Integral();
                    break;
                }
                case 4: 
                case 5: {
                    integralsdouble[i2] = this.IF.IntegralDouble();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                }
            }
            size += this.Size;
        }
        this.IntegralDouble = 0.0;
        this.Average = 0.0;
        this.Integral = 0L;
        switch (image.getRaster().getDataBuffer().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (i2 = FromZ; i2 < EndZ; ++i2) {
                    this.Average += (double)integrals[i2] / (double)size;
                    this.Integral += integrals[i2];
                }
                break;
            }
            case 4: 
            case 5: {
                for (i2 = FromZ; i2 < EndZ; ++i2) {
                    this.Average += integralsdouble[i2] / (double)size;
                    this.IntegralDouble += integralsdouble[i2];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
        image = null;
        integrals = null;
        integralsdouble = null;
        this.Size = size;
        return this.Average;
    }

    public double Minimum(BufferedImage[] images) {
        double min = this.IF.Minimum(images[0]);
        for (int i2 = 1; i2 < images.length; ++i2) {
            if (!(this.IF.Minimum(images[i2]) < min)) continue;
            min = this.IF.Minimum();
        }
        this.Minimum = min;
        return this.Minimum;
    }

    public double Maximum(BufferedImage[] images) {
        double max = this.IF.Maximum(images[0]);
        for (int i2 = 1; i2 < images.length; ++i2) {
            if (!(max < this.IF.Maximum(images[i2]))) continue;
            max = this.IF.Maximum();
        }
        this.Maximum = max;
        return this.Maximum;
    }

    public double Minimum(BufferedImage[] images, int ForbiddenValue) {
        int min = Integer.MAX_VALUE;
        try {
            min = (int)this.IF.Minimum(images[0], ForbiddenValue);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        for (int i2 = 1; i2 < images.length; ++i2) {
            try {
                if ((int)this.IF.Minimum(images[i2], ForbiddenValue) >= min) continue;
                min = (int)this.IF.Minimum();
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (min == Integer.MAX_VALUE) {
            throw new IllegalStateException("No valid value found!");
        }
        this.Minimum = min;
        return this.Minimum;
    }

    public double Minimum(BufferedImage[] images, double ForbiddenValue) {
        double min = Double.MAX_VALUE;
        try {
            min = this.IF.Minimum(images[0], ForbiddenValue);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        for (int i2 = 1; i2 < images.length; ++i2) {
            try {
                if (!(this.IF.Minimum(images[i2], ForbiddenValue) < min)) continue;
                min = this.IF.Minimum();
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (min == Double.MAX_VALUE) {
            throw new IllegalStateException("No valid value found!");
        }
        this.Minimum = min;
        return this.Minimum;
    }

    public double Maximum(BufferedImage[] images, int ForbiddenValue) {
        int max = Integer.MIN_VALUE;
        try {
            max = (int)this.IF.Maximum(images[0], ForbiddenValue);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        for (int i2 = 1; i2 < images.length; ++i2) {
            try {
                if (max >= (int)this.IF.Maximum(images[i2], ForbiddenValue)) continue;
                max = (int)this.IF.Maximum();
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (max == Integer.MIN_VALUE) {
            throw new IllegalStateException("No valid value found!");
        }
        this.Maximum = max;
        return this.Maximum;
    }

    public double Maximum(BufferedImage[] images, double ForbiddenValue) {
        double max = -1.7976931348623157E308;
        try {
            max = this.IF.Maximum(images[0], ForbiddenValue);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        for (int i2 = 1; i2 < images.length; ++i2) {
            try {
                if (!(max < this.IF.Maximum(images[i2], ForbiddenValue))) continue;
                max = this.IF.Maximum();
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (max == -1.7976931348623157E308) {
            throw new IllegalStateException("No valid value found!");
        }
        this.Maximum = max;
        return this.Maximum;
    }

    public double Maximum(File[] images) throws IOException {
        BufferedImage image = ImageIO.Read(images[0]);
        double max = this.IF.Maximum(image);
        for (int i2 = 1; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            if (max < this.IF.Maximum(image)) {
                max = this.IF.Maximum();
            }
            image = null;
        }
        this.Maximum = max;
        return this.Maximum;
    }

    public double Maximum(File[] images, int ForbiddenValue) throws IOException {
        BufferedImage image = ImageIO.Read(images[0]);
        double max = this.IF.Maximum(image, ForbiddenValue);
        for (int i2 = 1; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            if (max < this.IF.Maximum(image, ForbiddenValue)) {
                max = this.IF.Maximum();
            }
            image = null;
        }
        this.Maximum = max;
        return this.Maximum;
    }

    public double Maximum(File[] images, double ForbiddenValue) throws IOException {
        BufferedImage image = ImageIO.Read(images[0]);
        double max = this.IF.Maximum(image, ForbiddenValue);
        for (int i2 = 1; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            if (max < this.IF.Maximum(image, ForbiddenValue)) {
                max = this.IF.Maximum();
            }
            image = null;
        }
        this.Maximum = max;
        return this.Maximum;
    }

    public double Minimum(File[] images) throws IOException {
        BufferedImage image = ImageIO.Read(images[0]);
        double min = this.IF.Minimum(image);
        for (int i2 = 1; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            if (this.IF.Minimum(image) < min) {
                min = this.IF.Minimum();
            }
            image = null;
        }
        this.Minimum = min;
        return this.Minimum;
    }

    public double Minimum(File[] images, int ForbiddenValue) throws IOException {
        BufferedImage image = ImageIO.Read(images[0]);
        int min = (int)this.IF.Minimum(image, ForbiddenValue);
        for (int i2 = 1; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            if ((int)this.IF.Minimum(image, ForbiddenValue) < min) {
                min = (int)this.IF.Minimum();
            }
            image = null;
        }
        this.Minimum = min;
        return this.Minimum;
    }

    public double Minimum(File[] images, double ForbiddenValue) throws IOException {
        BufferedImage image = ImageIO.Read(images[0]);
        int min = (int)this.IF.Minimum(image, ForbiddenValue);
        for (int i2 = 1; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            if ((int)this.IF.Minimum(image, ForbiddenValue) < min) {
                min = (int)this.IF.Minimum();
            }
            image = null;
        }
        this.Minimum = min;
        return this.Minimum;
    }

    public void MinMaximum(File[] images) throws IOException {
        BufferedImage image = ImageIO.Read(images[0]);
        double min = this.IF.Minimum(image);
        double max = this.IF.Maximum(image);
        for (int i2 = 1; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            if (this.IF.Minimum(image) < min) {
                min = this.IF.Minimum();
            }
            if (max < this.IF.Maximum(image)) {
                max = this.IF.Maximum();
            }
            image = null;
        }
        this.Minimum = min;
        this.Maximum = max;
    }

    public void MinMaximum(File[] images, int ForbiddenValue) throws IOException {
        BufferedImage image = ImageIO.Read(images[0]);
        double min = this.IF.Minimum(image, ForbiddenValue);
        double max = this.IF.Maximum(image, ForbiddenValue);
        for (int i2 = 1; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            if (this.IF.Minimum(image, ForbiddenValue) < min) {
                min = this.IF.Minimum();
            }
            if (max < this.IF.Maximum(image, ForbiddenValue)) {
                max = this.IF.Maximum();
            }
            image = null;
        }
        this.Minimum = min;
        this.Maximum = max;
    }

    public void MinMaximum(File[] images, double ForbiddenValue) throws IOException {
        BufferedImage image = ImageIO.Read(images[0]);
        double min = this.IF.Minimum(image, ForbiddenValue);
        double max = this.IF.Maximum(image, ForbiddenValue);
        for (int i2 = 1; i2 < images.length; ++i2) {
            image = ImageIO.Read(images[i2]);
            if (this.IF.Minimum(image, ForbiddenValue) < min) {
                min = this.IF.Minimum();
            }
            if (max < this.IF.Maximum(image, ForbiddenValue)) {
                max = this.IF.Maximum();
            }
            image = null;
        }
        this.Minimum = min;
        this.Maximum = max;
    }

    public long Integral() {
        return this.Integral;
    }

    public double IntegralDouble() {
        return this.IntegralDouble;
    }

    public long Size() {
        return this.Size;
    }

    public double Average() {
        return this.Average;
    }

    public double Minimum() {
        return this.Minimum;
    }

    public double Maximum() {
        return this.Maximum;
    }
}

