/*
 * Decompiled with CFR 0.152.
 */
package stackTiTi;

import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import mathematics.Maths;
import stackTiTi.StackNew;

public class StackConverter {
    public static BufferedImage[] GrayToColor(BufferedImage[] source) {
        BufferedImage[] result = StackNew.Same(source, 5);
        StackConverter.GrayToColor(source, result);
        return result;
    }

    public static void GrayToColor(BufferedImage[] source, BufferedImage[] result) {
        if (source.length != result.length) {
            throw new IllegalArgumentException("source.length != result.length");
        }
        for (int i2 = 0; i2 < source.length; ++i2) {
            ImageConverter.GrayToColor((BufferedImage)source[i2], (BufferedImage)result[i2]);
        }
    }

    public static BufferedImage[] OneEvery(BufferedImage[] stack, int subpos, int nbSubStack) {
        if (Maths.Modulo((int)stack.length, (int)nbSubStack) != 0) {
            throw new IllegalArgumentException("stack.length % nbSubStack != 0");
        }
        BufferedImage[] result = StackNew.Random(stack[0], stack.length / nbSubStack);
        StackConverter.OneEvery(stack, subpos, nbSubStack, result);
        return result;
    }

    public static void OneEvery(BufferedImage[] stack, int subpos, int nbSubStack, BufferedImage[] result) {
        int s = subpos;
        int r = 0;
        while (s < stack.length) {
            ImageNew.Copy((BufferedImage)stack[s], (BufferedImage)result[r]);
            s += nbSubStack;
            ++r;
        }
    }
}

