/*
 * Decompiled with CFR 0.152.
 */
package stackTiTi;

import imageTiTi.ImageArithmetic;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import stackTiTi.StackNew;
import utils.strings.StringToolsImageDV;

public class StackArithmetic {
    public static BufferedImage[] Add(BufferedImage[] Original1, BufferedImage[] Original2) {
        BufferedImage[] result = StackNew.Same(Original2);
        StackArithmetic.Add(Original1, Original2, result);
        return result;
    }

    public static void Add(BufferedImage[] Original1, BufferedImage[] Original2, BufferedImage[] Result) {
        if (Original1.length != Original2.length || Original1.length != Result.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < Original1.length; ++i2) {
            ImageArithmetic.Add(Original1[i2], Original2[i2], Result[i2]);
        }
    }

    public static BufferedImage[] Add(BufferedImage[] Original1, BufferedImage[] Original2, int Threshold, int SafeValue) {
        BufferedImage[] result = StackNew.Same(Original2);
        StackArithmetic.Add(Original1, Original2, result, Threshold, SafeValue);
        return result;
    }

    public static void Add(BufferedImage[] Original1, BufferedImage[] Original2, BufferedImage[] Result, int Threshold, int SafeValue) {
        if (Original1.length != Original2.length || Original1.length != Result.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < Original1.length; ++i2) {
            ImageArithmetic.Add(Original1[i2], Original2[i2], Result[i2], Threshold, SafeValue);
        }
    }

    public static BufferedImage[] Add(BufferedImage[] Original, int Value, int Threshold, int SafeValue) {
        BufferedImage[] result = StackNew.Same(Original);
        StackArithmetic.Add(Original, Value, result, Threshold, SafeValue);
        return result;
    }

    public static void Add(BufferedImage[] Original, int Value, BufferedImage[] Result, int Threshold, int SafeValue) {
        if (Original.length != Result.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < Original.length; ++i2) {
            ImageArithmetic.Add(Original[i2], Value, Result[i2], Threshold, SafeValue);
        }
    }

    public static BufferedImage[] Add(BufferedImage[] Original, double Value) {
        BufferedImage[] result = StackNew.Same(Original);
        StackArithmetic.Add(Original, Value, result);
        return result;
    }

    public static void Add(BufferedImage[] Original, double Value, BufferedImage[] Result) {
        if (Original.length != Result.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < Original.length; ++i2) {
            ImageArithmetic.Add(Original[i2], Value, Result[i2]);
        }
    }

    public static void Add(File[] Originals, double Value, File[] Results) throws IOException {
        if (Originals.length != Results.length) {
            throw new IllegalArgumentException("Different number of files.");
        }
        for (int i2 = 0; i2 < Originals.length; ++i2) {
            BufferedImage image = ImageIO.Read(Originals[i2]);
            ImageArithmetic.Add(image, Value, image);
            ImageIO.Write(image, Results[i2].getAbsolutePath(), 6);
        }
    }

    public static BufferedImage[] Subtract(BufferedImage[] Original1, BufferedImage[] Original2) {
        BufferedImage[] result = StackNew.Same(Original2);
        StackArithmetic.Subtract(Original1, Original2, result);
        return result;
    }

    public static void Subtract(BufferedImage[] Original1, BufferedImage[] Original2, BufferedImage[] Result) {
        if (Original1.length != Original2.length || Original2.length != Result.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < Result.length; ++i2) {
            ImageArithmetic.Subtract(Original1[i2], Original2[i2], Result[i2]);
        }
    }

    public static BufferedImage[] Subtract(BufferedImage[] Original1, BufferedImage[] Original2, int Threshold, int SafeValue) {
        BufferedImage[] result = StackNew.Same(Original2);
        StackArithmetic.Subtract(Original1, Original2, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(BufferedImage[] Original1, BufferedImage[] Original2, BufferedImage[] Result, int Threshold, int SafeValue) {
        if (Original1.length != Original2.length || Original2.length != Result.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < Result.length; ++i2) {
            ImageArithmetic.Subtract(Original1[i2], Original2[i2], Result[i2], Threshold, SafeValue);
        }
    }

    public static BufferedImage[] Subtract(BufferedImage[] Original1, BufferedImage[] Original2, double Threshold, double SafeValue) {
        BufferedImage[] result = StackNew.Same(Original2);
        StackArithmetic.Subtract(Original1, Original2, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(BufferedImage[] Original1, BufferedImage[] Original2, BufferedImage[] Result, double Threshold, double SafeValue) {
        if (Original1.length != Original2.length || Original2.length != Result.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < Result.length; ++i2) {
            ImageArithmetic.Subtract(Original1[i2], Original2[i2], Result[i2], Threshold, SafeValue);
        }
    }

    public static BufferedImage[] Subtract(BufferedImage[] Original1, BufferedImage[] Original2, float Threshold, float SafeValue) {
        BufferedImage[] result = StackNew.Same(Original2);
        StackArithmetic.Subtract(Original1, Original2, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(BufferedImage[] Original1, BufferedImage[] Original2, BufferedImage[] Result, float Threshold, float SafeValue) {
        if (Original1.length != Original2.length || Original2.length != Result.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < Result.length; ++i2) {
            ImageArithmetic.Subtract(Original1[i2], Original2[i2], Result[i2], Threshold, SafeValue);
        }
    }

    public static BufferedImage[] Subtract(BufferedImage[] Original, int Value, int Threshold, int SafeValue) {
        BufferedImage[] result = StackNew.Same(Original);
        StackArithmetic.Subtract(Original, Value, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(BufferedImage[] Original, int Value, BufferedImage[] Result, int Threshold, int SafeValue) {
        if (Original.length != Result.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < Result.length; ++i2) {
            ImageArithmetic.Subtract(Original[i2], Value, Result[i2], Threshold, SafeValue);
        }
    }

    public static BufferedImage[] Multiply(BufferedImage[] Original, double Value) {
        BufferedImage[] result = StackNew.Same(Original);
        StackArithmetic.Multiply(Original, Value, result);
        return result;
    }

    public static void Multiply(BufferedImage[] Original, double Value, BufferedImage[] Result) {
        for (int i2 = 0; i2 < Original.length; ++i2) {
            ImageArithmetic.Multiply(Original[i2], Value, Result[i2]);
        }
    }

    public static void Multiply(File[] Originals, double Scalar, File[] Results) throws IOException {
        if (Originals.length != Results.length) {
            throw new IllegalArgumentException("Different number of files.");
        }
        for (int i2 = 0; i2 < Originals.length; ++i2) {
            BufferedImage image = ImageIO.Read(Originals[i2]);
            ImageArithmetic.Multiply(image, Scalar, image);
            ImageIO.Write(image, Results[i2], StringToolsImageDV.FindExtension((String)Results[i2].getName()));
        }
    }
}

