/*
 * Decompiled with CFR 0.152.
 */
package softwares.segmentation;

import filesAndFolders.FichiersDossiersIHM;
import ij.plugin.filter.PlugInFilter;
import imageJ.IJInterfacor;
import imageJ.plugInFilter.Entropy_Threshold;
import imageJ.plugInFilter.FFT_Filter_TiTi;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import morphee.Open;
import morphee.StructuringElement;
import processing.filters.Average;
import processing.filters.MaskFilter;
import processing.filters.MedianOld;
import processing.thresholding.Binary;
import utils.times.Chronometer;

public class NucleiSegmentation {
    public static final int Seg_MorphoMath = 0;
    public static final int Seg_Easy = 2;
    public static final int Seg_FFT = 3;
    protected Average average = new Average();
    protected Binary binary = new Binary();
    protected MedianOld median = new MedianOld();
    protected Open open = new Open();
    protected FillHole bh = new FillHole();
    protected ConnectedComponentLabeling ccl = new UnionFindCcl();

    public NucleiSegmentation() {
        this.median.Parameters(1, true);
    }

    public void Calculer(String CheminDossier, int Type2, int Ordre, int Seuil, boolean RetournerMasque, Chronometer Chrono) throws IOException {
        int marker = 0;
        File Dossier = null;
        BufferedImage image = null;
        BufferedImage masque = null;
        BufferedImage masqueBouche = null;
        String Nom = null;
        if (Chrono != null) {
            marker = Chrono.NewMarker();
            System.out.print("Segmentation des images a l'aide de la methode : ");
            switch (Type2) {
                case 0: {
                    System.out.println("MorphoMath (Ouverture + Soustraction + Seuillage)");
                    break;
                }
                case 2: {
                    System.out.println("Easy (Moyenne + Mediant + Seuillage)");
                    break;
                }
                case 3: {
                    System.out.println("FFT (FFT + Seuillage Entropie)");
                    break;
                }
                default: {
                    throw new Error("Default, valeur Type incorrecte : " + Type2);
                }
            }
        }
        Dossier = CheminDossier == null ? FichiersDossiersIHM.ChoisirDossier(new File("").getAbsolutePath(), true) : new File(CheminDossier);
        File[] fichiers = Dossier.listFiles();
        File SegmentationFolder = new File(Dossier.getAbsolutePath() + "/SegmentationFolder");
        SegmentationFolder.mkdir();
        for (int i2 = 0; i2 < fichiers.length; ++i2) {
            if (!fichiers[i2].isFile() || fichiers[i2].getName().equalsIgnoreCase(".DS_Store")) continue;
            System.out.print(i2 + " - ");
            image = null;
            masque = null;
            masqueBouche = null;
            image = ImageIO.Read(Dossier.getPath() + "/" + fichiers[i2].getName());
            Nom = this.RecupererSuffixe(fichiers[i2].getName());
            switch (Type2) {
                case 0: {
                    masque = this.Segmenter_MorphoMath(image, Ordre, Seuil, true);
                    break;
                }
                case 2: {
                    masque = this.Segmenter_Easy(image, Seuil, true, 1);
                    break;
                }
                case 3: {
                    masque = this.Segmenter_FFT_Entropy(image, true);
                    break;
                }
                default: {
                    throw new Error("Default, valeur Type incorrecte : " + Type2);
                }
            }
            masqueBouche = this.bh.Fill(masque, this.ccl, 1000000, true);
            if (!RetournerMasque) {
                ImageIO.Write(new MaskFilter().Filter(image, 1, masqueBouche), Dossier.getPath() + "/SegmentationFolder/" + Nom + ".pgm", 5);
                continue;
            }
            ImageIO.Write(masqueBouche, Dossier.getPath() + "/SegmentationFolder/" + Nom + ".pgm", 5);
        }
        if (Chrono != null) {
            System.out.println("Segmentation terminee en " + Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
    }

    public BufferedImage Segmenter_MorphoMath(BufferedImage source, int Ordre, int seuil, boolean RetournerMasque) {
        StructuringElement se = new StructuringElement(new Object[]{Ordre, -2});
        this.open.setStructuringElement(se);
        BufferedImage Fond = this.open.Filter(source, 1);
        BufferedImage binaire = this.binary.Filter(ImageArithmetic.Subtract(source, Fond, 0, 0), seuil);
        BufferedImage resultat = this.bh.Fill(binaire, this.ccl, 1000000, true);
        if (!RetournerMasque) {
            return new MaskFilter().Filter(source, 1, resultat);
        }
        return resultat;
    }

    public BufferedImage Segmenter_Easy(BufferedImage source, int seuil, boolean RetournerMasque, int nbCPU) {
        BufferedImage moyenne = this.average.Filter(source, nbCPU);
        BufferedImage mediant = this.median.Filter(moyenne, nbCPU);
        BufferedImage binaire = this.binary.Filter(mediant, seuil, nbCPU);
        BufferedImage resultat = this.bh.Fill(binaire, this.ccl, 1000000, true);
        if (!RetournerMasque) {
            return new MaskFilter().Filter(source, 1, resultat);
        }
        return resultat;
    }

    public BufferedImage Segmenter_FFT_Entropy(BufferedImage source, boolean RetournerMasque) {
        Vector<PlugInFilter> liste = new Vector<PlugInFilter>(2);
        liste.addElement(new FFT_Filter_TiTi());
        liste.addElement(new Entropy_Threshold());
        BufferedImage Resultat = IJInterfacor.PluginFilterInterfacor(liste, ImageNew.Clone((BufferedImage)source));
        if (!RetournerMasque) {
            return new MaskFilter().Filter(source, 1, Resultat);
        }
        return Resultat;
    }

    private String RecupererSuffixe(String Nom) {
        int i2;
        for (i2 = Nom.length() - 1; i2 >= 0 && Nom.charAt(i2) != '.'; --i2) {
        }
        if (i2 < 0) {
            throw new Error("Aucune extension detectee dans le nom de l'image : " + Nom);
        }
        return Nom.substring(0, i2);
    }
}

