/*
 * Decompiled with CFR 0.152.
 */
package softwares.progeria.picsEtLacs;

import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;

public class CompterOccurrences {
    protected int Colonne = -1;

    public FichierTabule Compter(FichierTabule Source2, FichierTabule Volumes, boolean Focis) {
        int Hauteur = Source2.Height();
        int PatientSource = Source2.ColumnNumber("Patient");
        int PatientVolumes = Volumes.ColumnNumber("Patient");
        int NoyauxSource = Source2.ColumnNumber("Noyaux");
        int NoyauxVolumes = Volumes.ColumnNumber("Noyaux");
        int Classement = Volumes.ColumnNumber("Classement");
        String Patient = null;
        String Noyaux = null;
        int[] Type2 = new int[]{0, 1, 1, 0, 0, 0};
        FichierTabule Compteur = new FichierTabule(Hauteur, Type2, "Compteur");
        Compteur.setColumnName(0, "Compteur");
        Compteur.setColumnName(1, "Moyenne");
        Compteur.setColumnName(2, "Variance");
        Compteur.setColumnName(3, "VolumeTotal");
        Compteur.setColumnName(4, "VolumeMin");
        Compteur.setColumnName(5, "VolumeMax");
        this.Colonne = Volumes.ColumnNumber("Volume");
        for (int y = 0; y < Hauteur; ++y) {
            Patient = Source2.getValueString(y, PatientSource);
            Noyaux = Source2.getValueString(y, NoyauxSource);
            Volumes.ClearSelection();
            Volumes.SelectWhere(PatientVolumes, 0, Patient);
            Volumes.SelectFromSelectionWhere(NoyauxVolumes, 0, Noyaux);
            if (Focis) {
                Volumes.SelectFromSelectionWhere(Classement, 0, "Foci");
            } else {
                Volumes.SelectFromSelectionWhere(Classement, 0, "Trou");
            }
            this.Calculer(Volumes, Compteur, y);
        }
        return FichierTabuleTools.MergeSideBySide(Source2, Compteur);
    }

    protected void Calculer(FichierTabule Volumes, FichierTabule Compteur, int Ligne) {
        if (Volumes.nbSelected() > 0) {
            int y;
            int Max;
            int Debut = 0;
            while (!Volumes.isSelected(Debut)) {
                ++Debut;
            }
            int Fin = Volumes.Height() - 1;
            while (!Volumes.isSelected(Fin)) {
                --Fin;
            }
            int nb = 1;
            int Min = Max = Volumes.getValueInt(Debut, this.Colonne);
            int Volume = Max;
            for (y = Debut + 1; y <= Fin; ++y) {
                if (!Volumes.isSelected(y)) continue;
                int Taille = Volumes.getValueInt(y, this.Colonne);
                if (Taille < Min) {
                    Min = Taille;
                }
                if (Taille > Max) {
                    Max = Taille;
                }
                Volume += Taille;
                ++nb;
            }
            double Moyenne = (double)Volume / (double)nb;
            double Variance = 0.0;
            for (y = Debut; y <= Fin; ++y) {
                if (!Volumes.isSelected(y)) continue;
                Variance += Math.pow((double)Volumes.getValueInt(y, this.Colonne) - Moyenne, 2.0) / (double)nb;
            }
            Variance = Math.sqrt(Variance);
            Compteur.setValue(Ligne, 0, nb++);
            Compteur.setValue(Ligne, 1, Moyenne);
            Compteur.setValue(Ligne, 2, Variance);
            Compteur.setValue(Ligne, 3, Volume);
            Compteur.setValue(Ligne, 4, Min);
            Compteur.setValue(Ligne, 5, Max);
            return;
        }
        Compteur.setValue(Ligne, 0, 0);
        Compteur.setValue(Ligne, 1, 0.0);
        Compteur.setValue(Ligne, 2, 0.0);
        Compteur.setValue(Ligne, 3, 0);
        Compteur.setValue(Ligne, 4, 0);
        Compteur.setValue(Ligne, 5, 0);
    }
}

