/*
 * Decompiled with CFR 0.152.
 */
package softwares.progeria.nuclei;

import arrayTiTi.ArrayFeatures;
import characterization.textures.statisticalmatrices.rlm.MultiFuzzyRLM;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import measures.cclh.UnionFindCcl;
import morphee.geodesic.CloseHole;
import processing.reducer.ColorReducer;
import processing.reducer.MinMaxLinearGLR;
import processing.thresholding.Huang;
import utils.LogFile;

public class NucleiProcessing {
    int coucou;
    private final Huang huang = new Huang();
    private final CloseHole ch = new CloseHole();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final MultiFuzzyRLM characterizer = new MultiFuzzyRLM();
    private final ColorReducer reducer = new MinMaxLinearGLR();

    public void ReOrder(String diagnostic, String FolderIn, String FolderOut) throws Exception {
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        FichierTabule label = new FichierTabule(diagnostic, true);
        int texture = label.ColumnNumber("Texture");
        int workable = label.ColumnNumber("Workable");
        int nuclei = label.ColumnNumber("Nuclei");
        label.ClearAll();
        File[] boxes = new File(FolderIn).listFiles();
        for (int b = 0; b < boxes.length; ++b) {
            if (!boxes[b].isDirectory()) continue;
            File[] images = new File(boxes[b].getAbsolutePath()).listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().contains(".png")) continue;
                try {
                    String state;
                    label.SelectWhere(nuclei, 0, boxes[b].getName() + "/" + images[i2].getName().replace(".png", ".pgm"));
                    if (label.nbSelected() != 1) {
                        throw new Exception("label.nbSelected() = " + label.nbSelected());
                    }
                    int row = label.FirstSelected();
                    label.ClearSelection();
                    if (label.getValueString(row, workable).equalsIgnoreCase("False") || (state = label.getValueString(row, texture)).equalsIgnoreCase("Unknown")) continue;
                    BufferedImage im = ImageIO.Read(images[i2].getAbsolutePath());
                    BufferedImage imhsv = ImageConverter.RGB_To_HSV((BufferedImage)im);
                    float[] fb = ((DataBufferFloat)imhsv.getRaster().getDataBuffer()).getData();
                    BufferedImage imv = new BufferedImage(imhsv.getWidth(), imhsv.getHeight(), 10);
                    byte[] bb = ((DataBufferByte)imv.getRaster().getDataBuffer()).getData();
                    int x = 2;
                    int pos = 0;
                    while (x < fb.length) {
                        bb[pos] = (byte)(fb[x] * 255.0f + 0.5f);
                        x += 3;
                        ++pos;
                    }
                    BufferedImage imbin = this.huang.Filter(imv, 1);
                    BufferedImage imfilled = this.ch.Filter(imbin, 1);
                    this.ccl.Label(imfilled, 0, true);
                    int max = this.AF.Maximum(this.ccl.Sizes(), 1, this.ccl.Sizes().length);
                    this.ccl.DeleteSmallerThan(imfilled, max);
                    ImageDrawer.Border(imfilled, 0, 1);
                    BufferedImage imndg = ImageConverter.RGB_To_GrayLevel((BufferedImage)im, (int)1);
                    ImageComparator.Compare((BufferedImage)imfilled, (String)"!=", (int)0, (BufferedImage)imndg, (int)0, (BufferedImage)imndg);
                    ImageIO.Write(imndg, FolderOut + "/" + boxes[b].getName() + "_" + images[i2].getName().replace(".png", "_" + state + ".png"), 6);
                    continue;
                }
                catch (IOException ex) {
                    log.addNewException(ex, new String[0]);
                    ex.printStackTrace();
                }
            }
        }
    }

    private void Init() {
    }

    public void Process(String inputfolder, String outputfile, int nbCPU) throws Exception {
        int i2;
        File[] images = new File(inputfolder).listFiles();
        LogFile log = new LogFile();
        double[] Features2 = null;
        this.Init();
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(outputfile));
        String[] FeaturesNames = this.characterizer.FeaturesNames();
        for (i2 = 0; i2 < FeaturesNames.length; ++i2) {
            Out.write(String.valueOf("\"" + FeaturesNames[i2] + "\" ").getBytes("ASCII"));
        }
        Out.write(String.valueOf("Image Class\n").getBytes("ASCII"));
        for (i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png") || images[i2].getName().contains("_Mask.png")) continue;
            try {
                BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                String name = images[i2].getName();
                String label = name.contains("Homogeneous") ? "Normal" : "Pathological";
                this.characterizer.Compute(image, null, -2, 0, 1, 13, 3, nbCPU);
                Features2 = this.characterizer.Features();
                for (int c = 0; c < Features2.length; ++c) {
                    Out.write(String.valueOf(Features2[c] + " ").getBytes("ASCII"));
                }
                Out.write(String.valueOf("\"" + name + "\" \"" + label + "\"\n").getBytes("ASCII"));
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
                log.addNewException(E, new String[0]);
                continue;
            }
            catch (Error E) {
                E.printStackTrace();
                log.addNewError(E, new String[0]);
            }
        }
        System.out.println(log.Resume());
    }
}

