/*
 * Decompiled with CFR 0.152.
 */
package softwares.progeria.nuclei;

import filesAndFolders.FichiersDossiersIHM;
import gui.MailBox;
import imageTiTi.ImageIO;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.MouseInputListener;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesManager;
import measures.Measures2D;
import utils.times.Chronometer;

public class NucleiLabeling
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Box Horizontale;
    private Box VerticaleDroite;
    private Box VerticaleGauche;
    private int Largeur = 1000;
    private int Hauteur = 850;
    private int Marge = 50;
    private int Redimensionnement = 0;
    private double Zoom = 1.0;
    private Scanner Entree = null;
    private DataOutputStream Out = null;
    private DataOutputStream Sortie = null;
    private String FichierCourant = null;
    private String NomExpert = null;
    private File TirageExpert = null;
    private List<String> Liste = null;
    private BufferedImage BufferedImageCourante = null;
    private BufferedImage BufferedImageSegmentee = null;
    private BufferedImage ImageCourante = null;
    private JButton BoutonErreurSegmentation = null;
    private JButton BoutonFocis = null;
    private JButton BoutonNoyauReplie = null;
    private JButton BoutonNoyauInexploitable = null;
    private JButton BoutonNoyauCoupe = null;
    private JButton BoutonNoyauxSuperposes = null;
    private JButton BoutonWholes = null;
    private JButton BoutonValider = null;
    private JList ListeZoom = null;
    private JList ListeBoursoufle = null;
    private JList ListeTexture = null;
    private JList ListeTailleNoyau = null;
    private JList ListeDiagnostic = null;
    private JPanel PanneauGeneral = null;
    private JRadioButton RadioBoutonRimMarquee = null;
    private JRadioButton RadioBoutonRimReguliere = null;
    private JScrollPane ScrollPaneImageCouleur = null;
    private JScrollPane ScrollPaneImageSegmentee = null;
    private final Object obj = new Object();
    private Chronometer chrono = null;
    private Measures2D mesures = null;
    private int marker;
    private static final int DIAGNOSTIC = 0;
    private static final int TAG_FOCIS = 1;
    private static final int TAG_WHOLES = 2;
    private CoordinatesManager Focis = new CoordinatesManager((LinkedList)null);
    private CoordinatesManager Wholes = new CoordinatesManager((LinkedList)null);
    private int TaillePoints = 10;
    private int Action = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NucleiLabeling() {
        super("Diagnostic des noyaux, noyaux par noyaux.");
        this.Focis.CatchingArea(this.TaillePoints);
        this.Wholes.CatchingArea(this.TaillePoints);
        Calendar cal = Calendar.getInstance();
        this.chrono = new Chronometer();
        this.CreerIHM();
        this.setBoutons(false);
        Object object = this.obj;
        synchronized (object) {
            try {
                this.obj.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.TirageExpert = new File(this.NomExpert + "/Tirage");
        if (!this.TirageExpert.exists()) {
            MailBox mailBox = new MailBox(0, "Aucun fichier de tirage trouve pour cet expert !\nDonnees corrompues !", "Erreur de donnees");
            System.exit(0);
        }
        try {
            this.Liste = new ArrayList<String>(113);
            this.Entree = new Scanner(this.TirageExpert);
            while (this.Entree.hasNext()) {
                this.Liste.add(this.Entree.nextLine());
                this.Liste.add(this.Entree.nextLine());
            }
            this.Entree.close();
            Object month = cal.get(2) + 1 < 10 ? "0" + String.valueOf(cal.get(2) + 1) : String.valueOf(cal.get(2) + 1);
            Object day = cal.get(5) < 10 ? "0" + String.valueOf(cal.get(5)) : String.valueOf(cal.get(5));
            Object hour = cal.get(11) < 10 ? "0" + String.valueOf(cal.get(11)) : String.valueOf(cal.get(11));
            Object minute = cal.get(12) < 10 ? "0" + String.valueOf(cal.get(12)) : String.valueOf(cal.get(12));
            File FichierSortie = new File(this.NomExpert + "/Labeling_" + cal.get(1) + "_" + (String)month + "_" + (String)day + "_" + (String)hour + "_" + (String)minute);
            FichierSortie.createNewFile();
            this.Sortie = new DataOutputStream(new FileOutputStream(FichierSortie));
            File FichierOut = new File(this.NomExpert + "/FocisWholes_" + cal.get(1) + "_" + (String)month + "_" + (String)day + "_" + (String)hour + "_" + (String)minute);
            FichierOut.createNewFile();
            this.Out = new DataOutputStream(new FileOutputStream(FichierOut));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            while (this.Liste.size() > 0) {
                this.ImageCourante = null;
                this.BufferedImageCourante = null;
                this.BufferedImageSegmentee = null;
                this.ExtraireInformations(this.Liste.get(0));
                this.ImageCourante = ImageIO.Read(this.Liste.get(0));
                this.BufferedImageCourante = javax.imageio.ImageIO.read(new File(this.Liste.get(1)));
                this.BufferedImageSegmentee = javax.imageio.ImageIO.read(new File(this.Liste.get(1)));
                this.mesures = null;
                this.mesures = new Measures2D(this.ImageCourante);
                this.mesures.Basics(true, false);
                this.ReInitialisation();
                this.DessinerImage();
                this.setBoutons(true);
                this.marker = this.chrono.NewMarker();
                Object e = this.obj;
                synchronized (e) {
                    try {
                        this.obj.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
                this.Liste.remove(0);
                this.Liste.remove(0);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.Quitter();
    }

    private void CreerIHM() {
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NucleiLabeling.this.Quitter();
            }
        };
        this.addWindowListener(l);
        this.setSize(this.Largeur + 2 * this.Marge, this.Hauteur + 2 * this.Marge);
        this.setLocation(200, 0);
        this.Horizontale = Box.createHorizontalBox();
        this.VerticaleDroite = Box.createVerticalBox();
        this.VerticaleGauche = Box.createVerticalBox();
        JLabel TitreVerticaleGauche = new JLabel("Noyau");
        TitreVerticaleGauche.setForeground(Color.BLUE);
        JLabel TexteZoom = new JLabel("Zoom -> ");
        String[] TypeZoom = new String[]{"50 %", "100 %", "150 %", "200 %", "250 %", "300 %"};
        this.ListeZoom = new JList<String>(TypeZoom);
        this.ListeZoom.setSelectedIndex(1);
        JPanel PanneauZoom = new JPanel();
        PanneauZoom.add(TexteZoom);
        PanneauZoom.add(this.ListeZoom);
        this.ListeZoom.addListSelectionListener(lse -> {
            switch (this.ListeZoom.getSelectedIndex()) {
                case 0: {
                    this.Zoom = 0.5;
                    break;
                }
                case 1: {
                    this.Zoom = 1.0;
                    break;
                }
                case 2: {
                    this.Zoom = 1.5;
                    break;
                }
                case 3: {
                    this.Zoom = 2.0;
                    break;
                }
                case 4: {
                    this.Zoom = 2.5;
                    break;
                }
                case 5: {
                    this.Zoom = 3.0;
                    break;
                }
                default: {
                    throw new Error("Default: unfnow value of zoom = " + this.ListeZoom.getSelectedIndex());
                }
            }
            this.Action = 0;
            this.DessinerImage();
        });
        MouseInputListener mouse = new MouseInputListener(){
            public static final int ClicG = 1;
            public static final int ClicM = 2;
            public static final int ClicD = 3;

            @Override
            public void mouseClicked(MouseEvent me) {
                switch (me.getButton()) {
                    case 1: {
                        if (NucleiLabeling.this.Action == 1) {
                            NucleiLabeling.this.Focis.NewPoint(me.getX(), me.getY(), 0);
                        } else if (NucleiLabeling.this.Action == 2) {
                            NucleiLabeling.this.Wholes.NewPoint(me.getX(), me.getY(), 0);
                        }
                        NucleiLabeling.this.DrawSegmentationFocisWholes();
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (NucleiLabeling.this.Action == 1 && NucleiLabeling.this.Focis.TakenPoint() != -1) {
                            NucleiLabeling.this.Focis.Remove(NucleiLabeling.this.Focis.TakenPoint());
                        } else if (NucleiLabeling.this.Action == 2 && NucleiLabeling.this.Wholes.TakenPoint() != -1) {
                            NucleiLabeling.this.Wholes.Remove(NucleiLabeling.this.Wholes.TakenPoint());
                        }
                        NucleiLabeling.this.DrawSegmentationFocisWholes();
                        break;
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
                switch (me.getButton()) {
                    case 1: {
                        if (NucleiLabeling.this.Action == 1) {
                            NucleiLabeling.this.Focis.TakenPoint(NucleiLabeling.this.Focis.Find(me.getX(), me.getY(), 0));
                            break;
                        }
                        if (NucleiLabeling.this.Action != 2) break;
                        NucleiLabeling.this.Wholes.TakenPoint(NucleiLabeling.this.Wholes.Find(me.getX(), me.getY(), 0));
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (NucleiLabeling.this.Action == 1) {
                    NucleiLabeling.this.Focis.TakenPoint(-1);
                } else if (NucleiLabeling.this.Action == 2) {
                    NucleiLabeling.this.Wholes.TakenPoint(-1);
                }
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                switch (me.getButton()) {
                    case 1: {
                        if (NucleiLabeling.this.Action == 1 && NucleiLabeling.this.Focis.TakenPoint() != -1) {
                            NucleiLabeling.this.Focis.setPoint(NucleiLabeling.this.Focis.TakenPoint(), me.getX(), me.getY(), 0);
                        } else if (NucleiLabeling.this.Action == 2 && NucleiLabeling.this.Wholes.TakenPoint() != -1) {
                            NucleiLabeling.this.Wholes.setPoint(NucleiLabeling.this.Wholes.TakenPoint(), me.getX(), me.getY(), 0);
                        }
                        NucleiLabeling.this.DrawSegmentationFocisWholes();
                        break;
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent me) {
            }
        };
        this.ScrollPaneImageCouleur = new JScrollPane();
        this.ScrollPaneImageSegmentee = new JScrollPane();
        this.ScrollPaneImageCouleur.setDoubleBuffered(true);
        this.ScrollPaneImageSegmentee.setDoubleBuffered(true);
        this.ScrollPaneImageSegmentee.addMouseListener(mouse);
        this.ScrollPaneImageSegmentee.addMouseMotionListener(mouse);
        this.BoutonErreurSegmentation = new JButton("Erreur de segmentation");
        this.BoutonErreurSegmentation.setEnabled(false);
        this.BoutonErreurSegmentation.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(1, 0, 0, 0, 0);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.BoutonNoyauxSuperposes = new JButton("Noyaux superposes/colles/mitose");
        this.BoutonNoyauxSuperposes.setEnabled(false);
        this.BoutonNoyauxSuperposes.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(0, 1, 0, 0, 0);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.BoutonNoyauCoupe = new JButton("Noyau coupe (sur le bord)");
        this.BoutonNoyauCoupe.setEnabled(false);
        this.BoutonNoyauCoupe.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(0, 0, 1, 0, 0);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.BoutonNoyauReplie = new JButton("Noyau replie/dechire");
        this.BoutonNoyauReplie.setEnabled(false);
        this.BoutonNoyauReplie.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(0, 0, 0, 1, 0);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.BoutonNoyauInexploitable = new JButton("Noyau inexploitable");
        this.BoutonNoyauInexploitable.setEnabled(false);
        this.BoutonNoyauInexploitable.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(0, 0, 0, 0, 1);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.VerticaleGauche.setDoubleBuffered(true);
        this.VerticaleGauche.add(TitreVerticaleGauche);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(PanneauZoom);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.ScrollPaneImageCouleur);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.BoutonErreurSegmentation);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.BoutonNoyauCoupe);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.BoutonNoyauReplie);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.BoutonNoyauInexploitable);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.ScrollPaneImageSegmentee);
        JLabel TitreVerticaleDroite = new JLabel("Diagnostic des noyaux");
        TitreVerticaleDroite.setForeground(Color.BLUE);
        JLabel TexteBoursoufle = new JLabel("Forme -> ");
        String[] TypeBoursoufle = new String[]{"Normale (convexe)", "Anormale (boursouflee)", "Incertaine"};
        this.ListeBoursoufle = new JList<String>(TypeBoursoufle);
        JPanel PanneauBoursoufle = new JPanel();
        PanneauBoursoufle.add(TexteBoursoufle);
        PanneauBoursoufle.add(this.ListeBoursoufle);
        JLabel TexteTexture = new JLabel("<- Texture");
        String[] TypeTexture = new String[]{"Homogene", "Non homogene", "Incertaine"};
        this.ListeTexture = new JList<String>(TypeTexture);
        JPanel PanneauTexture = new JPanel();
        PanneauTexture.add(this.ListeTexture);
        PanneauTexture.add(TexteTexture);
        Box Horizontale1 = Box.createHorizontalBox();
        Horizontale1.add(PanneauBoursoufle);
        Horizontale1.add(PanneauTexture);
        JLabel TexteTailleNoyau = new JLabel("Taille -> ");
        String[] TypeTailleNoyau = new String[]{"Normale", "Anormale (petite/grosse)", "Incertaine"};
        this.ListeTailleNoyau = new JList<String>(TypeTailleNoyau);
        JPanel PanneauTailleNoyau = new JPanel();
        PanneauTailleNoyau.add(TexteTailleNoyau);
        PanneauTailleNoyau.add(this.ListeTailleNoyau);
        this.BoutonFocis = new JButton("Marquer les focis");
        this.BoutonFocis.setEnabled(false);
        this.BoutonFocis.addActionListener(e -> {
            this.ListeZoom.setSelectedIndex(1);
            this.Action = 1;
            this.DessinerImage();
        });
        this.BoutonWholes = new JButton("Marquer les trous");
        this.BoutonWholes.setEnabled(false);
        this.BoutonWholes.addActionListener(e -> {
            this.ListeZoom.setSelectedIndex(1);
            this.Action = 2;
            this.DessinerImage();
        });
        JLabel TexteDiagnostic = new JLabel("Diagnostic -> ");
        String[] TypeDiagnostic = new String[]{"Normal (Sain)", "Anormal (Pathologique)", "Incertain"};
        this.ListeDiagnostic = new JList<String>(TypeDiagnostic);
        JPanel PanneauDiagnostic = new JPanel();
        PanneauDiagnostic.add(TexteDiagnostic);
        PanneauDiagnostic.add(this.ListeDiagnostic);
        this.RadioBoutonRimMarquee = new JRadioButton("Rim marquee");
        this.RadioBoutonRimReguliere = new JRadioButton("Rim reguliere");
        this.BoutonValider = new JButton("Valider le diagnostic");
        this.BoutonValider.setEnabled(false);
        this.BoutonValider.addActionListener(e -> {
            if (this.ListeBoursoufle.getSelectedIndex() < 0 || this.ListeTexture.getSelectedIndex() < 0 || this.ListeTailleNoyau.getSelectedIndex() < 0 || this.ListeDiagnostic.getSelectedIndex() < 0) {
                MailBox mailBox = new MailBox(0, "Au moins un champs non renseigne.", "Diagnostic incomplet");
                return;
            }
            this.setBoutons(false);
            this.EcrireStats(0, 0, 0, 0, 0);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.VerticaleDroite.setDoubleBuffered(true);
        this.VerticaleDroite.add(TitreVerticaleDroite);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(Horizontale1);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(PanneauTailleNoyau);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(this.BoutonFocis);
        this.VerticaleDroite.add(this.BoutonWholes);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(this.RadioBoutonRimMarquee);
        this.VerticaleDroite.add(this.RadioBoutonRimReguliere);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(PanneauDiagnostic);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 15)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(this.BoutonValider);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.Horizontale.setDoubleBuffered(true);
        this.Horizontale.add(this.VerticaleGauche);
        this.Horizontale.add(Box.createRigidArea(new Dimension(2 * this.Marge, this.Marge)));
        this.Horizontale.add(this.VerticaleDroite);
        this.PanneauGeneral = new JPanel();
        this.PanneauGeneral.add(this.Horizontale);
        this.PanneauGeneral.setVisible(true);
        this.PanneauGeneral.setPreferredSize(new Dimension(this.Largeur, this.Hauteur - this.Marge));
        this.PanneauGeneral.setDoubleBuffered(true);
        this.setContentPane(this.PanneauGeneral);
        this.setJMenuBar(this.CreerMenu());
        this.setVisible(true);
    }

    private JMenuBar CreerMenu() {
        JMenuBar barre = new JMenuBar();
        JMenu Fichier = new JMenu("Fichier");
        JMenuItem Nouvelle = new JMenuItem("Nouvelle expertise");
        Nouvelle.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent arg0) {
                MailBox boite = new MailBox(2, "Entrez votre nom", "Creation d'une nouvelle expertise.");
                if (boite.getReponseString() == null || boite.getReponseString().equalsIgnoreCase("")) {
                    MailBox mailBox = new MailBox(0, "Aucun nom n'a ete saisi !", "Erreur de saisie");
                    return;
                }
                NucleiLabeling.this.NomExpert = "./Experts/" + boite.getReponseString();
                File dossier = new File(NucleiLabeling.this.NomExpert);
                if (dossier.exists()) {
                    MailBox mailBox = new MailBox(0, "Il existe deje une expertise avec ce nom !", "Erreur de saisie, nom existant");
                    return;
                }
                File Tirage = new File(NucleiLabeling.this.NomExpert + "/Tirage");
                try {
                    dossier.mkdir();
                    Tirage.createNewFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                NucleiLabeling.this.TirerAleatoirement(Tirage);
                Object object = NucleiLabeling.this.obj;
                synchronized (object) {
                    NucleiLabeling.this.obj.notify();
                }
            }
        });
        JMenuItem Ouvrir = new JMenuItem("Ouvrir expertise");
        Ouvrir.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent arg0) {
                File dossier = FichiersDossiersIHM.ChoisirDossier(new File("./Experts").getAbsolutePath(), false);
                if (dossier == null) {
                    return;
                }
                NucleiLabeling.this.NomExpert = dossier.getAbsolutePath();
                Object object = NucleiLabeling.this.obj;
                synchronized (object) {
                    NucleiLabeling.this.obj.notify();
                }
            }
        });
        JMenuItem Quitter = new JMenuItem("Quitter");
        Quitter.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                NucleiLabeling.this.Quitter();
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        Fichier.add(Nouvelle);
        Fichier.add(Ouvrir);
        Fichier.add(new JSeparator());
        Fichier.add(Quitter);
        barre.add(Fichier);
        return barre;
    }

    private void Quitter() {
        Iterator<String> iter = null;
        try {
            if (this.Sortie != null) {
                this.Sortie.close();
            }
            this.Sortie = null;
            if (this.NomExpert != null) {
                this.Sortie = new DataOutputStream(new FileOutputStream(this.NomExpert + "/Tirage"));
                iter = this.Liste.iterator();
                while (iter.hasNext()) {
                    this.Sortie.write((iter.next() + "\n").getBytes("ASCII"));
                }
                this.Sortie.close();
                System.err.println("Temps de travail : " + this.chrono.getTimeSinceMarker(0) + "s");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void TirerAleatoirement(File fichier) {
        File[] DossierNoyaux = new File("./Resultat_Extraction_Tous_Noyaux/").listFiles();
        File[] ListeNoyaux = null;
        Iterator iter = null;
        ArrayList<String> ListeComplete = new ArrayList<String>(113);
        DataOutputStream sortie = null;
        for (int i2 = 0; i2 < DossierNoyaux.length; ++i2) {
            if (!DossierNoyaux[i2].isDirectory()) continue;
            ListeNoyaux = null;
            ListeNoyaux = DossierNoyaux[i2].listFiles();
            for (int j = 0; j < ListeNoyaux.length; ++j) {
                int position;
                if (ListeNoyaux[j].getName().equalsIgnoreCase(".DS_Store")) continue;
                while ((position = (int)(Math.random() * (double)ListeComplete.size())) % 2 == 1) {
                }
                ListeComplete.add(position, ListeNoyaux[j++].getAbsolutePath());
                ListeComplete.add(position + 1, ListeNoyaux[j].getAbsolutePath());
            }
        }
        try {
            sortie = new DataOutputStream(new FileOutputStream(fichier));
            iter = ListeComplete.iterator();
            while (iter.hasNext()) {
                sortie.write(((String)iter.next() + "\n").getBytes("ASCII"));
            }
            sortie.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ExtraireInformations(String nom) {
        int pos = nom.length() - 1;
        while (nom.charAt(pos--) != '/') {
        }
        while (nom.charAt(pos) != '/') {
            --pos;
        }
        this.FichierCourant = nom.substring(++pos);
    }

    private void DrawSegmentationFocisWholes() {
        Coordinates point2 = null;
        this.BufferedImageSegmentee.createGraphics().drawImage((Image)this.BufferedImageCourante, 0, 0, null);
        for (Coordinates point2 : this.mesures.Contour.Points()) {
            this.BufferedImageSegmentee.setRGB(point2.X, point2.Y, -55000);
            point2 = null;
        }
        Iterator<Coordinates> iter = null;
        int WidthGap = (this.ScrollPaneImageSegmentee.getWidth() - this.BufferedImageSegmentee.getWidth()) / 2;
        int HeightGap = (this.ScrollPaneImageSegmentee.getHeight() - this.BufferedImageSegmentee.getHeight()) / 2;
        Graphics2D graphics = this.BufferedImageSegmentee.createGraphics();
        if (this.Action == 1) {
            graphics.setColor(Color.BLUE);
            iter = this.Focis.Iterator();
            while (iter.hasNext()) {
                point2 = iter.next();
                graphics.drawRect(point2.X - this.TaillePoints / 2 - 2 - WidthGap, point2.Y - this.TaillePoints / 2 - 2 - HeightGap, this.TaillePoints, this.TaillePoints);
                point2 = null;
            }
            iter = null;
        } else if (this.Action == 2) {
            graphics.setColor(Color.YELLOW);
            iter = this.Wholes.Iterator();
            while (iter.hasNext()) {
                point2 = iter.next();
                graphics.drawRect(point2.X - this.TaillePoints / 2 - 2 - WidthGap, point2.Y - this.TaillePoints / 2 - 2 - HeightGap, this.TaillePoints, this.TaillePoints);
                point2 = null;
            }
            iter = null;
        }
        int largeur = (int)((double)this.BufferedImageCourante.getWidth() * this.Zoom);
        int hauteur = (int)((double)this.BufferedImageCourante.getHeight() * this.Zoom);
        this.ScrollPaneImageSegmentee.setViewportView(new JLabel(new ImageIcon(this.BufferedImageSegmentee.getScaledInstance(largeur, hauteur, 1))));
    }

    private void DessinerImage() {
        int largeur = (int)((double)this.BufferedImageCourante.getWidth() * this.Zoom);
        int hauteur = (int)((double)this.BufferedImageCourante.getHeight() * this.Zoom);
        this.DrawSegmentationFocisWholes();
        this.ScrollPaneImageCouleur.setViewportView(new JLabel(new ImageIcon(this.BufferedImageCourante.getScaledInstance(largeur, hauteur, 1))));
        if (this.Redimensionnement % 2 == 0) {
            this.setSize(this.Largeur + 2 * this.Marge - 1, this.Hauteur + 2 * this.Marge - 1);
        } else {
            this.setSize(this.Largeur + 2 * this.Marge + 1, this.Hauteur + 2 * this.Marge + 1);
        }
        ++this.Redimensionnement;
    }

    private void EcrireStats(int ErreurSegmentation, int NoyauxSuperposes, int NoyauCoupe, int NoyauReplie, int NoyauInexploitable) {
        try {
            Coordinates c;
            this.Out.write(String.valueOf(this.FichierCourant + " ").getBytes("ASCII"));
            this.Out.write(String.valueOf(this.Focis.Size() + " ").getBytes("ASCII"));
            Iterator<Coordinates> iter = this.Focis.Iterator();
            while (iter.hasNext()) {
                c = iter.next();
                this.Out.write(String.valueOf(c.X + " " + c.Y + " ").getBytes("ASCII"));
                c = null;
            }
            iter = null;
            iter = this.Wholes.Iterator();
            while (iter.hasNext()) {
                c = iter.next();
                this.Out.write(String.valueOf(c.X + " " + c.Y + " ").getBytes("ASCII"));
                c = null;
            }
            this.Out.write("\n".getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeBoursoufle.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeTexture.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeTailleNoyau.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.Focis.Size() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.Wholes.Size() + " ").getBytes("ASCII"));
            if (this.RadioBoutonRimMarquee.isSelected()) {
                this.Sortie.write(String.valueOf("1 ").getBytes("ASCII"));
            } else {
                this.Sortie.write(String.valueOf("0 ").getBytes("ASCII"));
            }
            if (this.RadioBoutonRimReguliere.isSelected()) {
                this.Sortie.write(String.valueOf("1 ").getBytes("ASCII"));
            } else {
                this.Sortie.write(String.valueOf("0 ").getBytes("ASCII"));
            }
            this.Sortie.write(String.valueOf(ErreurSegmentation + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(NoyauxSuperposes + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(NoyauCoupe + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(NoyauReplie + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(NoyauInexploitable + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeDiagnostic.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.chrono.getTimeSinceMarker(this.marker) + " ").getBytes("ASCII"));
            this.chrono.FreeMarker(this.marker);
            this.Sortie.write(String.valueOf(" " + this.FichierCourant).getBytes("ASCII"));
            this.Sortie.write("\n".getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ReInitialisation() {
        this.Focis.RemoveAll();
        this.Wholes.RemoveAll();
        this.ListeBoursoufle.clearSelection();
        this.ListeTexture.clearSelection();
        this.ListeTailleNoyau.clearSelection();
        this.ListeDiagnostic.clearSelection();
        this.RadioBoutonRimMarquee.setSelected(false);
        this.RadioBoutonRimReguliere.setSelected(false);
    }

    private void setBoutons(boolean Valeur) {
        this.BoutonErreurSegmentation.setEnabled(Valeur);
        this.BoutonFocis.setEnabled(Valeur);
        this.BoutonNoyauxSuperposes.setEnabled(Valeur);
        this.BoutonNoyauCoupe.setEnabled(Valeur);
        this.BoutonNoyauReplie.setEnabled(Valeur);
        this.BoutonNoyauInexploitable.setEnabled(Valeur);
        this.BoutonValider.setEnabled(Valeur);
        this.BoutonWholes.setEnabled(Valeur);
    }

    public static void main(String[] args) {
        NucleiLabeling nucleiLabeling = new NucleiLabeling();
    }
}

