/*
 * Decompiled with CFR 0.152.
 */
package softwares.progeria.nuclei;

import characterization.shapes.shapeIndexes.ShapeIndexesComputer;
import filesAndFolders.FichiersDossiersIHM;
import imageTiTi.ImageIO;
import imageTiTi.SubImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import measures.Measures2D;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.BasicChamfer;
import morphee.StructuringElement;
import processing.thresholding.Binary;

public class ImagesDeNoyaux
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Box Horizontale;
    private Box VerticaleDroite;
    private Box VerticaleGauche;
    private int Largeur = 800;
    private int Hauteur = 850;
    private int Marge = 50;
    private int nbImages = 0;
    private int Redimensionnement = 0;
    private int minx;
    private int miny;
    private int maxx;
    private int maxy;
    private int SurfaceMinimum = 0;
    private String FichierCourant = null;
    private DataOutputStream Sortie = null;
    private File Dossier = null;
    private BufferedImage BufferedImageCourante = null;
    private BufferedImage ImageCourante = null;
    private ShapeIndexesComputer indices = null;
    private Measures2D mesures = null;
    private JButton BoutonIgnorer = null;
    private JButton BoutonValider = null;
    private JList ListeBoursoufle = null;
    private JList ListeDiagnostic = null;
    private JList ListeTailleNoyau = null;
    private JList ListeTexture = null;
    private JPanel PanneauGeneral = null;
    private JRadioButton RadioBoutonReplie = null;
    private JRadioButton RadioBoutonRimMarquee = null;
    private JRadioButton RadioBoutonRimReguliere = null;
    private JRadioButton RadioBoutonSegmentation = null;
    private JScrollPane ScrollPaneImageCouleur = null;
    private JScrollPane ScrollPaneImageNDG = null;
    private final JSpinner SpinnerFoci = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1));
    private final JSpinner SpinnerNbArtefact = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1));
    private final JSpinner SpinnerTrous = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1));
    private final JSpinner SpinnerTrousArtefact = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1));
    private Object obj = new Object();
    protected Binary binary = new Binary();
    protected ConnectedComponentLabeling ccl = new UnionFindCcl();

    public ImagesDeNoyaux() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagesDeNoyaux(String CheminDossier, int DimensionsMinimum, int SurfaceMinimum) throws IOException {
        super("Diagnostic des noyaux e partir des images completes.");
        this.SurfaceMinimum = SurfaceMinimum;
        this.Dossier = CheminDossier == null ? FichiersDossiersIHM.ChoisirDossier(new File("").getAbsolutePath(), true) : new File(CheminDossier);
        File[] fichiers = this.Dossier.listFiles();
        File Stats = new File(this.Dossier.getAbsolutePath() + "/Stats");
        File Statistiques = new File(Stats.getAbsolutePath() + "/Statistiques.txt");
        try {
            Stats.mkdir();
            Statistiques.createNewFile();
            this.Sortie = new DataOutputStream(new FileOutputStream(Statistiques));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.CreerIHM();
        BufferedImage Segmentee = null;
        SubImage sousimage = null;
        this.nbImages = 0;
        for (int i2 = 0; i2 < fichiers.length; ++i2) {
            if (!fichiers[i2].isFile() || fichiers[i2].getName().equalsIgnoreCase(".DS_Store")) continue;
            this.BoutonIgnorer.setEnabled(false);
            this.BoutonValider.setEnabled(false);
            System.out.print(i2 + " - ");
            this.FichierCourant = fichiers[i2].getName();
            Segmentee = null;
            Segmentee = ImageIO.Read(this.Dossier.getPath() + "/" + fichiers[i2++].getName());
            this.ccl.Label(Segmentee, 0, false);
            Iterator iter = this.ccl.SeparateComponentsSub(null, SurfaceMinimum, 1).iterator();
            try {
                this.BufferedImageCourante = javax.imageio.ImageIO.read(new File(this.Dossier.getPath() + "/" + fichiers[i2].getName()));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            while (iter.hasNext()) {
                this.ImageCourante = null;
                sousimage = null;
                sousimage = (SubImage)iter.next();
                this.ImageCourante = sousimage.SubImage();
                if (this.ImageCourante.getHeight() < DimensionsMinimum && this.ImageCourante.getWidth() < DimensionsMinimum) continue;
                this.minx = sousimage.getMinx();
                this.miny = sousimage.getMiny();
                this.maxx = sousimage.getMaxx();
                this.maxy = sousimage.getMaxy();
                this.DessinerImage();
                this.BoutonIgnorer.setEnabled(true);
                this.BoutonValider.setEnabled(true);
                Object e1 = this.obj;
                synchronized (e1) {
                    try {
                        this.obj.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.BoutonIgnorer.setEnabled(false);
        this.BoutonValider.setEnabled(false);
        try {
            this.Sortie.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void CreerIHM() {
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        this.addWindowListener(l);
        this.setSize(this.Largeur + 2 * this.Marge, this.Hauteur);
        this.setLocation(200, 0);
        this.Horizontale = Box.createHorizontalBox();
        this.VerticaleDroite = Box.createVerticalBox();
        this.VerticaleGauche = Box.createVerticalBox();
        JLabel TitreVerticaleGauche = new JLabel("Noyau");
        TitreVerticaleGauche.setForeground(Color.BLUE);
        this.ScrollPaneImageCouleur = new JScrollPane();
        this.ScrollPaneImageNDG = new JScrollPane();
        this.ScrollPaneImageCouleur.setDoubleBuffered(true);
        this.ScrollPaneImageNDG.setDoubleBuffered(true);
        this.VerticaleGauche.setDoubleBuffered(true);
        this.VerticaleGauche.add(TitreVerticaleGauche);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 10)));
        this.VerticaleGauche.add(this.ScrollPaneImageCouleur);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 10)));
        this.VerticaleGauche.add(this.ScrollPaneImageNDG);
        JLabel TitreVerticaleDroite = new JLabel("Diagnostic");
        TitreVerticaleDroite.setForeground(Color.BLUE);
        JLabel TexteBoursoufle = new JLabel("Noyau Boursoufle -> ");
        String[] TypeBoursoufle = new String[]{"Non boursoufle", "Legerement boursoufle", "Boursoufle"};
        this.ListeBoursoufle = new JList<String>(TypeBoursoufle);
        JPanel PanneauBoursoufle = new JPanel();
        PanneauBoursoufle.add(TexteBoursoufle);
        PanneauBoursoufle.add(this.ListeBoursoufle);
        this.RadioBoutonSegmentation = new JRadioButton("Erreur de segmentation");
        JLabel TexteTailleNoyau = new JLabel("Taille -> ");
        String[] TypeTailleNoyau = new String[]{"Petit", "Normal", "Gros"};
        this.ListeTailleNoyau = new JList<String>(TypeTailleNoyau);
        JPanel PanneauTailleNoyau = new JPanel();
        PanneauTailleNoyau.add(TexteTailleNoyau);
        PanneauTailleNoyau.add(this.ListeTailleNoyau);
        JLabel TexteFoci = new JLabel("Nombre de Foci -> ");
        JPanel PanneauFoci = new JPanel();
        PanneauFoci.add(TexteFoci);
        PanneauFoci.add(this.SpinnerFoci);
        JLabel TexteNbTrous = new JLabel("Nombre de Trous -> ");
        JPanel PanneauTrous = new JPanel();
        PanneauTrous.add(TexteNbTrous);
        PanneauTrous.add(this.SpinnerTrous);
        JLabel TexteNbTrousArtefact = new JLabel("Nombre de Trous de Artefacts -> ");
        JPanel PanneauTrousArtefact = new JPanel();
        PanneauTrousArtefact.add(TexteNbTrousArtefact);
        PanneauTrousArtefact.add(this.SpinnerTrousArtefact);
        JLabel TexteNbArtefact = new JLabel("Nombre d'Artefacts de marquage -> ");
        JPanel PanneauNbArtefact = new JPanel();
        PanneauNbArtefact.add(TexteNbArtefact);
        PanneauNbArtefact.add(this.SpinnerNbArtefact);
        JLabel TexteTexture = new JLabel("Texture -> ");
        String[] TypeTexture = new String[]{"Homogene", "Legerement non homogene", "Non homogene"};
        this.ListeTexture = new JList<String>(TypeTexture);
        JPanel PanneauTexture = new JPanel();
        PanneauTexture.add(TexteTexture);
        PanneauTexture.add(this.ListeTexture);
        this.RadioBoutonReplie = new JRadioButton("Noyau replie");
        this.RadioBoutonRimMarquee = new JRadioButton("Rim marquee");
        this.RadioBoutonRimReguliere = new JRadioButton("Rim reguliere");
        JLabel TexteDiagnostic = new JLabel("Diagnostic -> ");
        String[] TypeDiagnostic = new String[]{"Normal", "Legerement anormal", "Anormal"};
        this.ListeDiagnostic = new JList<String>(TypeDiagnostic);
        JPanel PanneauDiagnostic = new JPanel();
        PanneauDiagnostic.add(TexteDiagnostic);
        PanneauDiagnostic.add(this.ListeDiagnostic);
        this.BoutonValider = new JButton("Valider");
        this.BoutonValider.setEnabled(false);
        this.BoutonValider.addActionListener(e -> {
            this.BoutonIgnorer.setEnabled(false);
            this.BoutonValider.setEnabled(false);
            try {
                ImageIO.Write(this.ImageCourante, this.Dossier.getPath() + "/Stats/" + this.nbImages + ".pgm", 5);
                javax.imageio.ImageIO.write((RenderedImage)this.BufferedImageCourante.getSubimage(this.minx, this.miny, this.maxx - this.minx, this.maxy - this.miny), "png", new File(this.Dossier.getPath() + "/Stats/" + this.nbImages + ".png"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.Mesures(this.binary.Filter(this.ImageCourante, 1));
            this.Indices();
            this.EcrireStats();
            ++this.nbImages;
            this.ReInitialisation();
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.BoutonIgnorer = new JButton("Ignorer");
        this.BoutonIgnorer.setEnabled(false);
        this.BoutonIgnorer.addActionListener(e -> {
            this.BoutonIgnorer.setEnabled(false);
            this.BoutonValider.setEnabled(false);
            this.ReInitialisation();
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.VerticaleDroite.setDoubleBuffered(true);
        this.VerticaleDroite.add(TitreVerticaleDroite);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 20)));
        this.VerticaleDroite.add(PanneauBoursoufle);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(this.RadioBoutonSegmentation);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(PanneauTailleNoyau);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(PanneauFoci);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(PanneauTrous);
        this.VerticaleDroite.add(PanneauTrousArtefact);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(PanneauNbArtefact);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(PanneauTexture);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(this.RadioBoutonReplie);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(this.RadioBoutonRimMarquee);
        this.VerticaleDroite.add(this.RadioBoutonRimReguliere);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(PanneauDiagnostic);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 20)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(this.BoutonValider);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(this.BoutonIgnorer);
        this.Horizontale.setDoubleBuffered(true);
        this.Horizontale.add(this.VerticaleGauche);
        this.Horizontale.add(Box.createRigidArea(new Dimension(2 * this.Marge, this.Marge)));
        this.Horizontale.add(this.VerticaleDroite);
        this.PanneauGeneral = new JPanel();
        this.PanneauGeneral.add(this.Horizontale);
        this.PanneauGeneral.setVisible(true);
        this.PanneauGeneral.setPreferredSize(new Dimension(this.Largeur, this.Hauteur - this.Marge));
        this.PanneauGeneral.setDoubleBuffered(true);
        this.setContentPane(this.PanneauGeneral);
        this.setVisible(true);
        this.ReInitialisation();
    }

    private void Mesures(BufferedImage image) {
        this.mesures = null;
        this.mesures = new Measures2D(image);
        this.mesures.Basics(true, false);
        this.mesures.EuclidianRadii();
        this.mesures.EuclidianDiameter();
        this.mesures.MainAxes();
        this.mesures.DistanceMapAndDiskMax(new StructuringElement(new Object[]{BasicChamfer.Chamfer13, -14}));
        this.mesures.GeodesicDiameter(new StructuringElement(new Object[]{6, -15}), false);
        this.mesures.DiskMin();
        this.mesures.NbHoles(true);
        this.mesures.ConnectedComponents(0, true);
        this.mesures.ConvexHull(true, this.SurfaceMinimum);
    }

    private void Indices() {
        this.indices = null;
        this.indices = new ShapeIndexesComputer();
        this.indices.ComputeIndexes(this.mesures);
    }

    private void DessinerImage() {
        this.ScrollPaneImageCouleur.setViewportView(new JLabel(new ImageIcon(this.BufferedImageCourante.getSubimage(this.minx, this.miny, this.maxx - this.minx, this.maxy - this.miny))));
        this.ScrollPaneImageCouleur.setSize(this.maxx - this.minx, this.maxy - this.miny);
        this.ScrollPaneImageNDG.setViewportView(new JLabel(new ImageIcon(this.binary.Filter(this.ImageCourante, 1))));
        this.ScrollPaneImageNDG.setSize(this.maxx - this.minx, this.maxy - this.miny);
        if (this.Redimensionnement % 2 == 0) {
            this.setSize(this.Largeur - 1, this.Hauteur - 1);
        } else {
            this.setSize(this.Largeur + 1, this.Hauteur + 1);
        }
        ++this.Redimensionnement;
    }

    private void EcrireStats() {
        try {
            this.Sortie.write(String.valueOf(this.mesures.getSurface() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.mesures.getPerimetre() + " ").getBytes("ASCII"));
            for (int i2 = 0; i2 < this.indices.Indexes.length; ++i2) {
                this.Sortie.write(String.valueOf(this.indices.Indexes[i2].LastValue() + " ").getBytes("ASCII"));
            }
            this.Sortie.write(String.valueOf(this.ListeBoursoufle.getSelectedIndex() + " ").getBytes("ASCII"));
            if (this.RadioBoutonSegmentation.isSelected()) {
                this.Sortie.write(String.valueOf("1 ").getBytes("ASCII"));
            } else {
                this.Sortie.write(String.valueOf("0 ").getBytes("ASCII"));
            }
            this.Sortie.write(String.valueOf(this.ListeTailleNoyau.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.SpinnerFoci.getValue() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.SpinnerTrous.getValue() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.SpinnerTrousArtefact.getValue() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.SpinnerNbArtefact.getValue() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeTexture.getSelectedIndex() + " ").getBytes("ASCII"));
            if (this.RadioBoutonReplie.isSelected()) {
                this.Sortie.write(String.valueOf("1 ").getBytes("ASCII"));
            } else {
                this.Sortie.write(String.valueOf("0 ").getBytes("ASCII"));
            }
            if (this.RadioBoutonRimMarquee.isSelected()) {
                this.Sortie.write(String.valueOf("1 ").getBytes("ASCII"));
            } else {
                this.Sortie.write(String.valueOf("0 ").getBytes("ASCII"));
            }
            if (this.RadioBoutonRimReguliere.isSelected()) {
                this.Sortie.write(String.valueOf("1 ").getBytes("ASCII"));
            } else {
                this.Sortie.write(String.valueOf("0 ").getBytes("ASCII"));
            }
            this.Sortie.write(String.valueOf(this.ListeDiagnostic.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.FichierCourant).getBytes("ASCII"));
            this.Sortie.write("\n".getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ReInitialisation() {
        this.ListeBoursoufle.setSelectedIndex(0);
        this.ListeDiagnostic.setSelectedIndex(0);
        this.ListeTailleNoyau.setSelectedIndex(1);
        this.ListeTexture.setSelectedIndex(0);
        this.RadioBoutonReplie.setSelected(false);
        this.RadioBoutonRimMarquee.setSelected(false);
        this.RadioBoutonRimReguliere.setSelected(true);
        this.RadioBoutonSegmentation.setSelected(false);
        this.SpinnerFoci.setValue(0);
        this.SpinnerNbArtefact.setValue(0);
        this.SpinnerTrous.setValue(0);
        this.SpinnerTrousArtefact.setValue(0);
    }

    public void VerifierSegmentation(String CheminDossier, int DimensionsMinimum, int SurfaceMinimum) throws IOException {
        this.Dossier = CheminDossier == null ? FichiersDossiersIHM.ChoisirDossier(new File("").getAbsolutePath(), true) : new File(CheminDossier);
        File[] fichiers = this.Dossier.listFiles();
        BufferedImage Segmentee = null;
        SubImage sousimage = null;
        for (int i2 = 0; i2 < fichiers.length; ++i2) {
            if (!fichiers[i2].isFile() || fichiers[i2].getName().equalsIgnoreCase(".DS_Store")) continue;
            System.out.print(i2 + " - ");
            this.FichierCourant = fichiers[i2].getName();
            Segmentee = null;
            Segmentee = ImageIO.Read(this.Dossier.getPath() + "/" + fichiers[i2++].getName());
            this.ccl.Label(Segmentee, 0, false);
            Iterator iter = this.ccl.SeparateComponentsSub(null, SurfaceMinimum, 1).iterator();
            try {
                this.BufferedImageCourante = javax.imageio.ImageIO.read(new File(this.Dossier.getPath() + "/" + fichiers[i2].getName()));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            while (iter.hasNext()) {
                this.ImageCourante = null;
                sousimage = null;
                sousimage = (SubImage)iter.next();
                this.ImageCourante = sousimage.SubImage();
                if (this.ImageCourante.getHeight() < DimensionsMinimum && this.ImageCourante.getWidth() < DimensionsMinimum) continue;
                System.out.print("* ");
            }
            System.out.println();
        }
    }
}

