/*
 * Decompiled with CFR 0.152.
 */
package softwares.progeria.nuclei;

import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageIO;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.Measures2D;
import utils.times.Chronometer;

public class CorrelationsExpertise
extends JFrame {
    private static final long serialVersionUID = -1552165447948707989L;
    private Box Horizontale;
    private Box VerticaleDroite;
    private Box VerticaleGauche;
    private int Largeur = 1000;
    private int Hauteur = 850;
    private int Marge = 50;
    private int Redimensionnement = 0;
    private double Zoom = 2.0;
    private DataOutputStream Sortie = null;
    private String FichierCourant = null;
    private BufferedImage BufferedImageCourante = null;
    private BufferedImage BufferedImageSegmentee = null;
    private BufferedImage ImageCourante = null;
    private JButton BoutonValider = null;
    private JButton BoutonErreurSegmentation = null;
    private JButton BoutonNoyauReplie = null;
    private JButton BoutonNoyauInexploitable = null;
    private JButton BoutonNoyauCoupe = null;
    private JList ListeZoom = null;
    private JList ListeBoursoufle = null;
    private JList ListeTexture = null;
    private JList ListeNombreTrou = null;
    private JList ListeNombreFoci = null;
    private JList ListeDiagnostic = null;
    private JList ListeNbArtefact = null;
    private JList ListeNbTrousArtefact = null;
    private JPanel PanneauGeneral = null;
    private JRadioButton RadioBoutonRimMarquee = null;
    private JRadioButton RadioBoutonRimReguliere = null;
    private JScrollPane ScrollPaneImageCouleur = null;
    private JScrollPane ScrollPaneImageSegmentee = null;
    private Object obj = new Object();
    private Chronometer chrono = null;
    private Measures2D mesures = null;
    private int marker;

    public CorrelationsExpertise() {
        super("Correlations entre differentes expertises");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RunExpertise(String NomFichier) throws Exception {
        FichierTabule Fichier = new FichierTabule(NomFichier, true);
        Calendar cal = Calendar.getInstance();
        this.chrono = new Chronometer();
        this.CreerIHM();
        this.setBoutons(false);
        try {
            File FichierSortie = new File("ResultCorrelations_" + NomFichier + "_" + cal.get(1) + "_" + (cal.get(2) + 1) + "_" + cal.get(5) + "_" + cal.get(11) + "h" + cal.get(12) + ".txt");
            FichierSortie.createNewFile();
            this.Sortie = new DataOutputStream(new FileOutputStream(FichierSortie));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        for (int y = 0; y < Fichier.Height(); ++y) {
            this.ImageCourante = null;
            this.BufferedImageCourante = null;
            this.BufferedImageSegmentee = null;
            this.FichierCourant = null;
            this.FichierCourant = Fichier.getValueString(y, Fichier.Width() - 1);
            this.ImageCourante = ImageIO.Read(this.FichierCourant);
            try {
                this.BufferedImageCourante = javax.imageio.ImageIO.read(new File(this.FichierCourant.substring(0, this.FichierCourant.length() - 3) + "png"));
                this.BufferedImageSegmentee = javax.imageio.ImageIO.read(new File(this.FichierCourant.substring(0, this.FichierCourant.length() - 3) + "png"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.mesures = null;
            this.mesures = new Measures2D(this.ImageCourante);
            this.mesures.Basics(true, false);
            this.ReInitialisation();
            this.DessinerImage();
            this.setBoutons(true);
            this.marker = this.chrono.NewMarker();
            Object object = this.obj;
            synchronized (object) {
                try {
                    this.obj.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        this.Quitter();
    }

    private void CreerIHM() {
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CorrelationsExpertise.this.Quitter();
            }
        };
        this.addWindowListener(l);
        this.setSize(this.Largeur + 2 * this.Marge, this.Hauteur + 2 * this.Marge);
        this.setLocation(200, 0);
        this.Horizontale = Box.createHorizontalBox();
        this.VerticaleDroite = Box.createVerticalBox();
        this.VerticaleGauche = Box.createVerticalBox();
        JLabel TitreVerticaleGauche = new JLabel("Noyau");
        TitreVerticaleGauche.setForeground(Color.BLUE);
        JLabel TexteZoom = new JLabel("Zoom -> ");
        String[] TypeZoom = new String[]{"50 %", "100 %", "150 %", "200 %", "250 %", "300 %"};
        this.ListeZoom = new JList<String>(TypeZoom);
        this.ListeZoom.setSelectedIndex(3);
        JPanel PanneauZoom = new JPanel();
        PanneauZoom.add(TexteZoom);
        PanneauZoom.add(this.ListeZoom);
        this.ListeZoom.addListSelectionListener(lse -> {
            switch (this.ListeZoom.getSelectedIndex()) {
                case 0: {
                    this.Zoom = 0.5;
                    break;
                }
                case 1: {
                    this.Zoom = 1.0;
                    break;
                }
                case 2: {
                    this.Zoom = 1.5;
                    break;
                }
                case 3: {
                    this.Zoom = 2.0;
                    break;
                }
                case 4: {
                    this.Zoom = 2.5;
                    break;
                }
                case 5: {
                    this.Zoom = 3.0;
                    break;
                }
                default: {
                    throw new Error("Default : valeur inconnue : " + this.ListeZoom.getSelectedIndex());
                }
            }
            this.DessinerImage();
        });
        this.ScrollPaneImageCouleur = new JScrollPane();
        this.ScrollPaneImageSegmentee = new JScrollPane();
        this.ScrollPaneImageCouleur.setDoubleBuffered(true);
        this.ScrollPaneImageSegmentee.setDoubleBuffered(true);
        this.BoutonErreurSegmentation = new JButton("Erreur segmentation");
        this.BoutonErreurSegmentation.setEnabled(false);
        this.BoutonErreurSegmentation.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(1, 0, 0, 0);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.BoutonNoyauCoupe = new JButton("Noyau coupe (sur le bord)");
        this.BoutonNoyauCoupe.setEnabled(false);
        this.BoutonNoyauCoupe.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(0, 0, 0, 1);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.VerticaleGauche.setDoubleBuffered(true);
        this.VerticaleGauche.add(TitreVerticaleGauche);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(PanneauZoom);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.ScrollPaneImageCouleur);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.BoutonNoyauCoupe);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.BoutonErreurSegmentation);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 5)));
        this.VerticaleGauche.add(this.ScrollPaneImageSegmentee);
        JLabel TitreVerticaleDroite = new JLabel("Diagnostic des noyaux");
        TitreVerticaleDroite.setForeground(Color.BLUE);
        JLabel TexteBoursoufle = new JLabel("Forme -> ");
        String[] TypeBoursoufle = new String[]{"Normale (convexe)", "Anormale (boursouflee)", "Incertaine"};
        this.ListeBoursoufle = new JList<String>(TypeBoursoufle);
        JPanel PanneauBoursoufle = new JPanel();
        PanneauBoursoufle.add(TexteBoursoufle);
        PanneauBoursoufle.add(this.ListeBoursoufle);
        JLabel TexteTexture = new JLabel("<- Texture");
        String[] TypeTexture = new String[]{"Homogene", "Non homogene", "Incertaine"};
        this.ListeTexture = new JList<String>(TypeTexture);
        JPanel PanneauTexture = new JPanel();
        PanneauTexture.add(this.ListeTexture);
        PanneauTexture.add(TexteTexture);
        Box Horizontale1 = Box.createHorizontalBox();
        Horizontale1.add(PanneauBoursoufle);
        Horizontale1.add(PanneauTexture);
        JLabel TexteFoci = new JLabel("Nombre de Foci -> ");
        String[] TypeNombreFoci = new String[]{"0", "1", "2", "3", "4", "> 4"};
        this.ListeNombreFoci = new JList<String>(TypeNombreFoci);
        JPanel PanneauFoci = new JPanel();
        PanneauFoci.add(TexteFoci);
        PanneauFoci.add(this.ListeNombreFoci);
        JLabel TexteNbTrous = new JLabel("<- Nombre de Trous");
        String[] TypeNombreTrou = new String[]{"0", "1", "2", "3", "4", "> 4"};
        this.ListeNombreTrou = new JList<String>(TypeNombreTrou);
        JPanel PanneauTrous = new JPanel();
        PanneauTrous.add(this.ListeNombreTrou);
        PanneauTrous.add(TexteNbTrous);
        Box Horizontale2 = Box.createHorizontalBox();
        Horizontale2.add(PanneauFoci);
        Horizontale2.add(PanneauTrous);
        JLabel TexteDiagnostic = new JLabel("Diagnostic -> ");
        String[] TypeDiagnostic = new String[]{"Normal (Sain)", "Anormal (Pathologique)", "Incertain"};
        this.ListeDiagnostic = new JList<String>(TypeDiagnostic);
        JPanel PanneauDiagnostic = new JPanel();
        PanneauDiagnostic.add(TexteDiagnostic);
        PanneauDiagnostic.add(this.ListeDiagnostic);
        JLabel TexteNbArtefact = new JLabel("Nombre d'Artefacts ->");
        String[] TypeNbArtefact = new String[]{"0", "1", "2", "3", "> 3"};
        this.ListeNbArtefact = new JList<String>(TypeNbArtefact);
        JPanel PanneauNbArtefact = new JPanel();
        PanneauNbArtefact.add(TexteNbArtefact);
        PanneauNbArtefact.add(this.ListeNbArtefact);
        JLabel TexteNbTrousArtefact = new JLabel("<- Nb Trous des Artefacts");
        String[] TypeNbTrousArtefact = new String[]{"0", "1", "2", "3", "> 3"};
        this.ListeNbTrousArtefact = new JList<String>(TypeNbTrousArtefact);
        JPanel PanneauNbTrousArtefact = new JPanel();
        PanneauNbTrousArtefact.add(this.ListeNbTrousArtefact);
        PanneauNbTrousArtefact.add(TexteNbTrousArtefact);
        Box Horizontale3 = Box.createHorizontalBox();
        Horizontale3.add(PanneauNbArtefact);
        Horizontale3.add(PanneauNbTrousArtefact);
        this.RadioBoutonRimMarquee = new JRadioButton("Rim marquee");
        this.RadioBoutonRimReguliere = new JRadioButton("Rim reguliere");
        this.BoutonValider = new JButton("Valider le diagnostic");
        this.BoutonValider.setEnabled(false);
        this.BoutonValider.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(0, 0, 0, 0);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.BoutonNoyauReplie = new JButton("Noyau replie");
        this.BoutonNoyauReplie.setEnabled(false);
        this.BoutonNoyauReplie.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(0, 1, 0, 0);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        this.BoutonNoyauInexploitable = new JButton("Noyau inexploitable");
        this.BoutonNoyauInexploitable.setEnabled(false);
        this.BoutonNoyauInexploitable.addActionListener(e -> {
            this.setBoutons(false);
            this.EcrireStats(0, 0, 1, 0);
            Object object = this.obj;
            synchronized (object) {
                this.obj.notify();
            }
        });
        Box HorizontaleBouton = Box.createHorizontalBox();
        HorizontaleBouton.add(this.BoutonNoyauReplie);
        HorizontaleBouton.add(this.BoutonNoyauInexploitable);
        this.VerticaleDroite.setDoubleBuffered(true);
        this.VerticaleDroite.add(TitreVerticaleDroite);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(Horizontale1);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(Horizontale2);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(PanneauDiagnostic);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(Horizontale3);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(this.RadioBoutonRimMarquee);
        this.VerticaleDroite.add(this.RadioBoutonRimReguliere);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(this.BoutonValider);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 5)));
        this.VerticaleDroite.add(HorizontaleBouton);
        this.VerticaleDroite.add(new JSeparator());
        this.Horizontale.setDoubleBuffered(true);
        this.Horizontale.add(this.VerticaleGauche);
        this.Horizontale.add(Box.createRigidArea(new Dimension(2 * this.Marge, this.Marge)));
        this.Horizontale.add(this.VerticaleDroite);
        this.PanneauGeneral = new JPanel();
        this.PanneauGeneral.add(this.Horizontale);
        this.PanneauGeneral.setVisible(true);
        this.PanneauGeneral.setPreferredSize(new Dimension(this.Largeur, this.Hauteur - this.Marge));
        this.PanneauGeneral.setDoubleBuffered(true);
        this.setContentPane(this.PanneauGeneral);
        this.setJMenuBar(this.CreerMenu());
        this.setVisible(true);
    }

    private JMenuBar CreerMenu() {
        JMenuBar barre = new JMenuBar();
        JMenu Fichier = new JMenu("Fichier");
        JMenuItem Quitter = new JMenuItem("Quitter");
        Quitter.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                CorrelationsExpertise.this.Quitter();
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        Fichier.add(new JSeparator());
        Fichier.add(Quitter);
        barre.add(Fichier);
        return barre;
    }

    private void Quitter() {
        try {
            if (this.Sortie != null) {
                this.Sortie.close();
            }
            System.err.println("Temps de travail : " + this.chrono.getTimeSinceMarker(0) + "s");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void DessinerImage() {
        int largeur = (int)((double)this.BufferedImageCourante.getWidth() * this.Zoom);
        int hauteur = (int)((double)this.BufferedImageCourante.getHeight() * this.Zoom);
        Coordinates point2 = null;
        for (Coordinates point2 : this.mesures.Contour.Points()) {
            this.BufferedImageSegmentee.setRGB(point2.X, point2.Y, -55000);
        }
        this.ScrollPaneImageCouleur.setViewportView(new JLabel(new ImageIcon(this.BufferedImageCourante.getScaledInstance(largeur, hauteur, 1))));
        this.ScrollPaneImageSegmentee.setViewportView(new JLabel(new ImageIcon(this.BufferedImageSegmentee.getScaledInstance(largeur, hauteur, 1))));
        if (this.Redimensionnement % 2 == 0) {
            this.setSize(this.Largeur + 2 * this.Marge - 1, this.Hauteur + 2 * this.Marge - 1);
        } else {
            this.setSize(this.Largeur + 2 * this.Marge + 1, this.Hauteur + 2 * this.Marge + 1);
        }
        ++this.Redimensionnement;
    }

    private void EcrireStats(int ErreurSegmentation, int NoyauReplie, int NoyauInexploitable, int NoyauCoupe) {
        try {
            this.Sortie.write(String.valueOf(this.ListeBoursoufle.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeTexture.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeNombreFoci.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeNombreTrou.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeNbTrousArtefact.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeNbArtefact.getSelectedIndex() + " ").getBytes("ASCII"));
            if (this.RadioBoutonRimMarquee.isSelected()) {
                this.Sortie.write(String.valueOf("1 ").getBytes("ASCII"));
            } else {
                this.Sortie.write(String.valueOf("0 ").getBytes("ASCII"));
            }
            if (this.RadioBoutonRimReguliere.isSelected()) {
                this.Sortie.write(String.valueOf("1 ").getBytes("ASCII"));
            } else {
                this.Sortie.write(String.valueOf("0 ").getBytes("ASCII"));
            }
            this.Sortie.write(String.valueOf(ErreurSegmentation + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(NoyauReplie + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(NoyauInexploitable + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(NoyauCoupe + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.ListeDiagnostic.getSelectedIndex() + " ").getBytes("ASCII"));
            this.Sortie.write(String.valueOf(this.chrono.getTimeSinceMarker(this.marker) + " ").getBytes("ASCII"));
            this.chrono.FreeMarker(this.marker);
            this.Sortie.write(String.valueOf(" " + this.FichierCourant).getBytes("ASCII"));
            this.Sortie.write("\n".getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ReInitialisation() {
        this.ListeBoursoufle.clearSelection();
        this.ListeTexture.clearSelection();
        this.ListeNombreTrou.clearSelection();
        this.ListeNombreFoci.clearSelection();
        this.ListeDiagnostic.clearSelection();
        this.ListeNbArtefact.setSelectedIndex(0);
        this.ListeNbTrousArtefact.setSelectedIndex(0);
        this.RadioBoutonRimMarquee.setSelected(false);
        this.RadioBoutonRimReguliere.setSelected(true);
    }

    private void setBoutons(boolean Valeur) {
        this.BoutonValider.setEnabled(Valeur);
        this.BoutonErreurSegmentation.setEnabled(Valeur);
        this.BoutonNoyauCoupe.setEnabled(Valeur);
        this.BoutonNoyauReplie.setEnabled(Valeur);
        this.BoutonNoyauInexploitable.setEnabled(Valeur);
    }
}

