/*
 * Decompiled with CFR 0.152.
 */
package softwares.progeria;

import imageTiTi.ImageIO;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import processing.thresholding.Binary;

public class VisualiseurNoyaux
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Box Horizontale;
    private Box VerticaleDroite;
    private Box VerticaleGauche;
    private int Largeur = 800;
    private int Hauteur = 850;
    private int Marge = 50;
    private int Redimensionnement = 0;
    private BufferedImage BufferedImageCourante = null;
    private BufferedImage ImageCourante = null;
    private JButton BoutonValider = null;
    private JLabel LabelErreur = null;
    private JLabel LabelMessageErreur = null;
    private JList ListeNomDossier = null;
    private JPanel PanneauGeneral = null;
    private JScrollPane ScrollPaneImageCouleur = null;
    private JScrollPane ScrollPaneImageNDG = null;
    private JTextField TextNoyau = null;
    private Binary binary = new Binary();

    public VisualiseurNoyaux() {
        super("Visualisation des noyaux.");
        this.CreerIHM();
    }

    private void CreerIHM() {
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        this.addWindowListener(l);
        this.setSize(this.Largeur + 2 * this.Marge, this.Hauteur);
        this.setLocation(200, 0);
        this.Horizontale = Box.createHorizontalBox();
        this.VerticaleDroite = Box.createVerticalBox();
        this.VerticaleGauche = Box.createVerticalBox();
        JLabel TitreVerticaleGauche = new JLabel("Noyau");
        TitreVerticaleGauche.setForeground(Color.BLUE);
        this.ScrollPaneImageCouleur = new JScrollPane();
        this.ScrollPaneImageNDG = new JScrollPane();
        this.ScrollPaneImageCouleur.setDoubleBuffered(true);
        this.ScrollPaneImageNDG.setDoubleBuffered(true);
        this.VerticaleGauche.setDoubleBuffered(true);
        this.VerticaleGauche.add(TitreVerticaleGauche);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 10)));
        this.VerticaleGauche.add(this.ScrollPaneImageCouleur);
        this.VerticaleGauche.add(Box.createRigidArea(new Dimension(this.Marge, 10)));
        this.VerticaleGauche.add(this.ScrollPaneImageNDG);
        JLabel TitreVerticaleDroite = new JLabel("Quel noyau afficher ?");
        TitreVerticaleDroite.setForeground(Color.BLUE);
        String[] NomDossier = new String[]{"5966", "7076", "9233", "13207", "AG019728", "GM00038", "MMP8"};
        this.ListeNomDossier = new JList<String>(NomDossier);
        JPanel PanneauDossier = new JPanel();
        JLabel LabelStats = new JLabel(" + /Stats + ");
        this.TextNoyau = new JTextField();
        JLabel LabelExtension = new JLabel(" + .pgm & .png");
        Box BoiteAdresse = Box.createHorizontalBox();
        BoiteAdresse.add(this.ListeNomDossier);
        BoiteAdresse.add(LabelStats);
        BoiteAdresse.add(this.TextNoyau);
        BoiteAdresse.add(LabelExtension);
        PanneauDossier.add(BoiteAdresse);
        this.LabelErreur = new JLabel("Erreur : ");
        this.LabelErreur.setVisible(false);
        this.LabelMessageErreur = new JLabel(" ");
        this.LabelMessageErreur.setVisible(false);
        Box BoiteErreur = Box.createHorizontalBox();
        BoiteErreur.add(this.LabelErreur);
        BoiteErreur.add(this.LabelMessageErreur);
        this.BoutonValider = new JButton("Valider");
        this.BoutonValider.setEnabled(true);
        this.BoutonValider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File fichierpng = new File(VisualiseurNoyaux.this.ListeNomDossier.getSelectedValue() + "/Stats/" + VisualiseurNoyaux.this.TextNoyau.getText() + ".png");
                File fichierpgm = new File(VisualiseurNoyaux.this.ListeNomDossier.getSelectedValue() + "/Stats/" + VisualiseurNoyaux.this.TextNoyau.getText() + ".pgm");
                VisualiseurNoyaux.this.AfficherErreur(null);
                try {
                    if (VisualiseurNoyaux.this.ListeNomDossier.getSelectedIndex() == -1) {
                        VisualiseurNoyaux.this.AfficherErreur("Aucun dossier source selectionne");
                        return;
                    }
                    if (!fichierpng.exists() || !fichierpgm.exists()) {
                        VisualiseurNoyaux.this.AfficherErreur("File not found Exception");
                        return;
                    }
                    VisualiseurNoyaux.this.BufferedImageCourante = javax.imageio.ImageIO.read(new File(VisualiseurNoyaux.this.ListeNomDossier.getSelectedValue() + "/Stats/" + VisualiseurNoyaux.this.TextNoyau.getText() + ".png"));
                    VisualiseurNoyaux.this.ImageCourante = ImageIO.Read(VisualiseurNoyaux.this.ListeNomDossier.getSelectedValue() + "/Stats/" + VisualiseurNoyaux.this.TextNoyau.getText() + ".pgm");
                }
                catch (IOException e1) {
                    VisualiseurNoyaux.this.AfficherErreur("IOException");
                    e1.printStackTrace();
                    return;
                }
                catch (Exception e1) {
                    VisualiseurNoyaux.this.AfficherErreur(e1.getMessage());
                    return;
                }
                VisualiseurNoyaux.this.DessinerImage();
            }
        });
        this.VerticaleDroite.setDoubleBuffered(true);
        this.VerticaleDroite.add(TitreVerticaleDroite);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 20)));
        this.VerticaleDroite.add(PanneauDossier);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(BoiteErreur);
        this.VerticaleDroite.add(new JSeparator());
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.VerticaleDroite.add(this.BoutonValider);
        this.VerticaleDroite.add(Box.createRigidArea(new Dimension(50, 10)));
        this.Horizontale.setDoubleBuffered(true);
        this.Horizontale.add(this.VerticaleGauche);
        this.Horizontale.add(Box.createRigidArea(new Dimension(2 * this.Marge, this.Marge)));
        this.Horizontale.add(this.VerticaleDroite);
        this.PanneauGeneral = new JPanel();
        this.PanneauGeneral.add(this.Horizontale);
        this.PanneauGeneral.setVisible(true);
        this.PanneauGeneral.setPreferredSize(new Dimension(this.Largeur, this.Hauteur - this.Marge));
        this.PanneauGeneral.setDoubleBuffered(true);
        this.setContentPane(this.PanneauGeneral);
        this.setVisible(true);
    }

    private void DessinerImage() {
        this.ScrollPaneImageCouleur.setViewportView(new JLabel(new ImageIcon(this.BufferedImageCourante)));
        this.ScrollPaneImageCouleur.setSize(this.BufferedImageCourante.getWidth(), this.BufferedImageCourante.getHeight());
        this.ScrollPaneImageNDG.setViewportView(new JLabel(new ImageIcon(this.binary.Filter(this.ImageCourante, 1))));
        this.ScrollPaneImageNDG.setSize(this.ImageCourante.getWidth(), this.ImageCourante.getHeight());
        if (this.Redimensionnement % 2 == 0) {
            this.setSize(this.Largeur - 1, this.Hauteur - 1);
        } else {
            this.setSize(this.Largeur + 1, this.Hauteur + 1);
        }
        ++this.Redimensionnement;
    }

    private void AfficherErreur(String erreur) {
        if (erreur == null) {
            this.LabelErreur.setVisible(false);
            this.LabelMessageErreur.setVisible(false);
            return;
        }
        this.LabelErreur.setVisible(true);
        this.LabelMessageErreur.setVisible(true);
        this.LabelMessageErreur.setText(erreur);
    }
}

