/*
 * Decompiled with CFR 0.152.
 */
package softwares.progeria;

import algoGeo.convexhull.ConvexHull;
import algoGeo.convexhull.Graham;
import dataMining.classifiers.Classification;
import dataMining.imbalanceDataSet.DataSetBalancer;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import measures.cclh.UnionFindCcl;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;

public class CceAnalyseBiDimension {
    private int largeur;
    private int hauteur;
    private int width;
    private int height;
    private int Classe0;
    private int Classe1;
    private double[] Maxima = null;
    private int[][] Tableau = null;
    private double[][] Resultat = null;
    private BufferedImage result = null;
    private List<Nucleus> nuclei = new Vector<Nucleus>(1013);
    private ConvexHull ch = new Graham();
    private UnionFindCcl ccl = new UnionFindCcl();
    private Classification classification = new Classification();

    public CceAnalyseBiDimension() {
    }

    public void CceAnalyzer(String folder, FichierTabule file, DataSetBalancer balancer, int kfold) throws UnsupportedEncodingException, IOException {
        int n;
        Object sizes;
        Nucleus nucleus;
        int i2;
        File[] folders = new File(folder).listFiles();
        int colshape = file.ColumnNumber("Shape");
        int colname = file.ColumnNumber("Nuclei");
        int colworkable = file.ColumnNumber("Workable");
        int nbError = 0;
        DataOutputStream output = new DataOutputStream(new FileOutputStream("Log_CceAnalyseBiDimension.txt"));
        this.nuclei.clear();
        for (int f = 0; f < folders.length; ++f) {
            if (!folders[f].isDirectory()) continue;
            File[] images = folders[f].listFiles();
            for (i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().contains(".pgm")) continue;
                try {
                    String str;
                    file.ClearSelectionRows();
                    file.SelectWhere(colname, 6, folders[f].getName());
                    file.SelectFromSelectionWhere(colname, 6, "/" + images[i2].getName());
                    if (file.nbSelected() != 1) {
                        throw new Exception("Found " + file.nbSelected() + " row containing '" + folders[f].getName() + "/" + images[i2].getName() + "'");
                    }
                    int row = file.FirstSelected();
                    if (file.getValueString(row, colworkable).equalsIgnoreCase("False") || (str = file.getValueString(row, colshape)).equalsIgnoreCase("Unknown")) continue;
                    nucleus = new Nucleus();
                    nucleus.classes = str;
                    BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                    this.ch.Compute(image, null);
                    this.ch.ComputeProperties(image, 1);
                    BufferedImage gaps = this.ch.getDifferences();
                    ImageIO.Write(gaps, folders[f].getName() + "_" + i2 + ".png", 6);
                    this.ccl.Label(gaps, 0, true);
                    sizes = this.ccl.Sizes();
                    for (int cc = 1; cc < ((Object)sizes).length; ++cc) {
                        nucleus.cce.add((int)sizes[cc]);
                    }
                    this.nuclei.add(nucleus);
                    nucleus = null;
                    continue;
                }
                catch (Exception E) {
                    E.printStackTrace();
                    output.write(("Error " + nbError + " --------------------------------------------\n").getBytes("ASCII"));
                    output.write(E.getMessage().getBytes("ASCII"));
                    output.write(E.getLocalizedMessage().getBytes("ASCII"));
                    output.write(E.getCause().toString().getBytes("ASCII"));
                    output.write("\n\n".getBytes("ASCII"));
                    continue;
                }
                catch (Error E) {
                    E.printStackTrace();
                    output.write(("Error " + nbError + " --------------------------------------------\n").getBytes("ASCII"));
                    output.write(E.getMessage().getBytes("ASCII"));
                    output.write(E.getLocalizedMessage().getBytes("ASCII"));
                    output.write(E.getCause().toString().getBytes("ASCII"));
                    output.write("\n\n".getBytes("ASCII"));
                }
            }
        }
        FichierTabule chars = new FichierTabule(this.nuclei.size(), new int[]{1, 2}, "TiTi_Cce");
        chars.TargetNominal(1);
        int maxnumber = 0;
        int maxsize = 0;
        for (n = 0; n < this.nuclei.size(); ++n) {
            nucleus = this.nuclei.get(n);
            if (maxnumber < nucleus.cce.size()) {
                maxnumber = nucleus.cce.size();
            }
            List<Integer> sizes2 = nucleus.cce;
            for (i2 = 0; i2 < sizes2.size(); ++i2) {
                if (maxsize >= sizes2.get(i2)) continue;
                maxsize = sizes2.get(i2);
            }
        }
        System.out.println("maxsize = " + maxsize + ", maxnumber = " + maxnumber);
        Vector<String> classes = new Vector<String>();
        classes.add("Normal");
        classes.add("Puffy");
        maxsize = 40;
        this.Resultat = new double[maxnumber + 1][maxsize + 1];
        for (int number = 1; number <= maxnumber; ++number) {
            for (int size = 1; size <= maxsize; ++size) {
                for (n = 0; n < this.nuclei.size(); ++n) {
                    nucleus = this.nuclei.get(n);
                    sizes = nucleus.cce;
                    int nb = 0;
                    for (i2 = 0; i2 < sizes.size(); ++i2) {
                        if (size > sizes.get(i2)) continue;
                        ++nb;
                    }
                    chars.setValue(n, 0, 1.0 / (1.0 + (double)nb));
                    chars.setValue(n, 1, nucleus.classes);
                }
                FichierTabule balanced = balancer.Balance(chars, classes, true);
                try {
                    this.classification.Classify(balanced, (Classifier)new Logistic(), null, 1, kfold);
                    this.Resultat[number][size] = this.classification.PercentageCorrect();
                    continue;
                }
                catch (Exception E) {
                    E.printStackTrace();
                    output.write(("Error " + nbError + " ----------------------------------------------\n").getBytes("ASCII"));
                    output.write(E.getMessage().getBytes("ASCII"));
                    output.write(E.getLocalizedMessage().getBytes("ASCII"));
                    output.write(E.getCause().toString().getBytes("ASCII"));
                    output.write("\n\n".getBytes("ASCII"));
                    continue;
                }
                catch (Error E) {
                    E.printStackTrace();
                    output.write(("Error " + nbError + " ----------------------------------------------\n").getBytes("ASCII"));
                    output.write(E.getMessage().getBytes("ASCII"));
                    output.write(E.getLocalizedMessage().getBytes("ASCII"));
                    output.write(E.getCause().toString().getBytes("ASCII"));
                    output.write("\n\n".getBytes("ASCII"));
                }
            }
        }
        this.result = ImageConverter.ArrayToImage((double[][])this.Resultat);
    }

    public CceAnalyseBiDimension(FichierTabule Fichier, int Classe0, int Classe1) {
        this.Tableau = Fichier.getFileInt();
        this.Classe0 = Classe0;
        this.Classe1 = Classe1;
        this.largeur = this.Tableau[0].length;
        this.width = this.largeur - 1;
        this.hauteur = this.Tableau.length;
        this.height = (int)this.TrouverMax(this.width, this.hauteur);
        this.Resultat = new double[this.height][this.width];
        this.Maxima = new double[this.height];
        this.Calculer();
        this.ResultatToImage();
        this.Ecrire();
    }

    private void Calculer() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.Resultat[y][x] = this.PourcentageBonneClassification(x + 1, y);
            }
        }
    }

    private double PourcentageBonneClassification(int Seuil, int nbComposante) {
        int MalClasse = 0;
        int BienClasse = 0;
        for (int y = 0; y < this.hauteur; ++y) {
            if (this.Tableau[y][this.largeur - 1] != this.Classe0 && this.Tableau[y][this.largeur - 1] != this.Classe1) continue;
            if (this.Tableau[y][Seuil - 1] >= nbComposante) {
                if (this.Tableau[y][this.largeur - 1] == this.Classe1) {
                    ++BienClasse;
                    continue;
                }
                ++MalClasse;
                continue;
            }
            if (this.Tableau[y][this.largeur - 1] == this.Classe0) {
                ++BienClasse;
                continue;
            }
            ++MalClasse;
        }
        return 100.0 * (double)BienClasse / (double)(BienClasse + MalClasse);
    }

    private double TrouverMax(int w, int h) {
        double max = this.Tableau[0][0];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (!(max < (double)this.Tableau[y][x])) continue;
                max = this.Tableau[y][x];
            }
        }
        return max;
    }

    private void TrouverMaxima(DataOutputStream Sortie) {
        try {
            Sortie.write((this.height + "\n").getBytes("ASCII"));
            for (int y = 0; y < this.height; ++y) {
                int X = 0;
                this.Maxima[y] = this.Tableau[y][0];
                for (int x = 1; x < this.width; ++x) {
                    if (!(this.Maxima[y] < this.Resultat[y][x])) continue;
                    this.Maxima[y] = this.Resultat[y][x];
                    X = x;
                }
                Sortie.write((X + " " + y + " " + this.Maxima[y] + "\n").getBytes("ASCII"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ResultatToImage() {
        this.result = new BufferedImage(this.width, this.height, 13);
        WritableRaster wr = this.result.getRaster();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                wr.setSample(x, y, 0, (int)(2.55 * this.Resultat[y][x]));
            }
        }
    }

    private void Ecrire() {
        DataOutputStream Sortie = null;
        String Entete = null;
        try {
            Sortie = new DataOutputStream(new FileOutputStream("ResultatBiDimension.txt"));
            Entete = String.valueOf(this.width) + " " + String.valueOf(this.height) + "\n";
            Sortie.write(Entete.getBytes("ASCII"));
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    Sortie.write(String.valueOf(this.Resultat[y][x] + " ").getBytes("ASCII"));
                }
                Sortie.write("\n".getBytes("ASCII"));
            }
            Sortie.close();
            Sortie = new DataOutputStream(new FileOutputStream("Maxima.txt"));
            this.TrouverMaxima(Sortie);
            Sortie.close();
            ImageIO.Write(this.result, "Result.pgm", 5);
        }
        catch (Exception E) {
            E.printStackTrace();
            System.exit(0);
        }
    }

    public BufferedImage getResultImage() {
        return this.result;
    }

    public double[] getMaxima() {
        return this.Maxima;
    }

    public double[][] getResultat() {
        return this.Resultat;
    }

    public int[][] getTableau() {
        return this.Tableau;
    }

    private class Nucleus {
        public String classes;
        public List<Integer> cce = new Vector<Integer>(113);

        private Nucleus() {
        }
    }
}

