/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.sunjong;

import displays.Colors;
import displays.Display;
import filesAndFolders.FileFilters;
import filesAndFolders.FileNameFilters;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import segmentation.cells.Lamin;
import stackTiTi.StackConverter;
import stackTiTi.StackIO;

public class LaminSegmentation {
    private Lamin lamseg = new Lamin();
    public Display display = null;
    public FilenameFilter D3D = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.endsWith("_D3D.dv");
    public FilenameFilter nonD3D = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.endsWith("_R3D.dv");
    public FileFilter done = file -> file.isDirectory() && file.getName().endsWith("-done");

    public void LaminAC_2D(String stackspath, String resultsdir, int nbCPU) throws IOException {
        File resfile = new File(resultsdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        Object[] stacks = new File(stackspath).listFiles(FileFilters.Directories);
        for (int s = 0; s < stacks.length; ++s) {
            Object[] lamin = StackIO.ReadImageSequence(stacks[s].getAbsolutePath(), FileNameFilters.ImagesPNGorTIF);
            File resultfile = new File(resfile.getAbsolutePath() + "/" + ((File)stacks[s]).getName());
            if (!resultfile.exists()) {
                resultfile.mkdirs();
            }
            BufferedImage zprojseg = this.lamseg.LaminAC_2D((BufferedImage[])lamin, resultfile.getAbsolutePath(), nbCPU);
            Arrays.fill(lamin, null);
            lamin = null;
        }
        Arrays.fill(stacks, null);
        stacks = null;
    }

    public void LaminB_2D(String linespath, String resultsdir, int nbCPU) throws IOException {
        File resfile = new File(resultsdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        this.lamseg.display = this.display;
        File[] celllines = new File(linespath).listFiles(FileFilters.Directories);
        for (int line = 0; line < celllines.length; ++line) {
            File[] stacks = new File(celllines[line].getAbsolutePath()).listFiles(FileFilters.Directories);
            for (int s = 0; s < stacks.length; ++s) {
                BufferedImage[] lamin = StackIO.ReadImageSequence(stacks[s].getAbsolutePath(), FileNameFilters.ImagesPNG);
                File resultfile = new File(resfile.getAbsolutePath() + "/" + stacks[s].getName());
                if (!resultfile.exists()) {
                    resultfile.mkdirs();
                }
                BufferedImage zprojseg = this.lamseg.LaminB_2D(lamin, resultfile.getAbsolutePath(), nbCPU);
                zprojseg = null;
            }
        }
    }

    public void ExtractLaminFromDVserver(String dirpath, String resdir) {
        boolean work = false;
        Object[] acquisitions = new File(dirpath).listFiles(this.done);
        for (int a = 0; a < acquisitions.length; ++a) {
            Object[] directories = new File(((File)acquisitions[a]).getAbsolutePath()).listFiles(FileFilters.Directories);
            for (int d = 0; d < directories.length; ++d) {
                Object[] dvs = new File(((File)directories[d]).getAbsolutePath()).listFiles(this.D3D);
                for (int dv = 0; dv < dvs.length; ++dv) {
                    String name = dvs[dv].getName().substring(0, ((File)dvs[dv]).getName().indexOf(".dv"));
                    File resfile = new File(resdir + "/" + ((File)directories[d]).getName() + "/" + name);
                    if (!resfile.exists()) {
                        resfile.mkdirs();
                    }
                    try {
                        Object[] stack = StackIO.ReadStackBioFormat(((File)dvs[dv]).getAbsolutePath());
                        Object[] lamin = StackConverter.OneEvery((BufferedImage[])stack, stack.length % 4 == 0 ? 1 : 0, stack.length % 4 == 0 ? 4 : 3);
                        StackIO.WriteImageSequence((BufferedImage[])lamin, resfile.getAbsolutePath(), name, 6);
                        Arrays.fill(stack, null);
                        Arrays.fill(lamin, null);
                        lamin = null;
                        stack = null;
                        continue;
                    }
                    catch (IOException ex) {
                        System.out.flush();
                        System.err.println("Cannot read: '" + ((File)dvs[dv]).getAbsolutePath() + "'");
                        System.err.flush();
                    }
                }
                Arrays.fill(dvs, null);
                dvs = null;
            }
            Arrays.fill(directories, null);
            directories = null;
        }
        Arrays.fill(acquisitions, null);
        acquisitions = null;
    }

    public void ExtractLaminFromDV(String dirpath, String resdir) {
        Object[] directories = new File(dirpath).listFiles(FileFilters.Directories);
        for (int d = 0; d < directories.length; ++d) {
            Object[] dvs = new File(((File)directories[d]).getAbsolutePath()).listFiles(this.D3D);
            for (int dv = 0; dv < dvs.length; ++dv) {
                String name = dvs[dv].getName().substring(0, ((File)dvs[dv]).getName().indexOf(".dv"));
                File resfile = new File(resdir + "/" + ((File)directories[d]).getName() + "/" + name);
                if (!resfile.exists()) {
                    resfile.mkdirs();
                }
                try {
                    Object[] stack = StackIO.ReadStackBioFormat(((File)dvs[dv]).getAbsolutePath());
                    StackIO.WriteImageSequence((BufferedImage[])stack, resfile.getAbsolutePath(), name, 6);
                    Arrays.fill(stack, null);
                    stack = null;
                    continue;
                }
                catch (IOException ex) {
                    System.out.flush();
                    System.err.println("Cannot read: '" + ((File)dvs[dv]).getAbsolutePath() + "'");
                    System.err.flush();
                }
            }
            Arrays.fill(dvs, null);
            dvs = null;
        }
        Arrays.fill(directories, null);
        directories = null;
    }

    public void ExtractLaminFromDV2(String dirpath, String resdir) {
        Object[] dvs = new File(dirpath).listFiles(this.D3D);
        for (int dv = 0; dv < dvs.length; ++dv) {
            String name = dvs[dv].getName().substring(0, ((File)dvs[dv]).getName().indexOf(".dv"));
            File resfile = new File(resdir + "/" + name);
            if (!resfile.exists()) {
                resfile.mkdirs();
            }
            try {
                Object[] stack = StackIO.ReadStackBioFormat(((File)dvs[dv]).getAbsolutePath());
                Object[] lamin = StackConverter.OneEvery((BufferedImage[])stack, 1, 4);
                StackIO.WriteImageSequence((BufferedImage[])lamin, resfile.getAbsolutePath(), name, 6);
                Arrays.fill(stack, null);
                Arrays.fill(lamin, null);
                lamin = null;
                stack = null;
                continue;
            }
            catch (IOException ex) {
                System.out.flush();
                System.err.println("Cannot read: '" + ((File)dvs[dv]).getAbsolutePath() + "'");
                System.err.flush();
            }
        }
        Arrays.fill(dvs, null);
        dvs = null;
    }

    public void AddColorSegmentation(String path) {
        Object[] dirs = new File(path).listFiles(FileFilters.Directories);
        for (int dir = 0; dir < dirs.length; ++dir) {
            try {
                BufferedImage zproj = ImageIO.Read(((File)dirs[dir]).getAbsolutePath() + "/ZProjection.png");
                BufferedImage seg = ImageIO.Read(((File)dirs[dir]).getAbsolutePath() + "/Segmentation.png");
                BufferedImage rgb = ImageConverter.GrayToColor((BufferedImage)zproj);
                BufferedImage contour = ImageOperations.Contour((BufferedImage)seg, (boolean)true);
                ImageDrawer.Draw(rgb, contour, Colors.RED);
                ImageIO.Write(rgb, ((File)dirs[dir]).getAbsolutePath() + "/SegmentationColor.png", 6);
                contour = null;
                rgb = null;
                seg = null;
                zproj = null;
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Arrays.fill(dirs, null);
        dirs = null;
    }

    public void Visualize(String path, String imname, int min, int max, Display display) throws IOException {
        Object[] dirs = new File(path).listFiles(FileFilters.Directories);
        int first = Math.max(0, min);
        int last = Math.min(dirs.length, max);
        for (int dir = first; dir < last; ++dir) {
            display.Image(ImageIO.Read(((File)dirs[dir]).getAbsolutePath() + "/" + imname), ((File)dirs[dir]).getAbsolutePath() + "/" + imname, 1.0);
        }
        Arrays.fill(dirs, null);
        dirs = null;
    }

    public void Visualize(String path, String imname, String key, Display display) throws IOException {
        Object[] dirs = new File(path).listFiles(FileFilters.Directories);
        for (int dir = 0; dir < dirs.length; ++dir) {
            if (!dirs[dir].getName().contains(key)) continue;
            display.Image(ImageIO.Read(((File)dirs[dir]).getAbsolutePath() + "/" + imname), ((File)dirs[dir]).getAbsolutePath() + "/" + imname, 1.0);
        }
        Arrays.fill(dirs, null);
        dirs = null;
    }
}

