/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.sunjong;

import characterization.ComputableFeatures;
import characterization.MasterCharacterizer;
import characterization.textures.BasicTexturalFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import characterization.textures.lbp.MultiLBP;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.rlm.FuzzyRLMfeatures;
import characterization.textures.statisticalmatrices.rlm.MultiFuzzyRLM;
import characterization.textures.statisticalmatrices.rlm.MultiRLM;
import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.FuzzySZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiFuzzySZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiSZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import dataMining.classifiers.GenericClassifier;
import dataMining.imbalanceDataSet.DataSetBalancer;
import filesAndFolders.FileFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import listTiTi.ListConverter;
import mathematics.functions.LinearFunctions;
import morphee.StructuringElement3D;
import morphee.granulometry.PatternSpectrum;
import processing.reducer.FuzzyGLR;
import processing.reducer.HistogramGLR;
import processing.reducer.MinMaxLinearGLR;
import weka.classifiers.functions.Logistic;
import weka.classifiers.trees.RandomForest;

public class LaminCharacterization {
    public void Characterize(String laminpath, String resultname, int nbCPU) throws IOException {
        File[] lamins;
        ArrayList<File> files = new ArrayList<File>(1237);
        for (File lamin : lamins = new File(laminpath).listFiles(FileFilters.Directories)) {
            files.add(new File(lamin.getAbsolutePath() + "/Segmentation.png"));
        }
        this.Characterize(files, resultname, nbCPU);
    }

    private void Characterize(List<File> files, String result, int nbCPU) {
        ArrayList<ComputableFeatures> characterizers = new ArrayList<ComputableFeatures>(43);
        this.AddBasics(characterizers);
        this.AddSZM(characterizers);
        this.AddMultiSZM(characterizers);
        this.AddFuzzySZM(characterizers);
        this.AddMultiFuzzySZM(characterizers);
        this.AddHaralick(characterizers);
        this.AddRLM(characterizers);
        this.AddMultiRLM(characterizers);
        this.AddFuzzyRLM(characterizers);
        this.AddMultiFuzzyRLM(characterizers);
        this.AddLBP(characterizers);
        this.AddMultiLBP(characterizers);
        this.AddPatternSpectrum(characterizers);
        MasterCharacterizer mc = new MasterCharacterizer();
        mc.Margin(2);
        mc.Characterize(files, MasterCharacterizer.Source.Image, null, characterizers, result, true, true, nbCPU);
        mc = null;
    }

    private void AddBasics(List<ComputableFeatures> characterizers) {
        BasicTexturalFeatures btf = new BasicTexturalFeatures();
        btf.Parameters(0);
        characterizers.add(btf);
    }

    private void AddSZM(List<ComputableFeatures> characterizers) {
        SZMfeatures szm8 = new SZMfeatures();
        szm8.Parameters(8, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm8);
        SZMfeatures szm16 = new SZMfeatures();
        szm16.Parameters(16, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm16);
        SZMfeatures szm32 = new SZMfeatures();
        szm32.Parameters(32, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm32);
        SZMfeatures szm64 = new SZMfeatures();
        szm64.Parameters(64, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm64);
        SZMfeatures szm128 = new SZMfeatures();
        szm128.Parameters(128, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm128);
        SZMfeatures szm256 = new SZMfeatures();
        szm256.Parameters(256, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm256);
        SZMfeatures szmhist8 = new SZMfeatures();
        szmhist8.Parameters(8, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist8);
        SZMfeatures szmhist16 = new SZMfeatures();
        szmhist16.Parameters(16, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist16);
        SZMfeatures szmhist32 = new SZMfeatures();
        szmhist32.Parameters(32, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist32);
        SZMfeatures szmhist64 = new SZMfeatures();
        szmhist64.Parameters(64, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist64);
        SZMfeatures szmhist128 = new SZMfeatures();
        szmhist128.Parameters(128, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist128);
    }

    private void AddMultiSZM(List<ComputableFeatures> characterizers) {
        MultiSZM mmlin = new MultiSZM();
        mmlin.Parameters(1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(mmlin);
        MultiSZM hist = new MultiSZM();
        hist.Parameters(1, new HistogramGLR(), 0, true);
        characterizers.add(hist);
    }

    private void AddFuzzySZM(List<ComputableFeatures> characterizers) {
        FuzzySZMfeatures fszm1 = new FuzzySZMfeatures();
        fszm1.Parameters(-1, new FuzzyGLR(1, 8, LinearFunctions.DecreasingLinearFrom_01_N0(1)), 0, true);
        characterizers.add(fszm1);
        FuzzySZMfeatures fszm2 = new FuzzySZMfeatures();
        fszm2.Parameters(-1, new FuzzyGLR(2, 8, LinearFunctions.DecreasingLinearFrom_01_N0(2)), 0, true);
        characterizers.add(fszm2);
        FuzzySZMfeatures fszm3 = new FuzzySZMfeatures();
        fszm3.Parameters(-1, new FuzzyGLR(3, 8, LinearFunctions.DecreasingLinearFrom_01_N0(3)), 0, true);
        characterizers.add(fszm3);
        FuzzySZMfeatures fszm5 = new FuzzySZMfeatures();
        fszm5.Parameters(-1, new FuzzyGLR(5, 8, LinearFunctions.DecreasingLinearFrom_01_N0(5)), 0, true);
        characterizers.add(fszm5);
        FuzzySZMfeatures fszm7 = new FuzzySZMfeatures();
        fszm7.Parameters(-1, new FuzzyGLR(7, 8, LinearFunctions.DecreasingLinearFrom_01_N0(7)), 0, true);
        characterizers.add(fszm7);
        FuzzySZMfeatures fszm11 = new FuzzySZMfeatures();
        fszm11.Parameters(-1, new FuzzyGLR(11, 8, LinearFunctions.DecreasingLinearFrom_01_N0(11)), 0, true);
        characterizers.add(fszm11);
    }

    private void AddMultiFuzzySZM(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        MultiFuzzySZM mfszm = new MultiFuzzySZM();
        mfszm.Parameters(1, 11, 2, -1, 0, true, weights);
        characterizers.add(mfszm);
        MultiFuzzySZM mfszm3 = new MultiFuzzySZM();
        mfszm3.Parameters(2, 17, 3, -1, 0, true, weights);
        characterizers.add(mfszm3);
        MultiFuzzySZM mfszm5 = new MultiFuzzySZM();
        mfszm5.Parameters(5, 30, 5, -1, 0, true, weights);
        characterizers.add(mfszm5);
    }

    private void AddHaralick(List<ComputableFeatures> characterizers) {
        Haralick hmml8 = new Haralick();
        hmml8.Parameters(new MinMaxLinearGLR(), 8, 0);
        characterizers.add(hmml8);
        Haralick hmml16 = new Haralick();
        hmml16.Parameters(new MinMaxLinearGLR(), 16, 0);
        characterizers.add(hmml16);
        Haralick hmml32 = new Haralick();
        hmml32.Parameters(new MinMaxLinearGLR(), 32, 0);
        characterizers.add(hmml32);
        Haralick hmml64 = new Haralick();
        hmml64.Parameters(new MinMaxLinearGLR(), 64, 0);
        characterizers.add(hmml64);
        Haralick hmml128 = new Haralick();
        hmml128.Parameters(new MinMaxLinearGLR(), 128, 0);
        characterizers.add(hmml128);
        Haralick hmml256 = new Haralick();
        hmml256.Parameters(new MinMaxLinearGLR(), 256, 0);
        characterizers.add(hmml256);
        Haralick hhist8 = new Haralick();
        hhist8.Parameters(new HistogramGLR(), 8, 0);
        characterizers.add(hhist8);
        Haralick hhist16 = new Haralick();
        hhist16.Parameters(new HistogramGLR(), 16, 0);
        characterizers.add(hhist16);
        Haralick hhist32 = new Haralick();
        hhist32.Parameters(new HistogramGLR(), 32, 0);
        characterizers.add(hhist32);
        Haralick hhist64 = new Haralick();
        hhist64.Parameters(new HistogramGLR(), 64, 0);
        characterizers.add(hhist64);
        Haralick hhist128 = new Haralick();
        hhist128.Parameters(new HistogramGLR(), 128, 0);
        characterizers.add(hhist128);
    }

    private void AddRLM(List<ComputableFeatures> characterizers) {
        RLMfeatures rlm8 = new RLMfeatures();
        rlm8.Parameters(8, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm8);
        RLMfeatures rlm16 = new RLMfeatures();
        rlm16.Parameters(16, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm16);
        RLMfeatures rlm32 = new RLMfeatures();
        rlm32.Parameters(32, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm32);
        RLMfeatures rlm64 = new RLMfeatures();
        rlm64.Parameters(64, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm64);
        RLMfeatures rlm128 = new RLMfeatures();
        rlm128.Parameters(128, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm128);
        RLMfeatures rlm256 = new RLMfeatures();
        rlm256.Parameters(256, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm256);
        RLMfeatures rlmhist8 = new RLMfeatures();
        rlmhist8.Parameters(8, new HistogramGLR(), 0);
        characterizers.add(rlmhist8);
        RLMfeatures rlmhist16 = new RLMfeatures();
        rlmhist16.Parameters(16, new HistogramGLR(), 0);
        characterizers.add(rlmhist16);
        RLMfeatures rlmhist32 = new RLMfeatures();
        rlmhist32.Parameters(32, new HistogramGLR(), 0);
        characterizers.add(rlmhist32);
        RLMfeatures rlmhist64 = new RLMfeatures();
        rlmhist64.Parameters(64, new HistogramGLR(), 0);
        characterizers.add(rlmhist64);
        RLMfeatures rlmhist128 = new RLMfeatures();
        rlmhist128.Parameters(128, new HistogramGLR(), 0);
        characterizers.add(rlmhist128);
    }

    private void AddMultiRLM(List<ComputableFeatures> characterizers) {
        MultiRLM mmlin = new MultiRLM();
        mmlin.Parameters(new MinMaxLinearGLR(), 0);
        characterizers.add(mmlin);
        MultiRLM hist = new MultiRLM();
        hist.Parameters(new HistogramGLR(), 0);
        characterizers.add(hist);
    }

    private void AddFuzzyRLM(List<ComputableFeatures> characterizers) {
        FuzzyRLMfeatures frlm1 = new FuzzyRLMfeatures();
        int fuzzy = 1;
        frlm1.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm1);
        FuzzyRLMfeatures frlm2 = new FuzzyRLMfeatures();
        fuzzy = 2;
        frlm2.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm2);
        FuzzyRLMfeatures frlm3 = new FuzzyRLMfeatures();
        fuzzy = 3;
        frlm3.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm3);
        FuzzyRLMfeatures frlm5 = new FuzzyRLMfeatures();
        fuzzy = 5;
        frlm5.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm5);
        FuzzyRLMfeatures frlm7 = new FuzzyRLMfeatures();
        fuzzy = 7;
        frlm7.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm7);
        FuzzyRLMfeatures frlm11 = new FuzzyRLMfeatures();
        fuzzy = 11;
        frlm11.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm11);
    }

    private void AddMultiFuzzyRLM(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        MultiFuzzyRLM mfrlm = new MultiFuzzyRLM();
        mfrlm.Parameters(1, 11, 2, -1, 0, weights);
        characterizers.add(mfrlm);
        MultiFuzzyRLM mfrlm3 = new MultiFuzzyRLM();
        mfrlm3.Parameters(2, 17, 3, -1, 0, weights);
        characterizers.add(mfrlm3);
        MultiFuzzyRLM mfrlm5 = new MultiFuzzyRLM();
        mfrlm5.Parameters(5, 30, 5, -1, 0, weights);
        characterizers.add(mfrlm5);
        weights = null;
    }

    private void AddLBP(List<ComputableFeatures> characterizers) {
        LocalBinaryPattern lbp21 = new LocalBinaryPattern();
        lbp21.Parameters(new StructuringElement3D(new Object[]{1, -13, 8}), 2, 0);
        characterizers.add(lbp21);
        LocalBinaryPattern lbp23 = new LocalBinaryPattern();
        lbp23.Parameters(new StructuringElement3D(new Object[]{3, -13, 8}), 2, 0);
        characterizers.add(lbp23);
        LocalBinaryPattern lbp25 = new LocalBinaryPattern();
        lbp25.Parameters(new StructuringElement3D(new Object[]{5, -13, 8}), 2, 0);
        characterizers.add(lbp25);
    }

    private void AddMultiLBP(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0};
        MultiLBP mlbp172 = new MultiLBP();
        mlbp172.Parameters(1, 7, 2, 0, 2, weights);
        characterizers.add(mlbp172);
        double[] weights2 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        MultiLBP mlbp1223 = new MultiLBP();
        mlbp1223.Parameters(1, 23, 3, 0, 2, weights2);
        characterizers.add(mlbp1223);
        weights2 = null;
        weights = null;
    }

    private void AddPatternSpectrum(List<ComputableFeatures> characterizers) {
        PatternSpectrum ps1 = new PatternSpectrum();
        ps1.Parameters(1, 5, 1, 0, -9);
        characterizers.add(ps1);
        PatternSpectrum ps2 = new PatternSpectrum();
        ps2.Parameters(1, 13, 2, 0, -9);
        characterizers.add(ps2);
    }

    public FichierTabule TestSingleFeature(FichierTabule file, int nbfolds, String classname) {
        FichierTabule totest = new FichierTabule(file.Height(), new int[]{1, 2}, "");
        totest.setColumn(1, file.getColumnString(file.Target()));
        totest.TargetNominal(1);
        GenericClassifier genclass = new GenericClassifier(new Logistic(), new Object[0]);
        int nb = 0;
        for (int c = 0; c < file.Width(); ++c) {
            if (file.isExcludedColumn(c) || file.ColumnType(c) != 1) continue;
            ++nb;
        }
        FichierTabule result = new FichierTabule(nb, new int[]{1, 2}, "");
        nb = 0;
        block7: for (int c = 0; c < file.Width(); ++c) {
            if (file.isExcludedColumn(c)) continue;
            switch (file.ColumnType(c)) {
                case 0: {
                    System.out.println("Souci int column " + c);
                    continue block7;
                }
                case 1: {
                    totest.setColumn(0, file.getColumnDouble(c));
                    break;
                }
                default: {
                    continue block7;
                }
            }
            result.setValue(nb, 0, -1.0);
            result.setValue(nb, 1, file.getColumnName(c));
            try {
                genclass.LearnPredictEvaluate(totest, 1, nbfolds, classname);
            }
            catch (Exception e) {
                System.out.flush();
                System.err.println("Feature '" + file.getColumnName(c) + "', row " + nb);
                e.printStackTrace();
                System.err.flush();
            }
            result.setValue(nb, 0, genclass.Checks()[0]);
            ++nb;
        }
        return result;
    }

    public FichierTabule TestSingleFeature(FichierTabule file, int nbfolds, int trainingacquisition, int testingacquisition, DataSetBalancer dsb, String target, String classname) {
        int colacq = file.ColumnNumber("Acquisition");
        file.SelectWhere(colacq, 0, trainingacquisition);
        FichierTabule trainingset = FichierTabuleTools.SaveSelectedRows(file);
        trainingset.setExcludedColumn(colacq, true);
        trainingset.TargetNominal(target);
        FichierTabule training = dsb.Balance(trainingset, false);
        training.setExcludedColumn(colacq, true);
        file.SelectWhere(colacq, 0, testingacquisition);
        FichierTabule testingset = FichierTabuleTools.SaveSelectedRows(file);
        testingset.setExcludedColumn(colacq, true);
        testingset.TargetNominal(target);
        FichierTabule testing = dsb.Balance(testingset, false);
        testingset.setExcludedColumn(colacq, true);
        FichierTabule totrain = new FichierTabule(training.Height(), new int[]{1, 2}, "");
        totrain.setColumn(1, training.getColumnString(training.Target()));
        totrain.TargetNominal(1);
        FichierTabule totest = new FichierTabule(testing.Height(), new int[]{1, 2}, "");
        totest.setColumn(1, testing.getColumnString(testing.Target()));
        totest.TargetNominal(1);
        GenericClassifier genclass = new GenericClassifier(new Logistic(), new Object[0]);
        int nb = 0;
        for (int c = 0; c < training.Width(); ++c) {
            if (training.isExcludedColumn(c) || training.ColumnType(c) != 1) continue;
            ++nb;
        }
        FichierTabule result = new FichierTabule(nb, new int[]{1, 1, 1, 2}, "");
        result.setColumnName(0, "Training");
        result.setColumnName(1, "Testing");
        result.setColumnName(2, "Gap");
        result.setColumnName(3, "Feature");
        nb = 0;
        block9: for (int c = 0; c < file.Width(); ++c) {
            if (training.isExcludedColumn(c)) continue;
            switch (training.ColumnType(c)) {
                case 0: {
                    System.out.println("Souci int column " + c);
                    continue block9;
                }
                case 1: {
                    totrain.setColumn(0, training.getColumnDouble(c));
                    totest.setColumn(0, testing.getColumnDouble(c));
                    break;
                }
                default: {
                    continue block9;
                }
            }
            result.setValue(nb, 0, -1.0);
            result.setValue(nb, 1, -1.0);
            result.setValue(nb, 2, -1.0);
            result.setValue(nb, 3, file.getColumnName(c));
            try {
                genclass.LearnPredictEvaluate(totrain, 1, nbfolds, classname);
            }
            catch (Exception e) {
                System.out.flush();
                System.err.println("Feature '" + file.getColumnName(c) + "', row " + nb);
                e.printStackTrace();
                System.err.flush();
            }
            result.setValue(nb, 0, genclass.Checks()[0]);
            try {
                genclass.Train(totrain);
                genclass.Classify(totest);
            }
            catch (Exception e) {
                System.out.flush();
                System.err.println("Feature '" + file.getColumnName(c) + "', row " + nb);
                e.printStackTrace();
                System.err.flush();
            }
            String[] predictions = genclass.Predictions();
            double sumok = 0.0;
            double sumko = 0.0;
            for (int i2 = 0; i2 < predictions.length; ++i2) {
                if (predictions[i2].equalsIgnoreCase(totest.getValueString(i2, 1))) {
                    sumok += totest.Weight(i2);
                    continue;
                }
                sumko += totest.Weight(i2);
            }
            result.setValue(nb, 1, sumok / (sumok + sumko) * 100.0);
            result.setValue(nb, 2, result.getValueDouble(nb, 1) - result.getValueDouble(nb, 0));
            ++nb;
        }
        return result;
    }

    public FichierTabule TestSingleFeature(FichierTabule file) {
        System.out.println("Target = " + file.getColumnName(file.Target()));
        int colcells = file.ColumnNumber("File");
        List<String> cells = this.FindCellLines(file.getColumnString(colcells));
        file.setExcludedColumn("Acquisition", true);
        file.setExcludedColumn(colcells, true);
        boolean[] excludedcolumns = (boolean[])file.getExcludedColumn().clone();
        GenericClassifier genclass = new GenericClassifier(new Logistic(), new Object[0]);
        int nb = 0;
        for (int c = 0; c < file.Width(); ++c) {
            if (file.isExcludedColumn(c) || file.ColumnType(c) != 1) continue;
            ++nb;
        }
        FichierTabule result = new FichierTabule(nb, new int[]{1, 2}, "");
        result.setColumnName(0, "Prediction");
        result.setColumnName(1, "Feature");
        nb = 0;
        block7: for (int c = 0; c < file.Width(); ++c) {
            if (excludedcolumns[c]) continue;
            switch (file.ColumnType(c)) {
                case 1: {
                    break;
                }
                case 0: {
                    System.out.println("Souci int column " + c + ", " + file.getColumnName(c));
                }
                default: {
                    continue block7;
                }
            }
            result.setValue(nb, 0, -1.0);
            result.setValue(nb, 1, file.getColumnName(c));
            Arrays.fill(file.getExcludedColumn(), true);
            file.setExcludedColumn(c, false);
            file.setExcludedColumn(file.Target(), false);
            double sumok = 0.0;
            double sumko = 0.0;
            for (String celline : cells) {
                file.SelectWhere(colcells, 6, celline);
                file.ExcludeSelectedRows();
                FichierTabule training = FichierTabuleTools.DeleteExcluded(file);
                training.TargetNominal(1);
                file.InverseExclusionRows();
                FichierTabule testing = FichierTabuleTools.DeleteExcluded(file);
                file.ClearExcludedRows();
                try {
                    genclass.Train(training);
                    genclass.Classify(testing);
                }
                catch (Exception e) {
                    System.out.flush();
                    System.err.println("Feature '" + file.getColumnName(c) + "', row " + nb);
                    e.printStackTrace();
                    System.err.flush();
                }
                String[] predictions = genclass.Predictions();
                for (int i2 = 0; i2 < predictions.length; ++i2) {
                    if (predictions[i2].equalsIgnoreCase(testing.getValueString(i2, 1))) {
                        sumok += testing.Weight(i2);
                        continue;
                    }
                    sumko += testing.Weight(i2);
                }
                predictions = null;
            }
            Iterator<String> iter = null;
            result.setValue(nb, 0, sumok / (sumok + sumko) * 100.0);
            ++nb;
        }
        return result;
    }

    private List<String> FindCellLines(String[] images) {
        String[] names = new String[images.length];
        for (int i2 = 0; i2 < images.length; ++i2) {
            names[i2] = images[i2].substring(0, images[i2].indexOf(95));
        }
        return ListConverter.ArrayToListWithoutReccurrence(names);
    }

    public void TestFeatures(FichierTabule file, int nbfolds, int trainingacquisition, int testingacquisition, DataSetBalancer dsb, String target, String classname) {
        int colacq = file.ColumnNumber("Acquisition");
        file.SelectWhere(colacq, 0, trainingacquisition);
        FichierTabule trainingset = FichierTabuleTools.SaveSelectedRows(file);
        trainingset.setExcludedColumn(colacq, true);
        trainingset.TargetNominal(target);
        FichierTabule training = dsb.Balance(trainingset, false);
        training.setExcludedColumn(colacq, true);
        file.SelectWhere(colacq, 0, testingacquisition);
        FichierTabule testingset = FichierTabuleTools.SaveSelectedRows(file);
        testingset.setExcludedColumn(colacq, true);
        testingset.TargetNominal(target);
        FichierTabule testing = dsb.Balance(testingset, false);
        testing.setExcludedColumn(colacq, true);
        file.TargetNominal(target);
        for (int i2 = 0; i2 < file.Width(); ++i2) {
            if (file.ColumnType(i2) != 2 || i2 == file.Target()) continue;
            training.setExcludedColumn(i2, true);
            testing.setExcludedColumn(i2, true);
        }
        training = FichierTabuleTools.DeleteExcludedColumns(training);
        testing = FichierTabuleTools.DeleteExcludedColumns(testing);
        training.TargetNominal(target);
        testing.TargetNominal(target);
        GenericClassifier genclass = new GenericClassifier(new RandomForest(), new Object[0]);
        try {
            genclass.LearnPredictEvaluate(training, 1, nbfolds, classname);
            System.out.println("Training: " + genclass.Checks()[0]);
            genclass.Train(training);
            genclass.Classify(testing);
            String[] predictions = genclass.Predictions();
            double sumok = 0.0;
            double sumko = 0.0;
            for (int i3 = 0; i3 < predictions.length; ++i3) {
                if (predictions[i3].equalsIgnoreCase(testing.getValueString(i3, testing.Target()))) {
                    sumok += testing.Weight(i3);
                    continue;
                }
                sumko += testing.Weight(i3);
            }
            System.out.println("Testing: " + sumok / (sumok + sumko) * 100.0);
        }
        catch (Exception e) {
            System.out.flush();
            e.printStackTrace();
            System.err.flush();
        }
    }

    public void TestFeatures(FichierTabule file) {
        int colcells = file.ColumnNumber("File");
        List<String> cells = this.FindCellLines(file.getColumnString(colcells));
        GenericClassifier genclass = new GenericClassifier(new RandomForest(), new Object[0]);
        for (int i2 = 0; i2 < file.Width(); ++i2) {
            if (file.ColumnType(i2) != 2 && file.ColumnType(i2) != 0 || i2 == file.Target()) continue;
            file.setExcludedColumn(i2, true);
        }
        double sumok = 0.0;
        double sumko = 0.0;
        for (String celline : cells) {
            file.SelectWhere(colcells, 6, celline);
            file.ExcludeSelectedRows();
            FichierTabule training = FichierTabuleTools.DeleteExcluded(file);
            int target = training.Width() - 1;
            training.TargetNominal(target);
            file.InverseExclusionRows();
            FichierTabule testing = FichierTabuleTools.DeleteExcluded(file);
            testing.TargetNominal(target);
            file.ClearExcludedRows();
            try {
                genclass.Train(training);
                genclass.Classify(testing);
                String[] predictions = genclass.Predictions();
                for (int i3 = 0; i3 < predictions.length; ++i3) {
                    if (predictions[i3].equalsIgnoreCase(testing.getValueString(i3, target))) {
                        sumok += testing.Weight(i3);
                        continue;
                    }
                    sumko += testing.Weight(i3);
                }
                predictions = null;
            }
            catch (Exception e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
            }
        }
        Iterator<String> iter = null;
        System.out.println("Prediction: " + sumok / (sumok + sumko) * 100.0);
    }

    public FichierTabule TestDoubleFeatures(FichierTabule file, int nbfolds, String classname) {
        FichierTabule totest = new FichierTabule(file.Height(), new int[]{1, 1, 2}, "");
        totest.setColumn(2, file.getColumnString(file.Target()));
        totest.TargetNominal(2);
        GenericClassifier genclass = new GenericClassifier(new Logistic(), new Object[0]);
        int maxsize = 23;
        PriorityQueue<BestResult> bestlist = new PriorityQueue<BestResult>(23);
        double minbest = 0.0;
        block10: for (int c0 = 0; c0 < file.Width() - 1; ++c0) {
            if (file.isExcludedColumn(c0)) continue;
            switch (file.ColumnType(c0)) {
                case 0: {
                    System.out.println("Souci int column " + c0);
                    continue block10;
                }
                case 1: {
                    totest.setColumn(0, file.getColumnDouble(c0));
                    break;
                }
                default: {
                    continue block10;
                }
            }
            block11: for (int c1 = c0 + 1; c1 < file.Width(); ++c1) {
                if (file.isExcludedColumn(c1)) continue;
                switch (file.ColumnType(c1)) {
                    case 0: {
                        continue block11;
                    }
                    case 1: {
                        totest.setColumn(1, file.getColumnDouble(c1));
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                try {
                    genclass.LearnPredictEvaluate(totest, 1, nbfolds, classname);
                }
                catch (Exception e) {
                    System.out.flush();
                    System.err.println("Features '" + file.getColumnName(c0) + "' & '" + file.getColumnName(c1) + "'");
                    e.printStackTrace();
                    System.err.flush();
                }
                if (bestlist.size() >= 23 && !(minbest < genclass.Checks()[0])) continue;
                minbest = this.InsertResult(bestlist, 23, new BestResult(genclass.Checks()[0], file.getColumnName(c0) + "&" + file.getColumnName(c1)));
            }
        }
        FichierTabule result = new FichierTabule(23, new int[]{1, 2}, "");
        for (int i2 = 0; i2 < result.Height(); ++i2) {
            BestResult br = (BestResult)bestlist.poll();
            result.setValue(i2, 0, br.prediction);
            result.setValue(i2, 1, br.name);
        }
        return result;
    }

    private double InsertResult(PriorityQueue<BestResult> list, int maxsize, BestResult newbr) {
        if (list.size() == maxsize) {
            list.poll();
        }
        list.add(newbr);
        return list.peek().prediction;
    }

    private class BestResult
    implements Comparable<BestResult> {
        public String name;
        public double prediction;

        public BestResult(double prediction, String name) {
            this.name = name;
            this.prediction = prediction;
        }

        @Override
        public int compareTo(BestResult br) {
            return br.prediction < this.prediction ? 1 : -1;
        }
    }
}

