/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.summer;

import filesAndFolders.FichiersDossiersIHM;
import filesAndFolders.fichiersTabules.FichierTabule;
import gui.MailBox;
import ij.IJ;
import ij.plugin.PlugIn;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import morphee.Close;
import morphee.Open;
import morphee.StructuringElement;
import processing.filters.Median;
import processing.thresholding.ImageThresholder;
import processing.thresholding.PercentileDoubleThresholding;
import processing.thresholding.PercentileThresholding;
import processing.thresholding.TriangleThresholding;

public class Image_Quantifier
extends JFrame
implements PlugIn {
    private static final long serialVersionUID = 1L;
    private final FilenameFilter fnf = (file, name1) -> name1.charAt(0) != '.' && (name1.contains(".tif") || name1.contains(".czi") || name1.contains(".png"));
    private final Median median = new Median();
    private ImageThresholder tt = null;
    private BufferedImage immed = null;
    private BufferedImage imthres = null;
    private BufferedImage imgray = null;
    private BufferedImage imtmp = null;
    private final StructuringElement se2disk = new StructuringElement(new Object[]{2, -2});
    private final Open open = new Open();
    private final Close close = new Close();
    private final ImageFeatures IF = new ImageFeatures();
    private String currentpath = "~/";

    public Image_Quantifier() {
        this.IHM();
    }

    public void run(String string) {
        this.IHM();
    }

    private void IHM() {
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        this.addWindowListener(l);
        int width = 500;
        int height = 150;
        this.setSize(width, height);
        this.setLocation(200, 0);
        JLabel labeldir = new JLabel("Directory");
        JTextField textdir = new JTextField("", 23);
        textdir.setEditable(false);
        JButton butdir = new JButton("Choose");
        butdir.addActionListener(e -> {
            File file = FichiersDossiersIHM.ChoisirDossier(this.currentpath, false);
            if (file == null) {
                return;
            }
            this.currentpath = file.getParentFile().getAbsolutePath();
            textdir.setText(file.getAbsolutePath());
            textdir.repaint();
        });
        Box box1 = Box.createHorizontalBox();
        box1.add(butdir);
        box1.add(labeldir);
        box1.add(textdir);
        JComboBox<String> combobox = new JComboBox<String>();
        combobox.addItem("Triangle");
        combobox.addItem("Percentile");
        combobox.addItem("Double Percentile");
        JLabel labelparam = new JLabel("Parameter(s)");
        JTextField textparam = new JTextField("", 7);
        textparam.setEditable(true);
        Box box2 = Box.createHorizontalBox();
        box2.add(combobox);
        box2.add(labelparam);
        box2.add(textparam);
        JButton buttonprocess = new JButton("Process");
        buttonprocess.addActionListener(e -> {
            int nbCPU = Runtime.getRuntime().availableProcessors() - 1;
            if (nbCPU <= 0) {
                nbCPU = 1;
            }
            switch ((String)combobox.getSelectedItem()) {
                case "Triangle": {
                    this.tt = new TriangleThresholding();
                    break;
                }
                case "Percentile": {
                    int per = 0;
                    try {
                        per = Integer.valueOf(textparam.getText());
                    }
                    catch (Exception E) {
                        MailBox box = new MailBox(0, "The percentile is not a number!", "Error");
                        box = null;
                        return;
                    }
                    if (per < 0 || 100 < per) {
                        MailBox box = new MailBox(0, "The percentile is not into the range [0,100].", "Error");
                        box = null;
                        return;
                    }
                    this.tt = new PercentileThresholding(per);
                    break;
                }
                case "Double Percentile": {
                    int permax;
                    int permin;
                    try {
                        String[] params = textparam.getText().split(" ");
                        if (params.length != 2) {
                            MailBox box = new MailBox(0, "Two percentiles are required!\nUse space(s) to separate them.", "Error");
                            box = null;
                            return;
                        }
                        permin = Integer.valueOf(params[0]);
                        permax = Integer.valueOf(params[1]);
                    }
                    catch (Exception E) {
                        MailBox box = new MailBox(0, "One of the percentile is not a number!", "Error");
                        box = null;
                        return;
                    }
                    try {
                        this.tt = new PercentileDoubleThresholding(permin, permax);
                        break;
                    }
                    catch (Exception E) {
                        MailBox box = new MailBox(0, E.getMessage(), "Error");
                        box = null;
                        return;
                    }
                }
                default: {
                    throw new Error("Must not occur.");
                }
            }
            this.Process(textdir.getText(), nbCPU);
        });
        JButton buttondone = new JButton("Done");
        buttondone.addActionListener(e -> System.exit(0));
        Box mainbox = Box.createVerticalBox();
        mainbox.add(box1);
        mainbox.add(box2);
        mainbox.add(buttonprocess);
        mainbox.add(buttondone);
        JPanel panel = new JPanel();
        panel.add(mainbox);
        panel.setVisible(true);
        panel.setPreferredSize(new Dimension(width, height));
        panel.setDoubleBuffered(true);
        this.setContentPane(panel);
        this.setVisible(true);
    }

    private void Process(String path, int nbCPU) {
        File[] images = new File(path).listFiles(this.fnf);
        if (images == null) {
            MailBox box = new MailBox(0, "No images found!", "Error");
            box = null;
            return;
        }
        File resfile = new File(path + "/Results/");
        if (!resfile.exists()) {
            resfile.mkdir();
        }
        String[] names = new String[]{"Count", "Surface Percentage", "Average", "SD", "Skewness", "Kurtosis", "Contrast", "Michelson", "Minimum", "Rank05", "Rank25", "Rank50", "Rank75", "Rank95", "Maximum", "Image"};
        int[] types = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 2};
        FichierTabule file = new FichierTabule(images.length, types, "Results");
        file.setColumnsNames(names);
        FichierTabule filecleaned = new FichierTabule(images.length, types, "Results Cleaned");
        filecleaned.setColumnsNames(names);
        String separator = " \t ";
        file.setSeparator(separator);
        filecleaned.setSeparator(separator);
        IJ.showStatus((String)"Quantifier On");
        IJ.showProgress((double)0.0);
        for (int i2 = 0; i2 < images.length; ++i2) {
            try {
                BufferedImage image = ImageIO.Read(images[i2]);
                if (this.imthres == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)this.imthres)) {
                    this.imtmp = null;
                    this.imthres = null;
                    this.imthres = ImageNew.SameBinary((BufferedImage)image);
                    this.imgray = ImageNew.Same((BufferedImage)image);
                    this.imtmp = ImageNew.Same((BufferedImage)image);
                    this.immed = ImageNew.Same((BufferedImage)image);
                }
                this.median.Filter(image, this.se2disk, this.immed, nbCPU);
                this.tt.Filter(this.immed, this.imthres, nbCPU);
                ImageConverter.BinaryToGray((BufferedImage)this.imthres, (BufferedImage)this.imgray);
                this.open.Filter(this.imgray, this.se2disk, this.imtmp, nbCPU);
                this.close.Filter(this.imtmp, this.se2disk, this.imgray, nbCPU);
                if (ImageTools.isBlack((BufferedImage)this.imgray)) {
                    file.setValue(i2, file.Width() - 1, images[i2].getName());
                    filecleaned.setValue(i2, filecleaned.Width() - 1, images[i2].getName());
                    continue;
                }
                int pos = 0;
                ImageComparator.Compare((BufferedImage)this.imgray, (String)"!=", (int)0, (BufferedImage)image, (int)0, (BufferedImage)image);
                this.IF.Moments(image, 0);
                file.setValue(i2, pos++, this.IF.Size());
                file.setValue(i2, pos++, (double)this.IF.Size() / (double)(image.getWidth() * image.getHeight()) * 100.0);
                file.setValue(i2, pos++, this.IF.Average());
                file.setValue(i2, pos++, this.IF.StandardDeviation());
                file.setValue(i2, pos++, this.IF.Skewness());
                file.setValue(i2, pos++, this.IF.Kurtosis());
                file.setValue(i2, pos++, this.IF.Contrast(image, 0));
                file.setValue(i2, pos++, this.IF.Michelson(image, 0));
                this.IF.Ranks(image, 0);
                file.setValue(i2, pos++, this.IF.Minimum());
                file.setValue(i2, pos++, (int)this.IF.Rank05());
                file.setValue(i2, pos++, (int)this.IF.Rank25());
                file.setValue(i2, pos++, (int)this.IF.Rank50());
                file.setValue(i2, pos++, (int)this.IF.Rank75());
                file.setValue(i2, pos++, (int)this.IF.Rank95());
                file.setValue(i2, pos++, this.IF.Maximum());
                file.setValue(i2, pos, images[i2].getName());
                pos = 0;
                ImageComparator.Compare((BufferedImage)this.imgray, (String)"!=", (int)0, (BufferedImage)this.immed, (int)0, (BufferedImage)this.immed);
                this.IF.Moments(this.immed, 0);
                filecleaned.setValue(i2, pos++, this.IF.Size());
                filecleaned.setValue(i2, pos++, (double)this.IF.Size() / (double)(image.getWidth() * image.getHeight()) * 100.0);
                filecleaned.setValue(i2, pos++, this.IF.Average());
                filecleaned.setValue(i2, pos++, this.IF.StandardDeviation());
                filecleaned.setValue(i2, pos++, this.IF.Skewness());
                filecleaned.setValue(i2, pos++, this.IF.Kurtosis());
                filecleaned.setValue(i2, pos++, this.IF.Contrast(image, 0));
                filecleaned.setValue(i2, pos++, this.IF.Michelson(image, 0));
                this.IF.Ranks(this.immed, 0);
                filecleaned.setValue(i2, pos++, this.IF.Minimum());
                filecleaned.setValue(i2, pos++, (int)this.IF.Rank05());
                filecleaned.setValue(i2, pos++, (int)this.IF.Rank25());
                filecleaned.setValue(i2, pos++, (int)this.IF.Rank50());
                filecleaned.setValue(i2, pos++, (int)this.IF.Rank75());
                filecleaned.setValue(i2, pos++, (int)this.IF.Rank95());
                filecleaned.setValue(i2, pos++, this.IF.Maximum());
                filecleaned.setValue(i2, pos, images[i2].getName());
                ImageIO.Write(this.imgray, resfile.getAbsolutePath() + "/" + images[i2].getName() + "_Bin.png", 6);
                ImageIO.Write(image, resfile.getAbsolutePath() + "/" + images[i2].getName() + "_Seg.png", 6);
                ImageIO.Write(this.immed, resfile.getAbsolutePath() + "/" + images[i2].getName() + "_SegMed.png", 6);
                IJ.showProgress((double)((double)(i2 + 1) / (double)images.length));
                image = null;
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        file.Write(resfile.getAbsolutePath() + "/Measures.txt", false);
        filecleaned.Write(resfile.getAbsolutePath() + "/Measures_Cleaned.txt", false);
        IJ.showStatus((String)"Quantifier Done");
        IJ.showMessage((String)"Quantifier", (String)"Done");
        resfile = null;
        images = null;
        this.imthres = null;
        this.imtmp = null;
        this.imgray = null;
        MailBox box = new MailBox(0, "Done!", "Processing over");
        box = null;
    }

    public static void main(String[] args) {
        Image_Quantifier iq = new Image_Quantifier();
    }
}

