/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.summer;

import arrayTiTi.ArrayFeatures;
import filesAndFolders.FileFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Arrays;
import measures.cclh.UnionFindCcl;
import measures.histogram.Histogram;

public class DrugFeatures {
    private final Histogram histogram = new Histogram();
    private final UnionFindCcl ufccl = new UnionFindCcl();
    private final ArrayFeatures AF = new ArrayFeatures();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Compute(String dirpath) throws IOException, InterruptedException {
        FilterOutputStream statsfile = null;
        File[] dirs = new File(dirpath).listFiles(FileFilters.Directories);
        for (int i2 = 0; i2 < dirs.length; ++i2) {
            try {
                BufferedImage staining = ImageIO.Read(dirs[i2].getAbsolutePath() + "/Marker.tif");
                if (staining.getType() == 5) {
                    staining = ImageConverter.Channel((BufferedImage)staining, (int)0);
                }
                File statisticsfile = new File(dirs[i2].getAbsolutePath() + "/Statistics.txt");
                statsfile = new DataOutputStream(new FileOutputStream(statisticsfile.getAbsolutePath()));
                StringBuilder sbdirect = new StringBuilder(1000);
                StringBuilder sbrefined = new StringBuilder(1000);
                StringBuilder sbrefinedplus = new StringBuilder(1000);
                sbdirect.append(dirs[i2].getName()).append("\n");
                sbdirect.append(dirs[i2].getAbsolutePath()).append("\n");
                BufferedImage basins = ImageIO.Read(dirs[i2].getAbsolutePath() + "/Watershed - Basins.png");
                switch (basins.getType()) {
                    case 10: {
                        basins = ImageConverter.ByteToInt((BufferedImage)basins);
                        break;
                    }
                    case 11: {
                        basins = ImageConverter.ShortToInt((BufferedImage)basins);
                        break;
                    }
                    case 6: {
                        basins = ImageConverter.RGBtoInt((BufferedImage)basins);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Bassins encoding not supported.");
                    }
                }
                if (!ImageTools.areDimensionsEqual((BufferedImage)staining, (BufferedImage)basins)) {
                    throw new IllegalArgumentException("Images with different dimensions.");
                }
                int width = basins.getWidth();
                int height = basins.getHeight();
                int length = width * height;
                BufferedImage roi = ImageIO.Read(dirs[i2].getAbsolutePath() + "/Segmentation - ROI.png");
                this.histogram.Fill(roi);
                int[] hist = this.histogram.getValues(0);
                sbdirect.append("\n\nGeneral:\n");
                sbdirect.append(" - ").append(roi.getWidth()).append(" x ").append(roi.getHeight());
                sbdirect.append(" => ").append(length).append(" pixels\n");
                sbdirect.append(" - ").append(hist[255]).append(" (").append((double)hist[255] / (double)length * 100.0);
                sbdirect.append("%) pixels detected as nuclei (red, ROI = ").append(255).append(").\n");
                sbdirect.append(" - ").append(hist[200]).append(" (").append((double)hist[200] / (double)length * 100.0);
                sbdirect.append("%) pixels detected as unconfirmed nuclei (blue, ROI = ").append(200).append(").\n");
                this.ufccl.Label(basins, 0, true);
                this.ufccl.ComputeBoundingBoxes();
                int[] labels = (int[])this.ufccl.Labels1D().clone();
                int[] sizes = (int[])this.ufccl.Sizes().clone();
                int[] minx = (int[])this.ufccl.minx().clone();
                int[] maxx = (int[])this.ufccl.maxx().clone();
                int[] miny = (int[])this.ufccl.miny().clone();
                int[] maxy = (int[])this.ufccl.maxy().clone();
                sbdirect.append("\n\nDirect measurements:\n");
                sbdirect.append(" - ").append(sizes.length).append(" cells\n");
                int[] sizesclone = (int[])sizes.clone();
                sizesclone[0] = 0;
                this.AF.Ranks(sizesclone);
                int median = (int)this.AF.Rank50();
                int rank95 = (int)this.AF.Rank95();
                int[] coefs = new int[sizes.length];
                Arrays.fill(coefs, 1);
                coefs[0] = 0;
                for (int s = 1; s < sizes.length; ++s) {
                    if (rank95 >= sizes[s]) continue;
                    coefs[s] = sizes[s] / median;
                }
                int coefsum = (int)this.AF.Integral(coefs, 1, coefs.length);
                sbrefined.append("\n\nRefined measurements (after statistical analysis):\n");
                sbrefined.append(" - ").append(coefsum).append(" cells\n");
                ImageComparator.Compare((BufferedImage)roi, (String)"==", (int)200, (int)1, (int)0, (BufferedImage)roi);
                this.ufccl.Label(roi, 0, false);
                int[] sizesplus = this.ufccl.Sizes();
                int[] coefplus = new int[sizesplus.length];
                Arrays.fill(coefplus, 1);
                coefplus[0] = 0;
                for (int s = 1; s < sizesplus.length; ++s) {
                    coefplus[s] = sizesplus[s] / median;
                }
                int coefplusum = (int)this.AF.Integral(coefplus, 1, coefplus.length);
                sbrefinedplus.append("\n\nFull measurements => Nuclei (red) + Unconfirmed Nuclei (blue) + Statistical Analysis):\n");
                sbrefinedplus.append(" - ").append(coefsum + coefplusum).append(" cells\n");
                statsfile.write(sbdirect.toString().getBytes("ISO-8859-1"));
                statsfile.write(sbrefined.toString().getBytes("ISO-8859-1"));
                statsfile.write(sbrefinedplus.toString().getBytes("ISO-8859-1"));
                int[] types = new int[11];
                Arrays.fill(types, 0);
                types[0] = 2;
                types[10] = 1;
                types[9] = 1;
                types[8] = 1;
                types[7] = 1;
                FichierTabule features = new FichierTabule(sizes.length - 1, types, "");
                String[] names = new String[]{"Image", "ID", "MinX", "MaxX", "MinY", "MaxY", "Surface", "Average Intensity DAPI", "% Intensity DAPI", "Average Intensity Drug", "% Intensity Drug"};
                features.setColumnsNames(names);
                for (int c = 1; c < sizes.length; ++c) {
                    features.setValue(c - 1, 0, dirs[i2].getName());
                    features.setValue(c - 1, 1, c);
                    features.setValue(c - 1, 2, minx[c]);
                    features.setValue(c - 1, 3, maxx[c]);
                    features.setValue(c - 1, 4, miny[c]);
                    features.setValue(c - 1, 5, maxy[c]);
                    features.setValue(c - 1, 6, sizes[c]);
                }
                BufferedImage source = ImageIO.Read(dirs[i2].getAbsolutePath() + "/Original.png");
                byte[] bb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int[] integrals = new int[sizes.length];
                for (int p = 0; p < bb.length; ++p) {
                    int n = labels[p];
                    integrals[n] = integrals[n] + (bb[p] & 0xFF);
                }
                bb = null;
                for (int c = 1; c < sizes.length; ++c) {
                    features.setValue(c - 1, 7, (double)integrals[c] / (double)sizes[c]);
                }
                BufferedImage drug = ImageIO.Read(dirs[i2].getAbsolutePath() + "/Marker.tif");
                if (drug.getRaster().getNumBands() != 1) {
                    drug = ImageConverter.Channel((BufferedImage)drug, (int)0);
                }
                bb = ((DataBufferByte)drug.getRaster().getDataBuffer()).getData();
                Arrays.fill(integrals, 0);
                for (int p = 0; p < bb.length; ++p) {
                    int n = labels[p];
                    integrals[n] = integrals[n] + (bb[p] & 0xFF);
                }
                for (int c = 1; c < sizes.length; ++c) {
                    features.setValue(c - 1, 9, (double)integrals[c] / (double)sizes[c]);
                }
                features.Write(dirs[i2].getAbsolutePath() + "/Features.txt", false);
                sizesclone = null;
                sizes = null;
                labels = null;
                basins = null;
                features.Kill();
                continue;
            }
            catch (IOException e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
                statsfile.write("Exception!\n".getBytes("ISO-8859-1"));
                statsfile.write((e.getCause().toString() + "\n").getBytes("ISO-8859-1"));
                statsfile.write((e.getMessage() + "\n").getBytes("ISO-8859-1"));
                continue;
            }
            finally {
                statsfile.close();
                statsfile = null;
            }
        }
    }

    public void ComputeRatio(String dirpath) throws Exception {
        int c;
        FichierTabule f;
        int i2;
        int c2;
        FichierTabule features = null;
        File[] dirs = new File(dirpath).listFiles(FileFilters.Directories);
        for (int i3 = 0; i3 < dirs.length; ++i3) {
            try {
                FichierTabule f2 = new FichierTabule(dirs[i3].getAbsolutePath() + "/Features.txt", true);
                features = features == null ? f2 : FichierTabuleTools.Merge(features, f2);
                if (0 < i3) {
                    f2.Kill();
                }
                f2 = null;
                continue;
            }
            catch (IOException e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
            }
        }
        double[] averages = (double[])features.getColumnDouble("Average Intensity DAPI").clone();
        Arrays.sort(averages);
        double threshold = averages[averages.length / 20];
        for (c2 = 0; c2 < features.Height(); ++c2) {
            features.setValue(c2, 8, Math.max(1.0, features.getValueDouble(c2, 7) / threshold));
        }
        features.Write(dirpath + "/Features.txt", false);
        for (i2 = 0; i2 < dirs.length; ++i2) {
            try {
                f = new FichierTabule(dirs[i2].getAbsolutePath() + "/Features.txt", true);
                for (c = 0; c < f.Height(); ++c) {
                    f.setValue(c, 8, Math.max(1.0, f.getValueDouble(c, 7) / threshold));
                }
                f.Write(dirs[i2].getAbsolutePath() + "/Features.txt", false);
                f.Kill();
                f = null;
                continue;
            }
            catch (IOException e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
            }
        }
        System.arraycopy(features.getColumnDouble("Average Intensity Drug"), 0, averages, 0, averages.length);
        Arrays.sort(averages);
        threshold = averages[averages.length / 20];
        averages = null;
        for (c2 = 0; c2 < features.Height(); ++c2) {
            features.setValue(c2, 10, Math.max(1.0, features.getValueDouble(c2, 9) / threshold));
        }
        features.Write(dirpath + "/Features.txt", false);
        for (i2 = 0; i2 < dirs.length; ++i2) {
            try {
                f = new FichierTabule(dirs[i2].getAbsolutePath() + "/Features.txt", true);
                for (c = 0; c < f.Height(); ++c) {
                    f.setValue(c, 10, Math.max(1.0, f.getValueDouble(c, 9) / threshold));
                }
                f.Write(dirs[i2].getAbsolutePath() + "/Features.txt", false);
                f.Kill();
                f = null;
                continue;
            }
            catch (IOException e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
            }
        }
    }
}

