/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.sears;

import displays.Colors;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import measures.BasicMeasures;
import measures.Measures2D;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import morphee.Dilate;
import morphee.StructuringElement;
import morphee.filters.AreaClosing;
import morphee.filters.AreaOpening;
import morphee.segmentation.Skiz;
import processing.filters.ContrastEqualizer;
import processing.thresholding.Binary;
import processing.thresholding.Huang;
import processing.thresholding.Li;
import processing.thresholding.Otsu;
import processing.thresholding.Renyi;
import segmentation.cells.DapiMM;
import utils.LogFile;
import utils.memory.Allocator;

public class SearsVsGray {
    private Allocator allocator = Allocator.Instance();
    private final int Magnification;
    private AreaOpening ao = new AreaOpening();
    private AreaClosing ac = new AreaClosing();
    private Binary binary = new Binary();
    private ContrastEqualizer equalizer = new ContrastEqualizer();
    private DapiMM dapi;
    private Dilate dilate = new Dilate();
    private FillHole fh = new FillHole();
    private Skiz skiz = new Skiz();
    private UnionFindCcl ccl = new UnionFindCcl();
    private Huang huang = new Huang();
    private Li li = new Li();
    private Otsu otsu = new Otsu();
    private Renyi renyi = new Renyi();
    private StructuringElement sedisk2 = new StructuringElement(new Object[]{2, -2});
    private StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private LogFile log = new LogFile();
    private final ImageFeatures IF = new ImageFeatures();
    public boolean masksegment = true;
    public boolean nucleisegment = true;
    public boolean cellsegment = true;
    private final int windowsize = 104;
    private int AOThreshold = 150;
    private int FHThreshold = 500;
    private BasicMeasures basic = new BasicMeasures();

    public SearsVsGray(int Magnification) {
        switch (Magnification) {
            case 20: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.Magnification = Magnification;
        this.dapi = new DapiMM(Magnification, false);
    }

    public void Segment(String inputdir, String outputdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        Object[] dapis = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith(" - DAPI).tif"));
        Arrays.sort(dapis);
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        boolean dirtybackground = false;
        int simplifytexture = 2;
        boolean equalize = false;
        boolean fillholes = true;
        boolean DeleteOnTop = true;
        boolean roi100saver = false;
        for (int i2 = 0; i2 < dapis.length; ++i2) {
            try {
                boolean keepworking = true;
                String name2 = ((File)dapis[i2]).getName().substring(0, ((File)dapis[i2]).getName().indexOf(" - DAPI).tif"));
                BufferedImage nuclei = ImageIO.Read((File)dapis[i2]);
                switch (nuclei.getType()) {
                    case 5: {
                        nuclei = ImageConverter.Channel((BufferedImage)nuclei, (int)0);
                    }
                }
                if (this.masksegment && keepworking) {
                    keepworking &= this.FindMask(nuclei, name2, outputdir, nbCPU);
                }
                if (this.nucleisegment && keepworking) {
                    try {
                        BufferedImage mask = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/" + name2 + " - Nuclei Safety Mask.png"));
                        BufferedImage nuc = this.ac.Filter(nuclei, 100, true);
                        this.dapi.Segmentation(nuc, false, 2, false, true, true, false, mask, 150, outputdir, nbCPU);
                        this.Rename(name2, outputdir);
                        mask = this.allocator.Release(mask);
                        nuc = this.allocator.Release(nuc);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, new String[0]);
                        this.log.addComment("Cannot segment nuclei in image " + name2);
                    }
                }
                if (keepworking && this.cellsegment) {
                    try {
                        this.SegmentCells(inputdir, outputdir, name2, nbCPU);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.addNewException(e, new String[0]);
                        this.log.addComment("Cannot segment cells in image " + name2);
                        keepworking = false;
                    }
                }
                nuclei = null;
                name2 = null;
                this.allocator.ClearAll(true);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot process images: " + ((File)dapis[i2]).getAbsolutePath());
            }
        }
    }

    public void SegmentCells(String inputdir, String outputdir, String name, int nbCPU) throws Exception {
        BufferedImage basins = ImageIO.Read(outputdir + "/" + name + " - Nuclei Basins.tif");
        if ((int)this.IF.Maximum(basins) == 0) {
            this.log.addComment("Cell segmentation impossible in image " + name + ", no nuclei found.");
            ImageIO.Write(basins, outputdir + "/" + name + " - Cell Basins.tif", 8);
            return;
        }
        BufferedImage dapi = ImageIO.Read(inputdir + "/" + name + " - DAPI).tif");
        float[] radii = this.FindAdaptedRadii(dapi, basins);
        BufferedImage skizlabels = this.skiz.Filter(basins, this.sem3, true, radii, nbCPU);
        ImageIO.Write(skizlabels, outputdir + "/" + name + " - Cell Basins.tif", 8);
        radii = null;
        BufferedImage dapirgb = ImageConverter.GrayToColor((BufferedImage)dapi);
        ImageDrawer.Cells(dapirgb, ((DataBufferInt)skizlabels.getRaster().getDataBuffer()).getData(), Colors.RED, Colors.YELLOW);
        ImageIO.Write(dapirgb, outputdir + "/" + name + " - Cell Segmentation.png", 6);
        dapi = this.allocator.Release(dapi);
        dapirgb = this.allocator.Release(dapirgb);
        skizlabels = this.allocator.Release(skizlabels);
        basins = this.allocator.Release(basins);
        this.allocator.ClearAll(true);
    }

    private float[] FindAdaptedRadii(BufferedImage src, BufferedImage basins) {
        this.ccl.Label(basins, 0, true);
        float[] results = new float[this.ccl.ConnectedComponentsNumber() + 1];
        BufferedImage[] nuclei = this.ccl.SeparateComponents(src, 1, 1);
        for (int i2 = 1; i2 < nuclei.length; ++i2) {
            if (nuclei[i2] == null) continue;
            Measures2D measures = new Measures2D(nuclei[i2]);
            measures.EuclidianRadii();
            measures.MainAxes();
            results[i2] = (float)Math.max(measures.getSmallestRadius(), measures.SecondAxis02.Length() / 2.0);
            measures.Kill();
            measures = null;
        }
        nuclei = null;
        return results;
    }

    public void CutCells(String inputdir, String segdir, String outputdir, int nbCPU) throws Exception {
        File outdsRed;
        File outFITC;
        this.log.StartNewLog(this, "./");
        Object[] dapis = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith("UV - DAPI).tif"));
        Arrays.sort(dapis);
        File outCy5 = new File(outputdir + "/Cy5/");
        if (!outCy5.exists()) {
            outCy5.mkdirs();
        }
        if (!(outFITC = new File(outputdir + "/FITC/")).exists()) {
            outFITC.mkdirs();
        }
        if (!(outdsRed = new File(outputdir + "/dsRed/")).exists()) {
            outdsRed.mkdirs();
        }
        for (int i2 = 0; i2 < 1; ++i2) {
            try {
                String name2 = ((File)dapis[i2]).getName().substring(0, ((File)dapis[i2]).getName().indexOf("UV - DAPI).tif"));
                BufferedImage cells = ImageIO.Read(segdir + "/" + name2 + "UV - Nuclei Basins.tif");
                this.ccl.ImportLabels(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), cells.getWidth(), cells.getHeight());
                BufferedImage cy5 = ImageIO.Read(inputdir + "/" + name2 + "Red - Cy5).tif");
                this.Cut(cy5, name2, outCy5.getAbsolutePath());
                cy5 = null;
                BufferedImage fitc = ImageIO.Read(inputdir + "/" + name2 + "Blue - FITC).tif");
                this.Cut(fitc, name2, outFITC.getAbsolutePath());
                fitc = null;
                BufferedImage dsRed = ImageIO.Read(inputdir + "/" + name2 + "Green - dsRed).tif");
                this.Cut(dsRed, name2, outdsRed.getAbsolutePath());
                dsRed = null;
                this.allocator.ClearAll(true);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot process image: " + ((File)dapis[i2]).getAbsolutePath());
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, new String[0]);
                this.log.addComment("Cannot process image: " + ((File)dapis[i2]).getAbsolutePath());
            }
        }
        outdsRed = null;
        outFITC = null;
        outCy5 = null;
        Arrays.fill(dapis, null);
        dapis = null;
        this.log.Stop();
    }

    private void Cut(BufferedImage image, String name, String outputdir) throws IOException {
        BufferedImage[] list = this.ccl.SeparateComponents(image, 1, 0);
        for (int i2 = 1; i2 < list.length; ++i2) {
            if (list[i2] == null) continue;
            try {
                BufferedImage cell = list[i2];
                BufferedImage patch = new BufferedImage(104, 104, cell.getType());
                if (104 <= cell.getWidth() && 104 <= cell.getHeight()) {
                    ImageOperations.UnPadding((BufferedImage)cell, (BufferedImage)patch);
                } else if (104 <= cell.getWidth() || 104 <= cell.getHeight()) {
                    int minx = Math.min(cell.getWidth(), 104);
                    int miny = Math.min(cell.getHeight(), 104);
                    int dx = Math.max(0, 104 - cell.getWidth()) >> 1;
                    int dy = Math.max(0, 104 - cell.getHeight()) >> 1;
                    WritableRaster wrin = cell.getRaster();
                    WritableRaster wrout = patch.getRaster();
                    for (int y = 0; y < miny; ++y) {
                        for (int x = 0; x < minx; ++x) {
                            wrout.setSample(x + dx, y + dy, 0, wrin.getSample(x, y, 0));
                        }
                    }
                    wrout = null;
                    wrin = null;
                } else {
                    ImageOperations.Padding((BufferedImage)cell, (BufferedImage)patch, (int)0);
                }
                ImageIO.Write(patch, outputdir + "/" + name + i2 + ".png", 6);
                patch = null;
                cell = null;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot process patch " + i2 + " in image: " + name);
            }
        }
        list = null;
    }

    public void CutCellsRGB(String inputdir, String segdir, String outputdir, boolean addapi, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        Object[] dapis = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith("UV - DAPI).tif"));
        Arrays.sort(dapis);
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        for (Object dapi1 : dapis) {
            try {
                String name2 = ((File)dapi1).getName().substring(0, ((File)dapi1).getName().indexOf("UV - DAPI).tif"));
                String shortname = name2.replace(" ", "");
                BufferedImage cells = ImageIO.Read(segdir + "/" + name2 + "UV - Nuclei Basins.tif");
                this.ccl.ImportLabels(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), cells.getWidth(), cells.getHeight());
                BufferedImage cy5 = ImageIO.Read(inputdir + "/" + name2 + "Red - Cy5).tif");
                BufferedImage dsRed = ImageIO.Read(inputdir + "/" + name2 + "Green - dsRed).tif");
                BufferedImage fitc = ImageIO.Read(inputdir + "/" + name2 + "Blue - FITC).tif");
                if (addapi) {
                    BufferedImage dapi = ImageIO.Read(((File)dapi1).getAbsoluteFile());
                    this.Cut(cy5, dsRed, dapi, fitc, shortname, out.getAbsolutePath());
                    dapi = null;
                } else {
                    this.Cut(cy5, dsRed, fitc, shortname, out.getAbsolutePath());
                }
                dsRed = null;
                fitc = null;
                cy5 = null;
                cells = null;
                this.allocator.ClearAll(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot process image: " + ((File)dapi1).getAbsolutePath());
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, new String[0]);
                this.log.addComment("Cannot process image: " + ((File)dapi1).getAbsolutePath());
            }
        }
        Arrays.fill(dapis, null);
        dapis = null;
        out = null;
        this.log.Stop();
    }

    private void Cut(BufferedImage red, BufferedImage green, BufferedImage blue, String name, String outputdir) throws IOException {
        BufferedImage[] redlist = this.ccl.SeparateComponents(red, 1, 0);
        BufferedImage[] greenlist = this.ccl.SeparateComponents(green, 1, 0);
        BufferedImage[] bluelist = this.ccl.SeparateComponents(blue, 1, 0);
        if (redlist.length != greenlist.length || redlist.length != bluelist.length) {
            throw new IllegalArgumentException("redlist.size() != greenlist.size() || redlist.size() != bluelist.size()");
        }
        for (int i2 = 1; i2 < redlist.length; ++i2) {
            if (redlist[i2] == null) continue;
            try {
                BufferedImage redcell = redlist[i2];
                BufferedImage greencell = greenlist[i2];
                BufferedImage bluecell = bluelist[i2];
                BufferedImage patch = ImageNew.Short((int)104, (int)104, (int)3);
                BufferedImage patch16 = new BufferedImage(104, 104, 11);
                if (104 <= redcell.getWidth() && 104 <= redcell.getHeight()) {
                    ImageOperations.UnPadding((BufferedImage)redcell, (BufferedImage)patch16);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)2);
                    ImageOperations.UnPadding((BufferedImage)greencell, (BufferedImage)patch16);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)1);
                    ImageOperations.UnPadding((BufferedImage)bluecell, (BufferedImage)patch16);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)0);
                } else if (104 <= redcell.getWidth() || 104 <= redcell.getHeight()) {
                    int minx = Math.min(redcell.getWidth(), 104);
                    int miny = Math.min(redcell.getHeight(), 104);
                    int dx = Math.max(0, 104 - redcell.getWidth()) >> 1;
                    int dy = Math.max(0, 104 - redcell.getHeight()) >> 1;
                    WritableRaster wrout = patch.getRaster();
                    WritableRaster wrinred = redcell.getRaster();
                    WritableRaster wringreen = greencell.getRaster();
                    WritableRaster wrinblue = bluecell.getRaster();
                    for (int y = 0; y < miny; ++y) {
                        for (int x = 0; x < minx; ++x) {
                            wrout.setSample(x + dx, y + dy, 0, wrinred.getSample(x, y, 0));
                            wrout.setSample(x + dx, y + dy, 1, wringreen.getSample(x, y, 0));
                            wrout.setSample(x + dx, y + dy, 2, wrinblue.getSample(x, y, 0));
                        }
                    }
                    wrout = null;
                    wrinblue = null;
                    wringreen = null;
                    wrinred = null;
                } else {
                    ImageOperations.Padding((BufferedImage)redcell, (BufferedImage)patch16, (int)0);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)2);
                    ImageOperations.Padding((BufferedImage)greencell, (BufferedImage)patch16, (int)0);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)1);
                    ImageOperations.Padding((BufferedImage)bluecell, (BufferedImage)patch16, (int)0);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)0);
                }
                ImageIO.WriteJAI(patch, outputdir + "/" + name + i2 + ".tif", 8);
                patch16 = null;
                patch = null;
                bluecell = null;
                greencell = null;
                redcell = null;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot process patch " + i2 + " in image: " + name);
            }
        }
        bluelist = null;
        greenlist = null;
        redlist = null;
    }

    private void Cut(BufferedImage red, BufferedImage green, BufferedImage blue, BufferedImage alpha, String name, String outputdir) throws IOException {
        BufferedImage[] redlist = this.ccl.SeparateComponents(red, 1, 0);
        BufferedImage[] greenlist = this.ccl.SeparateComponents(green, 1, 0);
        BufferedImage[] bluelist = this.ccl.SeparateComponents(blue, 1, 0);
        BufferedImage[] alphalist = this.ccl.SeparateComponents(alpha, 1, 0);
        if (redlist.length != greenlist.length || redlist.length != bluelist.length || redlist.length != alphalist.length) {
            throw new IllegalArgumentException("redlist.size() != greenlist.size() || redlist.size() != bluelist.size()");
        }
        for (int i2 = 1; i2 < redlist.length; ++i2) {
            if (redlist[i2] == null) continue;
            try {
                BufferedImage redcell = redlist[i2];
                BufferedImage greencell = greenlist[i2];
                BufferedImage bluecell = bluelist[i2];
                BufferedImage alphacell = alphalist[i2];
                BufferedImage patch = ImageNew.Short((int)104, (int)104, (int)4);
                BufferedImage patch16 = new BufferedImage(104, 104, 11);
                if (104 <= redcell.getWidth() && 104 <= redcell.getHeight()) {
                    ImageOperations.UnPadding((BufferedImage)redcell, (BufferedImage)patch16);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)0);
                    ImageOperations.UnPadding((BufferedImage)greencell, (BufferedImage)patch16);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)1);
                    ImageOperations.UnPadding((BufferedImage)bluecell, (BufferedImage)patch16);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)2);
                    ImageOperations.UnPadding((BufferedImage)alphacell, (BufferedImage)patch16);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)3);
                } else if (104 <= redcell.getWidth() || 104 <= redcell.getHeight()) {
                    int minx = Math.min(redcell.getWidth(), 104);
                    int miny = Math.min(redcell.getHeight(), 104);
                    int dx = Math.max(0, 104 - redcell.getWidth()) >> 1;
                    int dy = Math.max(0, 104 - redcell.getHeight()) >> 1;
                    WritableRaster wrout = patch.getRaster();
                    WritableRaster wrinred = redcell.getRaster();
                    WritableRaster wringreen = greencell.getRaster();
                    WritableRaster wrinblue = bluecell.getRaster();
                    WritableRaster wrinalpha = alphacell.getRaster();
                    for (int y = 0; y < miny; ++y) {
                        for (int x = 0; x < minx; ++x) {
                            wrout.setSample(x + dx, y + dy, 0, wrinred.getSample(x, y, 0));
                            wrout.setSample(x + dx, y + dy, 1, wringreen.getSample(x, y, 0));
                            wrout.setSample(x + dx, y + dy, 2, wrinblue.getSample(x, y, 0));
                            wrout.setSample(x + dx, y + dy, 3, wrinalpha.getSample(x, y, 0));
                        }
                    }
                    wrout = null;
                    wrinalpha = null;
                    wrinblue = null;
                    wringreen = null;
                    wrinred = null;
                } else {
                    ImageOperations.Padding((BufferedImage)redcell, (BufferedImage)patch16, (int)0);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)0);
                    ImageOperations.Padding((BufferedImage)greencell, (BufferedImage)patch16, (int)0);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)1);
                    ImageOperations.Padding((BufferedImage)bluecell, (BufferedImage)patch16, (int)0);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)2);
                    ImageOperations.Padding((BufferedImage)alphacell, (BufferedImage)patch16, (int)0);
                    ImageNew.Copy((BufferedImage)patch16, (BufferedImage)patch, (int)3);
                }
                ImageIO.WriteJAI(patch, outputdir + "/" + name + i2 + ".tif", 8);
                patch16 = null;
                patch = null;
                alphacell = null;
                bluecell = null;
                greencell = null;
                redcell = null;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot process patch " + i2 + " in image: " + name);
            }
        }
        alphalist = null;
        bluelist = null;
        greenlist = null;
        redlist = null;
    }

    private void Rename(String name, String output) {
        File f = new File(output + "/Intermediate - WhiteTopHat.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - AreaOpening.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - UltimateEroded.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Watershed - Markers.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - ROI.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - Full Color.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/" + name + " - Nuclei Segmentation.png"));
        }
        f = null;
        f = new File(output + "/Watershed - Basins.tif");
        if (f.exists()) {
            f.renameTo(new File(output + "/" + name + " - Nuclei Basins.tif"));
        }
        f = null;
    }

    public boolean FindMask(BufferedImage dapi, String name, String outputdir, int nbCPU) throws IOException {
        BufferedImage gray = null;
        switch (dapi.getType()) {
            case 10: {
                gray = dapi;
                break;
            }
            case 11: {
                gray = ImageConverter.UShortGrayToGray((BufferedImage)dapi, (boolean)true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        BufferedImage dapimp = this.equalizer.Filter(gray, ContrastEqualizer.Equalization.CLAHE, nbCPU);
        ImageIO.Write(dapimp, outputdir + "/" + name + " - DAPI CE.png", 6);
        gray = this.allocator.Release(gray);
        BufferedImage bin = ImageNew.Same((BufferedImage)dapimp);
        this.huang.Filter(dapimp, bin, nbCPU);
        this.li.Filter(dapimp, bin, nbCPU);
        this.otsu.Filter(dapimp, bin, nbCPU);
        this.renyi.Filter(dapimp, bin, nbCPU);
        int[] thres = new int[]{this.huang.getThreshold(0), this.li.getThreshold(0), this.otsu.getThreshold(0), this.renyi.getThreshold(0)};
        Arrays.sort(thres);
        this.binary.Filter(dapimp, thres[1] + thres[2] >> 2, bin, nbCPU);
        dapimp = this.allocator.Release(dapimp);
        BufferedImage binao = this.ao.Filter(bin, this.AOThreshold, true);
        this.dilate.Filter(binao, this.sedisk2, bin, nbCPU);
        this.fh.Fill(bin, (ConnectedComponentLabeling)this.ccl, this.FHThreshold, true, binao);
        bin = this.allocator.Release(bin);
        ImageIO.Write(ImageConverter.GrayToBinary((BufferedImage)binao), outputdir + "/" + name + " - Nuclei Safety Mask.png", 6);
        if (ImageTools.isBlack((BufferedImage)binao)) {
            binao = this.allocator.Release(binao);
            this.log.addComment("No nuclei found (empty mask) in image " + name);
            return false;
        }
        binao = this.allocator.Release(binao);
        return true;
    }

    public void FeaturesExtraction(String inputdir, String segmentationdir, String featuresdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        File resfile = new File(featuresdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        resfile = null;
        Object[] basins = new File(segmentationdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith("Basins.tif"));
        Arrays.sort(basins);
        for (int i2 = 0; i2 < basins.length; ++i2) {
            try {
                BufferedImage bas = ImageIO.Read((File)basins[i2]);
                String name2 = ((File)basins[i2]).getName().substring(0, ((File)basins[i2]).getName().indexOf(" - Nuclei Basins.tif"));
                BufferedImage dapi = ImageIO.Read(inputdir + "/" + name2 + " - DAPI).tif");
                this.ccl.ImportLabels(((DataBufferInt)bas.getRaster().getDataBuffer()).getData(), bas.getWidth(), bas.getHeight());
                this.ccl.ComputeBoundingBoxes();
                List<BufferedImage> nucleilist = this.Separate(this.ccl, dapi);
                FichierTabule nucfeatures = this.ComputeFeatures(this.ccl, nucleilist, nbCPU);
                nucfeatures.Write(featuresdir + "/" + name2 + ".txt", false);
                nucleilist.clear();
                nucleilist = null;
                name2 = null;
                dapi = null;
                bas = null;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot extract features for image " + ((File)basins[i2]).getAbsolutePath());
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, new String[0]);
                this.log.addComment("Cannot extract features for image " + ((File)basins[i2]).getAbsolutePath());
            }
        }
        this.log.Stop();
    }

    private List<BufferedImage> Separate(UnionFindCcl ccl, BufferedImage image) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(ccl.ConnectedComponentsNumber() + 13);
        int width = image.getWidth();
        int height = image.getHeight();
        boolean margin = true;
        int[] labels = ccl.Labels1D();
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        for (int i2 = 1; i2 <= ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - 1 < 0 ? 0 : minx[i2] - 1;
            int sy = miny[i2] - 1 < 0 ? 0 : miny[i2] - 1;
            int ex = width <= maxx[i2] + 1 ? width - 1 : maxx[i2] + 1;
            int ey = height <= maxy[i2] + 1 ? height - 1 : maxy[i2] + 1;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)image, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (labels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            images.add(patch);
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    private FichierTabule ComputeFeatures(UnionFindCcl ccl, List<BufferedImage> images, int nbCPU) {
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        int[] types = new int[12];
        Arrays.fill(types, 1);
        Arrays.fill(types, 0, 5, 0);
        types[7] = 0;
        FichierTabule features = new FichierTabule(ccl.ConnectedComponentsNumber() + 1, types, "");
        types = null;
        features.setColumnName(0, "Label");
        features.setColumnName(1, "MinX");
        features.setColumnName(2, "MinY");
        features.setColumnName(3, "MaxX");
        features.setColumnName(4, "MaxY");
        features.setColumnName(5, "CentroidX");
        features.setColumnName(6, "CentroidY");
        features.setColumnName(7, "Surface");
        features.setColumnName(8, "EuclideanLongestRadius");
        features.setColumnName(9, "EuclideanShortestRadius");
        features.setColumnName(10, "MainAxisLength");
        features.setColumnName(11, "SecondaryAxisLength");
        int nb = 1;
        for (BufferedImage image : images) {
            features.setValue(nb, 0, nb);
            features.setValue(nb, 1, minx[nb]);
            features.setValue(nb, 2, miny[nb]);
            features.setValue(nb, 3, maxx[nb]);
            features.setValue(nb, 4, maxy[nb]);
            this.basic.Compute(image, true);
            features.setValue(nb, 5, (double)minx[nb] + this.basic.Centroid.X);
            features.setValue(nb, 6, (double)miny[nb] + this.basic.Centroid.Y);
            features.setValue(nb, 7, (int)this.IF.Counter(image, 0));
            Measures2D measures = new Measures2D(image);
            measures.EuclidianRadii();
            measures.MainAxes();
            features.setValue(nb, 8, measures.getLongestRadius());
            features.setValue(nb, 9, measures.getSmallestRadius());
            features.setValue(nb, 10, measures.MainAxis01.Length());
            features.setValue(nb, 11, measures.SecondAxis02.Length());
            ++nb;
        }
        Iterator<BufferedImage> iter = null;
        return features;
    }
}

