/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.sears;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import displays.Colors;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListTools;
import measures.BasicMeasures;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import morphee.Dilate;
import morphee.StructuringElement;
import morphee.filters.AreaOpening;
import morphee.segmentation.Skiz;
import processing.filters.ContrastEqualizer;
import processing.thresholding.Binary;
import processing.thresholding.Huang;
import processing.thresholding.Li;
import processing.thresholding.Otsu;
import processing.thresholding.Renyi;
import segmentation.cells.DapiMM;
import utils.LogFile;
import utils.memory.Allocator;

public class BioPrinted {
    private Allocator allocator = Allocator.Instance();
    private final int Magnification;
    private AreaOpening ao = new AreaOpening();
    private Binary binary = new Binary();
    private ContrastEqualizer equalizer = new ContrastEqualizer();
    private final DapiMM dapi;
    private final DapiMM dapihalf;
    private Dilate dilate = new Dilate();
    private FillHole fh = new FillHole();
    private Skiz skiz = new Skiz();
    private UnionFindCcl ccl = new UnionFindCcl();
    private UnionFindCcl ccl2 = new UnionFindCcl();
    private Huang huang = new Huang();
    private Li li = new Li();
    private Otsu otsu = new Otsu();
    private Renyi renyi = new Renyi();
    private StructuringElement sedisk2 = new StructuringElement(new Object[]{2, -2});
    private StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private LogFile log = new LogFile();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    public boolean TestMode = false;
    public boolean masksegment = true;
    public boolean markersegment = true;
    public boolean nucleisegment = true;
    public boolean cellsegment = true;
    public String Segment_WaitFor = "";
    public boolean SingleWork = false;
    private int AOThreshold = 150;
    private int FHThreshold = 500;
    private boolean ReadMask = false;
    private BasicMeasures basic = new BasicMeasures();

    public BioPrinted(int Magnification) {
        switch (Magnification) {
            case 20: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.Magnification = Magnification;
        this.dapi = new DapiMM(Magnification, false);
        this.dapihalf = new DapiMM(Magnification / 2, false);
    }

    public void Segment(String inputdir, int nbCPU) throws Exception {
        Object[] dirs = new File(inputdir).listFiles(file -> file.isDirectory() && !file.getName().contains(" - Segmentation") && !file.getName().contains(" - Features"));
        Arrays.sort(dirs);
        boolean work = this.Segment_WaitFor.isEmpty();
        for (int d = 0; d < dirs.length; ++d) {
            if (!work) {
                if (!((File)dirs[d]).getName().equalsIgnoreCase(this.Segment_WaitFor)) continue;
                work = true;
            }
            this.Segment(((File)dirs[d]).getAbsolutePath(), inputdir + "/" + ((File)dirs[d]).getName() + " - Segmentation/", nbCPU);
        }
        Arrays.fill(dirs, null);
        dirs = null;
    }

    public void Segment(String inputdir, String outputdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        out = null;
        File[] dapis = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith("_DAPI.tif"));
        boolean dirtybackground = false;
        int simplifytexture = 2;
        boolean equalize = false;
        boolean fillholes = true;
        boolean DeleteOnTop = true;
        boolean roi100saver = false;
        boolean AF647_Cy5_channel = false;
        boolean AF555_Cy3_channel = true;
        int AF488_FITC_channel = 2;
        int[] channels = new int[]{1, 1, 2};
        boolean work = this.Segment_WaitFor.isEmpty();
        for (int i2 = 0; i2 < dapis.length; ++i2) {
            try {
                if (!work) {
                    if (!dapis[i2].getName().equalsIgnoreCase(this.Segment_WaitFor)) continue;
                    work = true;
                }
                boolean keepworking = true;
                String name2 = dapis[i2].getName().substring(0, dapis[i2].getName().indexOf("_DAPI.tif"));
                BufferedImage nuclei = ImageIO.Read(dapis[i2]);
                switch (nuclei.getType()) {
                    case 5: {
                        nuclei = ImageConverter.Channel((BufferedImage)nuclei, (int)0);
                    }
                }
                if (this.masksegment && keepworking && !this.TestMode) {
                    keepworking &= this.FindMask(nuclei, -1, 2, 0.75, true, name2, outputdir, "DAPI", "Nuclei Safety Mask", nbCPU);
                }
                if (this.markersegment && keepworking) {
                    BufferedImage AF488 = ImageIO.Read(inputdir + "/" + name2 + "_AF488_FITC.tif");
                    if (!this.TestMode) {
                        this.FindMask(AF488, channels[2], 3, 0.5, true, name2, outputdir, "Marker AF488_FITC", "Marker AF488_FITC Segmentation", nbCPU);
                    }
                    AF488 = null;
                }
                if (this.markersegment && keepworking) {
                    BufferedImage AF555 = ImageIO.Read(inputdir + "/" + name2 + "_AF555_Cy3.tif");
                    if (!this.TestMode) {
                        this.FindMask(AF555, channels[1], 2, 0.05, false, name2, outputdir, "Marker AF555_Cy3", "Marker AF555_Cy3 Segmentation", nbCPU);
                    }
                    AF555 = null;
                }
                if (this.nucleisegment && keepworking && !this.TestMode) {
                    try {
                        BufferedImage mask = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/" + name2 + " - Nuclei Safety Mask.png"));
                        BufferedImage nuc = ImageConverter.GrayToUShort((BufferedImage)nuclei, (boolean)true);
                        this.dapi.Segmentation(nuc, false, 2, false, true, true, false, mask, 100, outputdir, nbCPU);
                        this.Rename(name2, outputdir);
                        this.dapihalf.Segmentation(nuc, false, 2, false, true, true, false, mask, 100, outputdir, nbCPU);
                        this.Rename(name2 + "half", outputdir);
                        mask = this.allocator.Release(mask);
                        this.CleanBlobs(nuc, name2, outputdir);
                        this.Delete(name2 + "half", outputdir);
                        nuc = this.allocator.Release(nuc);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, new String[0]);
                        this.log.addComment("Cannot segment nuclei in image " + name2);
                    }
                }
                if (this.cellsegment && keepworking && !this.TestMode) {
                    try {
                        this.SegmentCells(inputdir, outputdir, name2, nbCPU);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, new String[0]);
                        this.log.addComment("Cannot segment cells in image " + name2);
                    }
                }
                this.allocator.ClearAll(true);
                if (!this.SingleWork) continue;
                System.exit(0);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot process images: " + dapis[i2].getAbsolutePath());
            }
        }
        this.log.Stop();
    }

    public void SegmentCells(String inputdir, String outputdir, String name, int nbCPU) throws Exception {
        BufferedImage basins = ImageIO.Read(outputdir + "/" + name + " - Nuclei Basins.tif");
        int max = (int)this.IF.Maximum(basins);
        if (max == 0) {
            this.log.addComment("Cell segmentation impossible in image " + name + ", no nuclei found.");
            ImageIO.Write(basins, outputdir + "/" + name + " - Cell Basins.tif", 8);
            return;
        }
        float[] radii = new float[max + 1];
        Arrays.fill(radii, 6.0f);
        BufferedImage skizlabels = this.skiz.Filter(basins, this.sem3, true, radii, nbCPU);
        ImageIO.Write(skizlabels, outputdir + "/" + name + " - Cell Basins.tif", 8);
        radii = null;
        BufferedImage dapi = ImageConverter.Channel((BufferedImage)ImageIO.Read(inputdir + "/" + name + "_DAPI.tif"), (int)0);
        BufferedImage dapirgb = ImageConverter.GrayToColor((BufferedImage)dapi);
        ImageDrawer.Cells(dapirgb, ((DataBufferInt)skizlabels.getRaster().getDataBuffer()).getData(), Colors.RED, Colors.YELLOW);
        ImageIO.Write(dapirgb, outputdir + "/" + name + " - Cell Segmentation.png", 6);
        dapi = null;
        dapirgb = this.allocator.Release(dapirgb);
        skizlabels = this.allocator.Release(skizlabels);
        basins = this.allocator.Release(basins);
        this.allocator.ClearAll(true);
    }

    private void CleanBlobs(BufferedImage nuclei, String name, String outputdir) throws IOException {
        BufferedImage basins = ImageIO.Read(outputdir + "/" + name + " - Nuclei Basins.tif");
        int width = basins.getWidth();
        if (!ImageTools.isBlack((BufferedImage)basins)) {
            this.ccl.ImportLabels(((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), basins.getWidth(), basins.getHeight());
            int[] labels = this.ccl.Labels1D();
            int[] sizes = this.ccl.Sizes();
            this.ccl.ComputeBoundingBoxes();
            int[] minx = this.ccl.minx();
            int[] miny = this.ccl.miny();
            int[] maxx = this.ccl.maxx();
            int[] maxy = this.ccl.maxy();
            BufferedImage rgb = ImageConverter.GrayToColor((BufferedImage)nuclei);
            ImageDrawer.Cells(rgb, this.ccl.Labels1D(), Colors.RED, Colors.YELLOW);
            BufferedImage basinshalf = ImageIO.Read(outputdir + "/" + name + "half - Nuclei Basins.tif");
            this.ccl2.ImportLabels(((DataBufferInt)basinshalf.getRaster().getDataBuffer()).getData(), basinshalf.getWidth(), basinshalf.getHeight());
            int[] labels2 = this.ccl2.Labels1D();
            int[] sizes2 = this.ccl2.Sizes();
            this.AF.Ranks(this.ccl.Sizes(), 1, this.ccl.Sizes().length);
            int threshold = (int)(2.5 * this.AF.Rank50());
            int nb = sizes.length;
            int[] lut = this.allocator.newIntArray(this.ccl2.ConnectedComponentsNumber() + 1);
            for (int cc = 1; cc < sizes.length; ++cc) {
                int pos;
                int x;
                int y;
                if (threshold > sizes[cc]) continue;
                int sx = minx[cc];
                int sy = miny[cc];
                int ex = maxx[cc];
                int ey = maxy[cc];
                LinkedList<Integer> list = new LinkedList<Integer>();
                for (y = sy; y <= ey; ++y) {
                    x = sx;
                    pos = y * width + x;
                    while (x <= ex) {
                        if (labels[pos] == cc && labels2[pos] != 0) {
                            if (!ListTools.isInList(list, (int)labels2[pos])) {
                                list.add(labels2[pos]);
                            }
                            int n = labels2[pos];
                            lut[n] = lut[n] + 1;
                        }
                        ++x;
                        ++pos;
                    }
                }
                if (list.isEmpty()) {
                    for (y = sy; y <= ey; ++y) {
                        x = sx;
                        pos = y * width + x;
                        while (x <= ex) {
                            if (labels[pos] == cc) {
                                labels[pos] = 0;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                } else {
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        int num = (Integer)iter.next();
                        if (lut[num] == sizes2[num] && sizes2[num] < threshold) {
                            lut[num] = ++nb;
                            continue;
                        }
                        lut[num] = 0;
                    }
                    for (int y2 = sy; y2 <= ey; ++y2) {
                        int x2 = sx;
                        int pos2 = y2 * width + x2;
                        while (x2 <= ex) {
                            if (labels[pos2] == cc) {
                                labels[pos2] = lut[labels2[pos2]];
                            }
                            ++x2;
                            ++pos2;
                        }
                    }
                    iter = list.iterator();
                    while (iter.hasNext()) {
                        lut[((Integer)iter.next()).intValue()] = 0;
                    }
                    iter = null;
                }
                list.clear();
            }
            lut = this.allocator.Release(lut);
            sizes2 = null;
            sizes = null;
            System.arraycopy(labels, 0, ((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), 0, labels.length);
            this.ccl.Label(basins, 0, true);
            System.arraycopy(labels, 0, ((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), 0, labels.length);
            ImageIO.Write(basins, outputdir + "/" + name + " - Nuclei Basins.tif", 8);
            ImageConverter.GrayToColor((BufferedImage)nuclei, (BufferedImage)rgb);
            ImageDrawer.Cells(rgb, this.ccl.Labels1D(), Colors.RED, Colors.YELLOW);
            ImageIO.Write(rgb, outputdir + "/" + name + " - Nuclei Segmentation.png", 6);
            labels2 = null;
            labels = null;
            basinshalf = null;
        }
        basins = null;
    }

    private void Delete(String name, String output) {
        File f = new File(output + "/" + name + " - Nuclei Segmentation.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/" + name + " - Nuclei ROI.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/" + name + " - Nuclei Basins.tif");
        if (f.exists()) {
            f.delete();
        }
        f = null;
    }

    private void Rename(String name, String output) {
        File f = new File(output + "/Intermediate - WhiteTopHat.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - AreaOpening.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - UltimateEroded.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Watershed - Markers.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - ROI.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - Full Color.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/" + name + " - Nuclei Segmentation.png"));
        }
        f = null;
        f = new File(output + "/Watershed - Basins.tif");
        if (f.exists()) {
            f.renameTo(new File(output + "/" + name + " - Nuclei Basins.tif"));
        }
        f = null;
    }

    public boolean FindMask(BufferedImage image, int channel, int thresholdlevel, double thresholdrate, boolean CE, String name, String outputdir, String extce, String extout, int nbCPU) throws IOException {
        if (thresholdlevel < 0 || 3 < thresholdlevel) {
            throw new IllegalArgumentException("The threshold level value must be in range [0,3]");
        }
        if (thresholdrate < 0.0 || 1.0 <= thresholdrate) {
            throw new IllegalArgumentException("The threshold rate value must be in range [0,1[");
        }
        BufferedImage gray = null;
        switch (image.getType()) {
            case 10: {
                gray = image;
                break;
            }
            case 11: {
                gray = ImageConverter.UShortGrayToGray((BufferedImage)image, (boolean)true);
                break;
            }
            case 5: {
                gray = ImageConverter.Channel((BufferedImage)image, (int)channel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        String cext = CE ? " CE.png" : ".png";
        BufferedImage dapimp = null;
        dapimp = this.ReadMask ? ImageIO.Read(outputdir + "/" + name + " - " + extce + cext) : (!CE ? gray : this.equalizer.Filter(gray, ContrastEqualizer.Equalization.CLAHE, nbCPU));
        if (!this.ReadMask) {
            ImageIO.Write(dapimp, outputdir + "/" + name + " - " + extce + cext, 6);
        }
        gray = null;
        BufferedImage bin = ImageNew.Same((BufferedImage)dapimp);
        this.huang.Filter(dapimp, bin, nbCPU);
        this.li.Filter(dapimp, bin, nbCPU);
        this.otsu.Filter(dapimp, bin, nbCPU);
        this.renyi.Filter(dapimp, bin, nbCPU);
        int[] thres = new int[]{this.huang.getThreshold(0), this.li.getThreshold(0), this.otsu.getThreshold(0), this.renyi.getThreshold(0)};
        Arrays.sort(thres);
        int threshold = thresholdlevel == 3 ? (int)((1.0 + thresholdrate) * (double)thres[thresholdlevel]) : thres[thresholdlevel] + (int)(thresholdrate * (double)(thres[thresholdlevel + 1] - thres[thresholdlevel]));
        this.binary.Filter(dapimp, threshold, bin, nbCPU);
        dapimp = this.allocator.Release(dapimp);
        BufferedImage binao = this.ao.Filter(bin, this.AOThreshold, true);
        this.dilate.Filter(binao, this.sedisk2, bin, nbCPU);
        this.fh.Fill(bin, (ConnectedComponentLabeling)this.ccl, this.FHThreshold, true, binao);
        bin = this.allocator.Release(bin);
        ImageIO.Write(ImageConverter.GrayToBinary((BufferedImage)binao), outputdir + "/" + name + " - " + extout + ".png", 6);
        if (ImageTools.isBlack((BufferedImage)binao)) {
            binao = this.allocator.Release(binao);
            this.log.addComment("No nuclei found (empty mask) in image " + name + ", for " + extce + " & " + extout);
            return false;
        }
        binao = this.allocator.Release(binao);
        return true;
    }

    public void FeaturesExtraction(String inputdir, int nbCPU) throws Exception {
        Object[] dirs = new File(inputdir).listFiles(file -> file.isDirectory() && file.getName().contains(" - Segmentation"));
        for (int d = 0; d < dirs.length; ++d) {
            String path = dirs[d].getAbsolutePath().substring(0, ((File)dirs[d]).getAbsolutePath().indexOf(" - Segmentation"));
            this.FeaturesExtraction(path, path + " - Segmentation/", path + " - Features/", nbCPU);
            path = null;
        }
        Arrays.fill(dirs, null);
        dirs = null;
    }

    public void FeaturesExtraction(String inputdir, String segmentationdir, String featuresdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        File resfile = new File(featuresdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        resfile = null;
        File[] dapis = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith("_DAPI.tif"));
        System.out.println(dapis.length + " image(s) found in " + inputdir);
        UnionFindCcl cellccl = new UnionFindCcl();
        for (int d = 0; d < dapis.length; ++d) {
            String name2 = dapis[d].getName().substring(0, dapis[d].getName().indexOf("_DAPI.tif"));
            BufferedImage nuclei = ImageIO.Read(segmentationdir + "/" + name2 + " - Nuclei Basins.tif");
            this.ccl.ImportLabels(((DataBufferInt)nuclei.getRaster().getDataBuffer()).getData(), nuclei.getWidth(), nuclei.getHeight());
            this.ccl.ComputeBoundingBoxes();
            int[] nuclabels = this.ccl.Labels1D();
            int[] nucsizes = this.ccl.Sizes();
            float[] nucleipos = new float[this.ccl.ConnectedComponentsNumber() + 1];
            BufferedImage cells = ImageIO.Read(segmentationdir + "/" + name2 + " - Cell Basins.tif");
            cellccl.ImportLabels(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), cells.getWidth(), cells.getHeight());
            System.arraycopy(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), 0, cellccl.Labels1D(), 0, cellccl.Labels1D().length);
            cellccl.ComputeBoundingBoxes();
            int[] cellslabels = cellccl.Labels1D();
            int[] cellsizes = cellccl.Sizes();
            float[] cellspos = new float[cellccl.ConnectedComponentsNumber() + 1];
            float[] ringspos = new float[cellccl.ConnectedComponentsNumber() + 1];
            List<BufferedImage> nucleimasklist = this.SeparateNucleiCells(this.ccl, nuclei);
            List<BufferedImage> cellsmasklist = this.SeparateNucleiCells(cellccl, cells);
            List<BufferedImage> cellsminusnucleimasklist = this.SeparateCellsMinusNuclei(this.ccl, cellccl, cells);
            String[] rawmarkers = new String[]{"AF555_Cy3", "AF488_FITC"};
            String[] markers = new String[]{"AF555_Cy3", "AF488_FITC"};
            String[] types = new String[]{"Nuclei", "Ring"};
            int[] channels = new int[]{1, 2};
            for (int m = 0; m < markers.length; ++m) {
                try {
                    int i2;
                    BufferedImage impos = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(segmentationdir + "/" + name2 + " - Marker " + markers[m] + " Segmentation.png"));
                    byte[] bbpos = ((DataBufferByte)impos.getRaster().getDataBuffer()).getData();
                    Arrays.fill(nucleipos, 0.0f);
                    for (i2 = 0; i2 < bbpos.length; ++i2) {
                        if (bbpos[i2] == 0) continue;
                        int n = nuclabels[i2];
                        nucleipos[n] = nucleipos[n] + 1.0f;
                    }
                    for (i2 = 0; i2 < nucleipos.length; ++i2) {
                        int n = i2;
                        nucleipos[n] = nucleipos[n] / (float)nucsizes[i2];
                    }
                    Arrays.fill(cellspos, 0.0f);
                    for (i2 = 0; i2 < bbpos.length; ++i2) {
                        if (bbpos[i2] == 0) continue;
                        int n = cellslabels[i2];
                        cellspos[n] = cellspos[n] + 1.0f;
                    }
                    for (i2 = 0; i2 < cellspos.length; ++i2) {
                        int n = i2;
                        cellspos[n] = cellspos[n] / (float)cellsizes[i2];
                    }
                    Arrays.fill(ringspos, 0.0f);
                    for (i2 = 0; i2 < bbpos.length; ++i2) {
                        if (bbpos[i2] == 0 || cellslabels[i2] == 0 || cellslabels[i2] == nuclabels[i2]) continue;
                        int n = cellslabels[i2];
                        ringspos[n] = ringspos[n] + 1.0f;
                    }
                    for (i2 = 0; i2 < cellspos.length; ++i2) {
                        if (cellsizes[i2] - nucsizes[i2] == 0) {
                            ringspos[i2] = 0.0f;
                            continue;
                        }
                        int n = i2;
                        ringspos[n] = ringspos[n] / (float)(cellsizes[i2] - nucsizes[i2]);
                    }
                    bbpos = null;
                    BufferedImage staining = ImageConverter.Channel((BufferedImage)ImageIO.Read(inputdir + "/" + name2 + "_" + rawmarkers[m] + ".tif"), (int)channels[m]);
                    List<BufferedImage> nucleilist = this.SeparateNucleiCells(this.ccl, staining);
                    List<BufferedImage> cellslist = this.SeparateNucleiCells(cellccl, staining);
                    List<BufferedImage> cellsminusnucleilist = this.SeparateCellsMinusNuclei(this.ccl, cellccl, staining);
                    switch (types[m]) {
                        case "Nuclei": {
                            FichierTabule nucfeatures = this.ComputeFeatures(this.ccl, nucleilist, nucleimasklist, nucleipos);
                            nucfeatures.Write(featuresdir + "/" + name2 + " - " + rawmarkers[m] + " - Nuclei.txt", false);
                            nucfeatures = null;
                            break;
                        }
                        case "Cells": {
                            FichierTabule cellfeatures = this.ComputeFeatures(cellccl, cellslist, cellsmasklist, cellspos);
                            cellfeatures.Write(featuresdir + "/" + name2 + " - " + rawmarkers[m] + " - Cells.txt", false);
                            cellfeatures = null;
                            break;
                        }
                        case "Ring": {
                            FichierTabule cellminusnucleifeatures = this.ComputeFeatures(cellccl, cellsminusnucleilist, cellsminusnucleimasklist, ringspos);
                            cellminusnucleifeatures.Write(featuresdir + "/" + name2 + " - " + rawmarkers[m] + " - Ring.txt", false);
                            cellminusnucleifeatures = null;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unknown type.");
                        }
                    }
                    nucleilist.clear();
                    cellslist.clear();
                    cellsminusnucleilist.clear();
                    cellsminusnucleilist = null;
                    cellslist = null;
                    nucleilist = null;
                    staining = null;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.log.addNewException(ex, new String[0]);
                    this.log.addComment("Cannot extract features from image " + inputdir + "/" + name2);
                    continue;
                }
                catch (Error e) {
                    e.printStackTrace();
                    this.log.addNewError(e, new String[0]);
                    this.log.addComment("Cannot extract features from image " + inputdir + "/" + name2);
                }
            }
            nucleimasklist.clear();
            cellsmasklist.clear();
            cellsminusnucleimasklist.clear();
            cellsminusnucleimasklist = null;
            cellsmasklist = null;
            nucleimasklist = null;
            rawmarkers = null;
            markers = null;
            nuclei = null;
            cells = null;
        }
        this.log.Stop();
    }

    private List<BufferedImage> SeparateNucleiCells(UnionFindCcl ccl, BufferedImage staining) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(ccl.ConnectedComponentsNumber() + 13);
        int width = staining.getWidth();
        int height = staining.getHeight();
        boolean margin = true;
        int[] labels = ccl.Labels1D();
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        for (int i2 = 1; i2 <= ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - 1 < 0 ? 0 : minx[i2] - 1;
            int sy = miny[i2] - 1 < 0 ? 0 : miny[i2] - 1;
            int ex = width <= maxx[i2] + 1 ? width - 1 : maxx[i2] + 1;
            int ey = height <= maxy[i2] + 1 ? height - 1 : maxy[i2] + 1;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            switch (patch.getType()) {
                case 10: {
                    byte[] bbpatch = ((DataBufferByte)patch.getRaster().getDataBuffer()).getData();
                    int p = 0;
                    for (int y = sy; y <= ey; ++y) {
                        int x = sx;
                        int pos = x + y * width;
                        while (x <= ex) {
                            if (labels[pos] != i2) {
                                bbpatch[p] = 0;
                            }
                            ++x;
                            ++pos;
                            ++p;
                        }
                    }
                    bbpatch = null;
                    break;
                }
                case 0: {
                    int[] ibpatch = ((DataBufferInt)patch.getRaster().getDataBuffer()).getData();
                    int p = 0;
                    for (int y = sy; y <= ey; ++y) {
                        int x = sx;
                        int pos = x + y * width;
                        while (x <= ex) {
                            if (labels[pos] != i2) {
                                ibpatch[p] = 0;
                            }
                            ++x;
                            ++pos;
                            ++p;
                        }
                    }
                    ibpatch = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("");
                }
            }
            patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2), (int)(patch.getHeight() + 2), (int)0);
            images.add(patch);
            patch = null;
        }
        return images;
    }

    private List<BufferedImage> SeparateCellsMinusNuclei(UnionFindCcl nucccl, UnionFindCcl cellccl, BufferedImage staining) throws IOException {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(this.ccl.ConnectedComponentsNumber() + 13);
        int width = staining.getWidth();
        int height = staining.getHeight();
        boolean margin = true;
        int[] minx = cellccl.minx();
        int[] maxx = cellccl.maxx();
        int[] miny = cellccl.miny();
        int[] maxy = cellccl.maxy();
        int[] celllabels = (int[])cellccl.Labels1D().clone();
        ArrayArithmetic.Subtract((int[])celllabels, (int[])nucccl.Labels1D(), (int[])celllabels, (int)0, (int)0);
        for (int i2 = 1; i2 <= this.ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - 1 < 0 ? 0 : minx[i2] - 1;
            int sy = miny[i2] - 1 < 0 ? 0 : miny[i2] - 1;
            int ex = width <= maxx[i2] + 1 ? width - 1 : maxx[i2] + 1;
            int ey = height <= maxy[i2] + 1 ? height - 1 : maxy[i2] + 1;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            switch (patch.getType()) {
                case 10: {
                    byte[] bbpatch = ((DataBufferByte)patch.getRaster().getDataBuffer()).getData();
                    int p = 0;
                    for (int y = sy; y <= ey; ++y) {
                        int x = sx;
                        int pos = x + y * width;
                        while (x <= ex) {
                            if (celllabels[pos] != i2) {
                                bbpatch[p] = 0;
                            }
                            ++x;
                            ++pos;
                            ++p;
                        }
                    }
                    bbpatch = null;
                    break;
                }
                case 0: {
                    int[] ibpatch = ((DataBufferInt)patch.getRaster().getDataBuffer()).getData();
                    int p = 0;
                    for (int y = sy; y <= ey; ++y) {
                        int x = sx;
                        int pos = x + y * width;
                        while (x <= ex) {
                            if (celllabels[pos] != i2) {
                                ibpatch[p] = 0;
                            }
                            ++x;
                            ++pos;
                            ++p;
                        }
                    }
                    ibpatch = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("");
                }
            }
            patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2), (int)(patch.getHeight() + 2), (int)0);
            images.add(patch);
            patch = null;
        }
        return images;
    }

    private FichierTabule ComputeFeatures(UnionFindCcl ccl, List<BufferedImage> images, List<BufferedImage> masks, float[] overlap) {
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        int[] types = new int[15];
        Arrays.fill(types, 1);
        Arrays.fill(types, 0, 5, 0);
        types[7] = 2;
        types[9] = 0;
        FichierTabule features = new FichierTabule(ccl.ConnectedComponentsNumber() + 1, types, "");
        features.setColumnName(0, "Label");
        features.setColumnName(1, "MinX");
        features.setColumnName(2, "MinY");
        features.setColumnName(3, "MaxX");
        features.setColumnName(4, "MaxY");
        features.setColumnName(5, "CentroidX");
        features.setColumnName(6, "CentroidY");
        features.setColumnName(7, "Positive");
        features.setColumnName(8, "Overlap");
        features.setColumnName(9, "Area");
        features.setColumnName(10, "MeanIntensity");
        features.setColumnName(11, "NormalizedMeanIntensity");
        features.setColumnName(12, "VarianceIntensity");
        features.setColumnName(13, "SkewnessIntensity");
        features.setColumnName(14, "KurtosisIntensity");
        int nb = 1;
        Iterator<BufferedImage> imiter = images.iterator();
        Iterator<BufferedImage> maskiter = masks.iterator();
        while (imiter.hasNext()) {
            BufferedImage image = imiter.next();
            BufferedImage mask = maskiter.next();
            BufferedImage newmask = ImageNew.Same((BufferedImage)image);
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (int)1, (int)0, (BufferedImage)newmask);
            features.setValue(nb, 0, nb);
            features.setValue(nb, 1, minx[nb]);
            features.setValue(nb, 2, miny[nb]);
            features.setValue(nb, 3, maxx[nb]);
            features.setValue(nb, 4, maxy[nb]);
            features.setValue(nb, 8, overlap[nb]);
            if (ImageTools.isBlack((BufferedImage)image)) {
                features.setValue(nb, 7, "-");
                ++nb;
                continue;
            }
            this.basic.Compute(image, true);
            features.setValue(nb, 5, (double)minx[nb] + this.basic.Centroid.X);
            features.setValue(nb, 6, (double)miny[nb] + this.basic.Centroid.Y);
            this.IF.Moments(image, newmask);
            features.setValue(nb, 9, (int)this.IF.Size());
            features.setValue(nb, 10, this.IF.Average());
            features.setValue(nb, 11, this.IF.Average());
            features.setValue(nb, 12, this.IF.Variance());
            features.setValue(nb, 13, this.IF.Skewness());
            features.setValue(nb, 14, this.IF.Kurtosis());
            features.setValue(nb, 7, 0.5f <= overlap[nb] ? "+" : "-");
            ++nb;
            newmask = null;
            mask = null;
            image = null;
        }
        imiter = null;
        double[] means = features.getColumnDouble(11);
        double minmean = Double.MAX_VALUE;
        for (int i2 = 1; i2 < means.length; ++i2) {
            if (!features.getValueString(i2, 7).equals("+") || !(means[i2] < minmean)) continue;
            minmean = means[i2];
        }
        ArrayArithmetic.Divide((double[])means, (double)minmean, (double[])means);
        means = null;
        return features;
    }

    public void Statistics(String inputdir, int nbCPU) throws Exception {
        int f;
        Object[] dirs = new File(inputdir).listFiles(file -> file.isDirectory() && file.getName().contains(" - Features"));
        Arrays.sort(dirs);
        Object[] files = new FichierTabule[dirs.length];
        int nbrow = 0;
        for (int d = 0; d < dirs.length; ++d) {
            this.Statistics(((File)dirs[d]).getAbsolutePath());
            files[d] = new FichierTabule(((File)dirs[d]).getAbsolutePath() + "/Statistics.txt", true);
            nbrow += files[d].Height() - 1;
        }
        String[] markers = new String[]{"AF647_Cy5", "AF555_Cy3", "AF488_FITC"};
        String[] names = new String[]{"Images", "Nuclei/Cells #", markers[0] + "+ #", markers[0] + "+ %", markers[1] + "+ #", markers[1] + "+ %", markers[2] + "+ #", markers[2] + "+ %", markers[0] + " & " + markers[1] + "+ #", markers[0] + " & " + markers[1] + "+ %", markers[0] + " & " + markers[2] + "+ #", markers[0] + " & " + markers[2] + "+ %", markers[1] + " & " + markers[2] + "+ #", markers[1] + " & " + markers[2] + "+ %", "% FITC+ also Cy5+ %", "% Cy3+ also Cy5+"};
        int[] coltypes = new int[names.length];
        Arrays.fill(coltypes, 1);
        coltypes[0] = 2;
        coltypes[1] = 0;
        for (int i2 = 2; i2 < coltypes.length - 2; i2 += 2) {
            coltypes[i2] = 0;
        }
        FichierTabule results = new FichierTabule(nbrow + 1, coltypes, "");
        results.setColumnsNames(names);
        int row = 0;
        for (int d = 0; d < dirs.length; ++d) {
            String dirname = ((File)dirs[d]).getName().replace(" - Features", "");
            int i3 = 0;
            while (i3 < files[d].Height() - 1) {
                FichierTabuleTools.CopyInstance(files[d], i3, results, row);
                results.setValue(row, 0, dirname + "/" + results.getValueString(row, 0));
                ++i3;
                ++row;
            }
        }
        if (row != nbrow) {
            throw new Error("Souci");
        }
        results.setValue(nbrow, 0, "Total");
        int sum = 0;
        for (f = 0; f < files.length; ++f) {
            sum += files[f].getValueInt(files[f].Height() - 1, 1);
        }
        results.setValue(nbrow, 1, sum);
        for (int i4 = 2; i4 < coltypes.length - 2; i4 += 2) {
            int count = 0;
            for (int f2 = 0; f2 < files.length; ++f2) {
                count += files[f2].getValueInt(files[f2].Height() - 1, i4);
            }
            results.setValue(nbrow, i4, count);
            results.setValue(nbrow, i4 + 1, (double)count / (double)sum * 100.0);
        }
        results.setValue(nbrow, 14, (double)results.getValueInt(0, 10) / (double)results.getValueInt(0, 6) * 100.0);
        results.setValue(nbrow, 15, (double)results.getValueInt(0, 8) / (double)results.getValueInt(0, 4) * 100.0);
        results.Write(inputdir + "/Statistics.txt", false);
        for (f = 0; f < files.length; ++f) {
            files[f].Kill();
        }
        Arrays.fill(files, null);
        files = null;
        Arrays.fill(dirs, null);
        dirs = null;
    }

    private void Statistics(String inputdir) throws Exception {
        String[] markers = new String[]{"AF647_Cy5", "AF555_Cy3", "AF488_FITC"};
        String[] type = new String[]{"Nuclei", "Ring", "Ring"};
        Object[] files = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains(markers[0]) && name.endsWith(".txt"));
        Arrays.sort(files);
        String[] names = new String[]{"Images", "Nuclei/Cells #", markers[0] + "+ #", markers[0] + "+ %", markers[1] + "+ #", markers[1] + "+ %", markers[2] + "+ #", markers[2] + "+ %", markers[0] + " & " + markers[1] + "+ #", markers[0] + " & " + markers[1] + "+ %", markers[0] + " & " + markers[2] + "+ #", markers[0] + " & " + markers[2] + "+ %", markers[1] + " & " + markers[2] + "+ #", markers[1] + " & " + markers[2] + "+ %", "% FITC+ also Cy5+", "% Cy3+ also Cy5+"};
        int[] coltypes = new int[names.length];
        Arrays.fill(coltypes, 1);
        coltypes[0] = 2;
        coltypes[1] = 0;
        for (int i2 = 2; i2 < coltypes.length - 2; i2 += 2) {
            coltypes[i2] = 0;
        }
        FichierTabule results = new FichierTabule(files.length + 1, coltypes, "");
        results.setColumnsNames(names);
        for (int f = 0; f < files.length; ++f) {
            results.setValue(f, 0, ((File)files[f]).getName().replace(" - " + markers[0] + " - Nuclei.txt", ""));
            FichierTabule f0 = new FichierTabule(((File)files[f]).getAbsolutePath(), true);
            f0.SelectWhere(7, 0, "+");
            results.setValue(f, 2, f0.nbSelected());
            results.setValue(f, 3, (double)f0.nbSelected() / (double)f0.Height() * 100.0);
            FichierTabule f1 = new FichierTabule(((File)files[f]).getAbsolutePath().replace(markers[0], markers[1]).replace(type[0], type[1]), true);
            f1.SelectWhere(7, 0, "+");
            results.setValue(f, 4, f1.nbSelected());
            results.setValue(f, 5, (double)f1.nbSelected() / (double)f1.Height() * 100.0);
            FichierTabule f2 = new FichierTabule(((File)files[f]).getAbsolutePath().replace(markers[0], markers[2]).replace(type[0], type[1]), true);
            f2.SelectWhere(7, 0, "+");
            results.setValue(f, 6, f2.nbSelected());
            results.setValue(f, 7, (double)f2.nbSelected() / (double)f2.Height() * 100.0);
            results.setValue(f, 1, f0.Height());
            FichierTabule concat = new FichierTabule(f0.Height(), new int[]{2, 2, 2}, "");
            concat.setColumn(0, f0.getColumnString(7));
            concat.setColumn(1, f1.getColumnString(7));
            concat.setColumn(2, f2.getColumnString(7));
            concat.SelectWhere(0, 0, "+");
            concat.SelectFromSelectionWhere(1, 0, "+");
            results.setValue(f, 8, concat.nbSelected());
            results.setValue(f, 9, (double)concat.nbSelected() / (double)concat.Height() * 100.0);
            results.setValue(f, 15, (double)concat.nbSelected() / (double)f1.nbSelected() * 100.0);
            concat.SelectWhere(0, 0, "+");
            concat.SelectFromSelectionWhere(2, 0, "+");
            results.setValue(f, 10, concat.nbSelected());
            results.setValue(f, 11, (double)concat.nbSelected() / (double)concat.Height() * 100.0);
            results.setValue(f, 14, (double)concat.nbSelected() / (double)f2.nbSelected() * 100.0);
            concat.SelectWhere(1, 0, "+");
            concat.SelectFromSelectionWhere(2, 0, "+");
            results.setValue(f, 12, concat.nbSelected());
            results.setValue(f, 13, (double)concat.nbSelected() / (double)concat.Height() * 100.0);
            f0.Kill();
            f1.Kill();
            f2.Kill();
            concat.Kill();
            concat = null;
            f2 = null;
            f1 = null;
            f0 = null;
        }
        int total = results.Height() - 1;
        results.setValue(total, 0, "Total");
        int sum = (int)this.AF.Integral(results.getColumnInt(1), 0, total);
        results.setValue(total, 1, sum);
        for (int i3 = 2; i3 < coltypes.length - 2; i3 += 2) {
            int count = (int)this.AF.Integral(results.getColumnInt(i3), 0, results.Height() - 1);
            results.setValue(total, i3, count);
            results.setValue(total, i3 + 1, (double)count / (double)sum * 100.0);
        }
        results.setValue(total, 14, (double)results.getValueInt(total, 10) / (double)results.getValueInt(total, 6) * 100.0);
        results.setValue(total, 15, (double)results.getValueInt(total, 8) / (double)results.getValueInt(total, 4) * 100.0);
        results.Write(inputdir + "/Statistics.txt", false);
        results.Kill();
        results = null;
    }

    public void Rename(String inputdir) {
        Object[] dirs = new File(inputdir).listFiles(file -> file.isDirectory());
        for (int d = 0; d < dirs.length; ++d) {
            FilesFolders.ReplaceInName(dirs[d], "c1.tif", "_DAPI.tif");
            FilesFolders.ReplaceInName((File)dirs[d], "c2.tif", "_AF488_FITC.tif");
            FilesFolders.ReplaceInName((File)dirs[d], "c3.tif", "_AF555_Cy3.tif");
            FilesFolders.ReplaceInName((File)dirs[d], "c4.tif", "_AF647_Cy5.tif");
        }
        Arrays.fill(dirs, null);
        dirs = null;
    }
}

