/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.monkeys.spectrums;

import displays.Display;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import morphee.Erode;
import morphee.Open;
import morphee.StructuringElement;
import morphee.filters.ASFilterOpenClose;
import processing.filters.Average;
import processing.filters.Median;

public class SpectrumAnalyze {
    int coucou;
    public Display display = null;
    Average average = new Average();
    Erode erode = new Erode();
    Open open = new Open();
    Median median = new Median();
    ASFilterOpenClose asfoc = new ASFilterOpenClose();

    public void Process(String path, FilenameFilter fnf, int nbCPU) {
        File[] files = new File(path).listFiles(fnf);
        for (int i2 = 0; i2 < files.length; ++i2) {
            try {
                BufferedImage image = ImageIO.Read(files[i2].getAbsolutePath());
                BufferedImage immed = this.median.Filter(image, new StructuringElement(new Object[]{3, -6}), nbCPU);
                BufferedImage imop = this.open.Filter(immed, new StructuringElement(new Object[]{3, -5}), nbCPU);
                BufferedImage imasf = this.asfoc.Filter(imop, new StructuringElement(new Object[]{13, -5}), nbCPU);
                this.display.Image(immed, "median - " + files[i2].getName(), 1.0);
                this.display.Image(imop, "open - " + files[i2].getName(), 1.0);
                this.display.Image(imasf, "ASF - " + files[i2].getName(), 1.0);
                immed = null;
                image = null;
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
                System.exit(0);
            }
        }
    }
}

