/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.monkeys.homography;

import arrayTiTi.ArrayFeatures;
import displays.Colors;
import displays.Display;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceTools;
import morphee.Close;
import morphee.Dilate;
import morphee.Erode;
import morphee.Open;
import morphee.StructuringElement;
import morphee.residues.UltimateErode;
import processing.filters.DynamicExpansion;
import processing.filters.Invert;
import processing.thresholding.Binary;
import softwares.ohsu.monkeys.homography.Monkey_Homography;
import softwares.ohsu.monkeys.homography.Monkey_InterestPoint;

public class Monkey_Main {
    int coucou;
    private Binary binary = new Binary();
    private Close close = new Close();
    private Erode erode = new Erode();
    private Dilate dilate = new Dilate();
    private DynamicExpansion dynexp = new DynamicExpansion();
    private ImageDrawer drawer = new ImageDrawer();
    private Invert invert = new Invert();
    private Open open = new Open();
    private UltimateErode ue = new UltimateErode();
    private UnionFindCcl ccl = new UnionFindCcl();
    private Monkey_Homography homography = new Monkey_Homography();
    private List<Monkey_InterestPoint> refpoints = new Vector<Monkey_InterestPoint>(13);
    private List<Monkey_InterestPoint> impts = new Vector<Monkey_InterestPoint>(13);
    private final ArrayFeatures AF = new ArrayFeatures();
    public Display display = null;

    public Monkey_Main(Display display) {
        this.display = display;
    }

    public void ComputeOnBoard(BufferedImage image, int nbCPU) {
        this.refpoints.add(new Monkey_InterestPoint(1, 1.8125, 5.75, 1.0));
        this.refpoints.add(new Monkey_InterestPoint(1, 22.0, 5.75, 1.0));
        this.refpoints.add(new Monkey_InterestPoint(1, 22.8125, 30.0, 1.0));
        this.refpoints.add(new Monkey_InterestPoint(1, 2.6875, 30.0, 1.0));
        for (Monkey_InterestPoint points : this.refpoints) {
            points.Normalize(24.0, 36.0);
        }
        this.display.Image(image, "Original", 1.0);
        BufferedImage imgray = ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (int)1);
        BufferedImage imcl = this.close.Filter(imgray, new StructuringElement(new Object[]{7, -1}), nbCPU);
        this.display.Image(imcl, "Closed", 1.0);
        BufferedImage imbin = this.binary.Filter(imcl, 200, nbCPU);
        this.display.Image(imbin, "Binary 1", 1.0);
        BufferedImage imdil = this.dilate.Filter(imbin, this.close.getStructuringElement(), nbCPU);
        this.display.Image(imdil, "Dilate", 1.0);
        BufferedImage iminv = this.invert.Filter(imdil, nbCPU);
        this.ccl.Label(iminv, 0, true);
        this.ccl.DeleteOnBorder(iminv, new int[0]);
        this.display.Image(iminv, "Border cleaned", 1.0);
        this.dilate.Filter(iminv, new StructuringElement(new Object[]{13, -1}), imdil, nbCPU);
        this.ccl.Label(imdil, 0, true);
        int max = this.AF.Maximum(this.ccl.Sizes(), 1, this.ccl.Sizes().length);
        this.ccl.DeleteSmallerThan(imdil, max);
        this.display.Image(imdil, "Dilated cleaned", 1.0);
        BufferedImage imero = this.erode.Filter(imdil, this.dilate.getStructuringElement(), nbCPU);
        this.display.Image(imero, "Eroded", 1.0);
        this.ue.Parameters(DistanceTools.CreateMontanariDistance(2, 7));
        BufferedImage imue = this.ue.Filter(imero, nbCPU);
        this.display.Image(imue, "Ultimate Opening", 1.0);
        this.ccl.Label(imue, 0, true);
        this.display.ArrayImage(this.ccl.Labels1D(), image.getWidth(), image.getHeight(), "Labels", 1.0);
        this.ccl.ComputeBoundingBoxes();
        int[] vx = this.ccl.minx();
        int[] vy = this.ccl.miny();
        this.impts.add(new Monkey_InterestPoint(1, vx[403], vy[403], 1.0));
        this.impts.add(new Monkey_InterestPoint(1, vx[476], vy[476], 1.0));
        this.impts.add(new Monkey_InterestPoint(1, vx[31], vy[31], 1.0));
        this.impts.add(new Monkey_InterestPoint(1, vx[1], vy[1], 1.0));
        for (Monkey_InterestPoint points : this.impts) {
            points.Normalize(24.0, 36.0);
        }
        if (this.impts.size() != this.refpoints.size()) {
            throw new Error("Souci: impts.size() != refpoints.size()");
        }
        HashMap<Monkey_InterestPoint, Monkey_InterestPoint> matchedPoints = new HashMap<Monkey_InterestPoint, Monkey_InterestPoint>(13);
        for (int i2 = 0; i2 < this.impts.size(); ++i2) {
            matchedPoints.put(this.refpoints.get(i2), this.impts.get(i2));
        }
        this.homography.Compute(matchedPoints);
        double[][] c1 = this.homography.corner1.getArray();
        double[][] c2 = this.homography.corner2.getArray();
        double[][] c3 = this.homography.corner3.getArray();
        double[][] c4 = this.homography.corner4.getArray();
        ImageDrawer.Line(image, (int)c1[0][0], (int)c1[1][0], (int)c2[0][0], (int)c2[1][0], 3, Colors.RED);
        ImageDrawer.Line(image, (int)c2[0][0], (int)c2[1][0], (int)c3[0][0], (int)c3[1][0], 3, Colors.RED);
        ImageDrawer.Line(image, (int)c3[0][0], (int)c3[1][0], (int)c4[0][0], (int)c4[1][0], 3, Colors.RED);
        ImageDrawer.Line(image, (int)c4[0][0], (int)c4[1][0], (int)c1[0][0], (int)c1[1][0], 3, Colors.RED);
        this.display.Image(image, "result", 1.0);
        System.out.println("Done.");
    }

    public void ComputeOnCage(BufferedImage image, int nbCPU) {
        double x = -12.0;
        this.refpoints.add(new Monkey_InterestPoint(1, 17.25 + x, 47.5, 1.0));
        this.refpoints.add(new Monkey_InterestPoint(1, 23.0 + x, 47.5, 1.0));
        this.refpoints.add(new Monkey_InterestPoint(1, 23.0 + x, 71.5, 1.0));
        this.refpoints.add(new Monkey_InterestPoint(1, 17.25 + x, 71.5, 1.0));
        for (Monkey_InterestPoint points : this.refpoints) {
            points.Normalize(30.0, 86.5);
        }
        this.impts.add(new Monkey_InterestPoint(1, 763.0, 377.0, 1.0));
        this.impts.add(new Monkey_InterestPoint(1, 840.0, 392.0, 1.0));
        this.impts.add(new Monkey_InterestPoint(1, 863.0, 257.0, 1.0));
        this.impts.add(new Monkey_InterestPoint(1, 781.0, 247.0, 1.0));
        for (Monkey_InterestPoint points : this.impts) {
            points.Normalize(1360.0, 1024.0);
            ImageDrawer.Cross(image, (int)points.x, (int)points.y, 5, 1, Colors.GREEN);
        }
        HashMap<Monkey_InterestPoint, Monkey_InterestPoint> matchedPoints = new HashMap<Monkey_InterestPoint, Monkey_InterestPoint>(13);
        for (int i2 = 0; i2 < this.impts.size(); ++i2) {
            matchedPoints.put(this.refpoints.get(i2), this.impts.get(i2));
        }
        this.homography.Compute(matchedPoints);
        int order = 1;
        double[][] c1 = this.homography.corner1.getArray();
        double[][] c2 = this.homography.corner2.getArray();
        double[][] c3 = this.homography.corner3.getArray();
        double[][] c4 = this.homography.corner4.getArray();
        ImageDrawer.Line(image, (int)c1[0][0], (int)c1[1][0], (int)c2[0][0], (int)c2[1][0], order, Colors.RED);
        ImageDrawer.Line(image, (int)c2[0][0], (int)c2[1][0], (int)c3[0][0], (int)c3[1][0], order, Colors.RED);
        ImageDrawer.Line(image, (int)c3[0][0], (int)c3[1][0], (int)c4[0][0], (int)c4[1][0], order, Colors.RED);
        ImageDrawer.Line(image, (int)c4[0][0], (int)c4[1][0], (int)c1[0][0], (int)c1[1][0], order, Colors.RED);
        this.display.Image(image, "result", 1.0);
        System.out.println("Done.");
    }
}

