/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.monkeys.homography;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;
import java.util.Locale;
import java.util.Scanner;

public class Monkey_InterestPoint {
    int coucou;
    public double x;
    public double y;
    public double xnorm;
    public double ynorm;
    public double strength;
    public double[] descriptor = null;
    public int number;

    public Monkey_InterestPoint(Scanner in) {
        this.Read(in);
    }

    public Monkey_InterestPoint(int size, float x, float y, float strength, float trace, float scale, int number) {
        this.x = x;
        this.y = y;
        this.strength = strength;
        this.number = number;
    }

    public Monkey_InterestPoint(int size, double x, double y, double strength) {
        this.descriptor = new double[size];
        this.x = x;
        this.y = y;
        this.strength = strength;
    }

    public void Normalize(double width, double height) {
        this.xnorm = 2.0 * this.x / width - 1.0;
        this.ynorm = 2.0 * this.y / height - 1.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1013);
        Formatter f = new Formatter(sb, Locale.US);
        f.format("%12f %12f %12f ", this.x, this.y, this.strength);
        int descSize = this.descriptor == null ? 0 : this.descriptor.length;
        f.format("%12d ", descSize);
        if (descSize > 0) {
            for (int i2 = 0; i2 < descSize; ++i2) {
                f.format("%12f ", this.descriptor[i2]);
            }
            f.format("\n", new Object[0]);
        }
        return f.toString();
    }

    public void Write(DataOutputStream out) throws UnsupportedEncodingException, IOException {
        out.write((this.x + "\t" + this.y + "\t" + this.strength + "\n").getBytes("ASCII"));
        out.write((this.descriptor.length + "\t").getBytes("ASCII"));
        for (int i2 = 0; i2 < this.descriptor.length; ++i2) {
            out.write((this.descriptor[i2] + "\t").getBytes("ASCII"));
        }
        out.write("\n".getBytes("ASCII"));
    }

    public void Read(Scanner in) {
        this.x = Float.valueOf(in.next()).floatValue();
        this.y = Float.valueOf(in.next()).floatValue();
        this.strength = Float.valueOf(in.next()).floatValue();
        int size = in.nextInt();
        this.descriptor = new double[size];
        for (int i2 = 0; i2 < size; ++i2) {
            this.descriptor[i2] = Float.valueOf(in.next()).floatValue();
        }
    }
}

