/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.monkeys.homography;

import java.util.Map;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import softwares.ohsu.monkeys.homography.Monkey_InterestPoint;
import tracking.texturetracker.tt_matrix.TT_Matrix;

public class Monkey_Homography {
    private TT_Matrix Q = new TT_Matrix(3, 3);
    private TT_Matrix P = new TT_Matrix(3, 3);
    private TT_Matrix Q4 = new TT_Matrix(3, 1);
    private TT_Matrix P4 = new TT_Matrix(3, 1);
    private TT_Matrix V = new TT_Matrix(3, 1);
    private TT_Matrix R = new TT_Matrix(3, 1);
    private TT_Matrix W = new TT_Matrix(3, 3);
    private TT_Matrix tmp1_3x3_T = new TT_Matrix(3, 3);
    private TT_Matrix tmp2_3x3_T = new TT_Matrix(3, 3);
    public TT_Matrix corner1;
    public TT_Matrix corner2;
    public TT_Matrix corner3;
    public TT_Matrix corner4;
    private TT_Matrix p = new TT_Matrix(3, 1);
    public int nbHomography = 0;
    public TT_Matrix T = new TT_Matrix(3, 3);
    public Point[] object = new Point3DF[4];
    public Point[] movie = new Point3DF[4];

    public void Compute(Map<Monkey_InterestPoint, Monkey_InterestPoint> matchedPoints) {
        if (matchedPoints.size() < 4) {
            return;
        }
        ++this.nbHomography;
        int nb = 0;
        for (Map.Entry<Monkey_InterestPoint, Monkey_InterestPoint> pair : matchedPoints.entrySet()) {
            this.object[nb] = new Point3DF(pair.getKey().xnorm, pair.getKey().ynorm, 1.0);
            this.movie[nb] = new Point3DF(pair.getValue().x, pair.getValue().y, 1.0);
            if (++nb != 4) continue;
            break;
        }
        if (!this.CollineationMatrix(this.object, this.movie, this.T)) {
            --this.nbHomography;
            return;
        }
        this.p.set(0, 0, -1.0);
        this.p.set(1, 0, 1.0);
        this.p.set(2, 0, 1.0);
        this.corner1 = this.T.times(this.p);
        this.p.set(0, 0, 1.0);
        this.p.set(1, 0, 1.0);
        this.corner2 = this.T.times(this.p);
        this.p.set(0, 0, 1.0);
        this.p.set(1, 0, -1.0);
        this.corner3 = this.T.times(this.p);
        this.p.set(0, 0, -1.0);
        this.p.set(1, 0, -1.0);
        this.corner4 = this.T.times(this.p);
        this.corner1.set(0, 0, this.corner1.get(0, 0) / this.corner1.get(2, 0));
        this.corner1.set(1, 0, this.corner1.get(1, 0) / this.corner1.get(2, 0));
        this.corner2.set(0, 0, this.corner2.get(0, 0) / this.corner2.get(2, 0));
        this.corner2.set(1, 0, this.corner2.get(1, 0) / this.corner2.get(2, 0));
        this.corner3.set(0, 0, this.corner3.get(0, 0) / this.corner3.get(2, 0));
        this.corner3.set(1, 0, this.corner3.get(1, 0) / this.corner3.get(2, 0));
        this.corner4.set(0, 0, this.corner4.get(0, 0) / this.corner4.get(2, 0));
        this.corner4.set(1, 0, this.corner4.get(1, 0) / this.corner4.get(2, 0));
    }

    private boolean CollineationMatrix(Point[] object, Point[] movie, TT_Matrix T) {
        try {
            TT_Matrix tmp1_3x3 = null;
            TT_Matrix tmp2_3x3 = null;
            for (int i2 = 0; i2 < 3; ++i2) {
                this.Q.set(i2, 0, object[i2].getX());
                this.Q.set(i2, 1, object[i2].getY());
                this.Q.set(i2, 2, object[i2].getZ());
                this.P.set(i2, 0, movie[i2].getX());
                this.P.set(i2, 1, movie[i2].getY());
                this.P.set(i2, 2, movie[i2].getZ());
            }
            this.Q4.set(0, 0, object[3].getX());
            this.Q4.set(1, 0, object[3].getY());
            this.Q4.set(2, 0, object[3].getZ());
            this.P4.set(0, 0, movie[3].getX());
            this.P4.set(1, 0, movie[3].getY());
            this.P4.set(2, 0, movie[3].getZ());
            tmp1_3x3 = this.P.inverse();
            tmp2_3x3 = this.Q.inverse();
            this.Transpose(tmp1_3x3, this.tmp1_3x3_T);
            this.Transpose(tmp2_3x3, this.tmp2_3x3_T);
            this.Multiply(this.tmp1_3x3_T, this.P4, this.V);
            this.Multiply(this.tmp2_3x3_T, this.Q4, this.R);
            this.Identity(this.W);
            double tmp = this.R.get(2, 0) / this.V.get(2, 0);
            this.W.set(0, 0, this.V.get(0, 0) / this.R.get(0, 0) * tmp);
            this.W.set(1, 1, this.V.get(1, 0) / this.R.get(1, 0) * tmp);
            this.Multiply(tmp2_3x3, this.W, tmp1_3x3);
            this.Multiply(tmp1_3x3, this.P, tmp2_3x3);
            this.Transpose(tmp2_3x3, T);
        }
        catch (Exception E) {
            System.out.println(E.getMessage());
            return false;
        }
        return true;
    }

    public void computeNormalisedCoordinates(Monkey_InterestPoint img, double width, double height) {
        img.xnorm = 2.0 * img.x / width - 1.0;
        img.ynorm = 2.0 * img.y / height - 1.0;
    }

    private void Multiply(TT_Matrix m1, TT_Matrix m2, TT_Matrix result) {
        for (int i2 = 0; i2 < result.getRowDimension(); ++i2) {
            for (int j = 0; j < result.getColumnDimension(); ++j) {
                double res = 0.0;
                for (int k = 0; k < m1.getColumnDimension(); ++k) {
                    res += m1.get(i2, k) * m2.get(k, j);
                }
                result.set(i2, j, res);
            }
        }
    }

    private void Identity(TT_Matrix m) {
        for (int i2 = 0; i2 < m.getRowDimension(); ++i2) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                m.set(i2, j, i2 == j ? 1.0 : 0.0);
            }
        }
    }

    private void Transpose(TT_Matrix m, TT_Matrix res) {
        for (int i2 = 0; i2 < m.getRowDimension(); ++i2) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                res.set(i2, j, m.get(j, i2));
            }
        }
    }
}

