/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.monkeys;

import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import utils.LogFile;

public class ResamplingImages {
    public void Resampling(String inputpath, int modulo, String outputpath, int format, String previousextension) {
        int length = previousextension.length();
        String extension = ImageIO.TypeToExtension(format);
        File input = new File(inputpath);
        if (!input.isDirectory()) {
            throw new IllegalArgumentException("The input path is not pointed on a folder.");
        }
        File output = new File(outputpath);
        if (!output.exists()) {
            output.mkdirs();
        }
        if (!output.isDirectory()) {
            throw new IllegalArgumentException("The output path is not pointed on a folder.");
        }
        LogFile log = new LogFile();
        try {
            log.StartNewLog(this, "./");
        }
        catch (FileNotFoundException e1) {
            System.err.println("Unable to start the log file.");
            e1.printStackTrace();
            System.exit(0);
        }
        System.out.println("Copying and resampling images from \"" + input.getAbsolutePath() + "\" into \"" + outputpath + "\".");
        File[] images = input.listFiles();
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (i2 % modulo != 0) continue;
            try {
                String name = images[i2].getName();
                BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                ImageIO.Write(image, output + "/" + name.substring(0, name.length() - length) + "." + extension, format);
                continue;
            }
            catch (Exception e) {
                try {
                    log.addNewException(e, new String[0]);
                }
                catch (Exception e1) {
                    System.err.println("Unable to write in the log file.");
                    e1.printStackTrace();
                    System.exit(0);
                }
                continue;
            }
            catch (Error e) {
                try {
                    log.addNewError(e, new String[0]);
                    continue;
                }
                catch (Exception e1) {
                    System.err.println("Unable to write in the log file.");
                    e1.printStackTrace();
                    System.exit(0);
                }
            }
        }
        try {
            log.Stop();
            System.out.flush();
            System.err.flush();
            System.err.println(log.Resume().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

