/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.monkeys;

import characterization.textures.detectors.points.Canny;
import characterization.textures.detectors.points.corners.FAST;
import characterization.textures.lbp.LocalBinaryPattern;
import displays.Display;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageResampler;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import morphee.StructuringElement;
import morphee.filters.ASFilterCloseOpen;
import morphee.filters.ASFilterOpenClose;
import processing.filters.Median;

public class MonkeyDetection {
    private String path = "/Users/FiReTiTi/Post Doc/Monkeys/";
    public boolean work = true;
    public String start = "blabla";
    public String end = "blabla";
    public Display display = null;
    private ASFilterCloseOpen asfco = new ASFilterCloseOpen();
    private ASFilterOpenClose asfoc = new ASFilterOpenClose();
    private LocalBinaryPattern lbp = new LocalBinaryPattern();
    private Median median = new Median();
    private FAST fast = new FAST();
    private Canny canny = null;
    private ConnectedComponentLabeling ccl = new UnionFindCcl();

    public void TrainingASF(int camera, StructuringElement se, int nbCPU) {
        File[] images = new File(this.path + "/Training/Camera" + camera + "/").listFiles();
        BufferedImage imoc = null;
        BufferedImage imco = null;
        BufferedImage imgray = null;
        BufferedImage immaxoc = null;
        BufferedImage immaxco = null;
        BufferedImage imminco = null;
        BufferedImage imminoc = null;
        BufferedImage image = null;
        this.asfco.Parameters(se);
        this.asfoc.Parameters(se);
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".tif")) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && imgray == null) {
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imco = ImageNew.Same((BufferedImage)imgray);
                imoc = ImageNew.Same((BufferedImage)imgray);
                imminco = ImageNew.Same((BufferedImage)imgray);
                imminoc = ImageNew.Same((BufferedImage)imgray);
                immaxco = ImageNew.Same((BufferedImage)imgray);
                immaxoc = ImageNew.Same((BufferedImage)imgray);
                ImageOperations.Fill((BufferedImage)imminco, (int)255);
                ImageOperations.Fill((BufferedImage)immaxco, (int)0);
                ImageOperations.Fill((BufferedImage)imminoc, (int)255);
                ImageOperations.Fill((BufferedImage)immaxoc, (int)0);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.asfco.Filter(imgray, imco, nbCPU);
            ImageComparator.Compare((BufferedImage)imco, (String)"<", (BufferedImage)imminco, (BufferedImage)imco, (BufferedImage)imminco, (BufferedImage)imminco);
            ImageComparator.Compare((BufferedImage)imco, (String)">", (BufferedImage)immaxco, (BufferedImage)imco, (BufferedImage)immaxco, (BufferedImage)immaxco);
            this.asfoc.Filter(imgray, imoc, nbCPU);
            ImageComparator.Compare((BufferedImage)imoc, (String)"<", (BufferedImage)imminoc, (BufferedImage)imoc, (BufferedImage)imminoc, (BufferedImage)imminoc);
            ImageComparator.Compare((BufferedImage)imoc, (String)">", (BufferedImage)immaxoc, (BufferedImage)imoc, (BufferedImage)immaxoc, (BufferedImage)immaxoc);
        }
        try {
            ImageIO.Write(imminco, this.path + "/Training/Camera" + camera + "/ASF/ImASFcoMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
            ImageIO.Write(immaxco, this.path + "/Training/Camera" + camera + "/ASF/ImASFcoMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
            ImageIO.Write(ImageArithmetic.Subtract(immaxco, imminco), this.path + "/Training/Camera" + camera + "/ASF/ImASFcoDiff" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
            ImageIO.Write(imminoc, this.path + "/Training/Camera" + camera + "/ASF/ImASFocMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
            ImageIO.Write(immaxoc, this.path + "/Training/Camera" + camera + "/ASF/ImASFocMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
            ImageIO.Write(ImageArithmetic.Subtract(immaxoc, imminoc), this.path + "/Training/Camera" + camera + "/ASF/ImASFocDiff" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void DetectionASF(int camera, StructuringElement se, int nbCPU) {
        File[] images = new File(this.path + "/Test/Camera" + camera + "/").listFiles();
        BufferedImage imdifoc = null;
        BufferedImage imdifco = null;
        BufferedImage immaxoc = null;
        BufferedImage imminoc = null;
        BufferedImage immaxco = null;
        BufferedImage imminco = null;
        BufferedImage imoc = null;
        BufferedImage imco = null;
        BufferedImage imgray = null;
        BufferedImage imdetoc = null;
        BufferedImage imdetco = null;
        BufferedImage image = null;
        try {
            imminco = ImageIO.Read(this.path + "/Training/Camera" + camera + "/ASF/ImASFcoMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png");
            immaxco = ImageIO.Read(this.path + "/Training/Camera" + camera + "/ASF/ImASFcoMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png");
            imminoc = ImageIO.Read(this.path + "/Training/Camera" + camera + "/ASF/ImASFocMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png");
            immaxoc = ImageIO.Read(this.path + "/Training/Camera" + camera + "/ASF/ImASFocMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.asfco.Parameters(se);
        this.asfoc.Parameters(se);
        for (int i2 = 0; i2 < images.length; ++i2) {
            int x;
            int y;
            if (!images[i2].getName().contains(".png")) continue;
            if (!this.work && images[i2].getName().contains(this.start)) {
                this.work = true;
            }
            if (this.work && images[i2].getName().contains(this.end)) {
                this.work = false;
            }
            if (!this.work) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && imgray == null) {
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imdetco = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                imdetoc = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                imco = ImageNew.Same((BufferedImage)imgray);
                imoc = ImageNew.Same((BufferedImage)imgray);
                imdifco = ImageNew.Same((BufferedImage)imgray);
                imdifoc = ImageNew.Same((BufferedImage)imgray);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.asfco.Filter(imgray, imco, nbCPU);
            ImageOperations.Fill((BufferedImage)imdetco, (int)0);
            ImageComparator.Compare((BufferedImage)imco, (String)">=", (BufferedImage)imminco, (BufferedImage)imdetco, (int)1, (BufferedImage)imdetco);
            ImageComparator.Compare((BufferedImage)imco, (String)"<=", (BufferedImage)immaxco, (BufferedImage)imdetco, (int)1, (BufferedImage)imdetco);
            ImageOperations.Fill((BufferedImage)imdifco, (int)0);
            for (y = 0; y < image.getHeight(); ++y) {
                for (x = 0; x < image.getWidth(); ++x) {
                    if (imdetco.getRaster().getSample(x, y, 0) == 0) continue;
                    int min = Math.min(Math.abs(imco.getRaster().getSample(x, y, 0) - imminco.getRaster().getSample(x, y, 0)), Math.abs(imco.getRaster().getSample(x, y, 0) - immaxco.getRaster().getSample(x, y, 0)));
                    imdifco.getRaster().setSample(x, y, 0, min);
                }
            }
            this.asfoc.Filter(imgray, imoc, nbCPU);
            ImageOperations.Fill((BufferedImage)imdetoc, (int)0);
            ImageComparator.Compare((BufferedImage)imoc, (String)">=", (BufferedImage)imminoc, (BufferedImage)imdetoc, (int)1, (BufferedImage)imdetoc);
            ImageComparator.Compare((BufferedImage)imoc, (String)"<=", (BufferedImage)immaxoc, (BufferedImage)imdetoc, (int)1, (BufferedImage)imdetoc);
            ImageOperations.Fill((BufferedImage)imdifoc, (int)0);
            for (y = 0; y < image.getHeight(); ++y) {
                for (x = 0; x < image.getWidth(); ++x) {
                    if (imdetoc.getRaster().getSample(x, y, 0) == 0) continue;
                    int min = Math.min(Math.abs(imoc.getRaster().getSample(x, y, 0) - imminoc.getRaster().getSample(x, y, 0)), Math.abs(imoc.getRaster().getSample(x, y, 0) - immaxoc.getRaster().getSample(x, y, 0)));
                    imdifoc.getRaster().setSample(x, y, 0, min);
                }
            }
            try {
                ImageIO.Write(imdifco, this.path + "/Test/Camera" + camera + "/ASF/ImASFcoDetectionDiffR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + "_" + images[i2].getName(), 6);
                ImageIO.Write(imdifoc, this.path + "/Test/Camera" + camera + "/ASF/ImASFocDetectionDiffR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + "_" + images[i2].getName(), 6);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void TrainingLBP(int camera, StructuringElement se, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Training/").listFiles();
        BufferedImage imlbp = null;
        BufferedImage imgray = null;
        BufferedImage immax = null;
        BufferedImage immin = null;
        BufferedImage image = null;
        this.lbp.Parameters(se, 0);
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && immin == null) {
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imlbp = ImageNew.Integer((int)image.getWidth(), (int)image.getHeight(), (int)1);
                immin = ImageNew.Same((BufferedImage)imlbp);
                immax = ImageNew.Same((BufferedImage)imlbp);
                ImageOperations.Fill((BufferedImage)immin, (int)Integer.MAX_VALUE);
                ImageOperations.Fill((BufferedImage)immax, (int)Integer.MIN_VALUE);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.lbp.Filter(imgray, imlbp, nbCPU);
            ImageComparator.Compare((BufferedImage)imlbp, (String)"<", (BufferedImage)immin, (BufferedImage)imlbp, (BufferedImage)immin, (BufferedImage)immin);
            ImageComparator.Compare((BufferedImage)imlbp, (String)">", (BufferedImage)immax, (BufferedImage)imlbp, (BufferedImage)immax, (BufferedImage)immax);
        }
        try {
            ImageIO.Write(immin, this.path + "/Camera" + camera + "/LBP/ImLBPMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".tif", 8);
            ImageIO.Write(immax, this.path + "/Camera" + camera + "/LBP/ImLBPMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".tif", 8);
            ImageIO.Write(ImageArithmetic.Subtract(immax, immin), this.path + "/Camera" + camera + "/LBP/ImLBPDiff" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".tif", 8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void DetectionLBP(int camera, StructuringElement se, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Test/").listFiles();
        BufferedImage immax = null;
        BufferedImage immin = null;
        BufferedImage imdif = null;
        BufferedImage imlbp = null;
        BufferedImage imgray = null;
        BufferedImage imdet = null;
        BufferedImage image = null;
        try {
            immin = ImageIO.Read(this.path + "/Camera" + camera + "/LBP/ImLBPMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".tif");
            immax = ImageIO.Read(this.path + "/Camera" + camera + "/LBP/ImLBPMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".tif");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lbp.Parameters(se, 0);
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            if (!this.work && images[i2].getName().contains(this.start)) {
                this.work = true;
            }
            if (this.work && images[i2].getName().contains(this.end)) {
                this.work = false;
            }
            if (!this.work) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && imdet == null) {
                imdet = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imlbp = ImageNew.Integer((int)image.getWidth(), (int)image.getHeight(), (int)1);
                imdif = new BufferedImage(image.getWidth(), image.getHeight(), 10);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.lbp.Filter(imgray, imlbp, nbCPU);
            ImageOperations.Fill((BufferedImage)imdet, (int)0);
            ImageComparator.Compare((BufferedImage)imlbp, (String)">=", (BufferedImage)immin, (BufferedImage)imdet, (int)1, (BufferedImage)imdet);
            ImageComparator.Compare((BufferedImage)imlbp, (String)"<=", (BufferedImage)immax, (BufferedImage)imdet, (int)1, (BufferedImage)imdet);
            ImageOperations.Fill((BufferedImage)imdif, (int)0);
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    if (imdet.getRaster().getSample(x, y, 0) == 0) continue;
                    int min = Math.min(Math.abs(imlbp.getRaster().getSample(x, y, 0) - immin.getRaster().getSample(x, y, 0)), Math.abs(imlbp.getRaster().getSample(x, y, 0) - immax.getRaster().getSample(x, y, 0)));
                    imdif.getRaster().setSample(x, y, 0, min);
                }
            }
            try {
                ImageIO.Write(imdif, this.path + "/Camera" + camera + "/LBP/ImLBPDetectionDiffR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + "_" + images[i2].getName(), 6);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void TrainingMedian(int camera, StructuringElement se, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Training/").listFiles();
        BufferedImage immed = null;
        BufferedImage imgray = null;
        BufferedImage immax = null;
        BufferedImage immin = null;
        BufferedImage image = null;
        this.median.Parameters(se);
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && immin == null) {
                immin = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                immax = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                immed = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                ImageOperations.Fill((BufferedImage)immin, (int)255);
                ImageOperations.Fill((BufferedImage)immax, (int)0);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.median.Filter(imgray, immed, nbCPU);
            ImageComparator.Compare((BufferedImage)immed, (String)"<", (BufferedImage)immin, (BufferedImage)immed, (BufferedImage)immin, (BufferedImage)immin);
            ImageComparator.Compare((BufferedImage)immed, (String)">", (BufferedImage)immax, (BufferedImage)immed, (BufferedImage)immax, (BufferedImage)immax);
        }
        try {
            ImageIO.Write(immin, this.path + "/Camera" + camera + "/Median/ImMedianMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
            ImageIO.Write(immax, this.path + "/Camera" + camera + "/Median/ImMedianMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void DetectionMedian(int camera, StructuringElement se, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Test/").listFiles();
        BufferedImage immax = null;
        BufferedImage immin = null;
        BufferedImage imdif = null;
        BufferedImage immed = null;
        BufferedImage imgray = null;
        BufferedImage imdet = null;
        BufferedImage image = null;
        try {
            immin = ImageIO.Read(this.path + "/Camera" + camera + "/Median/ImMedianMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png");
            immax = ImageIO.Read(this.path + "/Camera" + camera + "/Median/ImMedianMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.median.Parameters(se);
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            if (!this.work && images[i2].getName().contains(this.start)) {
                this.work = true;
            }
            if (this.work && images[i2].getName().contains(this.end)) {
                this.work = false;
            }
            if (!this.work) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && imdet == null) {
                imdet = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                immed = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imdif = new BufferedImage(image.getWidth(), image.getHeight(), 10);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.median.Filter(imgray, immed, nbCPU);
            ImageOperations.Fill((BufferedImage)imdet, (int)0);
            ImageComparator.Compare((BufferedImage)immed, (String)">=", (BufferedImage)immin, (BufferedImage)imdet, (int)1, (BufferedImage)imdet);
            ImageComparator.Compare((BufferedImage)immed, (String)"<=", (BufferedImage)immax, (BufferedImage)imdet, (int)1, (BufferedImage)imdet);
            ImageOperations.Fill((BufferedImage)imdif, (int)0);
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    if (imdet.getRaster().getSample(x, y, 0) == 0) continue;
                    int min = Math.min(Math.abs(immed.getRaster().getSample(x, y, 0) - immin.getRaster().getSample(x, y, 0)), Math.abs(immed.getRaster().getSample(x, y, 0) - immax.getRaster().getSample(x, y, 0)));
                    imdif.getRaster().setSample(x, y, 0, min);
                }
            }
            try {
                ImageIO.Write(imdif, this.path + "/Camera" + camera + "/Median/ImMedianDetectionDiffR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + "_" + images[i2].getName(), 6);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void TrainingMedianWithResampling(int camera, StructuringElement se, int resamplingfactor, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Training/").listFiles();
        BufferedImage immed = null;
        BufferedImage imresamp = null;
        BufferedImage imgray = null;
        BufferedImage immax = null;
        BufferedImage immin = null;
        BufferedImage image = null;
        this.median.Parameters(se);
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && immin == null) {
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            if (imresamp == null) {
                imresamp = ImageResampler.SubSampling(imgray, resamplingfactor, -4);
                immed = ImageNew.Same((BufferedImage)imresamp);
                immin = ImageNew.Same((BufferedImage)imresamp);
                immax = ImageNew.Same((BufferedImage)imresamp);
                ImageOperations.Fill((BufferedImage)immin, (int)255);
                ImageOperations.Fill((BufferedImage)immax, (int)0);
            } else {
                ImageResampler.SubSampling(imgray, resamplingfactor, -4, imresamp);
            }
            this.median.Filter(imresamp, immed, nbCPU);
            ImageComparator.Compare((BufferedImage)immed, (String)"<", (BufferedImage)immin, (BufferedImage)immed, (BufferedImage)immin, (BufferedImage)immin);
            ImageComparator.Compare((BufferedImage)immed, (String)">", (BufferedImage)immax, (BufferedImage)immed, (BufferedImage)immax, (BufferedImage)immax);
        }
        try {
            ImageIO.Write(immin, this.path + "/Camera" + camera + "/MedianResamp/ImMedianResMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
            ImageIO.Write(immax, this.path + "/Camera" + camera + "/MedianResamp/ImMedianResMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png", 6);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void DetectionMedianWithResampling(int camera, StructuringElement se, int resamplingfactor, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Test/").listFiles();
        BufferedImage imresamp = null;
        BufferedImage immax = null;
        BufferedImage immin = null;
        BufferedImage imdif = null;
        BufferedImage immed = null;
        BufferedImage imgray = null;
        BufferedImage imdet = null;
        BufferedImage image = null;
        try {
            immin = ImageIO.Read(this.path + "/Camera" + camera + "/MedianResamp/ImMedianResMinR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png");
            immax = ImageIO.Read(this.path + "/Camera" + camera + "/MedianResamp/ImMedianResMaxR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + ".png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.median.Parameters(se);
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            if (!this.work && images[i2].getName().contains(this.start)) {
                this.work = true;
            }
            if (this.work && images[i2].getName().contains(this.end)) {
                this.work = false;
            }
            if (!this.work) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && imdet == null) {
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            if (imresamp == null) {
                imresamp = ImageResampler.SubSampling(imgray, resamplingfactor, -4);
                immed = ImageNew.Same((BufferedImage)imresamp);
                imdet = ImageNew.Same((BufferedImage)imresamp);
                imdif = ImageNew.Same((BufferedImage)imresamp);
            } else {
                ImageResampler.SubSampling(imgray, resamplingfactor, -4, imresamp);
            }
            this.median.Filter(imresamp, immed, nbCPU);
            ImageOperations.Fill((BufferedImage)imdet, (int)0);
            ImageComparator.Compare((BufferedImage)immed, (String)">=", (BufferedImage)immin, (BufferedImage)imdet, (int)1, (BufferedImage)imdet);
            ImageComparator.Compare((BufferedImage)immed, (String)"<=", (BufferedImage)immax, (BufferedImage)imdet, (int)1, (BufferedImage)imdet);
            ImageOperations.Fill((BufferedImage)imdif, (int)0);
            for (int y = 0; y < imdet.getHeight(); ++y) {
                for (int x = 0; x < imdet.getWidth(); ++x) {
                    if (imdet.getRaster().getSample(x, y, 0) == 0) continue;
                    int min = Math.min(Math.abs(immed.getRaster().getSample(x, y, 0) - immin.getRaster().getSample(x, y, 0)), Math.abs(immed.getRaster().getSample(x, y, 0) - immax.getRaster().getSample(x, y, 0)));
                    imdif.getRaster().setSample(x, y, 0, min);
                }
            }
            try {
                ImageIO.Write(imdif, this.path + "/Camera" + camera + "/MedianResamp/ImMedianDetectionDiffR" + (se.getOrder() < 10 ? "0" : "") + se.getOrder() + "_" + images[i2].getName(), 6);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void TrainingFAST(int camera, double sensibility, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Training/").listFiles();
        BufferedImage immax = null;
        BufferedImage imdet = null;
        BufferedImage immed = null;
        BufferedImage imgray = null;
        BufferedImage image = null;
        this.median.Parameters(new StructuringElement(new Object[]{1, -1}));
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && imdet == null) {
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                immed = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imdet = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                immax = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                ImageOperations.Fill((BufferedImage)immax, (int)0);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.median.Filter(imgray, immed, nbCPU);
            this.fast.Filter(immed, sensibility, imdet, nbCPU);
            ImageComparator.Compare((BufferedImage)imdet, (String)">", (BufferedImage)immax, (BufferedImage)imdet, (BufferedImage)immax, (BufferedImage)immax);
        }
        try {
            ImageIO.Write(immax, this.path + "/Camera" + camera + "/FAST/ImFastMaxS" + Double.toString(sensibility).substring(0, 4) + ".png", 6);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void DetectionFAST(int camera, double sensibility, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Test/").listFiles();
        byte[] diff = null;
        byte[] max = null;
        BufferedImage immax = null;
        BufferedImage imdif = null;
        BufferedImage immed = null;
        BufferedImage imgray = null;
        BufferedImage imdet = null;
        BufferedImage image = null;
        try {
            immax = ImageIO.Read(this.path + "/Camera" + camera + "/FAST/ImFastMaxS" + Double.toString(sensibility).substring(0, 4) + ".png");
            max = ((DataBufferByte)immax.getRaster().getDataBuffer()).getData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.median.Parameters(new StructuringElement(new Object[]{1, -1}));
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            if (!this.work && images[i2].getName().contains(this.start)) {
                this.work = true;
            }
            if (this.work && images[i2].getName().contains(this.end)) {
                this.work = false;
            }
            if (!this.work) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && imdet == null) {
                imdet = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                immed = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imdif = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                diff = ((DataBufferByte)imdif.getRaster().getDataBuffer()).getData();
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.median.Filter(imgray, immed, nbCPU);
            ImageOperations.Fill((BufferedImage)imdet, (int)0);
            this.fast.Filter(immed, sensibility, imdet, nbCPU);
            byte[] det = ((DataBufferByte)imdet.getRaster().getDataBuffer()).getData();
            ImageOperations.Fill((BufferedImage)imdif, (int)0);
            for (int x = 0; x < det.length; ++x) {
                int m = max[x] & 0xFF;
                int d = det[x] & 0xFF;
                if (m >= d) continue;
                diff[x] = (byte)(d - m);
            }
            try {
                ImageIO.Write(imdif, this.path + "/Camera" + camera + "/FAST/ImFastDetectionS" + Double.toString(sensibility).substring(0, 4) + "_" + images[i2].getName(), 6);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void TrainingCanny(int camera, int thresinf, int thressup, int gauss, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Training/").listFiles();
        BufferedImage immax = null;
        BufferedImage imdet = null;
        BufferedImage immed = null;
        BufferedImage imgray = null;
        BufferedImage image = null;
        this.median.Parameters(new StructuringElement(new Object[]{3, -1}));
        this.canny = new Canny(thresinf, thressup, gauss);
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && imdet == null) {
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                immed = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imdet = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                immax = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                ImageOperations.Fill((BufferedImage)immax, (int)0);
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.median.Filter(imgray, immed, nbCPU);
            this.canny.Filter(immed, imdet, nbCPU);
            ImageComparator.Compare((BufferedImage)imdet, (String)">", (BufferedImage)immax, (BufferedImage)imdet, (BufferedImage)immax, (BufferedImage)immax);
        }
        try {
            ImageIO.Write(immax, this.path + "/Camera" + camera + "/Canny/ImCannyMax_" + thresinf + "_" + thressup + "_" + gauss + ".png", 6);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void DetectionCanny(int camera, int thresinf, int thressup, int gauss, int nbCPU) {
        File[] images = new File(this.path + "/Camera" + camera + "/Test/").listFiles();
        byte[] diff = null;
        byte[] max = null;
        BufferedImage immax = null;
        BufferedImage imdif = null;
        BufferedImage immed = null;
        BufferedImage imgray = null;
        BufferedImage imcopy = null;
        BufferedImage imdet = null;
        BufferedImage image = null;
        try {
            immax = ImageIO.Read(this.path + "/Camera" + camera + "/Canny/ImCannyMax_" + thresinf + "_" + thressup + "_" + gauss + ".png");
            max = ((DataBufferByte)immax.getRaster().getDataBuffer()).getData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.median.Parameters(new StructuringElement(new Object[]{3, -1}));
        this.canny = new Canny(thresinf, thressup, gauss);
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            if (!this.work && images[i2].getName().contains(this.start)) {
                this.work = true;
            }
            if (this.work && images[i2].getName().contains(this.end)) {
                this.work = false;
            }
            if (!this.work) continue;
            try {
                image = ImageIO.Read(images[i2].getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null && imdet == null) {
                imdet = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imcopy = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imgray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                immed = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                imdif = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                diff = ((DataBufferByte)imdif.getRaster().getDataBuffer()).getData();
            }
            ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
            this.median.Filter(imgray, immed, nbCPU);
            ImageOperations.Fill((BufferedImage)imdet, (int)0);
            this.canny.Filter(immed, imdet, nbCPU);
            byte[] det = ((DataBufferByte)imdet.getRaster().getDataBuffer()).getData();
            ImageOperations.Fill((BufferedImage)imdif, (int)0);
            for (int x = 0; x < det.length; ++x) {
                int m = max[x] & 0xFF;
                int d = det[x] & 0xFF;
                if (m >= d) continue;
                diff[x] = (byte)(d - m);
            }
            ImageNew.Copy((BufferedImage)imdif, (BufferedImage)imcopy);
            ImageComparator.Compare((BufferedImage)imdif, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)imdif);
            this.ccl.Label(imdif, 0, true);
            this.ccl.DeleteSmallerThan(imdif, 53);
            ImageComparator.Compare((BufferedImage)imdif, (String)"==", (int)255, (BufferedImage)imcopy, (int)0, (BufferedImage)imdif);
            try {
                ImageIO.Write(imdif, this.path + "/Camera" + camera + "/Canny/ImCannyDetection_" + thresinf + "_" + thressup + "_" + gauss + "_" + images[i2].getName(), 6);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

