/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.monkeys;

import arrayTiTi.ArrayFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.colorSpace.HLS;
import imageTiTi.colorSpace.HSV;
import imageTiTi.colorSpace.Lab;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class MonkeyColors {
    private final HLS hls = new HLS();
    private final HSV hsv = new HSV();
    private final Lab lab = new Lab();
    private final ArrayFeatures AF = new ArrayFeatures();

    public FichierTabule AnalyzeGroundTruth(String originalpath, String groundtruthpath) {
        File[] images = new File(groundtruthpath).listFiles();
        FichierTabule result = null;
        int[] types = new int[14];
        Arrays.fill(types, 1);
        types[types.length - 3] = 0;
        types[types.length - 2] = 0;
        types[types.length - 1] = 2;
        String[] names = new String[]{"Blue", "Green", "Red", "hls_H", "hls_L", "hls_S", "hsv_S", "hsv_V", "lab_L", "lab_a", "lab_b", "X", "Y", "Image"};
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].getName().contains(".png")) continue;
            try {
                int x;
                BufferedImage gt = ImageIO.Read(images[i2].getAbsolutePath());
                int channel = gt.getRaster().getNumBands();
                if (channel != 3) {
                    throw new Exception("channel != 3");
                }
                int width = gt.getWidth();
                int height = gt.getHeight();
                byte[] bbgt = ((DataBufferByte)gt.getRaster().getDataBuffer()).getData();
                int counter = 0;
                for (x = 0; x < bbgt.length; x += channel) {
                    if ((bbgt[x] & 0xFF) != 255 || (bbgt[x + 1] & 0xFF) != 0 || (bbgt[x + 2] & 0xFF) != 0) continue;
                    ++counter;
                }
                FichierTabule tmp = new FichierTabule(counter, types, "tmp");
                tmp.setColumnsNames(names);
                BufferedImage source = ImageIO.Read(originalpath + "/" + images[i2].getName().substring(0, 7) + "/" + images[i2].getName());
                byte[] bbso = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                counter = 0;
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        if ((bbgt[pos] & 0xFF) == 255 && (bbgt[pos + 1] & 0xFF) == 0 && (bbgt[pos + 2] & 0xFF) == 0) {
                            double b = bbso[pos] & 0xFF;
                            double g = bbso[pos + 1] & 0xFF;
                            double r = bbso[pos + 2] & 0xFF;
                            int col = 0;
                            tmp.setValue(counter, col++, b);
                            tmp.setValue(counter, col++, g);
                            tmp.setValue(counter, col++, r);
                            float[] bgr = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
                            float[] ls = this.hls.fromRGB(bgr);
                            tmp.setValue(counter, col++, ls[0]);
                            tmp.setValue(counter, col++, ls[1]);
                            tmp.setValue(counter, col++, ls[2]);
                            float[] sv = this.hsv.fromRGB(bgr);
                            tmp.setValue(counter, col++, sv[1]);
                            tmp.setValue(counter, col++, sv[2]);
                            float[] ab = this.lab.fromRGB(bgr);
                            tmp.setValue(counter, col++, ab[0]);
                            tmp.setValue(counter, col++, ab[1]);
                            tmp.setValue(counter, col++, ab[2]);
                            tmp.setValue(counter, col++, x);
                            tmp.setValue(counter, col++, y);
                            tmp.setValue(counter, col++, images[i2].getName());
                            ++counter;
                        }
                        ++x;
                        pos += channel;
                    }
                }
                if (result == null) {
                    result = tmp;
                    continue;
                }
                result = FichierTabuleTools.Merge(result, tmp);
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
            }
        }
        return result;
    }

    public void DetectFur(String input, FichierTabule colorfur, String output) throws IOException {
        double[] array = colorfur.getColumnDouble("Blue");
        this.AF.Ranks(array);
        double minblue = this.AF.Rank10();
        double maxblue = this.AF.Rank90();
        array = colorfur.getColumnDouble("Green");
        this.AF.Ranks(array);
        double mingreen = this.AF.Rank10();
        double maxgreen = this.AF.Rank90();
        array = colorfur.getColumnDouble("Red");
        this.AF.Ranks(array);
        double minred = this.AF.Rank10();
        double maxred = this.AF.Rank90();
        array = colorfur.getColumnDouble("hls_H");
        this.AF.Ranks(array);
        double minhlsH = this.AF.Rank10();
        double maxhlsH = this.AF.Rank90();
        array = colorfur.getColumnDouble("hls_L");
        this.AF.Ranks(array);
        double minhlsL = this.AF.Rank10();
        double maxhlsL = this.AF.Rank90();
        array = colorfur.getColumnDouble("hls_S");
        this.AF.Ranks(array);
        double minhlsS = this.AF.Rank10();
        double maxhlsS = this.AF.Rank90();
        array = colorfur.getColumnDouble("hsv_S");
        this.AF.Ranks(array);
        double minhsvS = this.AF.Rank10();
        double maxhsvS = this.AF.Rank90();
        array = colorfur.getColumnDouble("hsv_V");
        this.AF.Ranks(array);
        double minhsvV = this.AF.Rank10();
        double maxhsvV = this.AF.Rank90();
        array = colorfur.getColumnDouble("lab_L");
        this.AF.Ranks(array);
        double minlabL = this.AF.Rank10();
        double maxlabL = this.AF.Rank90();
        array = colorfur.getColumnDouble("lab_a");
        this.AF.Ranks(array);
        double minlabA = this.AF.Rank10();
        double maxlabA = this.AF.Rank90();
        array = colorfur.getColumnDouble("lab_b");
        this.AF.Ranks(array);
        double minlabB = this.AF.Rank10();
        double maxlabB = this.AF.Rank90();
        File[] folders = new File(input).listFiles();
        for (int f = 0; f < folders.length; ++f) {
            if (!folders[f].isDirectory() || !folders[f].getName().contains("Camera2")) continue;
            File[] images = new File(folders[f].getAbsolutePath()).listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().contains(".png")) continue;
                BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                byte[] bbim = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int width = image.getWidth();
                int height = image.getHeight();
                BufferedImage imhls = ImageConverter.RGB_To_HLS((BufferedImage)image);
                BufferedImage imhsv = ImageConverter.RGB_To_HSV((BufferedImage)image);
                BufferedImage imlab = ImageConverter.RGB_To_Lab((BufferedImage)image);
                float[] bbhls = ((DataBufferFloat)imhls.getRaster().getDataBuffer()).getData();
                float[] bbhsv = ((DataBufferFloat)imhsv.getRaster().getDataBuffer()).getData();
                float[] bblab = ((DataBufferFloat)imlab.getRaster().getDataBuffer()).getData();
                BufferedImage result = ImageNew.Clone((BufferedImage)image);
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (minblue <= (double)(bbim[pos] & 0xFF) && (double)(bbim[pos] & 0xFF) <= maxblue && mingreen <= (double)(bbim[pos + 1] & 0xFF) && (double)(bbim[pos + 1] & 0xFF) <= maxgreen && minred <= (double)(bbim[pos + 2] & 0xFF) && (double)(bbim[pos + 2] & 0xFF) <= maxred && minhlsH <= (double)bbhls[pos] && (double)bbhls[pos] <= maxhlsH && minhlsL <= (double)bbhls[pos + 1] && (double)bbhls[pos + 1] <= maxhlsL && minhlsS <= (double)bbhls[pos + 2] && (double)bbhls[pos + 2] <= maxhlsS && minhsvS <= (double)bbhsv[pos + 1] && (double)bbhsv[pos + 1] <= maxhsvS && minhsvV <= (double)bbhsv[pos + 2] && (double)bbhsv[pos + 2] <= maxhsvV && minlabL <= (double)bblab[pos] && (double)bblab[pos] <= maxlabL && minlabA <= (double)bblab[pos + 1] && (double)bblab[pos + 1] <= maxlabA && minlabB <= (double)bblab[pos + 2] && (double)bblab[pos + 2] <= maxlabB) {
                            bbres[pos + 1] = 0;
                            bbres[pos] = 0;
                            bbres[pos + 2] = -1;
                        } else {
                            bbres[pos] = (byte)((bbres[pos] & 0xFF) >> 1);
                            bbres[pos + 1] = (byte)((bbres[pos + 1] & 0xFF) >> 1);
                            bbres[pos + 2] = (byte)((bbres[pos + 2] & 0xFF) >> 1);
                        }
                        ++x;
                        pos += 3;
                    }
                }
                File out = new File(output + "/" + folders[f].getName() + "/");
                if (!out.exists()) {
                    out.mkdirs();
                }
                ImageIO.Write(result, out.getAbsolutePath() + "/" + images[i2].getName(), 6);
            }
        }
    }
}

