/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.mema;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import characterization.shapes.shapeIndexes.ShapeIndexesComputer;
import characterization.textures.lbp.LocalBinaryPattern;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.DZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import displays.Colors;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListIO;
import measures.BasicMeasures;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import morphee.Close;
import morphee.Dilate;
import morphee.Open;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import morphee.filters.AreaOpening;
import morphee.granulometry.PatternSpectrum;
import morphee.segmentation.watershed.Watershed;
import processing.filters.ContrastEqualizer;
import processing.filters.Invert;
import processing.filters.gradients.Sobel;
import processing.reducer.LinearGLR;
import processing.thresholding.Binary;
import processing.thresholding.Huang;
import processing.thresholding.Li;
import processing.thresholding.MeanThresholding;
import processing.thresholding.Otsu;
import processing.thresholding.Renyi;
import segmentation.cells.DapiMM;
import utils.LogFile;
import utils.memory.Allocator;

public class Mema {
    private Allocator allocator = Allocator.Instance();
    private String Copyright = "Software version 1.0.3 developed by Guillaume THIBAULT for the Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.";
    private final int Magnification;
    private AreaOpening ao = new AreaOpening();
    private Binary binary = new Binary();
    private Close close = new Close();
    private ContrastEqualizer equalizer = new ContrastEqualizer();
    private DapiMM dapi;
    private Dilate dilate = new Dilate();
    private DistanceMapComputer dmc = new DistanceMapComputer();
    private FillHole fh = new FillHole();
    private Invert invert = new Invert();
    private Open open = new Open();
    private Sobel sobel = new Sobel();
    private UnionFindCcl ccl = new UnionFindCcl();
    private Watershed watershed = new Watershed();
    private WhiteTopHat wth = new WhiteTopHat();
    private Huang huang = new Huang();
    private Li li = new Li();
    private MeanThresholding meanthres = new MeanThresholding();
    private Otsu otsu = new Otsu();
    private Renyi renyi = new Renyi();
    private StructuringElement sedisk1 = new StructuringElement(new Object[]{1, -2});
    private StructuringElement sedisk2 = new StructuringElement(new Object[]{2, -2});
    private StructuringElement sedisk31 = new StructuringElement(new Object[]{31, -2});
    private StructuringElement sehex2 = new StructuringElement(new Object[]{2, -9});
    private StructuringElement selbp8 = new StructuringElement(new Object[]{1, -13, 8});
    private StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private LogFile log = new LogFile();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    public boolean masksegment = true;
    public boolean markersegment = true;
    public boolean nucleisegment = true;
    public boolean cellsegment = true;
    public String Segment_WaitFor = "";
    public boolean SingleWork = false;
    public String[] Channel_Names = null;
    public String[] Channel_Purposes = null;
    private int DapiChannel = -1;
    private List<Integer> CellSegmentationChannel = new LinkedList<Integer>();
    private List<Integer> CellsChannel = new LinkedList<Integer>();
    private List<Integer> NucleiChannel = new LinkedList<Integer>();
    private int AOThreshold = 150;
    private int FHThreshold = 500;
    private boolean ReadMask = false;
    public String FE_Image = "";
    public boolean FE_SubtractBackground = false;
    private BasicMeasures basic = new BasicMeasures();
    private DZMfeatures dzm = new DZMfeatures();
    private Haralick haralick = new Haralick();
    private LocalBinaryPattern lbp = new LocalBinaryPattern();
    private PatternSpectrum ps = new PatternSpectrum();
    private SZMfeatures szm = new SZMfeatures();
    private ShapeIndexesComputer sic = new ShapeIndexesComputer();

    public Mema(int Magnification) {
        switch (Magnification) {
            case 20: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.Magnification = Magnification;
        this.dapi = new DapiMM(Magnification, false);
    }

    public void Segment(String inputdir, String outputdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        this.log.addComment(this.Copyright);
        System.out.println(this.Copyright);
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        out = null;
        File checks = new File(outputdir + "-Checks/");
        if (!checks.exists()) {
            checks.mkdirs();
        }
        checks = null;
        this.FindChannels();
        Object[] images = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith(".tif"));
        if (images == null) {
            throw new IOException("The directory '" + inputdir + "' does not exist or is empty.");
        }
        Arrays.sort(images);
        System.out.println(images.length + " images found in '" + inputdir + "'");
        this.dapi.SubtractToTopHat /= 2;
        boolean dirtybackground = false;
        int simplifytexture = 2;
        boolean equalize = false;
        boolean fillholes = true;
        boolean DeleteOnTop = true;
        boolean roi100saver = false;
        boolean work = this.Segment_WaitFor.isEmpty();
        for (int i2 = 0; i2 < images.length; ++i2) {
            try {
                if (!work) {
                    if (!((File)images[i2]).getName().equalsIgnoreCase(this.Segment_WaitFor)) continue;
                    work = true;
                }
                System.out.println(i2 + " / " + images.length);
                boolean keepworking = true;
                String name2 = ((File)images[i2]).getName().substring(0, ((File)images[i2]).getName().indexOf(".tif"));
                BufferedImage image = ImageIO.ReadBioFormat(((File)images[i2]).getAbsolutePath());
                BufferedImage nuclei = this.Channel_Names.length == 1 ? image : ImageConverter.Channel((BufferedImage)image, (int)this.DapiChannel);
                for (int c = 0; c < this.Channel_Names.length; ++c) {
                    if (this.Channel_Names[c].isEmpty()) continue;
                    ImageIO.Write(this.Channel_Names.length == 1 ? image : ImageConverter.Channel((BufferedImage)image, (int)c), outputdir + "-Checks/" + name2 + "-" + this.Channel_Names[c] + ".png", 6);
                }
                if (image.getRaster().getNumBands() != this.Channel_Names.length) {
                    throw new IllegalArgumentException("The number of channels in the image is different from the number of channels defined in the parameter 'Channel_Names'.");
                }
                if (this.masksegment && keepworking) {
                    keepworking &= this.FindMask(nuclei, -1, 1, 0.75, true, name2, outputdir + "-Checks/", "DAPI", "Nuclei Safety Mask", nbCPU);
                }
                if (this.nucleisegment && keepworking) {
                    try {
                        BufferedImage mask = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "-Checks/" + name2 + " - Nuclei Safety Mask.png"));
                        this.dapi.Segmentation(nuclei, false, 2, false, true, true, false, mask, 250, outputdir + "-Checks/", nbCPU);
                        this.MergeSmallNuclei(nuclei, outputdir + "-Checks/");
                        this.Rename(name2, outputdir + "-Checks/");
                        File f = new File(outputdir + "-Checks/" + name2 + " - Nuclei Basins.tif");
                        BufferedImage nucs = ImageIO.Read(f);
                        BufferedImage nuc = ImageConverter.IntToShort((BufferedImage)nucs);
                        ImageIO.Write(nuc, outputdir + "/" + name2 + "-Nuclei.png", 6);
                        f.delete();
                        f = null;
                        nuclei = this.allocator.Release(nuclei);
                        nuc = this.allocator.Release(nuc);
                        mask = null;
                        nucs = null;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, "Cannot segment nuclei in image " + name2);
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        this.log.addNewError(e, "Cannot segment nuclei in image " + name2);
                    }
                }
                if (this.cellsegment && keepworking && !this.CellSegmentationChannel.isEmpty()) {
                    try {
                        int c;
                        LinkedList<BufferedImage> cells = new LinkedList<BufferedImage>();
                        for (c = 0; c < this.CellSegmentationChannel.size(); ++c) {
                            cells.add(ImageConverter.Channel((BufferedImage)image, (int)this.CellSegmentationChannel.get(c)));
                        }
                        this.SegmentCells(cells, this.CellSegmentationChannel, outputdir, name2, nbCPU);
                        for (c = 0; c < cells.size(); ++c) {
                            cells.set(c, this.allocator.Release((BufferedImage)cells.get(c)));
                        }
                        cells.clear();
                        cells = null;
                        this.allocator.ClearAll(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, "Cannot segment cells in image " + name2);
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        this.log.addNewError(e, "Cannot segment cells in image " + name2);
                    }
                }
                image = null;
                nuclei = this.allocator.Release(nuclei);
                this.allocator.ClearAll(true);
                if (!this.SingleWork) continue;
                System.exit(0);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, "Cannot process images: " + ((File)images[i2]).getAbsolutePath());
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, "Cannot process images: " + ((File)images[i2]).getAbsolutePath());
            }
        }
        System.out.println("Segmentation done!\n" + this.Copyright);
        this.dapi.SubtractToTopHat *= 2;
        this.log.Stop();
    }

    private void FindChannels() {
        if (this.Channel_Purposes == null) {
            throw new IllegalArgumentException("The parameter 'Channel_Purposes' must be defined.");
        }
        if (this.Channel_Names == null) {
            throw new IllegalArgumentException("The parameter 'Channel_Names' must be defined.");
        }
        if (this.Channel_Names.length != this.Channel_Purposes.length) {
            throw new IllegalArgumentException("The parameters 'Channel_Names' and 'Channel_Purposes' must contain the same number of elements.");
        }
        this.DapiChannel = -1;
        this.CellSegmentationChannel.clear();
        this.CellsChannel.clear();
        this.NucleiChannel.clear();
        block17: for (int i2 = 0; i2 < this.Channel_Purposes.length; ++i2) {
            switch (this.Channel_Purposes[i2].toLowerCase()) {
                case "dapi": {
                    if (this.DapiChannel != -1) {
                        throw new IllegalArgumentException("Dapi listed twice in parameter 'Channel_Purposes'.");
                    }
                    this.DapiChannel = i2;
                    this.NucleiChannel.add(i2);
                    continue block17;
                }
                case "cells_segmentation": 
                case "cell_segmentation": {
                    this.CellSegmentationChannel.add(i2);
                }
                case "cells": 
                case "cell": {
                    this.CellsChannel.add(i2);
                    continue block17;
                }
                case "nuclei": 
                case "nucleus": {
                    this.NucleiChannel.add(i2);
                    continue block17;
                }
                case "": {
                    continue block17;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported keywork in 'Channel_Purposes': '" + this.Channel_Purposes[i2] + "', expected {Dapi, Cells_Segmentation, Cells, Nuclei}");
                }
            }
        }
        if (this.DapiChannel == -1) {
            throw new IllegalArgumentException("No 'Dapi' channel found/defined.");
        }
        System.out.println("Information found:");
        System.out.println(" - Dapi is in channel " + this.DapiChannel);
        ListIO.Display(this.CellSegmentationChannel, " - Channel(s) used for cells segmentation", " ");
        ListIO.Display(this.CellsChannel, " - Cellular channel(s) used for features extraction", " ");
        ListIO.Display(this.NucleiChannel, " - Nuclei channel(s) used for features extraction", " ");
    }

    private void MergeSmallNuclei(BufferedImage nuclei, String outputdir) throws IOException {
        BufferedImage basins = ImageIO.Read(outputdir + "/Watershed - Basins.tif");
        if (ImageTools.isBlack((BufferedImage)basins)) {
            BufferedImage srccolor = ImageConverter.GrayToColor((BufferedImage)nuclei);
            ImageIO.Write(srccolor, outputdir + "/Segmentation - Full Color.png", 6);
            return;
        }
        int width = basins.getWidth();
        int height = basins.getHeight();
        int[] ibbassins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        this.ccl.ImportLabels(ibbassins, width, height);
        int[] clone = (int[])this.ccl.Sizes().clone();
        Arrays.sort(clone);
        int minsize = clone[clone.length >> 1] / 3;
        clone = null;
        this.dapi.MergeSmallCCs((ConnectedComponentLabeling)this.ccl, minsize);
        System.arraycopy(this.ccl.Labels1D(), 0, ibbassins, 0, ibbassins.length);
        this.ccl.Label(basins, 0, true);
        System.arraycopy(this.ccl.Labels1D(), 0, ibbassins, 0, ibbassins.length);
        ImageIO.Write(basins, outputdir + "/Watershed - Basins.tif", 8);
        BufferedImage roi = ImageIO.Read(outputdir + "/Segmentation - ROI.png");
        byte[] bbroi = ((DataBufferByte)roi.getRaster().getDataBuffer()).getData();
        for (int x = 0; x < ibbassins.length; ++x) {
            if (0 != ibbassins[x] || (bbroi[x] & 0xFF) != 255) continue;
            bbroi[x] = 0;
        }
        ImageIO.Write(roi, outputdir + "/Segmentation - ROI.png", 6);
        BufferedImage srccolor = ImageConverter.GrayToColor((BufferedImage)nuclei);
        DapiMM.Paint(basins, roi, srccolor);
        ImageIO.Write(srccolor, outputdir + "/Segmentation - Full Color.png", 6);
        roi = this.allocator.Release(roi);
        basins = this.allocator.Release(basins);
    }

    public boolean FindMask(BufferedImage image, int channel, int thresholdlevel, double thresholdrate, boolean CE, String name, String outputdir, String extce, String extout, int nbCPU) throws IOException {
        if (thresholdlevel < 0 || 3 < thresholdlevel) {
            throw new IllegalArgumentException("The threshold level value must be in range [0,3]");
        }
        if (thresholdrate < 0.0 || 1.0 <= thresholdrate) {
            throw new IllegalArgumentException("The threshold rate value must be in range [0,1[");
        }
        BufferedImage gray = null;
        switch (image.getType()) {
            case 10: {
                gray = image;
                break;
            }
            case 11: {
                gray = ImageConverter.UShortGrayToGray((BufferedImage)image, (boolean)true);
                break;
            }
            case 5: {
                gray = ImageConverter.Channel((BufferedImage)image, (int)channel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        String cext = CE ? " CE.png" : ".png";
        BufferedImage dapimp = null;
        dapimp = this.ReadMask ? ImageIO.Read(outputdir + "/" + name + " - " + extce + cext) : (!CE ? gray : this.equalizer.Filter(gray, ContrastEqualizer.Equalization.CLAHE, nbCPU));
        if (!this.ReadMask) {
            ImageIO.Write(dapimp, outputdir + "/" + name + " - " + extce + cext, 6);
        }
        gray = null;
        BufferedImage bin = ImageNew.Same((BufferedImage)dapimp);
        this.huang.Filter(dapimp, bin, nbCPU);
        this.li.Filter(dapimp, bin, nbCPU);
        this.otsu.Filter(dapimp, bin, nbCPU);
        this.renyi.Filter(dapimp, bin, nbCPU);
        int[] thres = new int[]{this.huang.getThreshold(0), this.li.getThreshold(0), this.otsu.getThreshold(0), this.renyi.getThreshold(0)};
        Arrays.sort(thres);
        int threshold = thresholdlevel == 3 ? (int)((1.0 + thresholdrate) * (double)thres[thresholdlevel]) : thres[thresholdlevel] + (int)(thresholdrate * (double)(thres[thresholdlevel + 1] - thres[thresholdlevel]));
        this.binary.Filter(dapimp, threshold, bin, nbCPU);
        dapimp = this.allocator.Release(dapimp);
        BufferedImage binao = this.ao.Filter(bin, this.AOThreshold, true);
        this.dilate.Filter(binao, this.sedisk2, bin, nbCPU);
        this.fh.Fill(bin, (ConnectedComponentLabeling)this.ccl, this.FHThreshold, true, binao);
        bin = this.allocator.Release(bin);
        ImageIO.Write(ImageConverter.GrayToBinary((BufferedImage)binao), outputdir + "/" + name + " - " + extout + ".png", 6);
        if (ImageTools.isBlack((BufferedImage)binao)) {
            binao = this.allocator.Release(binao);
            this.log.addComment("No nuclei found (empty mask) in image " + name + ", for " + extce + " & " + extout);
            return false;
        }
        binao = this.allocator.Release(binao);
        return true;
    }

    private void SegmentCells(List<BufferedImage> cells, List<Integer> channels, String outputdir, String name, int nbCPU) throws IOException {
        BufferedImage nucbasins = ImageIO.Read(outputdir + "/" + name + "-Nuclei.png");
        nucbasins = ImageConverter.ShortToInt((BufferedImage)nucbasins);
        int maxlabel = (int)this.IF.Maximum(nucbasins) + 13;
        BufferedImage maxcell = ImageNew.Clone((BufferedImage)cells.get(0));
        BufferedImage bincells = this.BinarizeCells(cells.get(0), outputdir + "-Checks/", name, channels.get(0), nbCPU);
        for (int i2 = 1; i2 < cells.size(); ++i2) {
            ImageOperations.Maximum((BufferedImage)maxcell, (BufferedImage)cells.get(i2), (BufferedImage)maxcell);
            BufferedImage bincell = this.BinarizeCells(cells.get(i2), outputdir + "-Checks/", name, channels.get(i2), nbCPU);
            ImageOperations.Maximum((BufferedImage)bincells, (BufferedImage)bincell, (BufferedImage)bincells);
            bincell = null;
        }
        this.invert.Filter(bincells, bincells, nbCPU);
        ImageComparator.Compare((BufferedImage)nucbasins, (String)"==", (int)0, (BufferedImage)bincells, (int)0, (BufferedImage)bincells);
        ImageComparator.Compare((BufferedImage)bincells, (String)"==", (int)0, (BufferedImage)nucbasins, (int)maxlabel, (BufferedImage)nucbasins);
        BufferedImage gradcell = this.sobel.Filter(maxcell, nbCPU);
        BufferedImage maxcellce = ImageIO.Read(outputdir + "-Checks/" + name + " - Marker " + channels.get(0) + " CE.png");
        for (int i3 = 1; i3 < cells.size(); ++i3) {
            BufferedImage cellce = ImageIO.Read(outputdir + "-Checks/" + name + " - Marker " + channels.get(i3) + " CE.png");
            ImageOperations.Maximum((BufferedImage)maxcellce, (BufferedImage)cellce, (BufferedImage)maxcellce);
            cellce = null;
        }
        this.watershed.watershed(gradcell, nucbasins, this.sedisk1);
        ImageComparator.Compare((BufferedImage)this.watershed.Basins(), (String)"!=", (int)maxlabel, (BufferedImage)this.watershed.Basins(), (int)0, (BufferedImage)this.watershed.Basins());
        BufferedImage rgb = ImageConverter.GrayToColor((BufferedImage)maxcellce);
        ImageDrawer.Cells(rgb, ((DataBufferInt)this.watershed.Basins().getRaster().getDataBuffer()).getData(), Colors.RED, Colors.YELLOW);
        ImageIO.Write(ImageConverter.IntToShort((BufferedImage)this.watershed.Basins()), outputdir + "/" + name + "-Cells.png", 6);
        ImageIO.Write(rgb, outputdir + "-Checks/" + name + " - Cells Segmentation.png", 6);
        rgb = null;
        nucbasins = null;
        maxcellce = null;
        maxcell = null;
        gradcell = null;
        bincells = null;
    }

    private BufferedImage BinarizeCells(BufferedImage cells, String outputdir, String name, int num, int nbCPU) throws IOException {
        BufferedImage gray = null;
        switch (cells.getType()) {
            case 10: {
                gray = cells;
                break;
            }
            case 11: {
                gray = ImageConverter.UShortGrayToGray((BufferedImage)cells, (boolean)true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        BufferedImage cellce = this.equalizer.Filter(gray, ContrastEqualizer.Equalization.CLAHE, nbCPU);
        ImageIO.Write(cellce, outputdir + "/" + name + " - Marker " + num + " CE.png", 6);
        BufferedImage cellth = this.wth.Filter(cellce, this.sedisk31, nbCPU);
        BufferedImage bin = ImageNew.Same((BufferedImage)cellce);
        this.meanthres.Filter(cellce, bin, nbCPU);
        BufferedImage binop = this.open.Filter(bin, this.sehex2, nbCPU);
        BufferedImage bincl = this.close.Filter(binop, this.sehex2, nbCPU);
        ImageComparator.Compare((BufferedImage)cellth, (String)"!=", (int)0, (BufferedImage)bincl, (int)0, (BufferedImage)bincl);
        gray = this.allocator.Release(gray);
        cellce = this.allocator.Release(cellce);
        bin = this.allocator.Release(bin);
        binop = this.allocator.Release(binop);
        return bincl;
    }

    public void FeaturesExtraction(String inputdir, String segmentationdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        this.log.addComment(this.Copyright);
        System.out.println("\nFeatures extraction:\n" + this.Copyright);
        this.FindChannels();
        Object[] images = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith(".tif"));
        Arrays.sort(images);
        System.out.println(images.length + " image(s) found in " + inputdir);
        this.ps.Parameters(1, 7, 2, 0, -2);
        this.lbp.Parameters(this.selbp8, 2, 0);
        this.haralick.Parameters(new LinearGLR(64), 64, 0);
        this.szm.Parameters(64, 1, new LinearGLR(64), 0, true);
        this.dzm.Parameters(64, 1, this.sem3, false, false, new LinearGLR(64), 0, true);
        this.sic.Indexes[3] = null;
        this.sic.Indexes[5] = null;
        this.sic.Indexes[10] = null;
        Arrays.fill(this.sic.Indexes, 13, 20, null);
        this.sic.Indexes[22] = null;
        this.sic.Indexes[24] = null;
        this.sic.Indexes[25] = null;
        UnionFindCcl cellccl = new UnionFindCcl();
        boolean work = this.FE_Image.isEmpty();
        for (int im = 0; im < images.length; ++im) {
            try {
                int c;
                String imname = ((File)images[im]).getName();
                String name2 = imname.substring(0, imname.indexOf(".tif"));
                if (!work) {
                    if (!imname.equalsIgnoreCase(this.FE_Image)) continue;
                    work = true;
                }
                System.out.println(im + " / " + images.length);
                StructuringElement senuclei = null;
                StructuringElement secells = null;
                BufferedImage nucseg = ImageIO.Read(segmentationdir + "/" + name2 + "-Nuclei.png");
                nucseg = ImageConverter.ShortToInt((BufferedImage)nucseg);
                this.ccl.ImportLabels(((DataBufferInt)nucseg.getRaster().getDataBuffer()).getData(), nucseg.getWidth(), nucseg.getHeight());
                this.ccl.ComputeBoundingBoxes();
                if (this.ccl.ConnectedComponentsNumber() == 0) continue;
                if (this.FE_SubtractBackground) {
                    BufferedImage ims = ImageNew.Same((BufferedImage)nucseg, (int)10);
                    ImageComparator.Compare((BufferedImage)nucseg, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)ims);
                    this.dmc.Compute(ims, this.sem3);
                    int max = (int)(this.AF.Maximum(this.dmc.getMontanariMap1D()) + 0.5);
                    senuclei = new StructuringElement(new Object[]{max + 7, -9});
                    ims = this.allocator.Release(ims);
                }
                BufferedImage cellseg = null;
                if (0 < this.CellsChannel.size()) {
                    cellseg = ImageIO.Read(segmentationdir + "/" + name2 + "-Cells.png");
                    cellseg = ImageConverter.ShortToInt((BufferedImage)cellseg);
                    cellccl.ImportLabels(((DataBufferInt)cellseg.getRaster().getDataBuffer()).getData(), cellseg.getWidth(), cellseg.getHeight());
                    System.arraycopy(((DataBufferInt)cellseg.getRaster().getDataBuffer()).getData(), 0, cellccl.Labels1D(), 0, cellccl.Labels1D().length);
                    cellccl.ComputeBoundingBoxes();
                    if (this.FE_SubtractBackground) {
                        BufferedImage ims = ImageNew.Same((BufferedImage)cellseg, (int)10);
                        ImageComparator.Compare((BufferedImage)cellseg, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)ims);
                        this.dmc.Compute(ims, this.sem3);
                        int max = (int)(this.AF.Maximum(this.dmc.getMontanariMap1D()) + 0.5);
                        secells = new StructuringElement(new Object[]{max + 7, -9});
                        ims = this.allocator.Release(ims);
                    }
                }
                for (c = 0; c < this.CellsChannel.size(); ++c) {
                    BufferedImage image = ImageIO.Read(segmentationdir + "-Checks/" + name2 + "-" + this.Channel_Names[this.CellsChannel.get(c)] + ".png");
                    image = this.FE_SubtractBackground ? this.wth.Filter(image, secells, nbCPU) : image;
                    List<BufferedImage> cellslist = this.SeparateNucleiCells(cellccl, image);
                    FichierTabule cellfeatures = this.ComputeFeatures(cellccl, cellslist, false, nbCPU);
                    cellfeatures.Write(segmentationdir + "/" + name2 + "-" + this.Channel_Names[this.CellsChannel.get(c)] + "-Cytoplasm.txt", false);
                    cellslist.clear();
                    cellslist = null;
                    cellfeatures.Kill();
                    cellfeatures = null;
                    List<BufferedImage> cellsminusnucleilist = this.SeparateCellsMinusNuclei(this.ccl, cellccl, image);
                    FichierTabule cellminusnucleifeatures = this.ComputeFeatures(cellccl, cellsminusnucleilist, false, nbCPU);
                    cellminusnucleifeatures.Write(segmentationdir + "/" + name2 + "-" + this.Channel_Names[this.CellsChannel.get(c)] + "-CytoplasmMinusNuclei.txt", false);
                    cellsminusnucleilist.clear();
                    cellsminusnucleilist = null;
                    cellminusnucleifeatures.Kill();
                    cellminusnucleifeatures = null;
                    image = null;
                }
                for (c = 0; c < this.NucleiChannel.size(); ++c) {
                    BufferedImage image = ImageIO.Read(segmentationdir + "-Checks/" + name2 + "-" + this.Channel_Names[this.NucleiChannel.get(c)] + ".png");
                    image = this.FE_SubtractBackground ? this.wth.Filter(image, senuclei, nbCPU) : image;
                    List<BufferedImage> nucleilist = this.SeparateNucleiCells(this.ccl, image);
                    FichierTabule nucfeatures = this.ComputeFeatures(this.ccl, nucleilist, true, nbCPU);
                    nucfeatures.Write(segmentationdir + "/" + name2 + "-" + this.Channel_Names[this.NucleiChannel.get(c)] + "-Nuclei.txt", false);
                    nucleilist.clear();
                    nucleilist = null;
                    nucfeatures.Kill();
                    nucfeatures = null;
                    image = null;
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, "Cannot extract features from image " + ((File)images[im]).getAbsolutePath());
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, "Cannot extract features from image " + ((File)images[im]).getAbsolutePath());
            }
        }
        System.out.println("Features extraction done!\n" + this.Copyright);
        this.log.Stop();
    }

    private List<BufferedImage> SeparateNucleiCells(UnionFindCcl ccl, BufferedImage staining) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(ccl.ConnectedComponentsNumber() + 13);
        int width = staining.getWidth();
        int height = staining.getHeight();
        boolean margin = true;
        int[] labels = ccl.Labels1D();
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        for (int i2 = 1; i2 <= ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - 1 < 0 ? 0 : minx[i2] - 1;
            int sy = miny[i2] - 1 < 0 ? 0 : miny[i2] - 1;
            int ex = width <= maxx[i2] + 1 ? width - 1 : maxx[i2] + 1;
            int ey = height <= maxy[i2] + 1 ? height - 1 : maxy[i2] + 1;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (labels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2), (int)(patch.getHeight() + 2), (int)0);
            images.add(patch);
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    private List<BufferedImage> SeparateCellsMinusNuclei(UnionFindCcl nucccl, UnionFindCcl cellccl, BufferedImage staining) throws IOException {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(this.ccl.ConnectedComponentsNumber() + 13);
        int width = staining.getWidth();
        int height = staining.getHeight();
        boolean margin = true;
        int[] minx = cellccl.minx();
        int[] maxx = cellccl.maxx();
        int[] miny = cellccl.miny();
        int[] maxy = cellccl.maxy();
        int[] celllabels = (int[])cellccl.Labels1D().clone();
        ArrayArithmetic.Subtract((int[])celllabels, (int[])nucccl.Labels1D(), (int[])celllabels, (int)0, (int)0);
        for (int i2 = 1; i2 <= this.ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - 1 < 0 ? 0 : minx[i2] - 1;
            int sy = miny[i2] - 1 < 0 ? 0 : miny[i2] - 1;
            int ex = width <= maxx[i2] + 1 ? width - 1 : maxx[i2] + 1;
            int ey = height <= maxy[i2] + 1 ? height - 1 : maxy[i2] + 1;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (celllabels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2), (int)(patch.getHeight() + 2), (int)0);
            images.add(patch);
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    private FichierTabule ComputeFeatures(UnionFindCcl ccl, List<BufferedImage> images, boolean nuclei, int nbCPU) {
        int i2;
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        int nbPS = this.ps.Features().length;
        int nbLBP = this.lbp.Features().length;
        int nbHaralick = this.haralick.Features().length;
        int nbSZM = this.szm.Features().length;
        int nbDZM = this.dzm.Features().length;
        int nbSI = this.sic.Features().length;
        int[] types = new int[23 + nbPS + nbLBP + nbHaralick + nbSZM + nbDZM + (nuclei ? nbSI : 0)];
        Arrays.fill(types, 1);
        Arrays.fill(types, 0, 5, 0);
        types[7] = 0;
        Arrays.fill(types, 12, 23, 0);
        FichierTabule features = new FichierTabule(ccl.ConnectedComponentsNumber(), types, "");
        features.setColumnName(0, "Label");
        features.setColumnName(1, "MinX");
        features.setColumnName(2, "MinY");
        features.setColumnName(3, "MaxX");
        features.setColumnName(4, "MaxY");
        features.setColumnName(5, "CentroidX");
        features.setColumnName(6, "CentroidY");
        features.setColumnName(7, "Surface");
        features.setColumnName(8, "MeanIntensity");
        features.setColumnName(9, "VarianceIntensity");
        features.setColumnName(10, "SkewnessIntensity");
        features.setColumnName(11, "KurtosisIntensity");
        features.setColumnName(12, "Rank01");
        features.setColumnName(13, "Rank02.5");
        features.setColumnName(14, "Rank05");
        features.setColumnName(15, "Rank10");
        features.setColumnName(16, "Rank25");
        features.setColumnName(17, "Rank50");
        features.setColumnName(18, "Rank75");
        features.setColumnName(19, "Rank90");
        features.setColumnName(20, "Rank95");
        features.setColumnName(21, "Rank97.5");
        features.setColumnName(22, "Rank99");
        int pos = 23;
        String[] names = this.ps.FeaturesNames();
        for (i2 = 0; i2 < nbPS; ++i2) {
            features.setColumnName(pos + i2, names[i2]);
        }
        pos += nbPS;
        names = this.lbp.FeaturesNames();
        for (i2 = 0; i2 < nbLBP; ++i2) {
            features.setColumnName(pos + i2, names[i2]);
        }
        pos += nbLBP;
        names = this.haralick.FeaturesNames();
        for (i2 = 0; i2 < nbHaralick; ++i2) {
            features.setColumnName(pos + i2, names[i2]);
        }
        pos += nbHaralick;
        names = this.szm.FeaturesNames();
        for (i2 = 0; i2 < nbSZM; ++i2) {
            features.setColumnName(pos + i2, names[i2]);
        }
        pos += nbSZM;
        names = this.dzm.FeaturesNames();
        for (i2 = 0; i2 < nbDZM; ++i2) {
            features.setColumnName(pos + i2, names[i2]);
        }
        if (nuclei) {
            pos += nbDZM;
            names = this.sic.FeaturesNames();
            for (i2 = 0; i2 < nbSI; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
        }
        int nb = 1;
        Iterator<BufferedImage> iter = images.iterator();
        while (iter.hasNext()) {
            try {
                int i3;
                BufferedImage image = iter.next();
                features.setValue(nb - 1, 0, nb);
                features.setValue(nb - 1, 1, minx[nb]);
                features.setValue(nb - 1, 2, miny[nb]);
                features.setValue(nb - 1, 3, maxx[nb]);
                features.setValue(nb - 1, 4, maxy[nb]);
                if (ImageTools.isBlack((BufferedImage)image)) {
                    ++nb;
                    continue;
                }
                this.basic.Compute(image, true);
                features.setValue(nb - 1, 5, (double)minx[nb] + this.basic.Centroid.X);
                features.setValue(nb - 1, 6, (double)miny[nb] + this.basic.Centroid.Y);
                this.IF.Moments(image, 0);
                features.setValue(nb - 1, 7, (int)this.IF.Size());
                features.setValue(nb - 1, 8, this.IF.Average());
                features.setValue(nb - 1, 9, this.IF.Variance());
                features.setValue(nb - 1, 10, this.IF.Skewness());
                features.setValue(nb - 1, 11, this.IF.Kurtosis());
                if ((int)this.IF.Size() < 53) {
                    ++nb;
                    continue;
                }
                this.IF.Ranks(image, 0);
                features.setValue(nb - 1, 12, (int)this.IF.Rank01());
                features.setValue(nb - 1, 13, (int)this.IF.Rank025());
                features.setValue(nb - 1, 14, (int)this.IF.Rank05());
                features.setValue(nb - 1, 15, (int)this.IF.Rank10());
                features.setValue(nb - 1, 16, (int)this.IF.Rank25());
                features.setValue(nb - 1, 17, (int)this.IF.Rank50());
                features.setValue(nb - 1, 18, (int)this.IF.Rank75());
                features.setValue(nb - 1, 19, (int)this.IF.Rank90());
                features.setValue(nb - 1, 20, (int)this.IF.Rank95());
                features.setValue(nb - 1, 21, (int)this.IF.Rank975());
                features.setValue(nb - 1, 22, (int)this.IF.Rank99());
                pos = 23;
                this.ps.Compute(image, null, this.ps.ForbiddenValue(), nbCPU);
                double[] feat = this.ps.Features();
                for (i3 = 0; i3 < feat.length; ++i3) {
                    features.setValue(nb - 1, pos + i3, feat[i3]);
                }
                pos += nbPS;
                this.lbp.Compute(image, null, this.lbp.ForbiddenValue(), nbCPU);
                feat = this.lbp.Features();
                for (i3 = 0; i3 < feat.length; ++i3) {
                    features.setValue(nb - 1, pos + i3, feat[i3]);
                }
                pos += nbLBP;
                this.haralick.Compute(image, (BufferedImage)null, this.haralick.ForbiddenValue(), nbCPU);
                feat = this.haralick.Features();
                for (i3 = 0; i3 < feat.length; ++i3) {
                    features.setValue(nb - 1, pos + i3, feat[i3]);
                }
                pos += nbHaralick;
                this.szm.Compute(image, null, this.szm.ForbiddenValue(), nbCPU);
                feat = this.szm.Features();
                for (i3 = 0; i3 < feat.length; ++i3) {
                    features.setValue(nb - 1, pos + i3, feat[i3]);
                }
                pos += nbSZM;
                this.dzm.Compute(image, null, this.dzm.ForbiddenValue(), nbCPU);
                feat = this.dzm.Features();
                for (i3 = 0; i3 < feat.length; ++i3) {
                    features.setValue(nb - 1, pos + i3, feat[i3]);
                }
                if (nuclei) {
                    pos += nbDZM;
                    this.sic.Compute(image, null, this.sic.ForbiddenValue(), nbCPU);
                    feat = this.sic.Features();
                    for (i3 = 0; i3 < feat.length; ++i3) {
                        features.setValue(nb - 1, pos + i3, feat[i3]);
                    }
                }
                ++nb;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    this.log.addNewException(e, "Failed to characterize nucleus/cell/ring " + nb);
                    ++nb;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.err.println("Log file not accessible, must not occur => Abort!");
                    System.exit(0);
                }
            }
            catch (Error e) {
                try {
                    e.printStackTrace();
                    this.log.addNewError(e, "Failed to characterize nucleus/cell/ring " + nb);
                    ++nb;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.err.println("Log file not accessible, must not occur => Abort!");
                    System.exit(0);
                }
            }
        }
        return features;
    }

    private void NucleiCount(String inputdir, String segmentationdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        this.log.addComment(this.Copyright);
        System.out.println(this.Copyright);
        Object[] images = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && name.endsWith(".tif"));
        Arrays.sort(images);
        System.out.print(images.length + " image(s) found.");
        int[] types = new int[]{2, 0};
        FichierTabule count = new FichierTabule(images.length, types, "");
        count.setColumnName(0, "Name");
        count.setColumnName(1, "Count");
        for (int im = 0; im < images.length; ++im) {
            try {
                String imname = ((File)images[im]).getName();
                String name2 = imname.substring(0, imname.indexOf(".tif"));
                count.setValue(im, 0, name2);
                File file = new File(segmentationdir + "/" + name2 + " - Nuclei Basins.tif");
                if (file.exists()) {
                    BufferedImage nucseg = ImageIO.Read(segmentationdir + "/" + name2 + " - Nuclei Basins.tif");
                    count.setValue(im, 1, (int)this.IF.Maximum(nucseg));
                    nucseg = null;
                } else {
                    count.setValue(im, 1, 0);
                }
                name2 = null;
                imname = null;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, "Cannot cound nuclei in image " + ((File)images[im]).getAbsolutePath());
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, "Cannot cound nuclei in image " + ((File)images[im]).getAbsolutePath());
            }
        }
        count.Write(segmentationdir + "/Count.txt", false);
        count.Kill();
        count = null;
        System.out.println("Nuclei count done. " + this.Copyright);
        this.log.Stop();
    }

    private void Rename(String name, String output) {
        File f = new File(output + "/Intermediate - WhiteTopHat.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - AreaOpening.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - UltimateEroded.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Watershed - Markers.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - ROI.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - Full Color.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/" + name + " - Nuclei Segmentation.png"));
        }
        f = null;
        f = new File(output + "/Watershed - Basins.tif");
        if (f.exists()) {
            f.renameTo(new File(output + "/" + name + " - Nuclei Basins.tif"));
        }
        f = null;
    }
}

