/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.lincs;

import arrayTiTi.ArrayOperations;
import filesAndFolders.FileFilters;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import utils.memory.Allocator;

public class PreProcessing {
    private Allocator allocator = Allocator.Instance();
    private FilenameFilter ImagesTIF = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.endsWith("C0.tiff");

    public void Sort(String dirpath, double ratio, String outputdir, boolean writergb, boolean writegrays) {
        BufferedImage rgb;
        BufferedImage c2;
        BufferedImage c1;
        BufferedImage c0;
        int i2;
        File out;
        File[] images = new File(dirpath).listFiles(this.ImagesTIF);
        ArrayOperations.Shuffle((File[])images);
        int nbTraining = (int)((double)images.length * ratio + 0.5);
        if (writegrays) {
            out = new File(outputdir + "/C0/Training/");
            if (!out.exists()) {
                out.mkdirs();
            }
            if (!(out = new File(outputdir + "/C1/Training/")).exists()) {
                out.mkdirs();
            }
            if (!(out = new File(outputdir + "/C2/Training/")).exists()) {
                out.mkdirs();
            }
            if (!(out = new File(outputdir + "/C0/Testing/")).exists()) {
                out.mkdirs();
            }
            if (!(out = new File(outputdir + "/C1/Testing/")).exists()) {
                out.mkdirs();
            }
            if (!(out = new File(outputdir + "/C2/Testing/")).exists()) {
                out.mkdirs();
            }
        }
        if (writergb) {
            out = new File(outputdir + "/RGB/Training/");
            if (!out.exists()) {
                out.mkdirs();
            }
            if (!(out = new File(outputdir + "/RGB/Testing/")).exists()) {
                out.mkdirs();
            }
        }
        for (i2 = 0; i2 < nbTraining; ++i2) {
            try {
                c0 = ImageIO.ReadJAI(images[i2].getAbsolutePath());
                c1 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C1."));
                c2 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C2."));
                if (writegrays) {
                    ImageIO.Write(c0, outputdir + "/C0/Training/" + images[i2].getName().replace(".tiff", ".png"), 6);
                    ImageIO.Write(c1, outputdir + "/C1/Training/" + images[i2].getName().replace("_C0.tiff", "_C1.png"), 6);
                    ImageIO.Write(c2, outputdir + "/C2/Training/" + images[i2].getName().replace("_C0.tiff", "_C2.png"), 6);
                }
                if (!writergb) continue;
                rgb = ImageNew.New((int)c0.getWidth(), (int)c0.getHeight(), (int)5);
                ImageNew.Copy((BufferedImage)c0, (BufferedImage)rgb, (int)0);
                ImageNew.Copy((BufferedImage)c1, (BufferedImage)rgb, (int)1);
                ImageNew.Copy((BufferedImage)c2, (BufferedImage)rgb, (int)2);
                ImageIO.Write(rgb, outputdir + "/RGB/Training/" + images[i2].getName().replace("_C0.tiff", "_RGB.png"), 6);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        for (i2 = nbTraining; i2 < images.length; ++i2) {
            try {
                c0 = ImageIO.ReadJAI(images[i2].getAbsolutePath());
                c1 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C1."));
                c2 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C2."));
                if (writegrays) {
                    ImageIO.Write(c0, outputdir + "/C0/Testing/" + images[i2].getName().replace(".tiff", ".png"), 6);
                    ImageIO.Write(c1, outputdir + "/C1/Testing/" + images[i2].getName().replace("_C0.tiff", "_C1.png"), 6);
                    ImageIO.Write(c2, outputdir + "/C2/Testing/" + images[i2].getName().replace("_C0.tiff", "_C2.png"), 6);
                }
                if (!writergb) continue;
                rgb = ImageNew.New((int)c0.getWidth(), (int)c0.getHeight(), (int)5);
                ImageNew.Copy((BufferedImage)c0, (BufferedImage)rgb, (int)0);
                ImageNew.Copy((BufferedImage)c1, (BufferedImage)rgb, (int)1);
                ImageNew.Copy((BufferedImage)c2, (BufferedImage)rgb, (int)2);
                ImageIO.Write(rgb, outputdir + "/RGB/Testing/" + images[i2].getName().replace("_C0.tiff", "_RGB.png"), 6);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void SortAuto(String dirpath, double ratio, String outputdir, boolean writergb, boolean writegrays) {
        File[] classes = new File(dirpath).listFiles(FileFilters.Directories);
        for (int c = 0; c < classes.length; ++c) {
            BufferedImage rgb;
            BufferedImage c2;
            BufferedImage c1;
            BufferedImage c0;
            int i2;
            File out;
            File[] images = new File(classes[c].getAbsolutePath()).listFiles(this.ImagesTIF);
            ArrayOperations.Shuffle((File[])images);
            String name = classes[c].getName();
            int nbTraining = (int)((double)images.length * ratio + 0.5);
            if (writegrays) {
                out = new File(outputdir + "/C0/Training/" + name);
                if (!out.exists()) {
                    out.mkdirs();
                }
                if (!(out = new File(outputdir + "/C1/Training/" + name)).exists()) {
                    out.mkdirs();
                }
                if (!(out = new File(outputdir + "/C2/Training/" + name)).exists()) {
                    out.mkdirs();
                }
                if (!(out = new File(outputdir + "/C0/Testing/" + name)).exists()) {
                    out.mkdirs();
                }
                if (!(out = new File(outputdir + "/C1/Testing/" + name)).exists()) {
                    out.mkdirs();
                }
                if (!(out = new File(outputdir + "/C2/Testing/" + name)).exists()) {
                    out.mkdirs();
                }
            }
            if (writergb) {
                out = new File(outputdir + "/RGB/Training/" + name);
                if (!out.exists()) {
                    out.mkdirs();
                }
                if (!(out = new File(outputdir + "/RGB/Testing/" + name)).exists()) {
                    out.mkdirs();
                }
            }
            for (i2 = 0; i2 < nbTraining; ++i2) {
                try {
                    c0 = ImageIO.ReadJAI(images[i2].getAbsolutePath());
                    c1 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C1."));
                    c2 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C2."));
                    if (writegrays) {
                        ImageIO.Write(c0, outputdir + "/C0/Training/" + name + "/" + images[i2].getName().replace(".tiff", ".png"), 6);
                        ImageIO.Write(c1, outputdir + "/C1/Training/" + name + "/" + images[i2].getName().replace("_C0.tiff", "_C1.png"), 6);
                        ImageIO.Write(c2, outputdir + "/C2/Training/" + name + "/" + images[i2].getName().replace("_C0.tiff", "_C2.png"), 6);
                    }
                    if (!writergb) continue;
                    rgb = ImageNew.New((int)c0.getWidth(), (int)c0.getHeight(), (int)5);
                    ImageNew.Copy((BufferedImage)c0, (BufferedImage)rgb, (int)0);
                    ImageNew.Copy((BufferedImage)c1, (BufferedImage)rgb, (int)1);
                    ImageNew.Copy((BufferedImage)c2, (BufferedImage)rgb, (int)2);
                    ImageIO.Write(rgb, outputdir + "/RGB/Training/" + name + "/" + images[i2].getName().replace("_C0.tiff", "_RGB.png"), 6);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            for (i2 = nbTraining; i2 < images.length; ++i2) {
                try {
                    c0 = ImageIO.ReadJAI(images[i2].getAbsolutePath());
                    c1 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C1."));
                    c2 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C2."));
                    if (writegrays) {
                        ImageIO.Write(c0, outputdir + "/C0/Testing/" + name + "/" + images[i2].getName().replace(".tiff", ".png"), 6);
                        ImageIO.Write(c1, outputdir + "/C1/Testing/" + name + "/" + images[i2].getName().replace("_C0.tiff", "_C1.png"), 6);
                        ImageIO.Write(c2, outputdir + "/C2/Testing/" + name + "/" + images[i2].getName().replace("_C0.tiff", "_C2.png"), 6);
                    }
                    if (!writergb) continue;
                    rgb = ImageNew.New((int)c0.getWidth(), (int)c0.getHeight(), (int)5);
                    ImageNew.Copy((BufferedImage)c0, (BufferedImage)rgb, (int)0);
                    ImageNew.Copy((BufferedImage)c1, (BufferedImage)rgb, (int)1);
                    ImageNew.Copy((BufferedImage)c2, (BufferedImage)rgb, (int)2);
                    ImageIO.Write(rgb, outputdir + "/RGB/Testing/" + name + "/" + images[i2].getName().replace("_C0.tiff", "_RGB.png"), 6);
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void CreateRGBs(String dirpath, String outputdir) {
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        File[] images = new File(dirpath).listFiles(this.ImagesTIF);
        for (int i2 = 0; i2 < images.length; ++i2) {
            try {
                BufferedImage c0 = ImageIO.ReadJAI(images[i2].getAbsolutePath());
                BufferedImage c1 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C1."));
                BufferedImage c2 = ImageIO.ReadJAI(images[i2].getAbsolutePath().replace("_C0.", "_C2."));
                BufferedImage rgb = ImageNew.New((int)c0.getWidth(), (int)c0.getHeight(), (int)5);
                ImageNew.Copy((BufferedImage)c0, (BufferedImage)rgb, (int)0);
                ImageNew.Copy((BufferedImage)c1, (BufferedImage)rgb, (int)1);
                ImageNew.Copy((BufferedImage)c2, (BufferedImage)rgb, (int)2);
                ImageIO.Write(rgb, out.getAbsolutePath() + "/" + images[i2].getName().replace("_C0.tiff", "_RGB.png"), 6);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

