/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.keck.rotary;

import arrayTiTi.ArrayConverter;
import displays.Display;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import mathematics.fourier.JTransformsComplex;
import measures.cclh.UnionFindCcl;
import morphee.Close;
import morphee.Open;
import morphee.StructuringElement;
import morphee.filters.ASFilterCloseOpen;
import morphee.granulometry.AntiGranulometry;
import morphee.granulometry.Granulometry;
import morphee.other.Paths;
import morphee.rank.RankCloseOpen;
import processing.filters.Gabor;
import processing.filters.GaborCircular;
import processing.filters.Gaussian;
import processing.filters.Invert;
import processing.thresholding.Binary;

public class RotaryShadowMolecules {
    public Display display = null;
    private final int order = 5;
    private final StructuringElement sehori = new StructuringElement(new Object[]{5, -5});
    private final StructuringElement severt = new StructuringElement(new Object[]{5, -6});
    private final StructuringElement se45 = new StructuringElement(new Object[]{5, -4});
    private final StructuringElement se135 = new StructuringElement(new Object[]{5, -3});
    private final Close close = new Close();
    private final Open open = new Open();
    private final RankCloseOpen rco = new RankCloseOpen();
    private final ASFilterCloseOpen asfco = new ASFilterCloseOpen();
    private final Gaussian gauss = new Gaussian();
    private final Gabor gabor = new Gabor();
    private final GaborCircular circgab = new GaborCircular();
    private final JTransformsComplex jt = new JTransformsComplex();
    private final Binary binary = new Binary(1);
    private final Invert invert = new Invert();
    private final Paths path = new Paths();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final ImageFeatures IF = new ImageFeatures();

    public void Process(BufferedImage image, int nbCPU) {
        this.display.Image(image, "Original", 1.0);
        BufferedImage imndg = image;
        this.display.Image(imndg, "NDG", 1.0);
        BufferedImage reshori = this.open.Filter(imndg, this.sehori, nbCPU);
        BufferedImage resvert = this.open.Filter(imndg, this.severt, nbCPU);
        BufferedImage res45 = this.open.Filter(imndg, this.se45, nbCPU);
        BufferedImage res135 = this.open.Filter(imndg, this.se135, nbCPU);
        BufferedImage resmax1 = ImageOperations.Maximum((BufferedImage)reshori, (BufferedImage)resvert);
        BufferedImage resmax2 = ImageOperations.Maximum((BufferedImage)res45, (BufferedImage)res135);
        BufferedImage resmax = ImageOperations.Maximum((BufferedImage)resmax1, (BufferedImage)resmax2);
        this.display.Image(resmax, "resm**", 1.0);
        this.gauss.Parameters(5, 1.0, this.jt);
        BufferedImage resgauss = this.gauss.Filter(resmax, nbCPU);
        this.display.Image(resgauss, "resgauss", 1.0);
        BufferedImage resasfco = this.asfco.Filter(resgauss, new StructuringElement(new Object[]{5, -2}), nbCPU);
        this.display.Image(resasfco, "resasfco", 1.0);
        BufferedImage ressub = ImageArithmetic.Subtract(resasfco, resgauss, 0, 0);
        this.display.Image(ressub, "ressub", 1.0);
        double sigmax = 2.0;
        double sigmay = 1.5 * sigmax;
        double lambda = 3.0 * sigmax;
        double phase = 0.0;
        BufferedImage resgabor = new BufferedImage(ressub.getWidth(), ressub.getHeight(), 11);
        this.gabor.Parameters(0, 165, 15, sigmax, sigmay, lambda, phase, this.jt, 0, 1, true, false);
        this.gabor.Filter(ressub, resgabor, nbCPU);
        double average = this.IF.Average(resgabor);
        ImageArithmetic.Subtract(resgabor, (int)average, resgabor, 0, 0);
        this.display.Image(resgabor, "resgabor 2", 1.0);
        BufferedImage imbin = this.binary.Filter(resgabor, 1, nbCPU);
        this.ccl.Label(imbin, 0, true);
        BufferedImage resinv = this.invert.Filter(resgabor, nbCPU);
        int[][] markers = ArrayConverter.to2D((int[])this.ccl.Labels1D(), (int)imbin.getWidth(), (int)imbin.getHeight());
        this.path.Process(resinv, markers, markers, true, true, nbCPU);
        this.display.ArrayImage(this.path.Accumulator(), "Accumulator", 1.0);
        this.display.ArrayImage(this.path.Connections(), "Connections", 1.0);
    }

    public void ProcessStat(BufferedImage image, int nbCPU) {
        this.display.Image(image, "Original", 1.0);
        BufferedImage imndg = ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (int)1);
        this.display.Image(imndg, "NDG", 1.0);
        Granulometry gran = new Granulometry();
        gran.Process(imndg, null, 1, 20, 1, -1, -2, nbCPU);
        this.display.Function(gran.Features(), "Gran", "X", "Y", 1.0);
        AntiGranulometry antigran = new AntiGranulometry();
        antigran.Process(imndg, null, 1, 20, 1, -1, -2, nbCPU);
        this.display.Function(antigran.Features(), "antigran", "X", "Y", 1.0);
    }
}

