/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.keck.rotary;

import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;

public class BuildTrainingSet {
    public void Build(String imlabeled, String original, String path, int size) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException("The file does not exist.");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The file is not a directory.");
        }
        File clin = new File(file.getAbsolutePath() + "/ClassIn/");
        if (!clin.exists()) {
            clin.mkdirs();
        }
        String pathin = clin.getAbsolutePath();
        File clout = new File(file.getAbsolutePath() + "/ClassOut/");
        if (!clout.exists()) {
            clout.mkdirs();
        }
        String pathout = clout.getAbsolutePath();
        BufferedImage image = ImageIO.Read(imlabeled);
        WritableRaster wr = image.getRaster();
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage source = ImageIO.Read(original);
        if (!ImageTools.areDimensionsEqual((BufferedImage)image, (BufferedImage)source)) {
            throw new IllegalArgumentException("Images source and labeled have different dimensions.");
        }
        int nbin = 0;
        int nbout = 0;
        int length = (size << 1) + 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (wr.getSample(x, y, 0) == wr.getSample(x, y, 1) && wr.getSample(x, y, 1) == wr.getSample(x, y, 2)) continue;
                try {
                    if (200 <= wr.getSample(x, y, 0)) {
                        ImageIO.Write(ImageNew.SubImageWH((BufferedImage)source, (int)(x - size), (int)(y - size), (int)length, (int)length), pathin + "/ImageIn" + nbin++ + ".png", 6);
                        continue;
                    }
                    if (200 > wr.getSample(x, y, 2)) continue;
                    ImageIO.Write(ImageNew.SubImageWH((BufferedImage)source, (int)(x - size), (int)(y - size), (int)length, (int)length), pathout + "/ImageOut" + nbout++ + ".png", 6);
                    continue;
                }
                catch (Exception E) {
                    System.err.println("Outside: " + x + " " + y);
                    E.printStackTrace();
                }
            }
        }
        System.out.println("Final: " + nbin + " in, " + nbout + " out.");
        clout = null;
        clin = null;
        file = null;
        pathout = null;
        pathin = null;
        image = null;
        wr = null;
    }
}

