/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.keck.hpa;

import displays.Display;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import listTiTi.ListTools;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.filters.ASFilterCloseOpen;
import morphee.geodesic.CloseHole;
import morphee.geodesic.Opening;
import morphee.geodesic.UnderBuild;
import processing.filters.gradients.Sobel;
import processing.thresholding.Binary;
import processing.thresholding.Li;
import processing.thresholding.TriangleThresholding;
import utils.LogFile;

public class HPA {
    private ASFilterCloseOpen asfco = new ASFilterCloseOpen();
    private Binary binary = new Binary();
    private CloseHole ch = new CloseHole();
    private Erode erode = new Erode();
    private FillHole fh = new FillHole();
    private Li li = new Li();
    private Opening opening = new Opening();
    private Sobel sobel = new Sobel();
    private TriangleThresholding triangle = new TriangleThresholding();
    private UnderBuild ub = new UnderBuild();
    private UnionFindCcl ccl = new UnionFindCcl();
    private BufferedImage imtmp1;
    private BufferedImage imtmp2;
    private BufferedImage imtmp3;
    private BufferedImage dnabin;
    private BufferedImage markers;
    private BufferedImage tmpbin1;
    private BufferedImage tmpbin2;
    private BufferedImage protbin;
    private StructuringElement seope = new StructuringElement(new Object[]{5, -1});
    private StructuringElement seasf = new StructuringElement(new Object[]{3, -2});
    private StructuringElement seero = new StructuringElement(new Object[]{3, -1});
    public Display display = null;

    public HPA() {
        this.sobel.Parameters(2);
    }

    public void Segmentation(String inputfolder, String outputfolder, int nbCPU) throws Exception {
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        File[] folders = new File(inputfolder).listFiles();
        for (int f = 0; f < folders.length; ++f) {
            if (!folders[f].isDirectory()) continue;
            Object[] images = folders[f].listFiles();
            Arrays.sort(images);
            File out = new File(outputfolder + "/" + folders[f].getName() + "/");
            if (!out.exists()) {
                out.mkdirs();
            }
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!((File)images[i2]).isFile() || !((File)images[i2]).getName().contains(".png")) continue;
                try {
                    File imfile = new File(out.getAbsolutePath() + "/" + ((File)images[i2]).getName());
                    if (imfile.exists()) continue;
                    if (!((File)images[i2]).getName().contains("blue")) {
                        throw new Error("Bug blue: " + ((File)images[i2]).getName());
                    }
                    BufferedImage imdna = ImageIO.Read(((File)images[i2++]).getAbsolutePath());
                    if (!((File)images[i2]).getName().contains("green")) {
                        throw new Error("Bug green: " + ((File)images[i2]).getName());
                    }
                    BufferedImage imer = ImageIO.Read(((File)images[i2++]).getAbsolutePath());
                    if (!((File)images[++i2]).getName().contains("yellow")) {
                        throw new Error("Bug yellow: " + ((File)images[i2]).getName());
                    }
                    BufferedImage improteins = ImageIO.Read(((File)images[i2]).getAbsolutePath());
                    if (this.imtmp1 == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)imer, (BufferedImage)this.imtmp1)) {
                        this.imtmp1 = null;
                        this.imtmp1 = ImageNew.Same((BufferedImage)imer);
                        this.imtmp2 = null;
                        this.imtmp2 = ImageNew.Same((BufferedImage)imer);
                        this.imtmp3 = null;
                        this.imtmp3 = ImageNew.Same((BufferedImage)imer);
                        this.dnabin = null;
                        this.dnabin = ImageNew.SameBinary((BufferedImage)imer);
                        this.markers = null;
                        this.markers = ImageNew.Same((BufferedImage)imer);
                        this.tmpbin1 = null;
                        this.tmpbin1 = ImageNew.SameBinary((BufferedImage)imer);
                        this.tmpbin2 = null;
                        this.tmpbin2 = ImageNew.SameBinary((BufferedImage)imer);
                        this.protbin = null;
                        this.protbin = ImageNew.SameBinary((BufferedImage)imer);
                    }
                    this.opening.Filter(imdna, this.seope, this.imtmp1, nbCPU);
                    ImageComparator.Compare((BufferedImage)this.imtmp1, (String)"!=", (int)0, (BufferedImage)imdna, (int)0, (BufferedImage)this.imtmp1);
                    this.asfco.Filter(this.imtmp1, this.seasf, this.imtmp2, nbCPU);
                    this.erode.Filter(this.imtmp2, this.seero, this.imtmp3, nbCPU);
                    this.binary.Filter(this.imtmp3, 13, this.tmpbin1, nbCPU);
                    this.ccl.Label(this.tmpbin1, 0, true);
                    this.ccl.DeleteSmallerThan(this.tmpbin1, 10000);
                    this.ccl.DeleteOnBorder(this.tmpbin1, new int[0]);
                    this.fh.Fill(this.tmpbin1, (ConnectedComponentLabeling)this.ccl, 1000000, true, this.dnabin);
                    this.ccl.Label(this.dnabin, 0, true);
                    ImageComparator.Compare((BufferedImage)this.dnabin, (String)"!=", (int)0, (BufferedImage)imdna, (int)0, (BufferedImage)imdna);
                    this.asfco.Filter(improteins, this.seasf, this.imtmp1, nbCPU);
                    this.ch.Filter(this.imtmp1, this.imtmp2, nbCPU);
                    ImageComparator.Compare((BufferedImage)this.dnabin, (String)"!=", (int)0, (BufferedImage)this.imtmp2, (int)0, (BufferedImage)this.markers);
                    this.ub.Filter(this.imtmp2, this.markers, this.imtmp3, nbCPU);
                    this.li.Filter(this.imtmp3, this.tmpbin1, 0, nbCPU);
                    this.triangle.Filter(this.imtmp3, this.tmpbin2, 0, nbCPU);
                    ImageOperations.Maximum((BufferedImage)this.tmpbin1, (BufferedImage)this.tmpbin2, (BufferedImage)this.protbin);
                    ImageOperations.Maximum((BufferedImage)this.protbin, (BufferedImage)this.dnabin, (BufferedImage)this.protbin);
                    ImageArithmetic.Add(imdna, 1, imdna, 255, 255);
                    ImageComparator.Compare((BufferedImage)this.dnabin, (String)"!=", (int)0, (BufferedImage)imdna, (int)0, (BufferedImage)imdna);
                    ImageArithmetic.Add(improteins, 1, improteins, 255, 255);
                    ImageComparator.Compare((BufferedImage)this.protbin, (String)"!=", (int)0, (BufferedImage)improteins, (int)0, (BufferedImage)improteins);
                    ImageArithmetic.Add(imer, 1, imer, 255, 255);
                    ImageComparator.Compare((BufferedImage)this.protbin, (String)"!=", (int)0, (BufferedImage)imer, (int)0, (BufferedImage)imer);
                    ImageIO.Write(imdna, out.getAbsolutePath() + "/" + ((File)images[i2 - 3]).getName(), 6);
                    ImageIO.Write(imer, out.getAbsolutePath() + "/" + ((File)images[i2 - 2]).getName(), 6);
                    ImageIO.Write(improteins, out.getAbsolutePath() + "/" + ((File)images[i2]).getName(), 6);
                    continue;
                }
                catch (Exception E) {
                    E.printStackTrace();
                    log.addNewException(E, new String[0]);
                    continue;
                }
                catch (Error E) {
                    E.printStackTrace();
                    log.addNewError(E, new String[0]);
                }
            }
        }
        System.out.println(log.Resume());
        log.Stop();
    }

    public void PointCleaner(String inputfolder) throws Exception {
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        File[] folders = new File(inputfolder).listFiles();
        for (int f = 0; f < folders.length; ++f) {
            if (!folders[f].isDirectory()) continue;
            Object[] images = folders[f].listFiles();
            Arrays.sort(images);
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!((File)images[i2]).isFile() || !((File)images[i2]).getName().contains(".png") || ((File)images[i2]).getName().charAt(0) != '.') continue;
                FilesFolders.Delete((File)images[i2]);
            }
        }
        System.out.println(log.Resume());
        log.Stop();
    }

    public void ProcessProteinFile() throws Exception {
        FichierTabule fp = new FichierTabule("/Volumes/SP PHD U3/Datasets/HPA/protein_directory.txt", true);
        fp.SelectWhere("annotation", 6, ",");
        fp.ExcludeSelectedRows();
        FichierTabule fsingle = FichierTabuleTools.DeleteExcludedRows(fp);
        FichierTabule fres = new FichierTabule(fsingle.Height() * 2, fsingle.ColumnType(), "");
        int line = 0;
        fsingle.SelectWhere("Images", 6, ";");
        int row = fsingle.FirstSelected();
        do {
            String s = fsingle.getValueString(row, 0);
            int pos = s.indexOf(59);
            fres.setValue(line, 0, s.substring(0, pos));
            fres.setValue(line++, 1, fsingle.getValueString(row, 1));
            fres.setValue(line, 0, s.substring(pos + 1, s.length()));
            fres.setValue(line++, 1, fsingle.getValueString(row, 1));
        } while ((row = fsingle.NextSelected()) != -1);
        for (int i2 = 0; i2 < fres.Height() - 4; ++i2) {
            String s = fres.getValueString(i2, 0);
            int pos = s.indexOf(47);
            fres.setValue(i2, 0, s.substring(pos + 1, s.length()));
        }
        fres.Write("/Volumes/SP PHD U3/Datasets/HPA/HPA_Annotations.txt", false);
    }

    public void Process_IF_atlas_5_sub() throws Exception {
        FichierTabule f = new FichierTabule("/Volumes/SP PHD U3/Datasets/HPA_ReAnnotated/IF_atlas_5_sub.txt", true);
        f.setSelectedColumn("loc_Granular", true);
        f.ExcludeSelectedColumns();
        f = FichierTabuleTools.DeleteExcludedColumns(f);
        FichierTabule result = new FichierTabule(2000, new int[]{2, 2}, "");
        result.setColumnsNames(new String[]{"Image", "Class"});
        int row = 0;
        for (int y = 0; y < f.Height(); ++y) {
            for (int x = 3; x < f.Width(); ++x) {
                if (f.getValueInt(y, x) == 0) continue;
                try {
                    String stain = f.getValueString(y, 2);
                    if (stain.equalsIgnoreCase("Weak")) continue;
                    int plate = f.getValueInt(y, 0);
                    String position = f.getValueString(y, 1);
                    File output = new File("/Volumes/SP PHD U3/Datasets/HPA_ReAnnotated/Images/" + plate + "/");
                    if (!output.exists()) {
                        output.mkdirs();
                    }
                    String image = plate + "_" + position + "_" + (stain.equalsIgnoreCase("Strong") ? "1" : "2");
                    String link = "/Volumes/SP PHD U3/Datasets/HPA/Images/" + plate + "/" + image;
                    result.setValue(row, 0, image + "_green.png");
                    result.setValue(row++, 1, f.getColumnName(x));
                    continue;
                }
                catch (Exception E) {
                    E.printStackTrace();
                }
            }
        }
        result.Write("/Volumes/SP PHD U3/Datasets/HPA_ReAnnotated/HPA_ReAnnotations.txt", false);
    }

    public void BuildWorkingSet() throws Exception {
        FichierTabule f = new FichierTabule("/Volumes/SP PHD U3/Datasets/HPA/HPA_Annotations.txt", true);
        String input = "/Volumes/SP PHD U3/Datasets/HPA_lib (png)/";
        String output = "/Volumes/SP PHD U3/Datasets/HPA/WorkingSet/";
        int nb = 0;
        for (int i2 = 0; i2 < f.Height(); ++i2) {
            String link;
            File in;
            String s = f.getValueString(i2, 0);
            int position = Integer.valueOf(s.substring(0, s.indexOf(95)));
            File folderout = new File(output + "/" + position + "/");
            if (!folderout.exists()) {
                folderout.mkdirs();
            }
            if ((in = new File(input + (link = position + "/" + s.replace("green.png", "")) + "blue.png")).exists()) {
                FilesFolders.CopyFile(in, new File(output + link + "blue.png"));
                FilesFolders.CopyFile(new File(input + link + "green.png"), new File(output + link + "green.png"));
                FilesFolders.CopyFile(new File(input + link + "red.png"), new File(output + link + "red.png"));
                FilesFolders.CopyFile(new File(input + link + "yellow.png"), new File(output + link + "yellow.png"));
                continue;
            }
            System.out.println(nb++ + ": File not found: " + link);
        }
    }

    public void RecupMissed() throws Exception {
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        File[] input = new File("/Volumes/SP PHD U3/Datasets/HPA_lib (Rough)/").listFiles();
        String output = "/Volumes/SP PHD U3/Datasets/HPA_lib (png)/";
        LinkedList<String> list = new LinkedList<String>();
        int nb = 0;
        int nbexist = 0;
        for (int i2 = 0; i2 < input.length; ++i2) {
            if (!input[i2].isDirectory()) continue;
            File[] plates = new File(input[i2].getAbsolutePath() + "/images/HPA/images/IFconfocal/").listFiles();
            for (int p = 0; p < plates.length; ++p) {
                if (!plates[p].isDirectory()) continue;
                File[] images = new File(plates[p].getAbsolutePath()).listFiles();
                File folderout = new File(output + "/" + plates[p].getName());
                if (!folderout.exists()) {
                    folderout.mkdirs();
                }
                for (int im = 0; im < images.length; ++im) {
                    if (images[im].isFile() && images[im].getName().contains(".tif") && images[im].getName().charAt(0) != '.') {
                        try {
                            File out = new File(folderout.getAbsolutePath() + "/" + images[im].getName().replace(".tif", ".png"));
                            if (ListTools.isInList(list, (String)images[im].getName())) {
                                System.out.println("Souci: " + images[im].getName());
                                FilesFolders.Delete(images[im]);
                            } else {
                                list.add(images[im].getName());
                            }
                            if (out.exists() && out.isFile()) {
                                ++nbexist;
                                out = null;
                                continue;
                            }
                            BufferedImage image = ImageIO.Read(images[im].getAbsolutePath());
                            BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                            byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                            byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                            System.arraycopy(bbin, 0, bbres, 0, bbin.length);
                            ImageIO.Write(result, out.getAbsolutePath(), 6);
                            result = null;
                            image = null;
                        }
                        catch (Exception E) {
                            log.addNewException(E, new String[0]);
                            log.addComment(images[im].getName() + "\n\n");
                        }
                        continue;
                    }
                    if (!images[im].isFile() || !images[im].getName().contains(".tif") || images[im].getName().charAt(0) != '.') continue;
                    System.out.println(nb++ + " => " + images[im].getAbsolutePath());
                    FilesFolders.Delete(images[im]);
                }
            }
        }
        System.out.println("nbexists = " + nbexist);
        System.out.println(log.Resume());
    }

    public void CopyAndConvertRecup() throws Exception {
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        File[] input = new File("/Volumes/SP PHD U3/Datasets/HPA_lib (Rough)/").listFiles();
        String output = "/Volumes/SP PHD U3/Datasets/HPA_lib (png)/";
        for (int i2 = 0; i2 < input.length; ++i2) {
            if (!input[i2].isDirectory()) continue;
            File[] plates = new File(input[i2].getAbsolutePath() + "/images/HPA/images/IFconfocal/").listFiles();
            for (int p = 0; p < plates.length; ++p) {
                if (!plates[p].isDirectory()) continue;
                File[] images = new File(plates[p].getAbsolutePath()).listFiles();
                File folderout = new File(output + "/" + plates[p].getName());
                if (!folderout.exists()) {
                    folderout.mkdirs();
                }
                for (int im = 0; im < images.length; ++im) {
                    if (!images[im].isFile() || !images[im].getName().contains(".tif") || images[im].getName().charAt(0) == '.') continue;
                    File out = new File(folderout.getAbsolutePath() + "/" + images[im].getName().replace(".tif", ".png"));
                    boolean success = false;
                    BufferedImage image = null;
                    BufferedImage result = null;
                    try {
                        image = ImageIO.Read(out.getAbsolutePath());
                        if (image.getType() == 10) {
                            success = true;
                        }
                    }
                    catch (Exception E) {
                        System.out.println("\nFailed");
                    }
                    if (!success) {
                        try {
                            System.out.println("Try to recup: " + images[im].getName());
                            image = ImageIO.Read(images[im].getAbsolutePath());
                        }
                        catch (Exception E) {
                            log.addNewException(E, new String[0]);
                            log.addComment("Reading: " + input[i2].getName() + " => " + images[im].getName() + "\n\n");
                        }
                        result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                        byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                        System.arraycopy(bbin, 0, bbres, 0, bbin.length);
                        try {
                            ImageIO.Write(result, out.getAbsolutePath(), 6);
                        }
                        catch (Exception E) {
                            log.addNewException(E, new String[0]);
                            log.addComment("Writing: " + images[im].getName() + "\n\n");
                        }
                    }
                    result = null;
                    image = null;
                }
            }
        }
        System.out.println(log.Resume());
    }

    public void CopyAndConvert() throws Exception {
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        File[] input = new File("/Volumes/SP PHD U3/Datasets/HPA_lib (Rough)/").listFiles();
        String output = "/Volumes/SP PHD U3/Datasets/HPA_lib (png)/";
        for (int i2 = 0; i2 < input.length; ++i2) {
            if (!input[i2].isDirectory() || !input[i2].getName().contains(" ") || 27 > Integer.valueOf(input[i2].getName().substring(input[i2].getName().indexOf(32) + 1))) continue;
            File[] plates = new File(input[i2].getAbsolutePath() + "/images/HPA/images/IFconfocal/").listFiles();
            for (int p = 0; p < plates.length; ++p) {
                if (!plates[p].isDirectory()) continue;
                File[] images = new File(plates[p].getAbsolutePath()).listFiles();
                File folderout = new File(output + "/" + plates[p].getName());
                if (!folderout.exists()) {
                    folderout.mkdirs();
                }
                for (int im = 0; im < images.length; ++im) {
                    if (!images[im].isFile() || !images[im].getName().contains(".tif") || images[im].getName().charAt(0) == '.') continue;
                    try {
                        File out = new File(folderout.getAbsolutePath() + "/" + images[im].getName().replace(".tif", ".png"));
                        BufferedImage image = ImageIO.Read(images[im].getAbsolutePath());
                        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                        byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                        System.arraycopy(bbin, 0, bbres, 0, bbin.length);
                        ImageIO.Write(result, out.getAbsolutePath(), 6);
                        result = null;
                        image = null;
                        continue;
                    }
                    catch (Exception E) {
                        E.printStackTrace();
                        log.addNewException(E, new String[0]);
                        log.addComment(images[im].getName() + "\n\n");
                    }
                }
            }
        }
        System.out.println(log.Resume());
    }

    public void ConvertionMissed(String inputfolder) throws Exception {
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        File[] plates = new File(inputfolder).listFiles();
        for (int p = plates.length - 1; p >= 0; --p) {
            if (!plates[p].isDirectory()) continue;
            File[] images = new File(plates[p].getAbsolutePath()).listFiles();
            for (int im = 0; im < images.length; ++im) {
                if (!images[im].isFile() || !images[im].getName().contains(".png") || images[im].getName().charAt(0) == '.') continue;
                try {
                    BufferedImage image = ImageIO.Read(images[im].getAbsolutePath());
                    if (image.getType() == 10) {
                        image = null;
                        continue;
                    }
                    BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                    byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                    byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                    System.arraycopy(bbin, 0, bbres, 0, bbin.length);
                    ImageIO.Write(result, images[im].getAbsolutePath(), 6);
                    result = null;
                    image = null;
                    continue;
                }
                catch (Exception E) {
                    E.printStackTrace();
                    log.addNewException(E, new String[0]);
                    log.addComment(images[im].getName() + "\n\n");
                }
            }
        }
        System.out.println(log.Resume());
    }
}

