/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.keck.golds;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayTools;
import characterization.shapes.shapeIndexes.BesicovitchSymmetry;
import characterization.shapes.shapeIndexes.InscribedDiskGap;
import characterization.shapes.shapeIndexes.TiTiEllipseRadius;
import dataMining.classifiers.GenericClassifier;
import dataMining.imbalanceDataSet.DataSetBalancer;
import dataMining.imbalanceDataSet.WeightedSampling;
import displays.Colors;
import displays.Display;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import listTiTi.ListTools;
import mathematics.fitting.Gaussian2DFitter;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import measures.Measures2D;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.GeodesicDiameter;
import measures.histogram.Histogram;
import morphee.StructuringElement;
import morphee.adaptive.Aminima;
import morphee.filters.ASFilterCloseOpen;
import morphee.geodesic.OverBuild;
import morphee.rank.Rank;
import morphee.segmentation.watershed.Watershed;
import processing.filters.DynamicExpansionFV0;
import processing.filters.Invert;
import processing.thresholding.Binary;
import utils.LogFile;
import utils.pointers.IntPointer;
import weka.core.Instance;
import weka.core.Instances;

public class ImmunoGold {
    private Display display = null;
    private final ASFilterCloseOpen asfco = new ASFilterCloseOpen();
    private final Aminima amin = new Aminima();
    private final Binary binary = new Binary();
    private final DynamicExpansionFV0 dynexp = new DynamicExpansionFV0();
    private final Invert invert = new Invert();
    private final OverBuild ob = new OverBuild();
    private final UnionFindCcl ufccl = new UnionFindCcl();
    private final Watershed ws = new Watershed();
    private BufferedImage original = null;
    private BufferedImage borderprocessed = null;
    private BufferedImage localmin = null;
    private BufferedImage resamin = null;
    private BufferedImage localminnew = null;
    private BufferedImage marker = null;
    private BufferedImage prefilterdepthnew = null;
    private BufferedImage resasf = null;
    private BufferedImage candidates = null;
    private BufferedImage rebuiltcandidates = null;
    private BufferedImage detection = null;
    private BufferedImage bincand = null;
    private BufferedImage binrebcand = null;
    public int[] finalcandidates = null;
    private double contrast = -1.0;
    private BufferedImage[] golds = null;
    private final BesicovitchSymmetry besym = new BesicovitchSymmetry();
    private final StructuringElement sem = new StructuringElement(new Object[]{3, -15});
    private final Gaussian2DFitter gaussfit = new Gaussian2DFitter();
    private final InscribedDiskGap idg = new InscribedDiskGap();
    private final TiTiEllipseRadius terad = new TiTiEllipseRadius();
    private final GeodesicDiameter geodiam = new GeodesicDiameter();
    private final DataSetBalancer dsb = new WeightedSampling();
    private final int marge = 1;
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    private Histogram histogram = new Histogram();
    private int nbsplit = 0;
    private int CartoucheSize = -1;
    public boolean SEMmode = true;
    private Rank rank = new Rank();

    public ImmunoGold(Display display) {
        this.display = display;
    }

    public void NoiseDetection(String folderpath, String imtype, int percentage, int nbCPU) throws Exception {
        int counter = 0;
        int max = (int)(255.0 * (double)(100 - percentage) / 100.0 + 0.5);
        int min = (int)(255.0 * (double)percentage / 100.0 + 0.5);
        File[] folders = new File(folderpath).listFiles();
        BufferedImage constantnoisewhite = null;
        BufferedImage constantnoiseblack = null;
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        for (int f = 0; f < folders.length; ++f) {
            if (!folders[f].isDirectory()) continue;
            File[] images = new File(folders[f].getAbsolutePath()).listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().contains(imtype)) continue;
                try {
                    BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                    if (constantnoisewhite == null) {
                        constantnoisewhite = ImageNew.Same((BufferedImage)image);
                        constantnoiseblack = ImageNew.Same((BufferedImage)image);
                        ImageOperations.Fill((BufferedImage)constantnoiseblack, (int)0);
                        ImageOperations.Fill((BufferedImage)constantnoisewhite, (int)0);
                    } else if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)constantnoisewhite)) {
                        throw new Exception("Images have not identic dimensions and/or type.");
                    }
                    switch (image.getType()) {
                        case 10: {
                            byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                            byte[] bbblack = ((DataBufferByte)constantnoiseblack.getRaster().getDataBuffer()).getData();
                            byte[] bbwhite = ((DataBufferByte)constantnoisewhite.getRaster().getDataBuffer()).getData();
                            for (int x = 0; x < bb.length; ++x) {
                                if ((bb[x] & 0xFF) <= min) {
                                    bbblack[x] = (byte)((bbblack[x] & 0xFF) + 1);
                                    continue;
                                }
                                if (max > (bb[x] & 0xFF)) continue;
                                bbwhite[x] = (byte)((bbwhite[x] & 0xFF) + 1);
                            }
                            bbwhite = null;
                            bbblack = null;
                            bb = null;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Image type not supported.");
                        }
                    }
                    ++counter;
                    image = null;
                    continue;
                }
                catch (Exception ex) {
                    log.addNewException(ex, new String[0]);
                    ex.printStackTrace();
                    continue;
                }
                catch (Error er) {
                    log.addNewError(er, new String[0]);
                    er.printStackTrace();
                }
            }
        }
        ImageComparator.Compare(constantnoiseblack, (String)">", (int)(counter >> 1), constantnoiseblack, (int)0, constantnoiseblack);
        ImageComparator.Compare(constantnoisewhite, (String)">", (int)(counter >> 1), constantnoisewhite, (int)0, constantnoisewhite);
        ImageIO.Write(constantnoiseblack, "NoiseBlack.png", 6);
        ImageIO.Write(constantnoisewhite, "NoiseWhite.png", 6);
        log.Stop();
        System.out.println(log.Resume());
    }

    public void GroundTruthExtraction(String rootfolder, String outputfolder) {
        int nbsouci = 0;
        File fout = null;
        File[] files = new File(rootfolder).listFiles();
        for (int f = 0; f < files.length; ++f) {
            if (!files[f].isDirectory()) continue;
            fout = new File(outputfolder + "/" + files[f].getName());
            if (!fout.exists()) {
                fout.mkdirs();
            }
            File[] images = new File(files[f].getAbsolutePath()).listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !this.isImageExtension(images[i2].getName())) continue;
                try {
                    BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                    WritableRaster imras = image.getRaster();
                    int height = image.getHeight();
                    int width = image.getWidth();
                    BufferedImage groundtruth = new BufferedImage(width, height, 12);
                    WritableRaster gtras = groundtruth.getRaster();
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            if (imras.getSample(x, y, 0) == imras.getSample(x, y, 1) && imras.getSample(x, y, 0) == imras.getSample(x, y, 2) && imras.getSample(x, y, 1) == imras.getSample(x, y, 2)) continue;
                            gtras.setSample(x, y, 0, 1);
                        }
                    }
                    ImageIO.Write(groundtruth, fout.getAbsolutePath() + "/" + images[i2].getName(), 6);
                    groundtruth = null;
                    image = null;
                    gtras = null;
                    imras = null;
                    continue;
                }
                catch (Exception E) {
                    ++nbsouci;
                    E.printStackTrace();
                }
            }
            fout = null;
        }
        System.out.println("Process over, with " + nbsouci + " problems.");
    }

    private boolean isImageExtension(String name) {
        int pointpos = name.indexOf(46);
        if (pointpos < 0) {
            return false;
        }
        String sub = name.substring(pointpos);
        if (sub.contains("png")) {
            return true;
        }
        return sub.contains("tif");
    }

    public void Evaluate(FichierTabule detections, String output) throws Exception {
        LogFile log = new LogFile();
        log.StartNewLog(this, output);
        detections.ClearAll();
        DataOutputStream out = new DataOutputStream(new FileOutputStream(output + "/Informations.txt"));
        int colbox = detections.ColumnNumber("box");
        int colim = detections.ColumnNumber("image");
        int colmag = detections.ColumnNumber("magnification");
        int colclass = detections.ColumnNumber("Class");
        int colproba = detections.ColumnNumber("Probability");
        int[] types = new int[7];
        Arrays.fill(types, 1);
        types[4] = 0;
        types[3] = 0;
        types[2] = 0;
        types[1] = 0;
        String[] names = new String[]{"Magnifications", "TP", "TN", "FP", "FN", "Sensibility", "Specificity"};
        FichierTabule curves = new FichierTabule(113, types, "curves");
        curves.setColumnsNames(names);
        int nbimages = 0;
        int FN = 0;
        int FP = 0;
        int TN = 0;
        int TP = 0;
        List images = ArrayTools.ListOfUniqueItems((String[])detections.getColumnString(colim));
        Iterator imit = images.iterator();
        while (imit.hasNext()) {
            try {
                String imname = (String)imit.next();
                detections.SelectWhere(colim, 6, imname);
                int y = detections.FirstSelected();
                out.write((detections.getValueString(y, colbox) + " / " + detections.getValueString(y, colim) + "\n").getBytes("ASCII"));
                out.write((detections.nbSelected() + " instances\n").getBytes("ASCII"));
                detections.SelectFromSelectionWhere(colclass, 0, "Gold");
                detections.SelectFromSelectionWhere(colproba, 3, 0.5);
                int tp = detections.nbSelected();
                out.write(String.valueOf("TP: " + tp + "\n").getBytes("ASCII"));
                detections.ClearSelectionRows();
                detections.SelectWhere(colim, 6, imname);
                detections.SelectFromSelectionWhere(colclass, 0, "Other");
                detections.SelectFromSelectionWhere(colproba, 2, 0.5);
                int tn = detections.nbSelected();
                out.write(String.valueOf("TN: " + tn + "\n").getBytes("ASCII"));
                detections.ClearSelectionRows();
                detections.SelectWhere(colim, 6, imname);
                detections.SelectFromSelectionWhere(colclass, 0, "Gold");
                detections.SelectFromSelectionWhere(colproba, 2, 0.5);
                int fn = detections.nbSelected();
                out.write(String.valueOf("FN: " + fn + "\n").getBytes("ASCII"));
                detections.ClearSelectionRows();
                detections.SelectWhere(colim, 6, imname);
                detections.SelectFromSelectionWhere(colclass, 0, "Other");
                detections.SelectFromSelectionWhere(colproba, 3, 0.5);
                int fp = detections.nbSelected();
                out.write(String.valueOf("FP: " + fp + "\n").getBytes("ASCII"));
                out.write(String.valueOf("Sensibility: " + (double)tp / (double)(tp + fn) + "\n").getBytes("ASCII"));
                out.write(String.valueOf("Specificity: " + (double)tn / (double)(tn + fp) + "\n\n\n").getBytes("ASCII"));
                TP += tp;
                TN += tn;
                FP += fp;
                FN += fn;
                detections.ClearSelection();
                curves.setValue(nbimages, 0, detections.getValueDouble(y, colmag));
                curves.setValue(nbimages, 1, tp);
                curves.setValue(nbimages, 2, tn);
                curves.setValue(nbimages, 3, fp);
                curves.setValue(nbimages, 4, fn);
                curves.setValue(nbimages, 5, (double)tp / (double)(tp + fn));
                curves.setValue(nbimages, 6, (double)tn / (double)(tn + fp));
                ++nbimages;
            }
            catch (Exception E) {
                log.addNewException(E, new String[0]);
                E.printStackTrace();
            }
        }
        out.write(String.valueOf("Global:\n").getBytes("ASCII"));
        out.write(String.valueOf("TP: " + TP + "\n").getBytes("ASCII"));
        out.write(String.valueOf("TN: " + TN + "\n").getBytes("ASCII"));
        out.write(String.valueOf("FN: " + FN + "\n").getBytes("ASCII"));
        out.write(String.valueOf("FP: " + FP + "\n").getBytes("ASCII"));
        out.write(String.valueOf("Sensibility: " + (double)TP / (double)(TP + FN) + "\n").getBytes("ASCII"));
        out.write(String.valueOf("Specificity: " + (double)TN / (double)(TN + FP)).getBytes("ASCII"));
        out.close();
        for (int x = nbimages; x < curves.Height(); ++x) {
            curves.setSelected(x, true);
        }
        curves.ExcludeSelected();
        curves = FichierTabuleTools.DeleteExcluded(curves);
        FichierTabuleTools.Sort(curves, 0);
        curves.Write(output + "/Curves.txt", false);
    }

    public FichierTabule Classification(String originalpath, List<GenericClassifier> classifiers, FichierTabule dataset, String outputpath, boolean drawall, int nbCPU) throws Exception {
        int i2;
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        int colbox = dataset.ColumnNumber("box");
        int colim = dataset.ColumnNumber("image");
        int colposx = dataset.ColumnNumber("posx");
        int colposy = dataset.ColumnNumber("posy");
        int colwidth = dataset.ColumnNumber("width");
        int colheight = dataset.ColumnNumber("height");
        BufferedImage imres = null;
        File output = null;
        int[] addcolumns = new int[classifiers.size() + 2];
        Arrays.fill(addcolumns, 1);
        addcolumns[addcolumns.length - 1] = 2;
        FichierTabule result = FichierTabuleTools.AddColumns(dataset, addcolumns);
        int pos = result.Width() - 2 - classifiers.size();
        for (i2 = 0; i2 < classifiers.size(); ++i2) {
            result.setColumnName(pos + i2, classifiers.get(i2).getClass().getSimpleName());
        }
        result.setColumnName(pos + i2++, "Probability");
        result.setColumnName(pos + i2++, "Prediction");
        List images = ArrayTools.ListOfUniqueItems((String[])dataset.getColumnString(colim));
        for (String imname : images) {
            BufferedImage image;
            dataset.ClearAll();
            dataset.SelectWhere(colim, 0, imname);
            dataset.setExcludedColumn(colbox, true);
            dataset.setExcludedColumn(colim, true);
            dataset.setExcludedColumn("number", true);
            dataset.setExcludedColumn("posx", true);
            dataset.setExcludedColumn("posy", true);
            dataset.setExcludedColumn("width", true);
            dataset.setExcludedColumn("height", true);
            dataset.setExcludedColumn("magnification", true);
            int row = dataset.NextSelected();
            if (originalpath != null) {
                image = ImageIO.Read(originalpath + "/" + dataset.getValueString(row, colbox) + "/" + dataset.getValueString(row, colim));
                imres = ImageTools.isColored((BufferedImage)image) ? ImageNew.Clone((BufferedImage)image) : ImageConverter.GrayToColor((BufferedImage)image);
                output = new File(outputpath + "/" + dataset.getValueString(row, colbox) + "/");
                if (!output.exists()) {
                    output.mkdirs();
                }
            }
            dataset.ExcludeSelected();
            FichierTabule training = FichierTabuleTools.DeleteExcluded(dataset);
            dataset.InverseExclusionRows();
            FichierTabule testset = FichierTabuleTools.DeleteExcluded(dataset);
            int col = result.Width() - classifiers.size() - 2;
            int posold = -113;
            int c = 0;
            while (c < classifiers.size()) {
                GenericClassifier gc = classifiers.get(c);
                gc.Train(training);
                pos = gc.ClassIndexOf("Gold");
                if (0 <= posold && pos != posold) {
                    throw new Error("0 <= posold && pos != posold. Must not occured!");
                }
                posold = pos;
                gc.Classify(testset);
                row = dataset.FirstSelected();
                double[][] probas = gc.Probabilities();
                for (i2 = 0; i2 < probas.length; ++i2) {
                    result.setValue(row, col, probas[i2][pos]);
                    row = dataset.NextSelected();
                }
                if (row != -1) {
                    throw new Error("Souci: " + row + " " + dataset.nbSelected() + " " + testset.Height());
                }
                ++c;
                ++col;
            }
            row = dataset.FirstSelected();
            while (row != -1) {
                double sum = 0.0;
                col = result.Width() - classifiers.size() - 2;
                for (c = 0; c < classifiers.size(); ++c) {
                    sum += result.getValueDouble(row, col++);
                }
                if (Double.compare(sum, 0.0) != 0) {
                    sum /= (double)classifiers.size();
                }
                result.setValue(row, col++, sum);
                result.setValue(row, col++, 0.5 <= sum ? "Gold" : "Other");
                if (imres != null) {
                    if (0.5 <= sum) {
                        ImageDrawer.Rectangle(imres, dataset.getValueInt(row, colposx), dataset.getValueInt(row, colposy), dataset.getValueInt(row, colposx) + dataset.getValueInt(row, colwidth), dataset.getValueInt(row, colposy) + dataset.getValueInt(row, colheight), 0, Colors.RED);
                    } else if (drawall) {
                        ImageDrawer.Rectangle(imres, dataset.getValueInt(row, colposx), dataset.getValueInt(row, colposy), dataset.getValueInt(row, colposx) + dataset.getValueInt(row, colwidth), dataset.getValueInt(row, colposy) + dataset.getValueInt(row, colheight), 0, Colors.CYAN);
                    }
                }
                row = dataset.NextSelected();
            }
            if (imres != null) {
                ImageIO.Write(imres, output.getAbsolutePath() + "/" + imname.replace(".tif", ".png"), 6);
            }
            image = null;
            imres = null;
        }
        log.Stop();
        System.out.println(log.Resume());
        return result;
    }

    public FichierTabule DetectCharacterizeLabel_BuildTrainingSet(String originalpath, String groundtruthpath, BufferedImage noise, FilenameFilter ff, int nbCPU) throws Exception {
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        Object out = null;
        FichierTabule resfile = null;
        FichierTabule magnifications = null;
        IntPointer row = new IntPointer();
        boolean create = noise == null;
        File[] boxes = new File(originalpath).listFiles();
        for (int box = 0; box < boxes.length; ++box) {
            if (!boxes[box].isDirectory()) continue;
            try {
                magnifications = new FichierTabule(boxes[box].getAbsolutePath() + "/Magnifications.txt", false);
                if (magnifications.Width() != 2) {
                    throw new IllegalArgumentException("The file Magnification.txt has not 2 columns.");
                }
                if (magnifications.ColumnType(0) != 2 || magnifications.ColumnType(1) != 2) {
                    throw new IllegalArgumentException("The file Magnification.txt does not contain only String columns.");
                }
            }
            catch (Exception E) {
                System.err.println("No Magnification.txt file.");
                E.printStackTrace();
                System.exit(0);
            }
            File[] images = new File(boxes[box].getAbsolutePath()).listFiles(ff);
            for (int i2 = 0; i2 < images.length; ++i2) {
                try {
                    ++this.nbsplit;
                    BufferedImage im = ImageIO.Read(images[i2].getAbsolutePath());
                    if (ImageTools.isColored((BufferedImage)im)) {
                        im = ImageConverter.RGB_To_GrayLevel((BufferedImage)im, (int)1);
                    }
                    BufferedImage gt = ImageIO.Read(groundtruthpath + "/" + boxes[box].getName() + "/" + images[i2].getName());
                    magnifications.SelectWhere(0, 0, images[i2].getName());
                    if (magnifications.nbSelected() != 1) {
                        throw new Exception("magnifications.nbSelected() != 1");
                    }
                    String mag = magnifications.getValueString(magnifications.FirstSelected(), 1);
                    String unity = mag.substring(mag.length() - 2);
                    if (!unity.contains("nm") && !unity.contains("mm")) {
                        throw new Exception("Unity unknown: '" + unity + "'");
                    }
                    String valmag = mag.substring(0, mag.length() - 2);
                    double magnification = Double.valueOf(valmag) * (unity.contains("mm") ? 1000.0 : 1.0);
                    if (this.SEMmode) {
                        this.ProcessCutBorders(im);
                    }
                    if (this.SEMmode) {
                        int radius = (int)(4.0 / magnification) + 1;
                        StructuringElement se = new StructuringElement(new Object[]{radius, -2});
                        BufferedImage resrank25 = this.rank.Filter(im, se, 75, nbCPU);
                        BufferedImage resrank50 = this.rank.Filter(im, se, 50, nbCPU);
                        BufferedImage resrank75 = this.rank.Filter(im, se, 25, nbCPU);
                        switch (im.getType()) {
                            case 10: {
                                byte[] bbres25 = ((DataBufferByte)resrank25.getRaster().getDataBuffer()).getData();
                                byte[] bbres50 = ((DataBufferByte)resrank50.getRaster().getDataBuffer()).getData();
                                byte[] bbres75 = ((DataBufferByte)resrank75.getRaster().getDataBuffer()).getData();
                                byte[] bbim = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
                                for (int x = 0; x < bbim.length; ++x) {
                                    bbim[x] = (byte)(255.0 - (double)((bbres25[x] & 0xFF) + (bbres50[x] & 0xFF) + (bbres75[x] & 0xFF)) / 3.0);
                                }
                                bbim = null;
                                bbres75 = null;
                                bbres50 = null;
                                bbres25 = null;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Image type not supported.");
                            }
                        }
                        resrank75 = null;
                        resrank50 = null;
                        resrank25 = null;
                        im = ImageNew.SubImageWH((BufferedImage)im, (int)0, (int)0, (int)im.getWidth(), (int)this.CartoucheSize);
                        gt = ImageNew.SubImageWH((BufferedImage)gt, (int)0, (int)0, (int)im.getWidth(), (int)this.CartoucheSize);
                        Objects.requireNonNull(this.AF);
                        this.contrast = this.IF.MichelsonFromRanks(im, -2);
                        im = this.dynexp.Filter(im, nbCPU);
                        System.gc();
                    }
                    ImageIO.Write(im, (this.nbsplit < 10 ? "0" : "") + this.nbsplit + "_ImageToProcess.png", 6);
                    System.out.println("Contrast = " + this.contrast);
                    row.value = 0;
                    FichierTabule resdet = this.DetectCharacterizeLabel(im, gt, create ? new BufferedImage(im.getWidth(), im.getHeight(), 12) : noise, magnification, row, boxes[box].getName(), images[i2].getName(), log, nbCPU);
                    if (resfile == null) {
                        resdet.SelectNull("image");
                        resdet.ExcludeSelected();
                        resfile = FichierTabuleTools.DeleteExcludedRows(resdet);
                    } else {
                        resfile = FichierTabuleTools.Merge(resfile, 0, resfile.Height(), resdet, 0, row.value);
                    }
                    System.gc();
                    continue;
                }
                catch (Exception E) {
                    log.addNewException(E, new String[0]);
                    E.printStackTrace();
                    System.gc();
                }
            }
        }
        log.Stop();
        System.out.println(log.Resume());
        return resfile;
    }

    private FichierTabule DetectCharacterizeLabel(BufferedImage image, BufferedImage gt, BufferedImage noise, double magnification, IntPointer row, String box, String imname, LogFile log, int nbCPU) throws Exception {
        if (gt != null && !ImageTools.areDimensionsEqual((BufferedImage)image, (BufferedImage)gt) || !ImageTools.areDimensionsEqual((BufferedImage)image, (BufferedImage)noise)) {
            throw new IllegalArgumentException("image, gt, noise have different dimensions.");
        }
        int asfradius = (int)(14.0 / magnification) + 1;
        boolean eightconnex = true;
        this.Allocations(image);
        this.borderprocessed = this.original = image;
        int percentageheight = this.SEMmode ? (int)(43.0 * this.contrast) : 43;
        System.out.println("PercentageHeight: " + percentageheight);
        this.PreFilterDepthNew(this.borderprocessed, asfradius, percentageheight, eightconnex, this.prefilterdepthnew, nbCPU);
        this.CandidateDetection(this.prefilterdepthnew, asfradius, percentageheight, this.candidates, nbCPU);
        this.binary.Filter(this.candidates, 1, this.bincand, nbCPU);
        this.RebuildFromMarkers(this.SEMmode ? (int)(27.0 * (1.0 - (1.0 - this.contrast) / 2.0)) : 27, this.rebuiltcandidates);
        ImageArithmetic.Subtract(this.resasf, this.rebuiltcandidates, this.detection, 0, 0);
        ImageArithmetic.Add(this.detection, 1, this.detection, 255, 255);
        ImageComparator.Compare((BufferedImage)this.rebuiltcandidates, (String)"!=", (int)0, (BufferedImage)this.detection, (int)0, (BufferedImage)this.detection);
        this.binary.Filter(this.detection, 1, this.binrebcand, nbCPU);
        this.SplitCandidates(image, magnification, eightconnex);
        this.ufccl.Label(this.binrebcand, 0, eightconnex);
        this.golds = this.ufccl.SeparateAllComponents(this.detection, 1, 1);
        return this.CharacterizationLabeling(this.golds, magnification, noise, gt, row, box, imname, log);
    }

    private void SplitCandidates(BufferedImage image, double magnification, boolean eightconnex) throws IOException {
        ArrayList vector;
        int i2;
        int x;
        int y;
        int width = this.original.getWidth();
        int height = this.original.getHeight();
        StructuringElement se = new StructuringElement(new Object[]{1, eightconnex ? -2 : -1});
        BufferedImage im = ImageConverter.GrayToColor((BufferedImage)image);
        LinkedList<CoordinatesWeighted> listin = new LinkedList<CoordinatesWeighted>();
        LinkedList listout = new LinkedList();
        this.ufccl.Label(this.bincand, 0, eightconnex);
        int[] labelcand = Arrays.copyOf(this.ufccl.Labels1D(), this.ufccl.Labels1D().length);
        int[] sizes = Arrays.copyOf(this.ufccl.Sizes(), this.ufccl.Sizes().length);
        int pos = 0;
        for (y = 0; y < image.getHeight(); ++y) {
            x = 0;
            while (x < image.getWidth()) {
                if (labelcand[pos] != 0) {
                    im.getRaster().setSample(x, y, 0, 255);
                    im.getRaster().setSample(x, y, 1, 0);
                    im.getRaster().setSample(x, y, 2, 0);
                }
                ++x;
                ++pos;
            }
        }
        ImageIO.Write(im, (this.nbsplit < 10 ? "0" : "") + this.nbsplit + "_BinCandBefore.png", 6);
        this.ufccl.Label(this.binrebcand, 0, eightconnex);
        int[] labelrebcand = this.ufccl.Labels1D();
        ArrayList[] tosplit = new ArrayList[this.ufccl.ConnectedComponentsNumber() + 1];
        this.ufccl.ComputeBoundingBoxes();
        int[] minx = this.ufccl.minx();
        int[] maxx = this.ufccl.maxx();
        int[] miny = this.ufccl.miny();
        int[] maxy = this.ufccl.maxy();
        im = ImageConverter.GrayToColor((BufferedImage)image);
        for (i2 = 1; i2 < minx.length; ++i2) {
            float[] color = null;
            switch (i2 % 6) {
                case 0: {
                    color = Colors.RED;
                    break;
                }
                case 1: {
                    color = Colors.GREEN;
                    break;
                }
                case 2: {
                    color = Colors.BLUE;
                    break;
                }
                case 3: {
                    color = Colors.YELLOW;
                    break;
                }
                case 4: {
                    color = Colors.CYAN;
                    break;
                }
                case 5: {
                    color = Colors.PURPLE;
                    break;
                }
                default: {
                    throw new Error("BUG: Must not occur.");
                }
            }
            ImageDrawer.Rectangle(im, minx[i2], miny[i2], maxx[i2], maxy[i2], 0, color);
        }
        ImageIO.Write(im, (this.nbsplit < 10 ? "0" : "") + this.nbsplit + "_BinCandRebuilt.png", 6);
        for (i2 = 0; i2 < labelcand.length; ++i2) {
            if (labelrebcand[i2] == 0) continue;
            int lc = labelcand[i2];
            int lbc = labelrebcand[i2];
            vector = tosplit[lbc];
            if (lc == 0) continue;
            if (tosplit[lbc] == null) {
                tosplit[lbc] = new ArrayList(5);
                tosplit[lbc].add(lc);
                continue;
            }
            if (ListTools.isInList((List)vector, (int)lc)) continue;
            vector.add(lc);
        }
        for (i2 = 0; i2 < tosplit.length; ++i2) {
            if (tosplit[i2] == null || tosplit[i2].size() == 1) continue;
            vector = tosplit[i2];
            int max = sizes[(Integer)tosplit[i2].get(0)];
            for (x = 1; x < vector.size(); ++x) {
                y = sizes[(Integer)tosplit[i2].get(x)];
                if (y == 0) {
                    System.err.println("Souci y=0");
                }
                if (max >= y) continue;
                max = y;
            }
            max >>= 1;
            x = 0;
            while (x < vector.size()) {
                int v = (Integer)tosplit[i2].get(x);
                y = sizes[v];
                if (y < max) {
                    sizes[v] = 0;
                    ArrayComparator.Compare((int[])labelcand, (String)"!=", (int)v, (int[])labelcand, (int)0, (int[])labelcand);
                    vector.remove(x);
                    continue;
                }
                ++x;
            }
        }
        im = ImageConverter.GrayToColor((BufferedImage)image);
        pos = 0;
        for (y = 0; y < image.getHeight(); ++y) {
            x = 0;
            while (x < image.getWidth()) {
                if (labelcand[pos] != 0) {
                    im.getRaster().setSample(x, y, 0, 255);
                    im.getRaster().setSample(x, y, 1, 0);
                    im.getRaster().setSample(x, y, 2, 0);
                }
                ++x;
                ++pos;
            }
        }
        ImageIO.Write(im, (this.nbsplit < 10 ? "0" : "") + this.nbsplit + "_BinCandAfter.png", 6);
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (labelrebcand[pos] != 0 && tosplit[labelrebcand[pos]].size() != 1) {
                    listin.add(new CoordinatesWeighted(x, y, 0, pos, labelrebcand[pos]));
                }
                ++x;
                ++pos;
            }
        }
        if (listin.isEmpty()) {
            tosplit = null;
            return;
        }
        System.out.println("listin = " + listin.size());
        this.ws.watershed(this.prefilterdepthnew, listin, se);
        BufferedImage borders = this.ws.Edges();
        listin.clear();
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (labelcand[pos] != 0 && sizes[labelcand[pos]] != 0) {
                    listin.add(new CoordinatesWeighted(x, y, 0, pos, labelcand[pos]));
                }
                ++x;
                ++pos;
            }
        }
        int size = this.AF.Maximum(labelcand) + 1;
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (borders.getRaster().getSample(x, y, 0) != 0 && labelrebcand[pos] == 0) {
                    listin.add(new CoordinatesWeighted(x, y, 0, pos, size));
                }
                ++x;
                ++pos;
            }
        }
        this.ws.watershed(this.prefilterdepthnew, listin, se);
        ImageComparator.Compare((BufferedImage)this.ws.Basins(), (String)"!=", (int)size, (BufferedImage)this.ws.Basins(), (int)0, (BufferedImage)this.ws.Basins());
        this.finalcandidates = Arrays.copyOf(((DataBufferInt)this.ws.Basins().getRaster().getDataBuffer()).getData(), ((DataBufferInt)this.ws.Basins().getRaster().getDataBuffer()).getData().length);
        ArrayComparator.Compare((int[])labelrebcand, (String)"!=", (int)0, (int[])this.finalcandidates, (int)0, (int[])this.finalcandidates);
        int[] check = ArrayNew.Same((int[])this.finalcandidates);
        for (x = 0; x < check.length; ++x) {
            check[x] = this.finalcandidates[x] == 0 && labelrebcand[x] != 0 ? 1 : 0;
        }
        ArrayList<Coordinates> list = new ArrayList<Coordinates>(1013);
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (check[pos] != 0) {
                    list.add(new Coordinates(x, y));
                }
                ++x;
                ++pos;
            }
        }
        while (!list.isEmpty()) {
            i2 = 0;
            size = list.size();
            while (i2 < list.size()) {
                Coordinates c = (Coordinates)list.get(i2);
                pos = c.X + c.Y * width;
                if (this.finalcandidates[pos - 1] != 0) {
                    this.finalcandidates[pos] = this.finalcandidates[pos - 1];
                    list.remove(i2);
                    continue;
                }
                if (this.finalcandidates[pos + 1] != 0) {
                    this.finalcandidates[pos] = this.finalcandidates[pos + 1];
                    list.remove(i2);
                    continue;
                }
                if (this.finalcandidates[pos - width] != 0) {
                    this.finalcandidates[pos] = this.finalcandidates[pos - width];
                    list.remove(i2);
                    continue;
                }
                if (this.finalcandidates[pos + width] != 0) {
                    this.finalcandidates[pos] = this.finalcandidates[pos + width];
                    list.remove(i2);
                    continue;
                }
                if (this.finalcandidates[pos - width - 1] != 0) {
                    this.finalcandidates[pos] = this.finalcandidates[pos - width - 1];
                    list.remove(i2);
                    continue;
                }
                if (this.finalcandidates[pos - width + 1] != 0) {
                    this.finalcandidates[pos] = this.finalcandidates[pos - width + 1];
                    list.remove(i2);
                    continue;
                }
                if (this.finalcandidates[pos + width - 1] != 0) {
                    this.finalcandidates[pos] = this.finalcandidates[pos + width - 1];
                    list.remove(i2);
                    continue;
                }
                if (this.finalcandidates[pos + width + 1] != 0) {
                    this.finalcandidates[pos] = this.finalcandidates[pos + width + 1];
                    list.remove(i2);
                    continue;
                }
                ++i2;
            }
            if (list.size() != size) continue;
        }
        for (x = 0; x < check.length; ++x) {
            check[x] = this.finalcandidates[x] == 0 && labelrebcand[x] != 0 ? 1 : 0;
        }
        if (0 < (int)this.AF.Integral(check)) {
            System.err.println("Souci: 0 < (int)ArrayFeatures.Integral(check)");
        }
        this.ufccl.Label(this.finalcandidates, width, height, 0, eightconnex);
        System.arraycopy(this.ufccl.Labels1D(), 0, this.finalcandidates, 0, this.finalcandidates.length);
    }

    private FichierTabule CharacterizationLabeling(BufferedImage[] candidates, double magnification, BufferedImage noise, BufferedImage groundtruth, IntPointer row, String foldername, String imname, LogFile log) throws Exception {
        int x;
        int y;
        double pixelsurface = magnification * magnification;
        Coordinates coord = new Coordinates(0, 0);
        double[] buffer = new double[1013];
        int[] types = new int[30];
        Arrays.fill(types, 1);
        types[4] = 0;
        types[20] = 2;
        types[21] = 2;
        types[22] = 0;
        types[23] = 0;
        types[24] = 0;
        types[25] = 0;
        types[26] = 0;
        types[29] = 2;
        String[] names = new String[types.length];
        names[0] = "Surface";
        names[1] = "RadiusAve";
        names[2] = "RadiusMin";
        names[3] = "RadiusMax";
        names[4] = "Height";
        names[5] = "PerHeight";
        names[6] = "PerHeightAve";
        names[7] = "PerHeightMed";
        names[8] = "Average";
        names[9] = "Variance";
        names[10] = "Skewness";
        names[11] = "Kurtosis";
        names[12] = "Contrast";
        names[13] = "Michelson";
        names[14] = "Symmetry";
        names[15] = "CircularityDisk";
        names[16] = "CircularityRadius";
        names[17] = "GaussSigma";
        names[18] = "GaussError";
        names[19] = "Length";
        names[20] = "box";
        names[21] = "image";
        names[22] = "number";
        names[23] = "posx";
        names[24] = "posy";
        names[25] = "width";
        names[26] = "height";
        names[27] = "magnification";
        names[28] = "Probability";
        names[29] = "Class";
        FichierTabule resfile = new FichierTabule(candidates.length, types, "GoldvsNonGoldProfiles");
        resfile.setColumnsNames(names);
        int[] isgold = null;
        if (groundtruth != null) {
            int[] labels = this.ufccl.Labels1D();
            isgold = new int[this.ufccl.ConnectedComponentsNumber() + 1];
            int pos = 0;
            for (y = 0; y < groundtruth.getHeight(); ++y) {
                x = 0;
                while (x < groundtruth.getWidth()) {
                    if (groundtruth.getRaster().getSample(x, y, 0) != 0) {
                        isgold[labels[pos]] = 1;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        int[] sizes = this.ufccl.Sizes();
        int[] minix = this.ufccl.minx();
        int[] miniy = this.ufccl.miny();
        int[] maxix = this.ufccl.maxx();
        int[] maxiy = this.ufccl.maxy();
        for (int c = 0; c < candidates.length; ++c) {
            try {
                BufferedImage im = candidates[c];
                int minx = minix[c + 1] - 1;
                int miny = miniy[c + 1] - 1;
                if (im == null) {
                    throw new Error("BUG !!!!!");
                }
                boolean found = false;
                for (y = 0; y < im.getHeight(); ++y) {
                    for (x = 0; !found && x < im.getWidth(); ++x) {
                        if (im.getRaster().getSample(x, y, 0) == 0 || noise.getRaster().getSample(minx + x, miny + y, 0) == 0) continue;
                        found = true;
                    }
                }
                if (found || sizes[c + 1] < 4) continue;
                int col = 0;
                this.IF.Moments(im, 0);
                this.IF.Contrast(im, 0);
                this.IF.Michelson(im, 0);
                Measures2D measures = new Measures2D(this.binary.Filter(im, 1, 1));
                measures.Basics(true, false);
                measures.DistanceMapAndDiskMax(this.sem);
                measures.EuclidianRadii();
                this.besym.Compute(measures);
                this.idg.Compute(measures);
                this.terad.Compute(measures);
                resfile.setValue(row.value, col++, (double)sizes[c + 1] * pixelsurface);
                resfile.setValue(row.value, col++, measures.getAverageRadius() * magnification);
                resfile.setValue(row.value, col++, measures.getSmallestRadius() * magnification);
                resfile.setValue(row.value, col++, measures.getLongestRadius() * magnification);
                resfile.setValue(row.value, col++, this.IF.Maximum());
                int min = this.FindMin(this.original, this.ufccl.Labels1D(), c + 1, coord);
                resfile.setValue(row.value, col++, this.IF.Maximum() / ((double)min + this.IF.Maximum()) * 100.0);
                if (buffer.length < im.getWidth() * im.getHeight()) {
                    buffer = new double[im.getWidth() * im.getHeight()];
                }
                int nb = 0;
                double sum = 0.0;
                for (y = 0; y < im.getHeight(); ++y) {
                    for (x = 0; x < im.getWidth(); ++x) {
                        int v = im.getRaster().getSample(x, y, 0);
                        if (v == 0) continue;
                        int vo = this.original.getRaster().getSample(minx + x, miny + y, 0);
                        double p = (double)v / (double)(v + vo) * 100.0;
                        sum += p;
                        buffer[nb++] = p;
                    }
                }
                Arrays.sort(buffer, 0, nb);
                resfile.setValue(row.value, col++, sum / (double)nb);
                resfile.setValue(row.value, col++, buffer[nb >> 1]);
                resfile.setValue(row.value, col++, this.IF.Average());
                resfile.setValue(row.value, col++, this.IF.Variance());
                resfile.setValue(row.value, col++, Double.isNaN(this.IF.Skewness()) ? 0.0 : this.IF.Skewness());
                resfile.setValue(row.value, col++, Double.isNaN(this.IF.Kurtosis()) ? 0.0 : this.IF.Kurtosis());
                resfile.setValue(row.value, col++, this.IF.Contrast());
                resfile.setValue(row.value, col++, this.IF.Michelson());
                resfile.setValue(row.value, col++, this.besym.LastValue());
                resfile.setValue(row.value, col++, this.idg.LastValue());
                resfile.setValue(row.value, col++, this.terad.LastValue());
                min = (int)this.IF.Minimum(im, 0);
                byte[] bb = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
                double[] array = new double[bb.length];
                for (x = 0; x < bb.length; ++x) {
                    array[x] = (bb[x] & 0xFF) != 0 ? (double)(bb[x] & 0xFF) : (double)min;
                }
                try {
                    this.gaussfit.Compute(array, im.getWidth(), im.getHeight());
                    resfile.setValue(row.value, col++, this.gaussfit.Sigma());
                    resfile.setValue(row.value, col++, Math.sqrt(this.gaussfit.Error() / (double)bb.length));
                }
                catch (Exception E) {
                    resfile.setValue(row.value, col++, 0.0);
                    resfile.setValue(row.value, col++, 0.0);
                    System.out.println("Oups GaussGit: " + E.getMessage() + "&" + E.getLocalizedMessage());
                    E.printStackTrace();
                }
                this.geodiam.Compute(im, this.sem, null, false);
                resfile.setValue(row.value, col++, this.geodiam.getLength() * magnification);
                resfile.setValue(row.value, col++, foldername);
                resfile.setValue(row.value, col++, imname);
                resfile.setValue(row.value, col++, c + 1);
                resfile.setValue(row.value, col++, minix[c + 1]);
                resfile.setValue(row.value, col++, miniy[c + 1]);
                resfile.setValue(row.value, col++, maxix[c + 1] - minix[c + 1]);
                resfile.setValue(row.value, col++, maxiy[c + 1] - miniy[c + 1]);
                resfile.setValue(row.value, col++, magnification);
                resfile.setValue(row.value, col++, isgold == null ? 0.5 : (isgold[c + 1] == 1 ? 1.0 : 0.0));
                resfile.setValue(row.value, col++, isgold == null ? "?" : (isgold[c + 1] == 1 ? "Gold" : "Other"));
                measures = null;
                ++row.value;
                im = null;
                continue;
            }
            catch (Exception E) {
                log.addNewException(E, new String[0]);
                E.printStackTrace();
            }
        }
        return resfile;
    }

    private void RebuildFromMarkers(int perheightave, BufferedImage result) {
        int width = result.getWidth();
        int height = result.getHeight();
        WritableRaster wrim = this.prefilterdepthnew.getRaster();
        WritableRaster wrori = this.original.getRaster();
        WritableRaster wrasf = this.resasf.getRaster();
        WritableRaster wres = result.getRaster();
        ImageComparator.Compare((BufferedImage)this.candidates, (String)"!=", (int)0, (BufferedImage)this.original, (int)255, (BufferedImage)result);
        List list = ImageConverter.ImageToListOfPoints((BufferedImage)this.candidates);
        while (!list.isEmpty()) {
            Coordinates c = (Coordinates)list.remove(0);
            wres.setSample(c.X, c.Y, 0, wrori.getSample(c.X, c.Y, 0) == 0 ? 1 : wrori.getSample(c.X, c.Y, 0));
            for (int y = -1; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    int X = c.X + x;
                    int Y = c.Y + y;
                    if (0 > X || X >= width || 0 > Y || Y >= height || wres.getSample(X, Y, 0) != 255 || !((double)perheightave <= (1.0 - wrim.getSampleDouble(X, Y, 0) / wrasf.getSampleDouble(X, Y, 0)) * 100.0)) continue;
                    wres.setSample(X, Y, 0, wrori.getSample(X, Y, 0) == 0 ? 1 : wrori.getSample(X, Y, 0));
                    list.add(new Coordinates(X, Y));
                }
            }
        }
        ImageComparator.Compare((BufferedImage)result, (String)"!=", (int)255, (BufferedImage)result, (int)0, (BufferedImage)result);
        wres = null;
        wrasf = null;
        wrori = null;
        wrim = null;
        list = null;
    }

    private void CandidateDetection(BufferedImage image, int size, int percentageheight, BufferedImage result, int nbCPU) throws IOException {
        this.asfco.Parameters(new StructuringElement(new Object[]{size, -2}));
        this.asfco.Filter(image, this.resasf, nbCPU);
        ImageArithmetic.Subtract(this.resasf, image, result, 0, 0);
        BufferedImage map = ImageNew.Same((BufferedImage)image);
        switch (image.getType()) {
            case 10: {
                int i2;
                byte[] bbasf = ((DataBufferByte)this.resasf.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[] bbmap = ((DataBufferByte)map.getRaster().getDataBuffer()).getData();
                for (i2 = 0; i2 < bbasf.length; ++i2) {
                    if ((int)((double)(bbres[i2] & 0xFF) / (double)(bbasf[i2] & 0xFF) * 100.0) >= percentageheight) continue;
                    bbres[i2] = 0;
                }
                for (i2 = 0; i2 < bbasf.length; ++i2) {
                    bbmap[i2] = (byte)((double)(bbres[i2] & 0xFF) / (double)(bbasf[i2] & 0xFF) * 100.0);
                }
                bbmap = null;
                bbres = null;
                bbasf = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        ImageIO.Write(map, (this.nbsplit < 10 ? "0" : "") + this.nbsplit + "_PercentageMap.png", 6);
        ImageComparator.Compare((BufferedImage)result, (String)"!=", (int)0, (BufferedImage)this.original, (int)255, (BufferedImage)this.marker);
        this.ob.Filter(this.original, this.marker, this.prefilterdepthnew, nbCPU);
    }

    private void PreFilterDepthNew(BufferedImage image, int radius, int percentage, boolean eightconnex, BufferedImage result, int nbCPU) throws IOException {
        throw new UnsupportedOperationException("Method to upgrade.");
    }

    private void ProcessCutBorders(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        WritableRaster wr = image.getRaster();
        int meas1 = height - 2;
        while (wr.getSample(2, meas1, 0) <= 10) {
            --meas1;
        }
        int meas2 = height - 2;
        while (wr.getSample(width - 2, meas2, 0) <= 10) {
            --meas2;
        }
        --meas2;
        while (wr.getSample(width - 2, meas2, 0) <= 10) {
            --meas2;
        }
        this.CartoucheSize = Math.min(meas1, meas2);
    }

    private void Allocations(BufferedImage original) {
        if (this.borderprocessed != null && ImageTools.areDimensionsAndTypeEqual((BufferedImage)original, (BufferedImage)this.borderprocessed)) {
            return;
        }
        this.borderprocessed = ImageNew.Same((BufferedImage)original);
        this.prefilterdepthnew = ImageNew.Same((BufferedImage)original);
        this.localmin = ImageNew.Same((BufferedImage)original);
        this.resamin = ImageNew.Same((BufferedImage)original);
        this.localminnew = ImageNew.Same((BufferedImage)original);
        this.marker = ImageNew.Same((BufferedImage)original);
        this.resasf = ImageNew.Same((BufferedImage)original);
        this.candidates = ImageNew.Same((BufferedImage)original);
        this.bincand = new BufferedImage(original.getWidth(), original.getHeight(), 12);
        this.binrebcand = ImageNew.Same((BufferedImage)this.bincand);
        this.rebuiltcandidates = ImageNew.Same((BufferedImage)original);
        this.detection = ImageNew.Same((BufferedImage)original);
    }

    private String FindName(String s) {
        int i2 = s.length() - 1;
        while (s.charAt(i2) != '.') {
            --i2;
        }
        return s.substring(0, i2);
    }

    private int FindMin(BufferedImage image, int[] labels, int number, Coordinates position) {
        int min = Integer.MAX_VALUE;
        int width = image.getWidth();
        int height = image.getHeight();
        switch (image.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (labels[pos] == number && (bb[pos] & 0xFF) < min) {
                            min = bb[pos] & 0xFF;
                            position.X = x;
                            position.Y = y;
                        }
                        ++x;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        return min;
    }

    public FichierTabule DetectCharacterizeClassify(String originalpath, BufferedImage noise, String training, List<GenericClassifier> classifiers, FilenameFilter fnf, String output, boolean drawall, int nbCPU) throws Exception {
        int c;
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        FichierTabule resfile = null;
        FichierTabule trainingfile = new FichierTabule(training, true);
        trainingfile.TargetNominal("Class");
        int colbox = trainingfile.ColumnNumber("box");
        int colim = trainingfile.ColumnNumber("image");
        int colnum = trainingfile.ColumnNumber("number");
        int colposx = trainingfile.ColumnNumber("posx");
        int colposy = trainingfile.ColumnNumber("posy");
        int colwidth = trainingfile.ColumnNumber("width");
        int colheight = trainingfile.ColumnNumber("height");
        int colmag = trainingfile.ColumnNumber("magnification");
        int colproba = trainingfile.ColumnNumber("Probability");
        trainingfile.setExcludedColumn(colbox, true);
        trainingfile.setExcludedColumn(colim, true);
        trainingfile.setExcludedColumn(colposx, true);
        trainingfile.setExcludedColumn(colposy, true);
        trainingfile.setExcludedColumn(colwidth, true);
        trainingfile.setExcludedColumn(colheight, true);
        trainingfile.setExcludedColumn(colmag, true);
        trainingfile.setExcludedColumn(colnum, true);
        trainingfile.setExcludedColumn(colproba, true);
        FichierTabule learningfile = FichierTabuleTools.DeleteExcludedColumns(trainingfile);
        FichierTabule trainbal = this.dsb.Balance(learningfile, true);
        Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(trainbal, "TrainingInstances");
        Instance inst = instances.firstInstance();
        int pos = inst.attribute(inst.numAttributes() - 1).indexOfValue("Gold");
        for (c = 0; c < classifiers.size(); ++c) {
            classifiers.get(c).Train(instances);
            if (pos == classifiers.get(c).ClassIndexOf("Gold")) continue;
            throw new Error("pos != classifiers.get(c).ClassIndexOf(\"Gold\"), must not occured!");
        }
        FichierTabule magnifications = null;
        IntPointer row = new IntPointer();
        boolean create = noise == null;
        File[] boxes = new File(originalpath).listFiles();
        for (int box = 0; box < boxes.length; ++box) {
            if (!boxes[box].isDirectory()) continue;
            try {
                magnifications = new FichierTabule(boxes[box].getAbsolutePath() + "/Magnifications.txt", false);
                if (magnifications.Width() != 2) {
                    throw new IllegalArgumentException("The file Magnification.txt has not 2 columns.");
                }
                if (magnifications.ColumnType(0) != 2 || magnifications.ColumnType(1) != 2) {
                    throw new IllegalArgumentException("The file Magnification.txt does not contain only String columns.");
                }
            }
            catch (Exception E) {
                System.err.println("No Magnification.txt file.");
                E.printStackTrace();
                System.exit(0);
            }
            File[] images = new File(boxes[box].getAbsolutePath()).listFiles(fnf);
            for (int i2 = 0; i2 < images.length; ++i2) {
                try {
                    ++this.nbsplit;
                    BufferedImage im = ImageIO.Read(images[i2].getAbsolutePath());
                    if (ImageTools.isColored((BufferedImage)im)) {
                        im = ImageConverter.RGB_To_GrayLevel((BufferedImage)im, (int)1);
                    }
                    magnifications.SelectWhere(0, 0, images[i2].getName());
                    if (magnifications.nbSelected() != 1) {
                        throw new Exception("magnifications.nbSelected() != 1");
                    }
                    String mag = magnifications.getValueString(magnifications.FirstSelected(), 1);
                    String unity = mag.substring(mag.length() - 2);
                    if (!unity.contains("nm") && !unity.contains("mm")) {
                        throw new Exception("Unity unknown: '" + unity + "'");
                    }
                    String valmag = mag.substring(0, mag.length() - 2);
                    double magnification = Double.valueOf(valmag) * (unity.contains("mm") ? 1000.0 : 1.0);
                    if (this.SEMmode) {
                        this.ProcessCutBorders(im);
                    }
                    if (this.SEMmode) {
                        int radius = (int)(4.0 / magnification) + 1;
                        StructuringElement se = new StructuringElement(new Object[]{radius, -2});
                        BufferedImage resrank25 = this.rank.Filter(im, se, 75, nbCPU);
                        BufferedImage resrank50 = this.rank.Filter(im, se, 50, nbCPU);
                        BufferedImage resrank75 = this.rank.Filter(im, se, 25, nbCPU);
                        switch (im.getType()) {
                            case 10: {
                                byte[] bbres25 = ((DataBufferByte)resrank25.getRaster().getDataBuffer()).getData();
                                byte[] bbres50 = ((DataBufferByte)resrank50.getRaster().getDataBuffer()).getData();
                                byte[] bbres75 = ((DataBufferByte)resrank75.getRaster().getDataBuffer()).getData();
                                byte[] bbim = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
                                for (int x = 0; x < bbim.length; ++x) {
                                    bbim[x] = (byte)(255.0 - (double)((bbres25[x] & 0xFF) + (bbres50[x] & 0xFF) + (bbres75[x] & 0xFF)) / 3.0);
                                }
                                break;
                            }
                        }
                        resrank75 = null;
                        resrank50 = null;
                        resrank25 = null;
                        im = ImageNew.SubImageWH((BufferedImage)im, (int)0, (int)0, (int)im.getWidth(), (int)this.CartoucheSize);
                        Objects.requireNonNull(this.AF);
                        this.contrast = this.IF.MichelsonFromRanks(im, -2);
                        im = this.dynexp.Filter(im, nbCPU);
                        System.gc();
                    }
                    ImageIO.Write(im, (this.nbsplit < 10 ? "0" : "") + this.nbsplit + "_ImageToProcess.png", 6);
                    System.out.println("Contrast = " + this.contrast);
                    row.value = 0;
                    FichierTabule resdet = this.DetectCharacterizeLabel(im, null, create ? new BufferedImage(im.getWidth(), im.getHeight(), 12) : noise, magnification, row, boxes[box].getName(), images[i2].getName(), log, nbCPU);
                    File out = new File(output + "/" + resdet.getValueString(0, colbox));
                    if (!out.exists()) {
                        out.mkdirs();
                    }
                    resdet.ClearAll();
                    resdet.SelectNull(colproba + 1);
                    resdet.ExcludeSelected();
                    resdet = FichierTabuleTools.DeleteExcluded(resdet);
                    resdet.Write(out.getAbsolutePath() + "/" + resdet.getValueString(0, colim).replace(".png", ".txt"), false);
                    System.gc();
                    BufferedImage imres = null;
                    String imname = "fjldsk;hfukfjhdsukfjhazqd%$$&:";
                    for (int r = 0; r < resdet.Height(); ++r) {
                        if (!resdet.getValueString(r, colim).equalsIgnoreCase(imname)) {
                            BufferedImage imtmp = ImageIO.Read(originalpath + "/" + resdet.getValueString(r, colbox) + "/" + resdet.getValueString(r, colim));
                            imres = ImageConverter.GrayToColor((BufferedImage)imtmp);
                            imtmp = null;
                            imname = resdet.getValueString(r, colim);
                        }
                        block18: for (int x = 0; x < 19; ++x) {
                            switch (resdet.ColumnType(x)) {
                                case 1: {
                                    inst.setValue(x, resdet.getValueDouble(r, x));
                                    continue block18;
                                }
                                case 0: {
                                    inst.setValue(x, (double)resdet.getValueInt(r, x));
                                }
                            }
                        }
                        double sum = 0.0;
                        try {
                            for (c = 0; c < classifiers.size(); ++c) {
                                sum += classifiers.get(c).Classify(inst)[pos];
                            }
                        }
                        catch (Exception E) {
                            log.addNewException(E, new String[0]);
                            E.printStackTrace();
                            continue;
                        }
                        if (Double.compare(sum, 0.0) != 0) {
                            sum /= (double)classifiers.size();
                        }
                        resdet.setValue(r, resdet.Width() - 2, sum);
                        resdet.setValue(r, resdet.Width() - 1, 0.5 <= sum ? "Gold" : "Other");
                        if (imres == null) continue;
                        if (0.5 <= sum) {
                            ImageDrawer.Rectangle(imres, resdet.getValueInt(r, colposx), resdet.getValueInt(r, colposy), resdet.getValueInt(r, colposx) + resdet.getValueInt(r, colwidth), resdet.getValueInt(r, colposy) + resdet.getValueInt(r, colheight), 0, Colors.RED);
                            continue;
                        }
                        if (!drawall) continue;
                        ImageDrawer.Rectangle(imres, resdet.getValueInt(r, colposx), resdet.getValueInt(r, colposy), resdet.getValueInt(r, colposx) + resdet.getValueInt(r, colwidth), resdet.getValueInt(r, colposy) + resdet.getValueInt(r, colheight), 0, Colors.CYAN);
                    }
                    ImageIO.Write(imres, out.getAbsolutePath() + "/" + resdet.getValueString(0, colim), 6);
                    imres = null;
                    resdet = null;
                    continue;
                }
                catch (Exception E) {
                    E.printStackTrace();
                    log.addNewException(E, new String[0]);
                    System.gc();
                    System.exit(0);
                }
            }
        }
        log.Stop();
        System.out.println(log.Resume());
        return resfile;
    }

    public void DrawSelection(FichierTabule file, String folder, String output) throws Exception {
        int colbox = file.ColumnNumber("box");
        int colimage = file.ColumnNumber("image");
        int colposx = file.ColumnNumber("posx");
        int colposy = file.ColumnNumber("posy");
        int colwidth = file.ColumnNumber("width");
        int colheight = file.ColumnNumber("height");
        String oldbox = null;
        String oldimage = null;
        BufferedImage image = null;
        while (true) {
            int row;
            if ((row = file.NextSelected()) == -1 || oldbox == null || !oldbox.equalsIgnoreCase(file.getValueString(row, colbox)) || !oldimage.equalsIgnoreCase(file.getValueString(row, colimage))) {
                if (image != null) {
                    File out = new File(output + "/" + oldbox + "/");
                    if (!out.exists()) {
                        out.mkdirs();
                    }
                    ImageIO.Write(image, out.getAbsolutePath() + "/" + oldimage.replace(".tif", ".png"), 6);
                }
                if (row == -1) break;
                oldbox = file.getValueString(row, colbox);
                oldimage = file.getValueString(row, colimage);
                image = ImageConverter.GrayToColor((BufferedImage)ImageIO.Read(folder + "/" + file.getValueString(row, colbox) + "/" + file.getValueString(row, colimage)));
            }
            int sx = file.getValueInt(row, colposx);
            int sy = file.getValueInt(row, colposy);
            int w = file.getValueInt(row, colwidth);
            int h = file.getValueInt(row, colheight);
            ImageDrawer.Rectangle(image, sx, sy, sx + w, sy + h, 0, Colors.RED);
            ImageDrawer.Number(image, String.valueOf(row), sx + w + 1, sy + h, Colors.RED);
        }
    }

    public void FolderConverter(String folder) {
        File[] images;
        String ext = ".tif";
        for (File image1 : images = new File(folder).listFiles()) {
            if (!image1.isFile() || !image1.getName().contains(ext)) continue;
            try {
                BufferedImage image = ImageIO.Read(image1.getAbsolutePath());
                image = ImageConverter.Channel((BufferedImage)image, (int)0);
                ImageIO.Write(image, folder + "/" + image1.getName().replace(ext, ".png"), 6);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

