/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.keck.cells;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayOperations;
import displays.Display;
import dv.DV;
import dv.DvComparator;
import dv.DvConverter;
import dv.DvIO;
import dv.DvNew;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import ij.plugin.PlugIn;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import mathematics.Maths;
import mathematics.fourier.JTransformsReal;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import measures.cclh.UnionFindCcl;
import measures.histogram.Histogram;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.segmentation.watershed.Watershed;
import processing.filters.Invert;
import processing.filters.Median;
import processing.filters.StructureEnhancer;
import processing.filters.gradients.Sobel;
import stackTiTi.StackFeatures;
import stackTiTi.StackIO;
import stackTiTi.StackNew;
import stackTiTi.StackTools;
import utils.memory.MemoryInfo;
import utils.times.Chronometer;
import utils.times.Dates;

public class CellSegmentationEM
implements PlugIn {
    private static final long serialVersionUID = 1L;
    private FilenameFilter fnf = (file, name) -> !name.contains("DS_Store") && name.charAt(0) != '.' && name.contains(".png") && !name.contains("_merged_");
    private FilenameFilter fnf3 = (file, name) -> !name.contains("DS_Store") && name.contains("Result.png");
    public Chronometer chrono = new Chronometer();
    public Display display = null;
    private StructuringElement se4 = new StructuringElement(new Object[]{1, -2});
    private StructuringElement se02 = new StructuringElement(new Object[]{2, -1});
    private StructuringElement se03 = new StructuringElement(new Object[]{3, -1});
    private StructuringElement3D se6 = new StructuringElement3D(new Object[]{1, -2});
    private StructuringElement3D ses2 = new StructuringElement3D(new Object[]{2, -2});
    private StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private JTransformsReal jt = new JTransformsReal(true, false);
    private Histogram histogram = new Histogram();
    private Median median = new Median();
    private Sobel sobel = new Sobel();
    private StructureEnhancer sten = new StructureEnhancer();
    private UnionFindCcl ccl = new UnionFindCcl();
    private Watershed ws = new Watershed();
    private int maxsize = 512;
    private BufferedImage[] stackmarkers = null;
    private BufferedImage[] stackcolor = null;
    private int markermax = -1;
    private List<CoordinatesWeighted> markers = new LinkedList<CoordinatesWeighted>();
    private String[] extin = new String[]{"_Improved0.png", "_Improved1.png", "_Improved2.png", "_Improved3.png"};
    public String tmpfilename = "tmp";
    public String resfilename = "Results3D";
    public String resfilenamecolor = "Results3Dcolor";
    public String markersfilename = "Markers";
    public int thetastart = 0;
    public int thetaend = 135;
    public int thetastep = 45;
    public int phistart = 0;
    public int phiend = 135;
    public int phistep = 45;
    public double Coefficient = 0.9;
    public boolean LocalAverage = true;
    public boolean QuickProcessing = true;
    public boolean SimpleMarkers = true;
    public int MaxNumberMarkers = 3;
    public PrepMode Preprocessing = PrepMode.STACK;
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    private final StackFeatures SF = new StackFeatures();
    private int[] maxpositions = new int[5];
    private MemoryInfo mem = new MemoryInfo();
    public boolean verbose = true;
    public boolean AgressiveMemorySaving = true;

    public void Segment_Danielle(String directory, int maxsize, int nbSubVolumes, int nbCPU) throws Exception {
        File resfilecolor;
        File resfile;
        this.sobel.HowCorrect(2);
        if (!Maths.isPowerOf2((int)maxsize) || maxsize <= 1) {
            throw new IllegalArgumentException("maxsize must be dyadic.");
        }
        this.maxsize = maxsize;
        File tmpfile = new File(directory + "/" + this.tmpfilename + "/");
        if (!tmpfile.exists()) {
            tmpfile.mkdirs();
        }
        if (!(resfile = new File(directory + "/" + this.resfilename + "/")).exists()) {
            resfile.mkdirs();
        }
        if (!(resfilecolor = new File(directory + "/" + this.resfilenamecolor + "/")).exists()) {
            resfilecolor.mkdirs();
        }
        Object[] files = new File(directory).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(files);
        switch (this.Preprocessing) {
            case FILE: {
                this.Preprocessing3D((File[])files, tmpfile, nbSubVolumes, nbCPU);
                return;
            }
            case STACK: {
                this.Preprocessing3Dstack((File[])files, tmpfile, nbSubVolumes, nbCPU);
                return;
            }
            case NONE: {
                break;
            }
            case EXIT: {
                return;
            }
        }
        File markersfile = new File(directory + "/" + this.markersfilename);
        if (!markersfile.exists()) {
            throw new IllegalArgumentException("Any \"" + this.markersfilename + "\" directory found.");
        }
        Object[] imfilesmarkers = markersfile.listFiles(this.fnf);
        if (imfilesmarkers == null) {
            throw new IllegalArgumentException("Any \"" + this.markersfilename + "\" defined.");
        }
        System.out.println(imfilesmarkers.length + " found.");
        Arrays.sort(imfilesmarkers);
        int[] positions = new int[imfilesmarkers.length];
        int pos = 0;
        for (int i2 = 0; i2 < imfilesmarkers.length; ++i2) {
            String imname = ((File)imfilesmarkers[i2]).getName();
            while (pos < files.length && !imname.equalsIgnoreCase(((File)files[pos]).getName())) {
                ++pos;
            }
            if (files.length <= pos) {
                throw new Exception("Marker image '" + imname + "' not found among the images.");
            }
            positions[i2] = pos;
        }
        this.Segmentation(directory, (File[])files, (File[])imfilesmarkers, positions, nbCPU);
        resfile = null;
        tmpfile = null;
    }

    private void Segmentation(String directory, File[] images, File[] markersfiles, int[] positions, int nbCPU) {
        int tm0 = -1;
        int tm1 = -1;
        if (this.verbose) {
            tm0 = this.chrono.NewMarker();
            System.out.println("Segmentation starts at " + Dates.Time(" "));
        }
        int popy = 2;
        int nbimp = this.QuickProcessing ? 2 : 4;
        int[] bucketbuffer = new int[this.SimpleMarkers ? nbimp + 1 : 256];
        DV src = null;
        DV[] dvwsres = new DV[nbimp + 1];
        BufferedImage imtmp = null;
        BufferedImage imcolor = null;
        for (int mark = 0; mark <= positions.length; ++mark) {
            try {
                int i2;
                int imnum;
                if (this.verbose) {
                    System.out.println("Mark " + mark + " starts at " + Dates.Time(" "));
                    tm1 = this.chrono.NewMarker();
                }
                this.markers.clear();
                if (mark == 0) {
                    src = DvIO.ReadFromStack(images, 0, positions[mark] + 2);
                    this.CreateMarkers(ImageIO.Read(markersfiles[mark]), positions[mark]);
                    imtmp = new BufferedImage(src.SizeX, src.SizeY, 10);
                    imcolor = ImageNew.Same((BufferedImage)imtmp, (int)5);
                    imnum = 0;
                } else if (mark == positions.length) {
                    src = DvIO.ReadFromStack(images, positions[mark - 1] - 1, images.length - positions[mark - 1] + 1);
                    this.CreateMarkers(ImageIO.Read(markersfiles[mark - 1]), 1);
                    imnum = positions[mark - 1] - 1;
                } else {
                    src = DvIO.ReadFromStack(images, positions[mark - 1] - 1, positions[mark] - positions[mark - 1] + 3);
                    this.CreateMarkers(ImageIO.Read(markersfiles[mark - 1]), 1);
                    this.CreateMarkers(ImageIO.Read(markersfiles[mark]), src.SizeZ - 2);
                    imnum = positions[mark - 1] - 1;
                }
                DV dvmarkersint = DvNew.Same((DV)src, (int)32);
                DV dvresult = DvNew.Same((DV)src);
                for (i2 = 0; i2 < dvwsres.length; ++i2) {
                    dvwsres[i2] = DvNew.Same((DV)src, (int)32);
                }
                int popz = src.SizeX << 1;
                int w1 = src.SizeX - 1;
                int h1 = src.SizeY - 1;
                int d1 = src.SizeZ - 1;
                DV dvmed = this.median.Filter(src, this.ses2, nbCPU);
                DV dvgrad = this.sobel.Filter(dvmed, nbCPU);
                this.ws.watershed(dvgrad, this.markers, this.se6, 1, 1, 1, dvgrad.SizeX - 1, dvgrad.SizeY - 1, dvgrad.SizeZ - 1);
                DvNew.Copy((DV)this.ws.Basins3D(), (DV)dvmarkersint);
                DvNew.Copy((DV)this.ws.Basins3D(), (DV)dvwsres[0]);
                imtmp = new BufferedImage(src.SizeX, src.SizeY, 10);
                imcolor = ImageNew.Same((BufferedImage)imtmp, (int)5);
                for (int num = 1; num <= nbimp; ++num) {
                    String key = "ved" + num + "_";
                    Object[] impim = new File(directory + "/" + this.tmpfilename + "/").listFiles((dir, name) -> name.charAt(0) != '.' && name.contains(key));
                    Arrays.sort(impim);
                    if (mark == 0) {
                        DvIO.ReadFromStack((File[])impim, 0, positions[mark] + 2, src);
                    } else if (mark == positions.length) {
                        DvIO.ReadFromStack((File[])impim, positions[mark - 1] - 1, images.length - positions[mark - 1] + 1, src);
                    } else {
                        DvIO.ReadFromStack((File[])impim, positions[mark - 1] - 1, positions[mark] - positions[mark - 1] + 3, src);
                    }
                    this.median.Filter(src, this.ses2, dvmed, nbCPU);
                    this.sobel.Filter(dvmed, dvgrad, nbCPU);
                    this.ws.watershed(dvgrad, this.markers, this.se6, 1, 1, 1, dvgrad.SizeX - 1, dvgrad.SizeY - 1, dvgrad.SizeZ - 1);
                    DvComparator.Compare((DV)this.ws.Basins3D(), (String)"==", (DV)dvmarkersint, (DV)dvmarkersint, (int)0, (DV)dvmarkersint);
                    DvNew.Copy((DV)this.ws.Basins3D(), (DV)dvwsres[num]);
                }
                int[] ibdmi = dvmarkersint.getDataBufferInt(0);
                byte[] bbres = dvresult.getDataBufferByte(0);
                int z = 1;
                int pos = dvresult.LayerSize + src.SizeX + 1;
                while (z < d1) {
                    int y = 1;
                    while (y < h1) {
                        int x = 1;
                        while (x < w1) {
                            if (ibdmi[pos] != 0) {
                                bbres[pos] = (byte)ibdmi[pos];
                            } else {
                                Arrays.fill(bucketbuffer, 0);
                                for (int b = 0; b <= nbimp; ++b) {
                                    if (0 >= dvwsres[b].getVoxelInt(0, pos)) continue;
                                    int n = dvwsres[b].getVoxelInt(0, pos);
                                    bucketbuffer[n] = bucketbuffer[n] + 1;
                                }
                                bbres[pos] = (byte)this.FindResult(bucketbuffer);
                            }
                            ++x;
                            ++pos;
                        }
                        ++y;
                        pos += popy;
                    }
                    DvConverter.DVtoBufferedImage(dvresult, 0, z, imtmp);
                    ImageIO.Write(imtmp, directory + "/" + this.resfilename + "/" + images[imnum + z].getName().replace(".png", "_Result.png"), 6);
                    BufferedImage image = ImageIO.Read(images[imnum + z]);
                    ImageConverter.GrayToColor((BufferedImage)image, (BufferedImage)imcolor);
                    CellSegmentationEM.DrawBorders2(imcolor, imtmp);
                    ImageIO.Write(imcolor, directory + "/" + this.resfilenamecolor + "/" + images[imnum + z].getName().replace(".png", "_ResultColor.png"), 6);
                    ++z;
                    pos += popz;
                }
                bbres = null;
                ibdmi = null;
                this.markers.clear();
                src.Kill();
                dvgrad.Kill();
                dvmed.Kill();
                src = null;
                dvmed = null;
                dvgrad = null;
                for (i2 = 0; i2 < dvwsres.length; ++i2) {
                    dvwsres[i2].Kill();
                    dvwsres[i2] = null;
                }
                System.gc();
                if (!this.verbose) continue;
                System.out.println("Mark " + mark + " over at " + Dates.Time(" ") + " => " + this.chrono.getTimeSinceMarker(tm1));
                this.chrono.FreeMarker(tm1);
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
                System.exit(0);
                continue;
            }
            catch (Error E) {
                E.printStackTrace();
                System.exit(0);
            }
        }
        imcolor = null;
        imtmp = null;
        if (this.verbose) {
            System.out.println("Segmentation over at " + Dates.Time(" ") + " => " + this.chrono.getTimeSinceMarker(tm0));
            this.chrono.FreeMarker(tm0);
        }
    }

    private int FindResult(int[] buffer) {
        int i2;
        int poslength = 0;
        for (i2 = 0; i2 < buffer.length && buffer[i2] == 0; ++i2) {
        }
        if (i2 == buffer.length) {
            System.out.println("Bug (empty)!");
            return 0;
        }
        int max = buffer[i2];
        this.maxpositions[poslength++] = i2++;
        while (i2 < buffer.length) {
            if (max < buffer[i2]) {
                max = buffer[i2];
                this.maxpositions[0] = i2;
                poslength = 1;
            } else if (max == buffer[i2]) {
                this.maxpositions[poslength++] = i2;
            }
            ++i2;
        }
        switch (poslength) {
            case 1: {
                return this.maxpositions[0];
            }
            case 2: {
                return this.maxpositions[1];
            }
            case 0: {
                throw new Error("Bug (0)!");
            }
        }
        return 0;
    }

    private void Preprocessing3D(File[] files, File tmpfile, int nbSubVolumes, int nbCPU) throws IOException {
        double sigmax = 2.0;
        double sigmay = 2.0;
        double sigmaz = 2.0;
        double lambda = 3.0 * sigmax;
        double phase = 0.0;
        int marker = 1;
        if (this.verbose) {
            marker = this.chrono.NewMarker();
            System.out.println("Preprocessing starts at " + Dates.Time(" "));
        }
        if (this.verbose) {
            System.out.println("Preprocessing 1 starts = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        this.sten.Parameters(this.thetastart, this.thetaend, this.thetastep, this.phistart, this.phiend, this.phistep, 0, 0, 0, sigmax, sigmay, sigmaz, lambda, phase, this.jt, -1, 1, true, true);
        Arrays.sort(files);
        this.sten.Filter(files, this.maxsize, nbSubVolumes, this.AgressiveMemorySaving, tmpfile.getAbsolutePath(), "Improved1_", "", tmpfile.getAbsolutePath() + "/tmp/", nbCPU);
        if (this.verbose) {
            System.out.println("Preprocessing 1 over = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        System.gc();
        if (this.verbose) {
            System.out.println("After GC 1 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        if (this.verbose) {
            System.out.println("Preprocessing 2 starts = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        this.sten.Parameters(this.thetastart, this.thetaend, this.thetastep, this.phistart, this.phiend, this.phistep, 0, 0, 0, 2.0 * sigmax, sigmay, sigmaz, lambda, phase, this.jt, -1, 1, true, true);
        Object[] newfiles = new File(tmpfile.getAbsolutePath()).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(newfiles);
        this.sten.Filter((File[])newfiles, this.maxsize, nbSubVolumes, this.AgressiveMemorySaving, tmpfile.getAbsolutePath(), "Improved2_", "", tmpfile.getAbsolutePath() + "/tmp/", nbCPU);
        FilesFolders.ReplaceInName(tmpfile, "Improved2_Improved1_", "Improved2_");
        if (this.verbose) {
            System.out.println("Preprocessing 2 over = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        System.gc();
        if (this.verbose) {
            System.out.println("After GC 2 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        System.gc();
        if (this.verbose) {
            System.out.println("After GC Last = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        if (this.verbose) {
            System.out.println("Preprocessing over at " + Dates.Time(" ") + " => " + this.chrono.getTimeSinceMarker(marker));
            this.chrono.FreeMarker(marker);
        }
    }

    private void Preprocessing3Dstack(File[] files, File tmpfile, int nbSubVolumes, int nbCPU) throws IOException {
        double sigmax = 2.0;
        double sigmay = 2.0;
        double sigmaz = 2.0;
        double lambda = 3.0 * sigmax;
        double phase = 0.0;
        int marker = 1;
        if (this.verbose) {
            marker = this.chrono.NewMarker();
            System.out.println("Preprocessing starts at " + Dates.Time(" "));
        }
        BufferedImage[] stack = StackIO.ReadImageSequence(files);
        System.out.println("Stack read = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage());
        BufferedImage[] stackimproved = StackNew.Same(stack);
        System.out.println("Stack improved = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage());
        if (stackimproved == null || !StackTools.areDimensionsEqual(stackimproved, stack)) {
            stackimproved = null;
            stackimproved = StackNew.Same(stack);
        }
        if (this.verbose) {
            System.out.println("Preprocessing 1 starts = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        this.sten.Parameters(this.thetastart, this.thetaend, this.thetastep, this.phistart, this.phiend, this.phistep, 0, 0, 0, sigmax, sigmay, sigmaz, lambda, phase, this.jt, -1, 1, true, true);
        this.sten.Filter(stack, this.maxsize, nbSubVolumes, stackimproved, nbCPU);
        if (this.verbose) {
            System.out.println("Preprocessing 1 over = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        StackIO.WriteImageSequence(stackimproved, files, tmpfile.getAbsolutePath(), "Improved1_", 6);
        if (this.verbose) {
            System.out.println("Stack written 1 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        System.gc();
        if (this.verbose) {
            System.out.println("After GC 1 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        StackNew.Copy(stackimproved, stack);
        if (this.verbose) {
            System.out.println("Preprocessing 2 starts = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        this.sten.Parameters(this.thetastart, this.thetaend, this.thetastep, this.phistart, this.phiend, this.phistep, 0, 0, 0, 2.0 * sigmax, sigmay, sigmaz, lambda, phase, this.jt, -1, 1, true, true);
        this.sten.Filter(stack, this.maxsize, nbSubVolumes, stackimproved, nbCPU);
        if (this.verbose) {
            System.out.println("Preprocessing 2 over = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        StackIO.WriteImageSequence(stackimproved, files, tmpfile.getAbsolutePath(), "Improved2_", 6);
        if (this.verbose) {
            System.out.println("Stack written 2 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        System.gc();
        if (this.verbose) {
            System.out.println("After GC 2 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        if (!this.QuickProcessing) {
            StackNew.Copy(stackimproved, stack);
            if (this.verbose) {
                System.out.println("Preprocessing 3 starts = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
            }
            this.sten.Parameters(this.thetastart, this.thetaend, this.thetastep, this.phistart, this.phiend, this.phistep, 0, 0, 0, 3.0 * sigmax, sigmay, sigmaz, lambda, phase, this.jt, -1, 1, true, true);
            this.sten.Filter(stack, this.maxsize, nbSubVolumes, stackimproved, nbCPU);
            if (this.verbose) {
                System.out.println("Preprocessing 3over = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
            }
            StackIO.WriteImageSequence(stackimproved, files, tmpfile.getAbsolutePath(), "Improved3_", 6);
            if (this.verbose) {
                System.out.println("Stack written 3 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
            }
            System.gc();
            if (this.verbose) {
                System.out.println("After GC 3 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
            }
            StackNew.Copy(stackimproved, stack);
            if (this.verbose) {
                System.out.println("Preprocessing 4 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
            }
            this.sten.Parameters(this.thetastart, this.thetaend, this.thetastep, this.phistart, this.phiend, this.phistep, 0, 0, 0, 4.0 * sigmax, sigmay, sigmaz, lambda, phase, this.jt, -1, 1, true, true);
            this.sten.Filter(stack, this.maxsize, nbSubVolumes, stackimproved, nbCPU);
            if (this.verbose) {
                System.out.println("Preprocessing 4 over = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
            }
            StackIO.WriteImageSequence(stackimproved, files, tmpfile.getAbsolutePath(), "Improved4_", 6);
            if (this.verbose) {
                System.out.println("Stack written 4 = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
            }
        }
        for (int i2 = 0; i2 < stack.length; ++i2) {
            stackimproved[i2] = null;
            stack[i2] = null;
        }
        stackimproved = null;
        stack = null;
        System.gc();
        if (this.verbose) {
            System.out.println("After GC Last = " + this.mem.UsedMo() + " <=> " + this.mem.Percentage() + ", at " + Dates.Time(" "));
        }
        if (this.verbose) {
            System.out.println("Preprocessing over at " + Dates.Time(" ") + " => " + this.chrono.getTimeSinceMarker(marker));
            this.chrono.FreeMarker(marker);
        }
    }

    public void SeparateComponents(String directory) throws IOException {
        int i2;
        File[] files = new File(directory + "/" + this.resfilename).listFiles((dir, name) -> name.charAt(0) != '.' && name.contains(".png"));
        BufferedImage[] images = StackIO.ReadImageSequence(files);
        int max = (int)this.SF.Maximum(images);
        BufferedImage tmp = ImageNew.Same((BufferedImage)images[0]);
        for (i2 = 1; i2 <= max; ++i2) {
            File result = new File(directory + "/" + this.resfilename + "/" + i2 + "/");
            if (!result.exists()) {
                result.mkdirs();
            }
            result = null;
        }
        for (i2 = 0; i2 < images.length; ++i2) {
            for (int c = 1; c <= max; ++c) {
                ImageComparator.Compare((BufferedImage)images[i2], (String)"==", (int)c, (int)c, (int)0, (BufferedImage)tmp);
                ImageIO.Write(tmp, directory + "/" + this.resfilename + "/" + c + "/" + files[i2].getName(), 6);
            }
            images[i2] = null;
        }
        tmp = null;
        files = null;
    }

    public void MergeComponents(String directory, int comp1, int comp2) throws IOException {
        File[] files2;
        File[] files1 = new File(directory + "/" + this.resfilename + "/" + comp1 + "/").listFiles((dir, name) -> name.charAt(0) != '.' && name.contains(".png"));
        if (files1.length != (files2 = new File(directory + "/" + this.resfilename + "/" + comp2 + "/").listFiles((dir, name) -> name.charAt(0) != '.' && name.contains(".png"))).length) {
            throw new IllegalStateException("Different number of images.");
        }
        for (int i2 = 0; i2 < files1.length; ++i2) {
            if (!files1[i2].getName().equals(files2[i2].getName())) {
                throw new IllegalStateException("Different names.");
            }
            BufferedImage im1 = ImageIO.Read(files1[i2]);
            BufferedImage im2 = ImageIO.Read(files2[i2]);
            ImageOperations.Maximum((BufferedImage)im1, (BufferedImage)im2, (BufferedImage)im1);
            ImageComparator.Compare((BufferedImage)im1, (String)"!=", (int)comp2, (BufferedImage)im1, (int)comp1, (BufferedImage)im1);
            ImageIO.Write(im1, directory + "/" + this.resfilename + "/" + comp1 + "/" + files1[i2].getName(), 6);
            im2 = null;
            im1 = null;
        }
        files2 = null;
        files1 = null;
    }

    public void Binarize(String directory) throws IOException {
        File finalbin = new File(directory + "/FinalBin/");
        if (!finalbin.exists()) {
            finalbin.mkdirs();
        }
        finalbin = null;
        File[] files = new File(directory + "/Results3D/").listFiles((dir, name) -> name.contains("_Result.png"));
        for (int i2 = 0; i2 < files.length; ++i2) {
            BufferedImage im = ImageIO.Read(files[i2].getAbsoluteFile());
            ImageComparator.Compare((BufferedImage)im, (String)"==", (int)1, (int)0, (int)255, (BufferedImage)im);
            ImageIO.Write(im, directory + "/FinalBin/" + files[i2].getName(), 6);
            im = null;
        }
        files = null;
    }

    private void CorrectLabels(String directory, File[] markers, String resultsfile) {
        boolean[] imposed;
        int[] Lut;
        int x;
        byte[] bb2;
        byte[] bb1;
        int[][] overlap;
        int[] hist;
        BufferedImage im2;
        BufferedImage im1;
        int border3;
        int border2;
        int border1;
        int x2;
        int i2;
        File respassdown;
        Object[] results = new File(resultsfile).listFiles(this.fnf3);
        Arrays.sort(results);
        File respassup = new File(directory + "/Result3Dpassup");
        if (!respassup.exists()) {
            respassup.mkdirs();
        }
        if (!(respassdown = new File(directory + "/Results/")).exists()) {
            respassdown.mkdirs();
        }
        int[] positions = new int[markers.length];
        int pos = 0;
        for (i2 = 0; i2 < markers.length; ++i2) {
            String imname = markers[i2].getName();
            while (pos < results.length && !imname.equalsIgnoreCase(((File)results[pos]).getName().replace("_Result.png", ".png"))) {
                ++pos;
            }
            if (results.length <= pos) {
                throw new Error("Marker image '" + imname + "' not found among the images.");
            }
            positions[i2] = pos;
        }
        for (x2 = 0; x2 < results.length; ++x2) {
            FilesFolders.CopyFile((File)results[x2], respassup);
        }
        results = null;
        results = respassup.listFiles(this.fnf3);
        Arrays.sort(results);
        for (i2 = 0; i2 < positions.length - 1; ++i2) {
            try {
                pos = positions[i2];
                int pos2 = positions[i2 + 1];
                border1 = pos2 + pos >> 1;
                border2 = border1 + 1;
                border3 = i2 + 2 >= positions.length ? results.length - 1 : positions[i2 + 2] + pos2 >> 1;
                im1 = ImageIO.Read(((File)results[border1]).getAbsoluteFile());
                im2 = ImageIO.Read(((File)results[border2]).getAbsoluteFile());
                this.histogram.Fill(im2);
                hist = this.histogram.getValues(0);
                overlap = new int[(int)this.IF.Maximum(im2) + 1][(int)this.IF.Maximum(im1) + 1];
                switch (im1.getType()) {
                    case 10: {
                        bb1 = ((DataBufferByte)im1.getRaster().getDataBuffer()).getData();
                        bb2 = ((DataBufferByte)im2.getRaster().getDataBuffer()).getData();
                        for (x = 0; x < bb1.length; ++x) {
                            if (1 >= (bb1[x] & 0xFF) || 1 >= (bb2[x] & 0xFF)) continue;
                            int[] nArray = overlap[bb2[x] & 0xFF];
                            int n = bb1[x] & 0xFF;
                            nArray[n] = nArray[n] + 1;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet).");
                    }
                }
                im2 = null;
                im1 = null;
                Lut = new int[256];
                ArrayNew.FillIncreasing((int[])Lut, (int)0);
                ArrayComparator.Compare((int[])hist, (String)"!=", (int)0, (int[])Lut, (int)0, (int[])Lut);
                Lut[0] = 0;
                imposed = new boolean[Lut.length];
                Arrays.fill(imposed, false);
                for (x = 1; x < overlap.length; ++x) {
                    for (int y = 1; y < overlap[0].length; ++y) {
                        if (!(0.75 < (double)overlap[x][y] / (double)hist[x])) continue;
                        imposed[x] = true;
                        Lut[x] = y;
                    }
                }
                this.CheckAndFindNewValues(Lut, imposed);
                for (x = border2; x <= border3; ++x) {
                    BufferedImage image = ImageIO.Read((File)results[x]);
                    ImageOperations.Lut((BufferedImage)image, (int[])Lut, (BufferedImage)image);
                    ImageIO.Write(image, respassup.getAbsolutePath() + "/" + ((File)results[x]).getName(), 6);
                    image = null;
                }
                hist = null;
                Lut = null;
                imposed = null;
                overlap = null;
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        for (x2 = 0; x2 < results.length; ++x2) {
            FilesFolders.CopyFile((File)results[x2], respassdown);
        }
        results = null;
        results = respassdown.listFiles(this.fnf3);
        Arrays.sort(results);
        for (i2 = positions.length - 1; i2 >= 1; --i2) {
            try {
                pos = positions[i2];
                int pos2 = positions[i2 - 1];
                border1 = pos2 + pos >> 1;
                border2 = border1 + 1;
                border3 = i2 - 2 <= 0 ? 0 : positions[i2 - 2] + pos2 >> 1;
                im1 = ImageIO.Read(((File)results[border1]).getAbsoluteFile());
                im2 = ImageIO.Read(((File)results[border2]).getAbsoluteFile());
                this.histogram.Fill(im2);
                hist = this.histogram.getValues(0);
                overlap = new int[(int)this.IF.Maximum(im2) + 1][(int)this.IF.Maximum(im1) + 1];
                switch (im1.getType()) {
                    case 10: {
                        bb1 = ((DataBufferByte)im1.getRaster().getDataBuffer()).getData();
                        bb2 = ((DataBufferByte)im2.getRaster().getDataBuffer()).getData();
                        for (x = 0; x < bb1.length; ++x) {
                            if (1 >= (bb1[x] & 0xFF) || 1 >= (bb2[x] & 0xFF)) continue;
                            int[] nArray = overlap[bb2[x] & 0xFF];
                            int n = bb1[x] & 0xFF;
                            nArray[n] = nArray[n] + 1;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet).");
                    }
                }
                im2 = null;
                im1 = null;
                Lut = new int[256];
                ArrayNew.FillIncreasing((int[])Lut, (int)0);
                ArrayComparator.Compare((int[])hist, (String)"!=", (int)0, (int[])Lut, (int)0, (int[])Lut);
                Lut[0] = 0;
                imposed = new boolean[Lut.length];
                Arrays.fill(imposed, false);
                for (x = 1; x < overlap.length; ++x) {
                    for (int y = 1; y < overlap[0].length; ++y) {
                        if (!(0.75 < (double)overlap[x][y] / (double)hist[x])) continue;
                        imposed[x] = true;
                        Lut[x] = y;
                    }
                }
                this.CheckAndFindNewValues(Lut, imposed);
                for (x = border2; x <= border3; ++x) {
                    BufferedImage image = ImageIO.Read((File)results[x]);
                    ImageOperations.Lut((BufferedImage)image, (int[])Lut, (BufferedImage)image);
                    ImageIO.Write(image, respassup.getAbsolutePath() + "/" + ((File)results[x]).getName(), 6);
                    image = null;
                }
                hist = null;
                Lut = null;
                imposed = null;
                overlap = null;
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        File colorresult = new File(directory + "/ResultsColor/");
        if (!colorresult.exists()) {
            colorresult.mkdirs();
        }
        for (int x3 = 0; x3 < results.length; ++x3) {
            try {
                BufferedImage bassins = ImageIO.Read((File)results[x3]);
                BufferedImage original = ImageIO.Read(directory + "/" + ((File)results[x3]).getName().replace("_Result.png", ".png"));
                BufferedImage res = CellSegmentationEM.DrawBorders(original, bassins);
                ImageIO.Write(res, colorresult.getAbsolutePath() + "/" + ((File)results[x3]).getName().replace("_Result.png", "_ResultColor.png"), 6);
                res = null;
                original = null;
                bassins = null;
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        FilesFolders.Delete(respassup);
        results = null;
        colorresult = null;
        respassdown = null;
        respassup = null;
        System.exit(0);
    }

    private void CheckAndFindNewValues(int[] Lut, boolean[] imposed) {
        this.histogram.Fill(Lut, Lut.length, -1);
        int[] hist = this.histogram.getValues(0);
        ArrayList<Integer> freespots = new ArrayList<Integer>(13);
        this.FindFreeSpots(hist, freespots);
        ArrayList<Integer> issues = new ArrayList<Integer>(13);
        int max = Lut.length;
        for (int i2 = 1; i2 < hist.length; ++i2) {
            if (1 >= hist[i2]) continue;
            this.FindIndexesIssues(Lut, i2, issues);
            for (int x = 0; x < issues.size(); ++x) {
                int index = (Integer)issues.get(x);
                if (imposed[index]) continue;
                Lut[index] = !freespots.isEmpty() ? (Integer)freespots.remove(0) : max++;
            }
            issues.clear();
        }
        freespots.clear();
        freespots = null;
        issues = null;
        hist = null;
    }

    private void FindIndexesIssues(int[] Lut, int value, List<Integer> list) {
        for (int i2 = 1; i2 < Lut.length; ++i2) {
            if (Lut[i2] != value) continue;
            list.add(i2);
        }
    }

    private void FindFreeSpots(int[] hist, List<Integer> list) {
        for (int i2 = 1; i2 < hist.length; ++i2) {
            if (hist[i2] != 0) continue;
            list.add(i2);
        }
    }

    public static BufferedImage DrawBorders(BufferedImage image, BufferedImage bassins) {
        BufferedImage result = ImageConverter.GrayToColor((BufferedImage)image);
        int width = result.getWidth();
        int height = result.getHeight();
        switch (bassins.getType()) {
            case 10: {
                byte[] bbbas = ((DataBufferByte)bassins.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (1 < (bbbas[pos] & 0xFF)) {
                            boolean todo = false;
                            if (x == 0 || y == 0 || x == width - 1 || y == height - 1) {
                                todo = true;
                            } else if ((bbbas[pos - 1] & 0xFF) != (bbbas[pos] & 0xFF)) {
                                todo = true;
                            } else if ((bbbas[pos + 1] & 0xFF) != (bbbas[pos] & 0xFF)) {
                                todo = true;
                            } else if ((bbbas[pos - width] & 0xFF) != (bbbas[pos] & 0xFF)) {
                                todo = true;
                            } else if ((bbbas[pos + width] & 0xFF) != (bbbas[pos] & 0xFF)) {
                                todo = true;
                            }
                            if (todo) {
                                result.getRaster().setSample(x, y, 0, 255);
                                result.getRaster().setSample(x, y, 1, 0);
                                result.getRaster().setSample(x, y, 2, 0);
                            }
                        }
                        ++x;
                        ++pos;
                    }
                }
                break;
            }
            case 0: {
                switch (bassins.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ibbas = ((DataBufferInt)bassins.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                if (1 < ibbas[pos]) {
                                    boolean todo = false;
                                    if (x == 0 || y == 0 || x == width - 1 || y == height - 1) {
                                        todo = true;
                                    } else if (ibbas[pos - 1] != ibbas[pos]) {
                                        todo = true;
                                    } else if (ibbas[pos + 1] != ibbas[pos]) {
                                        todo = true;
                                    } else if (ibbas[pos - width] != ibbas[pos]) {
                                        todo = true;
                                    } else if (ibbas[pos + width] != ibbas[pos]) {
                                        todo = true;
                                    }
                                    if (todo) {
                                        result.getRaster().setSample(x, y, 0, 255);
                                        result.getRaster().setSample(x, y, 1, 0);
                                        result.getRaster().setSample(x, y, 2, 0);
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public static void DrawBorders2(BufferedImage result, BufferedImage bassins) {
        int width = result.getWidth();
        int height = result.getHeight();
        switch (bassins.getType()) {
            case 10: {
                byte[] bbbas = ((DataBufferByte)bassins.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int p3 = 0;
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int v = bbbas[pos] & 0xFF;
                        if (1 < v) {
                            boolean todo = false;
                            if (x == 0 || y == 0 || x == width - 1 || y == height - 1) {
                                todo = true;
                            } else if ((bbbas[pos - 1] & 0xFF) != v) {
                                todo = true;
                            } else if ((bbbas[pos + 1] & 0xFF) != v) {
                                todo = true;
                            } else if ((bbbas[pos - width] & 0xFF) != v) {
                                todo = true;
                            } else if ((bbbas[pos + width] & 0xFF) != v) {
                                todo = true;
                            }
                            if (todo) {
                                bbres[p3 + 1] = 0;
                                bbres[p3] = 0;
                                bbres[p3 + 2] = -1;
                            }
                        }
                        ++x;
                        ++pos;
                        p3 += 3;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image bassin type not supported.");
            }
        }
    }

    private void CreateMarkers(BufferedImage image, int layer) {
        if (this.SimpleMarkers) {
            this.CreateSimpleMarkers(image, layer);
        } else {
            this.CreateComplexMarkersNew(image, layer);
        }
    }

    private void CreateSimpleMarkers(BufferedImage image, int layer) {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        switch (image.getType()) {
            case 5: {
                int posrgb = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if ((bb[posrgb + 1] & 0xFF) == 0) {
                            if ((bb[posrgb] & 0xFF) == 255 && (bb[posrgb + 2] & 0xFF) == 0) {
                                this.markers.add(new CoordinatesWeighted(x, y, layer, -1, 1));
                            } else if ((bb[posrgb] & 0xFF) == 0 && (bb[posrgb + 2] & 0xFF) == 255) {
                                this.markers.add(new CoordinatesWeighted(x, y, layer, -1, 2));
                            }
                        }
                        ++x;
                        posrgb += 3;
                    }
                }
                break;
            }
            case 6: {
                int posrgb = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if ((bb[posrgb + 2] & 0xFF) == 0) {
                            if ((bb[posrgb + 1] & 0xFF) == 255 && (bb[posrgb + 3] & 0xFF) == 0) {
                                this.markers.add(new CoordinatesWeighted(x, y, layer, -1, 1));
                            } else if ((bb[posrgb + 1] & 0xFF) == 0 && (bb[posrgb + 3] & 0xFF) == 255) {
                                this.markers.add(new CoordinatesWeighted(x, y, layer, -1, 2));
                            }
                        }
                        ++x;
                        posrgb += 4;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker image type not supported (yet).");
            }
        }
        bb = null;
    }

    private void CreateComplexMarkersNew(BufferedImage image, int layer) {
        int x;
        int y;
        if (image.getType() != 5) {
            throw new IllegalArgumentException("Marker image type not supported (yet).");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage imtmp = ImageNew.Same((BufferedImage)image, (int)10);
        byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        byte[] bbtmp = ((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData();
        int posrgb = 0;
        int pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                bbtmp[pos] = (bb[posrgb + 1] & 0xFF) != 0 ? 0 : ((bb[posrgb] & 0xFF) == 255 && (bb[posrgb + 2] & 0xFF) == 0 || (bb[posrgb] & 0xFF) == 0 && (bb[posrgb + 2] & 0xFF) == 255 ? -1 : 0);
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
        this.ccl.Label(imtmp, 0, true);
        int[] labels = this.ccl.Labels1D();
        posrgb = 0;
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if ((bb[posrgb + 1] & 0xFF) != 0) {
                    labels[pos] = 0;
                } else if ((bb[posrgb] & 0xFF) == 255 && (bb[posrgb + 2] & 0xFF) == 0) {
                    labels[pos] = 1;
                } else if ((bb[posrgb] & 0xFF) != 0 || (bb[posrgb + 2] & 0xFF) != 255) {
                    labels[pos] = 0;
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
        int[] hist = new int[256];
        for (x = 0; x < labels.length; ++x) {
            int n = labels[x];
            hist[n] = hist[n] + 1;
        }
        int[] lut = new int[hist.length];
        lut[0] = 0;
        lut[1] = 1;
        int i2 = 2;
        for (x = 2; x < hist.length; ++x) {
            lut[x] = hist[x] == 0 ? 0 : i2++;
        }
        ArrayOperations.Lut((int[])labels, (int[])lut, (int[])labels);
        ArrayComparator.Compare((int[])labels, (String)"!=", (int)4, (int[])labels, (int)2, (int[])labels);
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (labels[pos] != 0) {
                    this.markers.add(new CoordinatesWeighted(x, y, layer, -1, labels[pos]));
                }
                ++x;
                ++pos;
            }
        }
        bbtmp = null;
        imtmp = null;
        this.markermax = this.AF.Maximum(labels);
        lut = null;
        hist = null;
        labels = null;
        if (255 < this.markermax) {
            throw new IllegalStateException("Too many markers: 255 < markermax");
        }
        if (this.MaxNumberMarkers + 1 < this.markermax) {
            throw new IllegalStateException("nummax+1 < markermax");
        }
    }

    private void CreateComplexMarkers(BufferedImage image, int layer) {
        int x;
        int y;
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage imtmp = ImageNew.Same((BufferedImage)image, (int)10);
        byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        byte[] bbtmp = ((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData();
        int posrgb = 0;
        int pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                bbtmp[pos] = (bb[posrgb + 1] & 0xFF) != 0 ? 0 : ((bb[posrgb] & 0xFF) == 255 && (bb[posrgb + 2] & 0xFF) == 0 || (bb[posrgb] & 0xFF) == 0 && (bb[posrgb + 2] & 0xFF) == 255 ? -1 : 0);
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
        this.ccl.Label(imtmp, 0, true);
        int[] labels = this.ccl.Labels1D();
        for (int i2 = 0; i2 < bbtmp.length; ++i2) {
            bbtmp[i2] = (byte)labels[i2];
        }
        ArrayArithmetic.AddUnsigned((byte[])bbtmp, (byte)1, (byte[])bbtmp);
        posrgb = 0;
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if ((bb[posrgb + 1] & 0xFF) != 0) {
                    bbtmp[pos] = 0;
                } else if ((bb[posrgb] & 0xFF) == 255 && (bb[posrgb + 2] & 0xFF) == 0) {
                    bbtmp[pos] = 1;
                } else if ((bb[posrgb] & 0xFF) != 0 || (bb[posrgb + 2] & 0xFF) != 255) {
                    bbtmp[pos] = 0;
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (bbtmp[pos] != 0) {
                    this.markers.add(new CoordinatesWeighted(x, y, layer, -1, bbtmp[pos] & 0xFF));
                }
                ++x;
                ++pos;
            }
        }
        bbtmp = null;
        labels = null;
        this.markermax = (int)this.IF.Maximum(imtmp);
        imtmp = null;
        if (255 < this.markermax) {
            throw new Error("Too many markers.");
        }
    }

    public void CorrectMarkersColors(String directory) throws IOException {
        File[] images = new File(directory).listFiles();
        for (int m = 0; m < images.length; ++m) {
            BufferedImage image = ImageIO.Read(images[m].getAbsoluteFile());
            int channel = image.getRaster().getNumBands();
            switch (image.getType()) {
                case 5: {
                    int pos;
                    byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                    for (pos = 0; pos < bb.length; pos += channel) {
                        if (bb[pos] == bb[pos + 1] && bb[pos + 1] == bb[pos + 2]) continue;
                        if ((bb[pos] & 0xFF) < (bb[pos + 2] & 0xFF)) {
                            bb[pos + 1] = 0;
                            bb[pos] = 0;
                            bb[pos + 2] = -1;
                            continue;
                        }
                        bb[pos] = -1;
                        bb[pos + 2] = 0;
                        bb[pos + 1] = 0;
                    }
                    bb = null;
                    break;
                }
                case 6: {
                    int pos;
                    byte[] bb2 = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                    for (pos = 0; pos < bb2.length; pos += channel) {
                        if (bb2[pos + 1] == bb2[pos + 2] && bb2[pos + 2] == bb2[pos + 3]) continue;
                        if ((bb2[pos + 1] & 0xFF) < (bb2[pos + 2] & 0xFF)) {
                            bb2[pos + 2] = 0;
                            bb2[pos + 1] = 0;
                            bb2[pos] = 0;
                            bb2[pos + 3] = -1;
                            continue;
                        }
                        bb2[pos + 1] = -1;
                        bb2[pos + 3] = 0;
                        bb2[pos + 2] = 0;
                        bb2[pos] = 0;
                    }
                    bb2 = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported.");
                }
            }
            ImageIO.Write(image, images[m].getName(), 6);
            image = null;
        }
        images = null;
    }

    public void WatershedAfterNN(String inputpath, String resultpath, int nbCPU) throws Exception {
        Object[] images = new File(inputpath).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(images);
        this.WatershedAfterNN((File[])images, 0, images.length, resultpath, nbCPU);
    }

    public void WatershedAfterNN(String inputpath, int from, int nbimages, String resultpath, int nbCPU) throws Exception {
        Object[] images = new File(inputpath).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(images);
        this.WatershedAfterNN((File[])images, from, nbimages, resultpath, nbCPU);
    }

    public void WatershedAfterNN(File[] images, int from, int nbimages, String resultpath, int nbCPU) throws Exception {
        DV dv = DvIO.ReadFromStack(images, from, nbimages);
        DvComparator.Compare((DV)dv, (String)"<=", (int)127, (int)0, (int)255, (DV)dv);
        UnionFindCcl ufccl = new UnionFindCcl();
        ufccl.Label(dv, 0, true);
        int[] labels = ufccl.Labels1D();
        int[] sizes = ufccl.Sizes();
        int maxindex = this.AF.MaximumIndex(sizes, 1, sizes.length);
        byte[] bbdv = dv.getDataBufferByte(0);
        for (int i2 = 0; i2 < bbdv.length; ++i2) {
            if (labels[i2] == maxindex) continue;
            bbdv[i2] = 0;
        }
        DV dvtmp = DvNew.Same((DV)dv);
        DV dvtmp2 = DvNew.Same((DV)dv);
        DV markers = DvNew.Same((DV)dv, (int)32);
        StructuringElement3D se5 = new StructuringElement3D(new Object[]{5, -2});
        Erode erode = new Erode();
        erode.Filter(dv, se5, dvtmp, nbCPU);
        DvComparator.Compare((DV)dvtmp, (String)"!=", (int)0, (int)200, (int)0, (DV)markers);
        Invert invert = new Invert();
        invert.Filter(dv, dvtmp, nbCPU);
        erode.Filter(dvtmp, se5, dvtmp2, nbCPU);
        DvComparator.Compare((DV)dvtmp2, (String)"==", (int)0, (DV)markers, (int)100, (DV)markers);
        erode.Kill();
        erode = null;
        StructuringElement3D se = new StructuringElement3D(new Object[]{2, -2});
        Median median = new Median();
        median.Filter(dv, se, dvtmp2, nbCPU);
        dv.Kill();
        dv = null;
        Sobel sobel = new Sobel();
        sobel.HowCorrect(2);
        sobel.Filter(dvtmp2, dvtmp, nbCPU);
        dvtmp2.Kill();
        dvtmp2 = null;
        Watershed watershed = new Watershed();
        watershed.watershed(dvtmp, markers, new StructuringElement3D(new Object[]{1, -2}));
        DvConverter.Universal(watershed.Basins3D(), dvtmp);
        DvComparator.Compare((DV)dvtmp, (String)"==", (int)200, (int)255, (int)0, (DV)dvtmp);
        File resfile = new File(resultpath);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        DvIO.WriteStack(dvtmp, resfile.getAbsolutePath() + "/", "Bassins_", "png");
        DvConverter.Universal(watershed.Edges3D(), dvtmp);
        DvIO.WriteStack(dvtmp, resfile.getAbsolutePath() + "/", "Edges_", "png");
    }

    public void DemocracyFromNNresults(String outputdir, int minvotes, String ... nnresults) throws IOException {
        int i2;
        File resfile = new File(outputdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        int nbnn = nnresults.length;
        File[][] resnn = new File[nbnn][];
        for (int i3 = 0; i3 < nbnn; ++i3) {
            resnn[i3] = new File(nnresults[i3]).listFiles(FileNameFilters.ImagesPNG);
            Arrays.sort(resnn[i3]);
        }
        int nbimages = resnn[0].length;
        for (i2 = 1; i2 < nbnn; ++i2) {
            if (resnn[i2].length == nbimages) continue;
            throw new IllegalArgumentException("Different number of images found into the directories.");
        }
        for (i2 = 0; i2 < nbimages; ++i2) {
            BufferedImage votes = null;
            byte[] bbvotes = null;
            for (int j = 0; j < nbnn; ++j) {
                BufferedImage image = ImageIO.Read(resnn[j][i2]);
                byte[] bbim = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                if (votes == null) {
                    votes = ImageNew.Same((BufferedImage)image);
                    bbvotes = ((DataBufferByte)votes.getRaster().getDataBuffer()).getData();
                } else if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)votes)) {
                    throw new IllegalArgumentException("Image are different: " + resnn[j][i2].getName());
                }
                for (int x = 0; x < bbim.length; ++x) {
                    if (bbim[x] >= 0) continue;
                    int n = x;
                    bbvotes[n] = (byte)(bbvotes[n] + 1);
                }
                bbim = null;
                image = null;
            }
            ImageComparator.Compare(votes, (String)">=", (int)minvotes, (int)255, (int)0, votes);
            ImageIO.Write(votes, resfile.getAbsolutePath() + "/" + resnn[0][i2].getName(), 6);
            bbvotes = null;
            votes = null;
        }
        for (i2 = 0; i2 < nbnn; ++i2) {
            Arrays.fill(resnn[i2], null);
        }
        Arrays.fill((Object[])resnn, null);
        resnn = null;
        resfile = null;
    }

    public void run(String string) {
    }

    public static enum PrepMode {
        STACK,
        FILE,
        NONE,
        EXIT;

    }
}

