/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.jason;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import filesAndFolders.FileFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListTools;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import measures.histogram.Histogram;
import morphee.StructuringElement;
import softwares.ohsu.jason.CellSegmentation;
import utils.memory.Allocator;

public class SampleStatistics {
    private Allocator allocator = Allocator.Instance();
    public static FilenameFilter ImagesDAPIPNG = CellSegmentation.ImagesDAPIPNG;
    public static FilenameFilter ImagesDAPI = CellSegmentation.ImagesDAPI;
    public static FilenameFilter MarkersFilter = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.startsWith("Segmentation - ") && name.endsWith("+.png");
    private DistanceMapComputer dmc = new DistanceMapComputer();
    private Histogram histogram = new Histogram();
    private StructuringElement se = new StructuringElement(new Object[]{3, -15});
    private UnionFindCcl ufccl = new UnionFindCcl();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final int MinSurface = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ComputeJason(String dirpath, boolean aggressivemode, String resultsdir, int nbCPU) throws IOException, InterruptedException {
        File resfile = new File(resultsdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        FilterOutputStream statsfile = null;
        File[] images = new File(dirpath).listFiles(ImagesDAPI);
        for (int i2 = 0; i2 < images.length; ++i2) {
            try {
                File resultfile;
                BufferedImage source = ImageIO.Read(images[i2].getAbsolutePath());
                if (source.getType() == 5) {
                    source = ImageConverter.Channel((BufferedImage)source, (int)0);
                }
                if (!(resultfile = new File(resfile.getAbsolutePath() + "/" + images[i2].getName())).exists()) {
                    throw new IllegalStateException("Result directory does not exist.");
                }
                statsfile = new DataOutputStream(new FileOutputStream(resultfile.getAbsolutePath() + "/Statistics.txt"));
                StringBuilder sbdirect = new StringBuilder(1000);
                StringBuilder sbrefined = new StringBuilder(1000);
                StringBuilder sbrefinedplus = new StringBuilder(1000);
                sbdirect.append(images[i2].getName()).append("\n");
                sbdirect.append(images[i2].getAbsolutePath()).append("\n");
                BufferedImage basins = ImageIO.Read(resultfile.getAbsolutePath() + "/Watershed - Basins.png");
                switch (basins.getType()) {
                    case 10: {
                        basins = ImageConverter.ByteToInt((BufferedImage)basins);
                        break;
                    }
                    case 11: {
                        basins = ImageConverter.ShortToInt((BufferedImage)basins);
                        break;
                    }
                    case 6: {
                        basins = ImageConverter.RGBtoInt((BufferedImage)basins);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Bassins encoding not supported.");
                    }
                }
                int width = basins.getWidth();
                int height = basins.getHeight();
                int length = width * height;
                BufferedImage roi = ImageIO.Read(resultfile.getAbsolutePath() + "/Segmentation - ROI.png");
                this.histogram.Fill(roi);
                int[] hist = this.histogram.getValues(0);
                sbdirect.append("\n\nGeneral:\n");
                sbdirect.append(" - ").append(roi.getWidth()).append(" x ").append(roi.getHeight());
                sbdirect.append(" => ").append(length).append(" pixels\n");
                sbdirect.append(" - ").append(hist[255]).append(" (").append((double)hist[255] / (double)length * 100.0);
                sbdirect.append("%) pixels detected as nuclei (red, ROI = ").append(255).append(").\n");
                sbdirect.append(" - ").append(hist[200]).append(" (").append((double)hist[200] / (double)length * 100.0);
                sbdirect.append("%) pixels detected as unconfirmed nuclei (blue, ROI = ").append(200).append(").\n");
                this.ufccl.Label(basins, 0, true);
                int[] labels = (int[])this.ufccl.Labels1D().clone();
                int[] sizes = (int[])this.ufccl.Sizes().clone();
                sbdirect.append("\n\nDirect measurements:\n");
                sbdirect.append(" - ").append(sizes.length).append(" cells\n");
                int[] sizesclone = (int[])sizes.clone();
                sizesclone[0] = 0;
                this.AF.Ranks(sizesclone);
                int median = (int)this.AF.Rank50();
                int rank95 = (int)this.AF.Rank95();
                int[] coefs = new int[sizes.length];
                Arrays.fill(coefs, 1);
                coefs[0] = 0;
                for (int s = 1; s < sizes.length; ++s) {
                    if (rank95 >= sizes[s]) continue;
                    coefs[s] = sizes[s] / median;
                }
                int coefsum = (int)this.AF.Integral(coefs, 1, coefs.length);
                sbrefined.append("\n\nRefined measurements (after statistical analysis):\n");
                sbrefined.append(" - ").append(coefsum).append(" cells\n");
                ImageComparator.Compare((BufferedImage)roi, (String)"==", (int)200, (int)1, (int)0, (BufferedImage)roi);
                this.ufccl.Label(roi, 0, false);
                int[] labelsplus = this.ufccl.Labels1D();
                int[] sizesplus = this.ufccl.Sizes();
                int[] coefplus = new int[sizesplus.length];
                Arrays.fill(coefplus, 1);
                coefplus[0] = 0;
                for (int s = 1; s < sizesplus.length; ++s) {
                    coefplus[s] = sizesplus[s] / median;
                }
                int coefplusum = (int)this.AF.Integral(coefplus, 1, coefplus.length);
                sbrefinedplus.append("\n\nFull measurements => Nuclei (red) + Unconfirmed Nuclei (blue) + Statistical Analysis):\n");
                sbrefinedplus.append(" - ").append(coefsum + coefplusum).append(" cells\n");
                Object[] markers = new File(resultfile.getAbsolutePath()).listFiles(MarkersFilter);
                Arrays.sort(markers);
                int[][] counts = new int[markers.length][sizes.length];
                int[][] countplus = new int[markers.length][sizesplus.length];
                int[] nbkos = new int[markers.length];
                int[] nbkosref = new int[markers.length];
                int[] nbkosrefplus = new int[markers.length];
                for (int m = 0; m < markers.length; ++m) {
                    BufferedImage image = ImageIO.Read(((File)markers[m]).getAbsolutePath());
                    String name = ((File)markers[m]).getName();
                    String marker = name.substring(15, name.indexOf(".png"));
                    Arrays.fill(counts[m], 0);
                    this.Compute(image, counts[m], labels, sizes, coefs, nbkos, nbkosref, m);
                    sbdirect.append(" - ").append(nbkos[m]).append(" ").append(marker).append(" => ");
                    sbdirect.append((double)nbkos[m] / (double)sizes.length * 100.0).append("%\n");
                    sbrefined.append(" - ").append(nbkosref[m]).append(" ").append(marker).append(" => ");
                    sbrefined.append((double)nbkosref[m] / (double)coefsum * 100.0).append("%\n");
                    Arrays.fill(countplus[m], 0);
                    this.Compute(image, countplus[m], labelsplus, sizesplus, coefplus, nbkosrefplus, m);
                    sbrefinedplus.append(" - ").append(nbkosref[m] + nbkosrefplus[m]).append(" ").append(marker).append(" => ");
                    sbrefinedplus.append((double)(nbkosref[m] + nbkosrefplus[m]) / (double)(coefsum + coefplusum) * 100.0).append("%\n");
                }
                for (int m1 = 0; m1 < markers.length - 1; ++m1) {
                    for (int m2 = m1 + 1; m2 < markers.length; ++m2) {
                        this.Compute((File)markers[m1], nbkos[m1], nbkosref[m1], nbkosrefplus[m1], counts[m1], countplus[m1], (File)markers[m2], nbkos[m2], nbkosref[m2], nbkosrefplus[m2], counts[m2], countplus[m2], sizes, coefs, coefsum, sizesplus, coefplus, coefplusum, source, sbdirect, sbrefined, sbrefinedplus);
                    }
                }
                statsfile.write(sbdirect.toString().getBytes("ISO-8859-1"));
                statsfile.write(sbrefined.toString().getBytes("ISO-8859-1"));
                statsfile.write(sbrefinedplus.toString().getBytes("ISO-8859-1"));
                sizesclone = null;
                sizes = null;
                labels = null;
                basins = null;
                source = null;
                Arrays.fill((Object[])counts, null);
                counts = null;
                continue;
            }
            catch (IOException e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
                statsfile.write("Exception!\n".getBytes("ISO-8859-1"));
                statsfile.write((e.getCause().toString() + "\n").getBytes("ISO-8859-1"));
                statsfile.write((e.getMessage() + "\n").getBytes("ISO-8859-1"));
                continue;
            }
            finally {
                statsfile.close();
                statsfile = null;
            }
        }
    }

    private void Compute(BufferedImage image, int[] counts, int[] labels, int[] sizes, int[] coefs, int[] nbkos, int[] nbkosref, int num) throws IOException {
        short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        for (int pos = 0; pos < sb.length; ++pos) {
            if (sb[pos] == 0) continue;
            int n = labels[pos];
            counts[n] = counts[n] + 1;
        }
        sb = null;
        int nbko = 0;
        int nbkoref = 0;
        for (int x = 1; x < counts.length; ++x) {
            if (!(0.5 < (double)counts[x] / (double)sizes[x])) continue;
            ++nbko;
            nbkoref += coefs[x];
        }
        nbkos[num] = nbko;
        nbkosref[num] = nbkoref;
    }

    private void Compute(BufferedImage image, int[] countplus, int[] labelsplus, int[] sizesplus, int[] coefplus, int[] nbkosrefplus, int num) throws IOException {
        short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        for (int pos = 0; pos < sb.length; ++pos) {
            if (sb[pos] == 0) continue;
            int n = labelsplus[pos];
            countplus[n] = countplus[n] + 1;
        }
        sb = null;
        int nbkorefplus = 0;
        for (int x = 1; x < countplus.length; ++x) {
            if (!(0.5 < (double)countplus[x] / (double)sizesplus[x])) continue;
            nbkorefplus += coefplus[x];
        }
        nbkosrefplus[num] = nbkorefplus;
    }

    private void Compute(File imfile1, int count1, int count1ref, int count1refplus, int[] counts1, int[] countplus1, File imfile2, int count2, int count2ref, int count2refplus, int[] counts2, int[] countplus2, int[] sizes, int[] coefs, int coefsum, int[] sizesplus, int[] coefplus, int coefplusum, BufferedImage source, Appendable directout, Appendable refinedout, Appendable refinedplusout) throws IOException {
        int x;
        String name1 = imfile1.getName();
        String marker1 = name1.substring(15, name1.indexOf(".png"));
        String name2 = imfile2.getName();
        String marker2 = name2.substring(15, name2.indexOf(".png"));
        BufferedImage bin1 = ImageIO.Read(imfile1.getAbsolutePath());
        BufferedImage bin2 = ImageIO.Read(imfile2.getAbsolutePath());
        short[] sb1 = ((DataBufferUShort)bin1.getRaster().getDataBuffer()).getData();
        short[] sb2 = ((DataBufferUShort)bin2.getRaster().getDataBuffer()).getData();
        BufferedImage srcrgb = ImageConverter.GrayToColor((BufferedImage)source);
        byte[] bbrgb = ((DataBufferByte)srcrgb.getRaster().getDataBuffer()).getData();
        int nbko = 0;
        int nbkoref = 0;
        for (int x2 = 1; x2 < counts1.length; ++x2) {
            if (!(0.5 < (double)counts1[x2] / (double)sizes[x2]) || !(0.5 < (double)counts2[x2] / (double)sizes[x2])) continue;
            ++nbko;
            nbkoref += coefs[x2];
        }
        directout.append(" - " + nbko + " " + marker1 + " & " + marker2 + " => " + (double)nbko / (double)counts1.length * 100.0 + "% total, " + (double)nbko / (double)count1 * 100.0 + "% of " + marker1 + ", " + (double)nbko / (double)count2 * 100.0 + "% of " + marker2 + "\n");
        refinedout.append(" - " + nbkoref + " " + marker1 + " & " + marker2 + " => " + (double)nbkoref / (double)coefsum * 100.0 + "% total, " + (double)nbkoref / (double)count1ref * 100.0 + "% of " + marker1 + ", " + (double)nbkoref / (double)count2ref * 100.0 + "% of " + marker2 + "\n");
        int nbkorefplus = 0;
        for (x = 1; x < countplus1.length; ++x) {
            if (!(0.5 < (double)countplus1[x] / (double)sizesplus[x]) || !(0.5 < (double)countplus2[x] / (double)sizesplus[x])) continue;
            nbkorefplus += coefplus[x];
        }
        refinedplusout.append(" - " + (nbkorefplus + nbkoref) + " " + marker1 + " & " + marker2 + " => " + (double)(nbkorefplus + nbkoref) / (double)(coefsum + coefplusum) * 100.0 + "% total, " + (double)(nbkorefplus + nbkoref) / (double)(count1ref + count1refplus) * 100.0 + "% of " + marker1 + ", " + (double)(nbkorefplus + nbkoref) / (double)(count2ref + count2refplus) * 100.0 + "% of " + marker2 + "\n");
        x = 0;
        int pos = 0;
        while (x < sb1.length) {
            if (sb1[x] != 0 && sb2[x] != 0) {
                bbrgb[pos + 1] = 0;
                bbrgb[pos] = 0;
            } else {
                bbrgb[pos + 2] = 0;
                bbrgb[pos + 1] = 0;
            }
            ++x;
            pos += 3;
        }
        ImageIO.Write(srcrgb, imfile1.getParent() + "/Segmentation Nuclei - " + marker1 + " & " + marker2 + ".png", 6);
        marker2 = null;
        name2 = null;
        marker1 = null;
        name1 = null;
        sb2 = null;
        sb1 = null;
        bin2 = null;
        bin1 = null;
    }

    public void ComputeAllison(String dirpath, List<String> markers, int nbCPU) throws IOException, InterruptedException {
        File resfile = new File(dirpath);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        int[] types = new int[]{2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1};
        String[] names = new String[]{"Image", "Number", "Size", "X", "Y", "Overlap Red (Nuclei)", "Overlap Red (Estimated Nuclei)", "Overlap Red (Pixel)", "% Overlap Red", "Distance to Red", "Overlap Blue (Estimated Nuclei)", "Overlap Blue (Pixels)", "% Overlap Blue", "Distance to Blue"};
        FichierTabule[] stats = new FichierTabule[markers.size()];
        for (int i2 = 0; i2 < markers.size(); ++i2) {
            stats[i2] = new FichierTabule(30000, types, "");
            stats[i2].setColumnsNames(names);
        }
        int TotalRedNuclei = 0;
        int TotalEstimatedRedNuclei = 0;
        int TotalBlueNuclei = 0;
        int[] row = new int[markers.size()];
        Arrays.fill(row, 0);
        File[] directories = new File(dirpath).listFiles(FileFilters.Directories);
        System.out.println(directories.length + " directories found in " + dirpath);
        for (int d = 0; d < directories.length; ++d) {
            try {
                int RedNuclei;
                System.out.println("Directory " + d + " / " + directories.length);
                BufferedImage basins = ImageIO.Read(directories[d].getAbsolutePath() + "/Watershed - Basins.tif");
                block2 : switch (basins.getType()) {
                    case 10: {
                        basins = ImageConverter.ByteToInt((BufferedImage)basins);
                        break;
                    }
                    case 11: {
                        basins = ImageConverter.ShortToInt((BufferedImage)basins);
                        break;
                    }
                    case 6: {
                        basins = ImageConverter.RGBtoInt((BufferedImage)basins);
                        break;
                    }
                    case 0: {
                        switch (basins.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                break block2;
                            }
                        }
                        throw new IllegalStateException("Basins encoding not supported.");
                    }
                    default: {
                        throw new IllegalStateException("Basins encoding not supported.");
                    }
                }
                int[] ibbasins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
                int width = basins.getWidth();
                this.ufccl.Label(basins, 0, true);
                int[] sizes = this.ufccl.Sizes();
                this.AF.Ranks(sizes);
                int median = (int)this.AF.Rank50();
                int median2 = median << 1;
                int rank25 = (int)this.AF.Rank25();
                int EstimatedRedNuclei = RedNuclei = this.ufccl.ConnectedComponentsNumber();
                for (int i3 = 1; i3 < sizes.length; ++i3) {
                    if (median2 > sizes[i3]) continue;
                    EstimatedRedNuclei += (int)((double)sizes[i3] / (double)median);
                }
                sizes = null;
                BufferedImage roi = ImageIO.Read(directories[d].getAbsolutePath() + "/Segmentation - ROI.png");
                BufferedImage tmp = ImageNew.Same((BufferedImage)basins, (int)10);
                ImageComparator.Compare((BufferedImage)roi, (String)"==", (int)255, (int)1, (int)0, (BufferedImage)tmp);
                this.dmc.VoronoiFromSets(tmp, this.se);
                float[] redmap = (float[])this.dmc.getMontanariMap1D().clone();
                ImageComparator.Compare((BufferedImage)roi, (String)">=", (int)200, (int)1, (int)0, (BufferedImage)tmp);
                this.dmc.VoronoiFromSets(tmp, this.se);
                float[] bluemap = this.dmc.getMontanariMap1D();
                int BlueNuclei = EstimatedRedNuclei;
                ImageComparator.Compare((BufferedImage)roi, (String)"==", (int)200, (int)1, (int)0, (BufferedImage)tmp);
                this.ufccl.Label(tmp, 0, true);
                sizes = this.ufccl.Sizes();
                for (int i4 = 1; i4 < sizes.length; ++i4) {
                    if (rank25 <= sizes[i4] && sizes[i4] <= median) {
                        ++BlueNuclei;
                        continue;
                    }
                    BlueNuclei += (int)((double)sizes[i4] / (double)median);
                }
                sizes = null;
                TotalRedNuclei += RedNuclei;
                TotalEstimatedRedNuclei += EstimatedRedNuclei;
                TotalBlueNuclei += BlueNuclei;
                StringBuilder sb = new StringBuilder(2000);
                sb.append("# Nuclei (Red) = ").append(RedNuclei).append("\n");
                sb.append("# Nuclei (Red Estimated) = ").append(EstimatedRedNuclei).append("\n");
                sb.append("# Nuclei (Blue) = ").append(BlueNuclei).append("\n\n");
                for (int i5 = 0; i5 < markers.size(); ++i5) {
                    try {
                        BufferedImage marker = ImageIO.Read(directories[d].getAbsolutePath() + "/Segmentation - " + markers.get(i5) + ".png");
                        this.ufccl.Label(marker, 0, true);
                        this.ufccl.ComputeBoundingBoxes();
                        int[] markerlabels = (int[])this.ufccl.Labels1D().clone();
                        int[] markersizes = (int[])this.ufccl.Sizes().clone();
                        int[] minx = this.ufccl.minx();
                        int[] maxx = this.ufccl.maxx();
                        int[] miny = this.ufccl.miny();
                        int[] maxy = this.ufccl.maxy();
                        marker = null;
                        LinkedList<Integer> list = new LinkedList<Integer>();
                        for (int p = 1; p < markersizes.length; ++p) {
                            if (30 > markersizes[p]) continue;
                            stats[i5].setSelected(row[i5], true);
                            stats[i5].setValue(row[i5], 0, directories[d].getAbsolutePath() + "/Segmentation - " + markers.get(i5) + ".png");
                            stats[i5].setValue(row[i5], 1, p);
                            stats[i5].setValue(row[i5], 2, markersizes[p]);
                            stats[i5].setValue(row[i5], 3, minx[p] + maxx[p] >> 1);
                            stats[i5].setValue(row[i5], 4, miny[p] + maxy[p] >> 1);
                            float bluedist = Float.MAX_VALUE;
                            float reddist = Float.MAX_VALUE;
                            int bluecount = 0;
                            int redcount = 0;
                            for (int y = miny[p]; y <= maxy[p]; ++y) {
                                int x = minx[p];
                                int pos = y * width + x;
                                while (x <= maxx[p]) {
                                    if (markerlabels[pos] == p) {
                                        if (ibbasins[pos] != 0 && !ListTools.isInList(list, (int)ibbasins[pos])) {
                                            list.add(ibbasins[pos]);
                                        }
                                        if (bluemap[pos] < bluedist) {
                                            bluedist = bluemap[pos];
                                        }
                                        if (redmap[pos] < reddist) {
                                            reddist = redmap[pos];
                                        }
                                        switch (roi.getRaster().getSample(x, y, 0)) {
                                            case 255: {
                                                ++redcount;
                                            }
                                            case 200: {
                                                ++bluecount;
                                                break;
                                            }
                                        }
                                    }
                                    ++x;
                                    ++pos;
                                }
                            }
                            stats[i5].setValue(row[i5], 5, list.size());
                            stats[i5].setValue(row[i5], 6, Math.max(rank25 <= redcount ? 1 : 0, (int)((double)redcount / (double)median + 0.5)));
                            stats[i5].setValue(row[i5], 7, redcount);
                            stats[i5].setValue(row[i5], 8, (double)redcount / (double)markersizes[p]);
                            stats[i5].setValue(row[i5], 9, reddist);
                            stats[i5].setValue(row[i5], 10, Math.max(rank25 <= bluecount ? 1 : 0, (int)((double)bluecount / (double)median + 0.5)));
                            stats[i5].setValue(row[i5], 11, bluecount);
                            stats[i5].setValue(row[i5], 12, (double)bluecount / (double)markersizes[p]);
                            stats[i5].setValue(row[i5], 13, bluedist);
                            list.clear();
                            int n = i5;
                            row[n] = row[n] + 1;
                        }
                        list = null;
                        FichierTabule file = FichierTabuleTools.SaveSelectedRows(stats[i5]);
                        file.SelectWhere(0, 6, directories[d].getName());
                        FichierTabule f2 = FichierTabuleTools.SaveSelectedRows(file);
                        file.Kill();
                        file = f2;
                        sb.append(markers.get(i5)).append("\n");
                        sb.append(names[5]).append(" > 0 = ");
                        file.SelectWhere(names[5], 1, 0);
                        sb.append(file.getNbSelected()).append(" => ");
                        sb.append(100.0 * (double)file.getNbSelected() / (double)RedNuclei).append("%\n");
                        sb.append(names[6]).append(" > 0 = ");
                        file.SelectWhere(names[6], 1, 0);
                        sb.append(file.getNbSelected()).append(" => ");
                        sb.append(100.0 * (double)file.getNbSelected() / (double)EstimatedRedNuclei).append("%\n");
                        sb.append(names[8]).append(" >= 50% = ");
                        file.SelectWhere(names[8], 3, 0.5);
                        sb.append(file.getNbSelected()).append(" => ");
                        sb.append(100.0 * (double)file.getNbSelected() / (double)EstimatedRedNuclei).append("%\n");
                        sb.append(names[8]).append(" >= 75% = ");
                        file.SelectWhere(names[8], 3, 0.75);
                        sb.append(file.getNbSelected()).append(" => ");
                        sb.append(100.0 * (double)file.getNbSelected() / (double)EstimatedRedNuclei).append("%\n");
                        sb.append(names[10]).append(" > 0 = ");
                        file.SelectWhere(names[10], 1, 0);
                        sb.append(file.getNbSelected()).append(" => ");
                        sb.append(100.0 * (double)file.getNbSelected() / (double)BlueNuclei).append("%\n");
                        sb.append(names[12]).append(" >= 50% = ");
                        file.SelectWhere(names[12], 3, 0.5);
                        sb.append(file.getNbSelected()).append(" => ");
                        sb.append(100.0 * (double)file.getNbSelected() / (double)BlueNuclei).append("%\n");
                        sb.append(names[12]).append(" >= 75% = ");
                        file.SelectWhere(names[12], 3, 0.75);
                        sb.append(file.getNbSelected()).append(" => ");
                        sb.append(100.0 * (double)file.getNbSelected() / (double)BlueNuclei).append("%\n\n\n");
                        file.Write(dirpath + "/" + directories[d].getName() + "/Statistics - " + markers.get(i5) + ".txt", false);
                        file.Kill();
                        f2 = null;
                        file = null;
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                DataOutputStream statsfile = new DataOutputStream(new FileOutputStream(dirpath + "/" + directories[d].getName() + "/Statistics.txt"));
                statsfile.write(sb.toString().getBytes("ISO-8859-1"));
                statsfile = null;
                roi = null;
                basins = null;
                this.allocator.Release(tmp);
                continue;
            }
            catch (IOException e) {
                System.out.flush();
                e.printStackTrace();
                System.err.println("Max in row[] = " + this.AF.Maximum(row));
                System.err.flush();
            }
        }
        DataOutputStream statsfile = new DataOutputStream(new FileOutputStream(dirpath + "/Statistics.txt"));
        StringBuilder sb = new StringBuilder(2000);
        sb.append("# Nuclei (Red) = ").append(TotalRedNuclei).append("\n");
        sb.append("# Nuclei (Red Estimated) = ").append(TotalEstimatedRedNuclei).append("\n");
        sb.append("# Nuclei (Blue) = ").append(TotalBlueNuclei).append("\n\n");
        for (int i6 = 0; i6 < markers.size(); ++i6) {
            if (0 >= stats[i6].getNbSelected()) continue;
            FichierTabule file = FichierTabuleTools.SaveSelectedRows(stats[i6]);
            sb.append(markers.get(i6)).append("\n");
            sb.append(names[5]).append(" > 0 = ");
            file.SelectWhere(names[5], 1, 0);
            sb.append(file.getNbSelected()).append(" => ");
            sb.append(100.0 * (double)file.getNbSelected() / (double)TotalRedNuclei).append("%\n");
            sb.append(names[6]).append(" > 0 = ");
            file.SelectWhere(names[6], 1, 0);
            sb.append(file.getNbSelected()).append(" => ");
            sb.append(100.0 * (double)file.getNbSelected() / (double)TotalEstimatedRedNuclei).append("%\n");
            sb.append(names[8]).append(" >= 50% = ");
            file.SelectWhere(names[8], 3, 0.5);
            sb.append(file.getNbSelected()).append(" => ");
            sb.append(100.0 * (double)file.getNbSelected() / (double)TotalEstimatedRedNuclei).append("%\n");
            sb.append(names[8]).append(" >= 75% = ");
            file.SelectWhere(names[8], 3, 0.75);
            sb.append(file.getNbSelected()).append(" => ");
            sb.append(100.0 * (double)file.getNbSelected() / (double)TotalEstimatedRedNuclei).append("%\n");
            sb.append(names[10]).append(" > 0 = ");
            file.SelectWhere(names[10], 1, 0);
            sb.append(file.getNbSelected()).append(" => ");
            sb.append(100.0 * (double)file.getNbSelected() / (double)TotalBlueNuclei).append("%\n");
            sb.append(names[12]).append(" >= 50% = ");
            file.SelectWhere(names[12], 3, 0.5);
            sb.append(file.getNbSelected()).append(" => ");
            sb.append(100.0 * (double)file.getNbSelected() / (double)TotalBlueNuclei).append("%\n");
            sb.append(names[12]).append(" >= 75% = ");
            file.SelectWhere(names[12], 3, 0.75);
            sb.append(file.getNbSelected()).append(" => ");
            sb.append(100.0 * (double)file.getNbSelected() / (double)TotalBlueNuclei).append("%\n\n\n");
            file.Write(dirpath + "/Statistics - " + markers.get(i6) + ".txt", false);
            file.Kill();
            stats[i6].Kill();
            stats[i6] = null;
            file = null;
        }
        statsfile.write(sb.toString().getBytes("ISO-8859-1"));
        statsfile = null;
    }

    public void ComputeImageAllison(String srcdirpath, String resdirpath) throws IOException, InterruptedException {
        File resfile = new File(resdirpath);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        int[] hist = new int[100];
        File[] directories = new File(srcdirpath).listFiles(FileFilters.Directories);
        for (int d = 0; d < directories.length; ++d) {
            try {
                int i2;
                BufferedImage src = ImageIO.Read(directories[d].getAbsolutePath() + "/" + directories[d].getName() + "_DAPI.tif");
                short[] sbsrc = ((DataBufferUShort)src.getRaster().getDataBuffer()).getData();
                BufferedImage cy3 = ImageIO.Read(directories[d].getAbsolutePath() + "/" + directories[d].getName() + "_Cy3.tif");
                short[] sbcy3 = ((DataBufferUShort)cy3.getRaster().getDataBuffer()).getData();
                BufferedImage cy55 = ImageIO.Read(directories[d].getAbsolutePath() + "/" + directories[d].getName() + "_Cy5-5.tif");
                short[] sbcy55 = ((DataBufferUShort)cy55.getRaster().getDataBuffer()).getData();
                System.out.println("Cy3 => Min = " + this.AF.Minimum(sbcy3) + ", max = " + this.AF.Maximum(sbcy3));
                System.out.println("Cy55 => Min = " + this.AF.Minimum(sbcy55) + ", max = " + this.AF.Maximum(sbcy55));
                int[] ibcy55 = this.allocator.newIntArray(sbcy55.length);
                ArrayConverter.UnsignedShortToInt((short[])sbcy55, (int[])ibcy55);
                ArrayArithmetic.Multiply((int[])ibcy55, (int)50, (int[])ibcy55);
                Arrays.fill(hist, 0);
                double[] result = this.allocator.newDoubleArray(sbcy55.length);
                for (i2 = 0; i2 < result.length; ++i2) {
                    result[i2] = (double)((sbcy3[i2] & 0xFFFF) - (sbcy55[i2] & 0xFFFF)) / (double)(sbcy55[i2] & 0xFFFF);
                    int n = (int)(result[i2] + 1.5);
                    hist[n] = hist[n] + 1;
                }
                System.out.println("Result => Min = " + this.AF.Minimum(result) + ", max = " + this.AF.Maximum(result));
                for (i2 = 0; i2 < result.length; ++i2) {
                    result[i2] = 15.0 * (result[i2] - 3.0);
                }
                BufferedImage imdapi = ImageNew.Same((BufferedImage)src, (int)10);
                byte[] bbdapi = ((DataBufferByte)imdapi.getRaster().getDataBuffer()).getData();
                BufferedImage imres = ImageNew.Same((BufferedImage)src, (int)10);
                byte[] bbres = ((DataBufferByte)imres.getRaster().getDataBuffer()).getData();
                BufferedImage imover = ImageNew.Same((BufferedImage)src, (int)5);
                byte[] bbover = ((DataBufferByte)imover.getRaster().getDataBuffer()).getData();
                int i3 = 0;
                int pos = 0;
                while (i3 < result.length) {
                    bbover[pos] = bbdapi[i3] = (byte)((sbsrc[i3] & 0xFFFF) >> 6);
                    int val = (int)(result[i3] + 0.5);
                    if (val < 0) {
                        val = 0;
                    } else if (255 < val) {
                        val = 255;
                    }
                    bbover[pos + 2] = bbres[i3] = (byte)val;
                    ++i3;
                    pos += 3;
                }
                File resdir = new File(resdirpath + "/" + directories[d].getName() + "_DAPI.tif");
                if (!resdir.exists()) {
                    resdir.mkdirs();
                }
                ImageIO.Write(imdapi, resdir.getAbsolutePath() + "/Dapi.png", 6);
                ImageIO.Write(imres, resdir.getAbsolutePath() + "/Result.png", 6);
                ImageIO.Write(imover, resdir.getAbsolutePath() + "/Overlay.png", 6);
                int sum = (int)this.AF.Integral(hist);
                for (int i4 = 0; i4 < hist.length; ++i4) {
                    System.out.println("hist[" + (i4 - 1) + "] = " + hist[i4] + " => " + (double)hist[i4] / (double)sum * 100.0 + "%");
                }
                this.allocator.Release(ibcy55);
                this.allocator.Release(imdapi);
                this.allocator.Release(imres);
                this.allocator.Release(imover);
                continue;
            }
            catch (IOException e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
            }
        }
        hist = null;
    }
}

