/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.jason;

import characterization.shapes.shapeIndexes.ShapeIndexesComputer;
import displays.Display;
import filesAndFolders.FileFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.Measures2D;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import morphee.Close;
import morphee.Erode;
import morphee.Open;
import morphee.StructuringElement;
import processing.filters.DynamicExpansion;
import processing.thresholding.Binary;
import processing.thresholding.Entropy;
import processing.thresholding.Huang;
import processing.thresholding.ImageThresholder;
import processing.thresholding.Li;
import processing.thresholding.Otsu;
import processing.thresholding.Renyi;
import processing.thresholding.TriangleThresholding;
import processing.thresholding.Yen;
import segmentation.cells.DapiMM;
import utils.memory.Allocator;

public class CellSegmentation {
    private Allocator allocator = Allocator.Instance();
    public Display display = null;
    private final DapiMM dapi;
    public static FilenameFilter ImagesDAPIPNG = (dir, name) -> !(name.charAt(0) == '.' || name.contains("DS_Store") || !name.contains("DAPI") && !name.contains("Dapi") || !name.endsWith(".png") && !name.endsWith(".PNG"));
    public static FilenameFilter ImagesDAPI = (dir, name) -> !(name.charAt(0) == '.' || name.contains("DS_Store") || !name.contains("_c0_") && !name.contains("Dapi") && !name.contains("20x_b0s0c0x") || !name.endsWith(".png") && !name.endsWith(".PNG") && !name.endsWith(".tif") && !name.endsWith(".tiff") && !name.endsWith(".TIF") && !name.endsWith(".TIFF"));
    private Binary binary = new Binary();
    private Close close = new Close();
    private DynamicExpansion de = new DynamicExpansion();
    private Erode erode = new Erode();
    private FillHole fh = new FillHole();
    private Open open = new Open();
    private UnionFindCcl ufccl = new UnionFindCcl();
    private ImageThresholder[] thresholders = new ImageThresholder[7];
    private final StructuringElement clopse;
    private final StructuringElement sq2se = new StructuringElement(new Object[]{2, -1});
    private final StructuringElement hex5se = new StructuringElement(new Object[]{5, -9});
    private final StructuringElement dmse = new StructuringElement(new Object[]{3, -15});
    private ShapeIndexesComputer csi = new ShapeIndexesComputer();
    public static int CKthres = 1500;
    public static int Kithres = 1500;
    public static int SYPthres = 1500;
    public static int AlphaSMAthres = 1500;
    public static int FillHoles = 250;
    private final int Magnification;
    private final boolean smallnuclei;
    private final ImageFeatures IF = new ImageFeatures();
    public String WaitFor = "";
    public boolean SingleWork = false;

    public CellSegmentation(int Magnification, boolean smallnuclei) {
        switch (Magnification) {
            case 10: {
                this.clopse = new StructuringElement(new Object[]{smallnuclei ? 2 : 5, -9});
                break;
            }
            case 20: {
                this.clopse = new StructuringElement(new Object[]{smallnuclei ? 7 : 11, -9});
                break;
            }
            case 40: {
                this.clopse = new StructuringElement(new Object[]{smallnuclei ? 17 : 23, -9});
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.dapi = new DapiMM(Magnification, smallnuclei);
        this.Magnification = Magnification;
        this.smallnuclei = smallnuclei;
        this.thresholders[0] = new Entropy();
        this.thresholders[1] = new Li();
        this.thresholders[2] = new Huang();
        this.thresholders[3] = new Otsu();
        this.thresholders[4] = new Renyi();
        this.thresholders[5] = new TriangleThresholding();
        this.thresholders[6] = new Yen();
        this.csi.Indexes[0] = null;
        this.csi.Indexes[1] = null;
        this.csi.Indexes[3] = null;
        this.csi.Indexes[4] = null;
        this.csi.Indexes[5] = null;
        this.csi.Indexes[9] = null;
        this.csi.Indexes[10] = null;
        this.csi.Indexes[13] = null;
        this.csi.Indexes[14] = null;
        this.csi.Indexes[15] = null;
        this.csi.Indexes[16] = null;
        this.csi.Indexes[17] = null;
        this.csi.Indexes[18] = null;
        this.csi.Indexes[19] = null;
        this.csi.Indexes[20] = null;
        this.csi.Indexes[21] = null;
        this.csi.Indexes[22] = null;
        this.csi.Indexes[23] = null;
        this.csi.Indexes[24] = null;
        this.csi.Indexes[25] = null;
        this.csi.Indexes[26] = null;
    }

    public void ProcessMultipleDirectories(String dirpath, boolean dirtybackground, String resultsdir, int nbCPU) throws IOException, InterruptedException {
        Object[] dirs = new File(dirpath).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        System.out.println(dirs.length + " directories found in " + dirpath);
        for (int i2 = 0; i2 < dirs.length; ++i2) {
            System.out.println(" ------------------------------------- Directory " + i2 + " / " + dirs.length + " ------------------------------------- ");
            this.Process(((File)dirs[i2]).getAbsolutePath(), dirtybackground, resultsdir, nbCPU);
        }
        Arrays.fill(dirs, null);
        dirs = null;
    }

    public void Process(String dirpath, boolean dirtybackground, String resultsdir, int nbCPU) throws IOException, InterruptedException {
        File resfile = new File(resultsdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        this.dapi.display = this.display;
        Object[] images = new File(dirpath).listFiles(ImagesDAPI);
        Arrays.sort(images);
        System.out.println("\n" + images.length + " images in " + dirpath);
        boolean work = this.WaitFor.isEmpty();
        for (int i2 = 0; i2 < images.length; ++i2) {
            try {
                File resultfile;
                System.out.println(i2 + " / " + images.length);
                if (!work) {
                    if (!((File)images[i2]).getName().equalsIgnoreCase(this.WaitFor)) continue;
                    work = true;
                    this.WaitFor = "";
                }
                if (!(resultfile = new File(resfile.getAbsolutePath() + "/" + ((File)images[i2]).getName())).exists()) {
                    resultfile.mkdirs();
                }
                BufferedImage source = ImageIO.Read(((File)images[i2]).getAbsolutePath());
                switch (source.getType()) {
                    case 10: {
                        ImageIO.Write(source, resfile.getAbsolutePath() + "/" + ((File)images[i2]).getName() + "/Original.png", 6);
                        source = ImageConverter.GrayToUShort((BufferedImage)source, (boolean)true);
                        break;
                    }
                    case 11: {
                        ImageIO.Write(source, resfile.getAbsolutePath() + "/" + ((File)images[i2]).getName() + "/Original.png", 6);
                        break;
                    }
                    case 5: {
                        source = ImageConverter.Channel((BufferedImage)source, (int)0);
                        ImageIO.Write(source, resfile.getAbsolutePath() + "/" + ((File)images[i2]).getName() + "/Original.png", 6);
                        source = ImageConverter.GrayToUShort((BufferedImage)source, (boolean)true);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Source image type not supported.");
                    }
                }
                this.dapi.Segmentation(source, dirtybackground, 2, true, true, true, false, null, 1, resultfile.getAbsolutePath(), nbCPU);
                BufferedImage roi = null;
                File roifile = new File(resultfile.getAbsolutePath() + "/Segmentation - ROI.png");
                if (roifile.exists()) {
                    roi = ImageIO.Read(resultfile.getAbsolutePath() + "/Segmentation - ROI.png");
                }
                if (roi == null || ImageTools.isBlack(roi)) {
                    source = ImageNew.Same((BufferedImage)source, (int)10);
                    ImageOperations.Fill((BufferedImage)source, (int)0);
                    ImageIO.Write(source, resultfile.getAbsolutePath() + "/Segmentation - C1+.png", 6);
                    ImageIO.Write(source, resultfile.getAbsolutePath() + "/Segmentation - C2+.png", 6);
                    ImageIO.Write(source, resultfile.getAbsolutePath() + "/Segmentation - C3+.png", 6);
                    continue;
                }
                BufferedImage ue = null;
                File uefile = new File(resultfile.getAbsolutePath() + "/Intermediate - UltimateEroded.png");
                if (uefile.exists()) {
                    ue = ImageIO.Read(resultfile.getAbsolutePath() + "/Intermediate - UltimateEroded.png");
                }
                if (ue == null || ImageTools.isBlack(ue)) {
                    source = ImageNew.Same((BufferedImage)source, (int)10);
                    ImageOperations.Fill((BufferedImage)source, (int)0);
                    ImageIO.Write(source, resultfile.getAbsolutePath() + "/Segmentation - C1+.png", 6);
                    ImageIO.Write(source, resultfile.getAbsolutePath() + "/Segmentation - C2+.png", 6);
                    ImageIO.Write(source, resultfile.getAbsolutePath() + "/Segmentation - C3+.png", 6);
                    continue;
                }
                this.de.Filter(source, 0, 65535, source, nbCPU);
                BufferedImage srccolor = ImageConverter.GrayToColor((BufferedImage)source);
                this.Segment(source, srccolor, roi, (File)images[i2], "_c0_", "_c1_", -1, resultfile, "C1", nbCPU);
                ImageConverter.GrayToColor((BufferedImage)source, (BufferedImage)srccolor);
                this.Segment(source, srccolor, roi, (File)images[i2], "_c0_", "_c2_", -1, resultfile, "C2", nbCPU);
                ImageConverter.GrayToColor((BufferedImage)source, (BufferedImage)srccolor);
                this.Segment(source, srccolor, roi, (File)images[i2], "_c0_", "_c3_", -1, resultfile, "C3", nbCPU);
                roi = null;
                srccolor = null;
                source = null;
                if (!this.SingleWork) continue;
                break;
            }
            catch (Exception e) {
                System.out.flush();
                e.printStackTrace();
                System.err.println("Exception generated by image: " + ((File)images[i2]).getAbsolutePath());
                System.err.flush();
            }
        }
    }

    private void Segment(BufferedImage source, BufferedImage srccolor, BufferedImage roi, File imfile, String tofind, String toreplace, int threshold, File resultfile, String markername, int nbCPU) throws IOException {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage marker = ImageIO.Read(imfile.getAbsolutePath().replace(tofind, toreplace));
        switch (marker.getType()) {
            case 10: {
                marker = ImageConverter.GrayToUShort((BufferedImage)marker, (boolean)true);
                break;
            }
            case 11: {
                break;
            }
            case 5: {
                BufferedImage channel = ImageNew.Same((BufferedImage)marker, (int)10);
                for (int c = 0; c < marker.getRaster().getNumBands(); ++c) {
                    ImageConverter.Channel((BufferedImage)marker, (int)c, (BufferedImage)channel);
                    if (!ImageTools.isBlack((BufferedImage)channel)) break;
                }
                marker = ImageConverter.GrayToUShort((BufferedImage)channel, (boolean)true);
                channel = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        BufferedImage imbin = ImageNew.Same((BufferedImage)marker);
        switch (threshold) {
            case -1: {
                BufferedImage acc = ImageNew.Same((BufferedImage)marker);
                for (ImageThresholder thresholder : this.thresholders) {
                    thresholder.Filter(marker, imbin, nbCPU);
                    ImageComparator.Compare((BufferedImage)imbin, (String)"!=", (int)0, (int)1, (int)0, (BufferedImage)imbin);
                    ImageArithmetic.Add(imbin, acc, acc);
                }
                ImageComparator.Compare((BufferedImage)acc, (String)">", (int)(this.thresholders.length >> 1), (int)65535, (int)0, (BufferedImage)imbin);
                acc = null;
                break;
            }
            default: {
                if (threshold < 0) {
                    throw new IllegalArgumentException("Threshold value not supported.");
                }
                this.binary.Filter(marker, threshold, imbin, nbCPU);
            }
        }
        BufferedImage imcl = this.close.Filter(imbin, this.clopse, nbCPU);
        BufferedImage imop = this.open.Filter(imcl, new StructuringElement(new Object[]{1, -9}), nbCPU);
        this.fh.Fill(imop, (ConnectedComponentLabeling)this.ufccl, FillHoles, true, imop);
        ImageIO.Write(imop, resultfile.getAbsolutePath() + "/Segmentation - " + markername + "+.png", 6);
        short[] sbop = ((DataBufferUShort)imop.getRaster().getDataBuffer()).getData();
        byte[] bbcolor = ((DataBufferByte)srccolor.getRaster().getDataBuffer()).getData();
        int pos = 0;
        int poscol = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                switch (roi.getRaster().getSample(x, y, 0)) {
                    case 200: 
                    case 255: {
                        if (sbop[pos] != 0) {
                            bbcolor[poscol + 1] = 0;
                            bbcolor[poscol] = 0;
                            break;
                        }
                        bbcolor[poscol + 2] = 0;
                        bbcolor[poscol + 1] = 0;
                        break;
                    }
                    case 100: {
                        if (sbop[pos] != 0) {
                            bbcolor[poscol + 1] = 0;
                            break;
                        }
                        bbcolor[poscol + 2] = 0;
                    }
                }
                ++x;
                ++pos;
                poscol += 3;
            }
        }
        sbop = null;
        bbcolor = null;
        ImageIO.Write(srccolor, resultfile.getAbsolutePath() + "/Segmentation Nuclei - " + markername + "+.png", 6);
        imcl = this.allocator.Release(imcl);
        imop = this.allocator.Release(imop);
        imbin = this.allocator.Release(imbin);
        marker = null;
    }

    private int FindThreshold(File imfile, String tofind, String srctoreplace, String imrefpath, int nbCPU) throws IOException {
        BufferedImage source = ImageIO.Read(imfile.getAbsolutePath().replace(tofind, srctoreplace));
        switch (source.getType()) {
            case 11: {
                break;
            }
            case 5: {
                BufferedImage channel = ImageNew.Same((BufferedImage)source, (int)10);
                for (int c = 0; c < source.getRaster().getNumBands(); ++c) {
                    ImageConverter.Channel((BufferedImage)source, (int)c, (BufferedImage)channel);
                    if (!ImageTools.isBlack((BufferedImage)channel)) break;
                }
                source = ImageConverter.GrayToUShort((BufferedImage)channel, (boolean)true);
                channel = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        BufferedImage reference = ImageIO.Read(imrefpath);
        BufferedImage imero = this.erode.Filter(reference, this.hex5se, nbCPU);
        BufferedImage imop = this.open.Filter(source, this.sq2se, nbCPU);
        BufferedImage imcl = this.close.Filter(imop, this.sq2se, nbCPU);
        ImageComparator.Compare((BufferedImage)imero, (String)"!=", (int)0, (BufferedImage)imcl, (int)0, (BufferedImage)imero);
        this.IF.Ranks(imero, 0);
        imop = null;
        imcl = null;
        imero = null;
        reference = null;
        source = null;
        return (int)this.IF.Rank95();
    }

    private void FindElongatedNuclei(BufferedImage srcrgb, File resfile) throws IOException {
        BufferedImage basins = ImageIO.Read(resfile.getAbsolutePath() + "/Watershed - Bassins.png");
        switch (basins.getType()) {
            case 10: {
                basins = ImageConverter.ByteToInt((BufferedImage)basins);
                break;
            }
            case 11: {
                basins = ImageConverter.ShortToInt((BufferedImage)basins);
                break;
            }
            case 5: 
            case 6: {
                basins = ImageConverter.RGBtoInt((BufferedImage)basins);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported. Must not occur!");
            }
        }
        int width = basins.getWidth();
        int height = basins.getHeight();
        this.ufccl.Label(basins, 0, true);
        int[] labels = this.ufccl.Labels1D();
        int[] numbers = (int[])this.ufccl.Colors();
        boolean[] elongated = new boolean[this.ufccl.ConnectedComponentsNumber() + 1];
        Arrays.fill(elongated, false);
        int[] types = new int[this.csi.Features().length + 2];
        Arrays.fill(types, 1);
        types[types.length - 1] = 0;
        types[types.length - 2] = 0;
        FichierTabule results = new FichierTabule(this.ufccl.ConnectedComponentsNumber() + 1, types, "Results");
        String[] featurenames = this.csi.FeaturesNames();
        for (int i2 = 0; i2 < featurenames.length; ++i2) {
            results.setColumnName(i2, featurenames[i2]);
        }
        results.setColumnName(featurenames.length, "Nucleus");
        results.setColumnName(featurenames.length + 1, "Elongated");
        featurenames = null;
        types = null;
        List<Integer>[] nuclei = this.FindNeighbors(this.ufccl.Labels1D(), width, height, this.ufccl.ConnectedComponentsNumber());
        results.setExcluded(0, true);
        for (int n = 1; n < nuclei.length; ++n) {
            if (nuclei[n] == null || nuclei[n].size() == 1) {
                BufferedImage nucleus = this.ufccl.ExtractComponent(basins, n, 1, 0);
                ImageComparator.Compare((BufferedImage)nucleus, (String)"==", (int)0, (int)0, (int)255, (BufferedImage)nucleus);
                nucleus = ImageConverter.IntToByte((BufferedImage)nucleus);
                Measures2D measures = new Measures2D(nucleus);
                measures.Basics(true, false);
                measures.DistanceMapAndDiskMax(this.dmse);
                measures.EuclidianDiameter();
                measures.EuclidianRadii();
                measures.GeodesicDiameter(this.dmse, false);
                this.csi.ComputeIndexes(measures);
                double[] features = this.csi.Features();
                for (int f = 0; f < features.length; ++f) {
                    results.setValue(n, f, features[f]);
                }
                results.setValue(n, features.length, numbers[n]);
                int nb = 0;
                if (features[0] < 0.25) {
                    ++nb;
                }
                if (features[1] < 0.3) {
                    ++nb;
                }
                if (features[2] < 0.35) {
                    ++nb;
                }
                if (features[3] < 0.41) {
                    ++nb;
                }
                if (features[4] < 0.36) {
                    ++nb;
                }
                if (features[5] < 0.41) {
                    ++nb;
                }
                if (3 < nb) {
                    results.setValue(n, features.length + 1, 1);
                    elongated[n] = true;
                } else {
                    results.setValue(n, features.length + 1, 0);
                }
                measures.Kill();
                measures = null;
                features = null;
                continue;
            }
            results.setExcluded(n, true);
        }
        byte[] bb = ((DataBufferByte)srcrgb.getRaster().getDataBuffer()).getData();
        int pos = 0;
        int posrgb = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (elongated[labels[pos]]) {
                    bb[posrgb] = 0;
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
        ImageIO.Write(srcrgb, resfile.getAbsolutePath() + "/Segmentation Stroma Cells.png", 6);
        FichierTabule res = FichierTabuleTools.DeleteExcluded(results);
        res.Write(resfile.getAbsolutePath() + "/Features.txt", false);
        res.Kill();
        results.Kill();
        res = null;
        results = null;
    }

    private List<Integer>[] FindNeighbors(int[] labels, int width, int height, int max) {
        List[] list = new List[max + 1];
        int w1 = width - 1;
        int h1 = height - 1;
        for (int y = 1; y < h1; ++y) {
            int x = 1;
            int pos = y * width + x;
            while (x < w1) {
                if (labels[pos] != 0) {
                    int label = labels[pos];
                    int neighbor = -1;
                    if (0 < labels[pos - 1] && labels[pos - 1] != label) {
                        neighbor = labels[pos - 1];
                    } else if (0 < labels[pos + 1] && labels[pos + 1] != label) {
                        neighbor = labels[pos + 1];
                    } else if (0 < labels[pos - width] && labels[pos - width] != label) {
                        neighbor = labels[pos - width];
                    } else if (0 < labels[pos + width] && labels[pos + width] != label) {
                        neighbor = labels[pos + width];
                    }
                    if (neighbor != -1) {
                        if (list[label] == null) {
                            list[label] = new ArrayList(2);
                            list[label].add(neighbor);
                        } else if (list[label].size() == 1 && (Integer)list[label].get(0) != neighbor) {
                            list[label].add(neighbor);
                        }
                    }
                }
                ++x;
                ++pos;
            }
        }
        return list;
    }
}

