/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.em;

import characterization.shapes.shapeIndexes.ShapeIndexesComputer;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import dv.DV;
import dv.DvComparator;
import dv.DvFeatures;
import dv.DvIO;
import dv.DvNew;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.CoordinatesManager;
import measures.Measures3D;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import morphee.StructuringElement3D;
import morphee.granulometry.PatternSpectrum;
import processing.reducer.LinearGLR;
import utils.LogFile;
import utils.memory.Allocator;

public class NucleiNucleoliFeatures {
    private final String Copyright = "Software version 0.5 (2021/03/30) developed by Guillaume THIBAULT for the Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.";
    private final Allocator allocator = Allocator.Instance();
    private int NucleoliRow = -1;
    private final DvFeatures DFt = new DvFeatures();
    private final Haralick haralick = new Haralick();
    private final ShapeIndexesComputer sic = new ShapeIndexesComputer();
    private final PatternSpectrum ps = new PatternSpectrum();
    private final SZMfeatures szm = new SZMfeatures();
    private final FillHole fh = new FillHole();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final boolean Debug;
    public static FilenameFilter NucleiFF = (dir, name) -> dir.isDirectory() && name.startsWith("cell_");
    public static FilenameFilter NucleoliFF = (dir, name) -> dir.isDirectory() && name.startsWith("nucleolus_");

    public NucleiNucleoliFeatures(boolean Debug2) {
        this.Debug = Debug2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Extract(String dir, int nbCPU) throws IOException {
        LogFile log = new LogFile();
        log.StartNewLog(this, dir);
        log.addComment("Software version 0.5 (2021/03/30) developed by Guillaume THIBAULT for the Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.");
        log.addComment("Starting features extraction on '" + dir + "'");
        Object[] nucleidirs = new File(dir).listFiles(NucleiFF);
        if (nucleidirs == null || nucleidirs.length == 0) {
            System.out.println("No nucleus directory found in '" + dir + "'.");
            log.addComment("No nucleus directory found in '" + dir + "'.");
            return;
        }
        Arrays.sort(nucleidirs);
        System.out.println(nucleidirs.length + " nucle" + (nucleidirs.length == 1 ? "us" : "i") + " found.");
        System.out.println("\n");
        this.Initializations();
        FichierTabule nuclei = this.CreateFeatures(nucleidirs.length, false);
        FichierTabule nucleoli = this.CreateFeatures(301, true);
        this.NucleoliRow = 0;
        for (Object f : nucleidirs) {
            try {
                this.ExtractFromSingleNucleus(((File)f).getAbsolutePath(), nuclei, nucleoli, log, nbCPU);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                log.addNewException(ex, "Cannot extract features from '" + ((File)f).getAbsolutePath() + "'.");
            }
            catch (Error er) {
                er.printStackTrace();
                log.addNewError(er, "Cannot extract features from '" + ((File)f).getAbsolutePath() + "'.");
            }
            finally {
                this.allocator.ClearAll(true);
            }
        }
        nuclei.Write(dir + "/Nuclei.csv", false, ",");
        FichierTabule nucleoli2 = FichierTabuleTools.SaveSelectedRows(nucleoli);
        nucleoli2.Write(dir + "/Nucleoli.csv", false, ",");
        nuclei.Kill();
        nucleoli.Kill();
        nucleoli2.Kill();
        nucleoli2 = null;
        nucleoli = null;
        nuclei = null;
        this.allocator.ClearAll(true);
        log.Stop();
    }

    private void ExtractFromSingleNucleus(String dir, FichierTabule nucleiFeatures, FichierTabule nucleoliFeatures, LogFile log, int nbCPU) throws Exception {
        int i2;
        System.out.println("Software version 0.5 (2021/03/30) developed by Guillaume THIBAULT for the Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.");
        System.out.println("\nProcessing: '" + dir + "'");
        log.addComment("Processing: '" + dir + "'");
        File imdir = new File(dir + "/images/");
        if (!imdir.exists()) {
            throw new Exception("Cannot find 'images' directory.");
        }
        File nucleusdir = new File(dir + "/nucleus_masks/");
        if (!nucleusdir.exists()) {
            throw new Exception("Cannot find 'nucleus_masks' directory.");
        }
        DV original = DvIO.ReadFromStack(imdir.getAbsolutePath(), FilesFolders.ComparatorLength(), FileNameFilters.ImagesPNGorTIF);
        DV nucleus = DvIO.ReadFromStack(nucleusdir.getAbsolutePath(), FilesFolders.ComparatorLength(), FileNameFilters.ImagesPNGorTIF);
        DV nmn = null;
        DV[] nucleoli = null;
        Object[] nucleolidirs = new File(dir).listFiles(NucleoliFF);
        if (nucleolidirs == null || nucleolidirs.length == 0) {
            System.out.println("No nucleolus found.");
            nmn = nucleus;
        } else {
            nmn = DvNew.Clone((DV)nucleus);
            Arrays.sort(nucleolidirs);
            System.out.println(nucleolidirs.length + " nucleol" + (nucleolidirs.length == 1 ? "us" : "i") + " found.");
            nucleoli = new DV[nucleolidirs.length];
            for (i2 = 0; i2 < nucleolidirs.length; ++i2) {
                nucleoli[i2] = DvIO.ReadFromStack(((File)nucleolidirs[i2]).getAbsolutePath(), FilesFolders.ComparatorLength(), FileNameFilters.ImagesPNGorTIF);
                DvComparator.Compare((DV)nucleoli[i2], (String)"==", (int)0, (DV)nmn, (int)0, (DV)nmn);
            }
        }
        this.Features(dir, original, nucleus, null, nmn, nucleiFeatures, -1, nbCPU);
        if (nucleoli != null) {
            for (i2 = 0; i2 < nucleoli.length; ++i2) {
                this.Features(dir, original, nucleus, nucleoli[i2], nucleoli[i2], nucleoliFeatures, i2, nbCPU);
                ++this.NucleoliRow;
            }
        }
        System.out.println("Features extraction done. Software version 0.5 (2021/03/30) developed by Guillaume THIBAULT for the Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.\n\n");
    }

    private void Features(String dir, DV original, DV nucleus, DV nucleolus, DV nmn, FichierTabule Features2, int nucleoli, int nbCPU) {
        int i2;
        File file = new File(dir);
        int nucnum = Integer.valueOf(file.getName().substring(5, file.getName().length()));
        int row = 0 <= nucleoli ? this.NucleoliRow : nucnum - 1;
        System.out.println("Original: " + original.SizeX + " x " + original.SizeY + " x " + original.SizeZ);
        System.out.println("Nucleus: " + nucleus.SizeX + " x " + nucleus.SizeY + " x " + nucleus.SizeZ);
        System.out.println("NMN: " + nmn.SizeX + " x " + nmn.SizeY + " x " + nmn.SizeZ);
        if (nucleolus != null) {
            System.out.println("Nucleolus: " + nucleolus.SizeX + " x " + nucleolus.SizeY + " x " + nucleolus.SizeZ);
        }
        Features2.setValue(row, 0, file.getParentFile().getName());
        Features2.setValue(row, 1, nucnum);
        Measures3D m3 = new Measures3D(0 <= nucleoli ? nucleolus : nucleus);
        m3.Basics(26);
        Features2.setValue(row, 2, m3.getVolume());
        Features2.setValue(row, 3, m3.getSurface());
        m3.EuclidianRadius();
        Features2.setValue(row, 4, m3.getAverageRadius());
        m3.DistanceMapAndSphereMax(new StructuringElement3D(new Object[]{2, -15}));
        DV texture = DvNew.Clone((DV)original);
        DvComparator.Compare((DV)nmn, (String)"!=", (int)0, (DV)texture, (int)0, (DV)texture);
        this.DFt.Moments(texture, 0, 0);
        Features2.setValue(row, 5, this.DFt.Average);
        Features2.setValue(row, 7, this.DFt.Variance);
        Features2.setValue(row, 8, this.DFt.Skewness);
        Features2.setValue(row, 9, this.DFt.Kurtosis);
        Features2.setValue(row, 6, this.DFt.Contrast(texture, 0, 0));
        this.DFt.Ranks(texture, 0, 0);
        Features2.setValue(row, 10, this.DFt.Rank01);
        Features2.setValue(row, 11, this.DFt.Rank025);
        Features2.setValue(row, 12, this.DFt.Rank05);
        Features2.setValue(row, 13, this.DFt.Rank10);
        Features2.setValue(row, 14, this.DFt.Rank25);
        Features2.setValue(row, 15, this.DFt.Rank50);
        Features2.setValue(row, 16, this.DFt.Rank75);
        Features2.setValue(row, 17, this.DFt.Rank90);
        Features2.setValue(row, 18, this.DFt.Rank95);
        Features2.setValue(row, 19, this.DFt.Rank975);
        Features2.setValue(row, 20, this.DFt.Rank99);
        int pos = 21;
        this.sic.Compute(texture, nbCPU);
        double[] feat = this.sic.Features();
        for (i2 = 0; i2 < feat.length; ++i2) {
            Features2.setValue(row, pos + i2, feat[i2]);
        }
        pos += feat.length;
        this.ps.Compute(texture, nbCPU);
        feat = this.ps.Features();
        for (i2 = 0; i2 < feat.length; ++i2) {
            Features2.setValue(row, pos + i2, feat[i2]);
        }
        pos += feat.length;
        this.haralick.Compute(texture, nbCPU);
        feat = this.haralick.Features();
        for (i2 = 0; i2 < feat.length; ++i2) {
            Features2.setValue(row, pos + i2, feat[i2]);
        }
        pos += feat.length;
        this.szm.Compute(texture, nbCPU);
        feat = this.szm.Features();
        for (i2 = 0; i2 < feat.length; ++i2) {
            Features2.setValue(row, pos + i2, feat[i2]);
        }
        if (0 <= nucleoli) {
            Coordinate centroid = m3.Barycentre;
            Features2.setValue(row, Features2.Width() - 4, centroid.X);
            Features2.setValue(row, Features2.Width() - 3, centroid.Y);
            Euclidian distance = new Euclidian();
            Measures3D M3nucleus = new Measures3D(nucleus);
            M3nucleus.Basics(26);
            CoordinatesManager nucleusurface = M3nucleus.surface;
            double shortest = distance.Distance(nucleusurface.Point(0), centroid);
            for (int i3 = 1; i3 < nucleusurface.Size(); ++i3) {
                double dist = distance.Distance(nucleusurface.Point(i3), centroid);
                if (!(dist < shortest)) continue;
                shortest = dist;
            }
            Features2.setValue(row, Features2.Width() - 2, shortest);
            Features2.setValue(row, Features2.Width() - 1, nucleoli);
            Features2.setSelected(row, true);
            DV filled = DvNew.Same((DV)nucleolus);
            this.fh.Fill(nucleolus, (ConnectedComponentLabeling)this.ccl, 10000000, true, filled);
            Measures3D nucfilled = new Measures3D(filled);
            nucfilled.Basics(26);
            Features2.setValue(row, Features2.Width() - 6, nucfilled.getVolume());
            Features2.setValue(row, Features2.Width() - 5, (double)m3.getVolume() / (double)nucfilled.getVolume());
            filled.Kill();
            filled = null;
            nucfilled = null;
            M3nucleus = null;
        }
    }

    private void Initializations() {
        this.haralick.Parameters(new LinearGLR(32), 32, 0);
        this.haralick.setDirections(new int[]{2, 0, 0, 2, 2, 0}, new int[]{0, 2, 0, 2, 0, 2}, new int[]{0, 0, 2, 0, 2, 2});
        this.sic.Indexes[3] = null;
        this.sic.Indexes[2] = null;
        this.sic.Indexes[0] = null;
        Arrays.fill(this.sic.Indexes, 5, 8, null);
        Arrays.fill(this.sic.Indexes, 11, 22, null);
        Arrays.fill(this.sic.Indexes, 23, 27, null);
        this.szm.Parameters(32, 1, new LinearGLR(32), 0, true);
        if (this.Debug) {
            this.ps.Parameters(1, 2, 1, 0, -2);
        } else {
            this.ps.Parameters(1, 5, 1, 0, -2);
        }
    }

    private FichierTabule CreateFeatures(int NB, boolean nucleoli) {
        int i2;
        int nbHaralick = this.haralick.Features().length;
        int nbSIC = this.sic.Features().length;
        int nbPS = this.ps.Features().length;
        int nbSZM = this.szm.Features().length;
        int[] types = new int[21 + nbPS + nbHaralick + nbSZM + nbSIC + (nucleoli ? 6 : 0)];
        Arrays.fill(types, 1);
        types[0] = 2;
        Arrays.fill(types, 1, 4, 0);
        if (nucleoli) {
            types[types.length - 1] = 0;
            types[types.length - 6] = 0;
        }
        FichierTabule features = new FichierTabule(NB, types, "Nuclei Features");
        features.setColumnName(0, "Patient");
        features.setColumnName(1, "Nucleus");
        features.setColumnName(2, "Volume");
        features.setColumnName(3, "Surface");
        features.setColumnName(4, "Average Radius");
        features.setColumnName(5, "Mean Intensity");
        features.setColumnName(6, "Contrast");
        features.setColumnName(7, "Variance");
        features.setColumnName(8, "Skewness");
        features.setColumnName(9, "Kurtosis");
        features.setColumnName(10, "Rank01");
        features.setColumnName(11, "Rank025");
        features.setColumnName(12, "Rank05");
        features.setColumnName(13, "Rank10");
        features.setColumnName(14, "Rank25");
        features.setColumnName(15, "Rank50");
        features.setColumnName(16, "Rank75");
        features.setColumnName(17, "Rank90");
        features.setColumnName(18, "Rank95");
        features.setColumnName(19, "Rank975");
        features.setColumnName(20, "Rank99");
        int pos = 21;
        String[] names = this.sic.FeaturesNames();
        for (i2 = 0; i2 < nbSIC; ++i2) {
            features.setColumnName(pos + i2, names[i2]);
        }
        pos += nbSIC;
        names = this.ps.FeaturesNames();
        for (i2 = 0; i2 < nbPS; ++i2) {
            features.setColumnName(pos + i2, names[i2]);
        }
        pos += nbPS;
        names = this.haralick.FeaturesNames();
        for (i2 = 0; i2 < nbHaralick; ++i2) {
            features.setColumnName(pos + i2, names[i2]);
        }
        pos += nbHaralick;
        names = this.szm.FeaturesNames();
        for (i2 = 0; i2 < nbSZM; ++i2) {
            features.setColumnName(pos + i2, names[i2]);
        }
        if (nucleoli) {
            features.setColumnName(types.length - 6, "Filled Volume");
            features.setColumnName(types.length - 5, "Volumes Ratio");
            features.setColumnName(types.length - 4, "X-centroid");
            features.setColumnName(types.length - 3, "Y-centroid");
            features.setColumnName(types.length - 2, "Shortest Distance To Nuclear Membrane");
            features.setColumnName(types.length - 1, "Nucleolus");
        }
        return features;
    }
}

