/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.em;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayIO;
import filesAndFolders.FileFilters;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import registration.turboreg.StackRegistration;
import stackTiTi.StackIO;
import utils.memory.Allocator;

public class EMpreProcessing {
    private final Allocator allocator = Allocator.Instance();
    private final ArrayFeatures AF = new ArrayFeatures();
    public FilenameFilter OneSlice = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && (name.endsWith(".tif") || name.endsWith(".TIF")) && name.contains("1--ICD_1");
    public FilenameFilter ImagesInSlice = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && (name.endsWith(".tif") || name.endsWith(".TIF")) && !name.contains("1--ICD_1");
    public static final int AVERAGE = -1;
    public static final int MEDIAN = -2;
    public static final int AVEMED = -3;

    public void SeparateImagesBySlice(String srcdir, String resdir) {
        File[] images = new File(srcdir).listFiles(this.OneSlice);
        ArrayIO.Display(images, "", "\n");
        for (File image : images) {
            int j;
            String number = image.getName().substring(29, 32);
            File resfile = new File(resdir + "/" + number + "/");
            if (!resfile.exists()) {
                resfile.mkdirs();
            }
            FilesFolders.CopyFile(image, resfile);
            for (j = 2; j <= 8; ++j) {
                FilesFolders.CopyFile(new File(image.getAbsolutePath().replace("1--ICD_1", j + "-ICD_" + (j + 1))), resfile);
            }
            for (j = 9; j <= 10; ++j) {
                FilesFolders.CopyFile(new File(image.getAbsolutePath().replace("1--ICD_1", j + "_ICD-" + (j + 1))), resfile);
            }
        }
    }

    public void SeparateImagesBySlice2(String srcdir, String resdir) {
        Object[] dirs = new File(srcdir).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            Object[] images = new File(((File)dir).getAbsolutePath()).listFiles(FileNameFilters.ImagesTIF);
            Arrays.sort(images);
            for (int i2 = 0; i2 < 5; ++i2) {
                int length;
                String name = ((File)images[i2]).getName();
                String number = name.substring((length = name.length()) - 7, length - 4);
                File resfile = new File(resdir + "/" + number + "/");
                if (!resfile.exists()) {
                    resfile.mkdirs();
                }
                FilesFolders.CopyFile((File)images[i2], resfile);
            }
        }
    }

    public void RegisterEachSlice(String srcdir, int from, int to, int NB, String resdir, int nbCPU) {
        StackRegistration sr = new StackRegistration();
        Object[] dirs = new File(srcdir).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        int max = Math.min(dirs.length, to);
        for (int d = from; d < max; ++d) {
            try {
                Object[] images = new File(((File)dirs[d]).getAbsolutePath()).listFiles(this.ImagesInSlice);
                Arrays.sort(images);
                int median = images.length >> 1;
                File resfile = new File(resdir + "/" + ((File)dirs[d]).getName() + "/");
                if (!resfile.exists()) {
                    resfile.mkdirs();
                }
                BufferedImage target = ImageIO.Read((File)images[median]);
                for (int i2 = 0; i2 < images.length; ++i2) {
                    if (i2 == median) {
                        ImageIO.Write(target, resfile.getAbsolutePath() + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                        continue;
                    }
                    BufferedImage source = ImageIO.Read((File)images[i2]);
                    BufferedImage result = sr.StochasticProcess(source, target, 6, NB, true, nbCPU);
                    ImageIO.Write(result, resfile.getAbsolutePath() + "/" + ((File)images[i2]).getName().replace(".tif", ".png"), 6);
                    result = null;
                    source = null;
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void Denoise(String srcdir, int method, String resdir, int nbCPU) {
        File resfile = new File(resdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        Object[] dirs = new File(srcdir).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            try {
                Object[] stack = StackIO.ReadImageSequence(((File)dir).getAbsolutePath(), FileNameFilters.ImagesPNGorTIF);
                byte[][] bb = new byte[stack.length][];
                for (int i2 = 0; i2 < stack.length; ++i2) {
                    bb[i2] = ((DataBufferByte)stack[i2].getRaster().getDataBuffer()).getData();
                }
                BufferedImage result = ImageNew.Same((BufferedImage)stack[0]);
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int width = result.getWidth();
                int height = result.getHeight();
                int[] buffer = new int[stack.length];
                switch (method) {
                    case -1: {
                        int x;
                        int y;
                        int pos = 0;
                        for (y = 0; y < height; ++y) {
                            x = 0;
                            while (x < width) {
                                for (int i3 = 0; i3 < stack.length; ++i3) {
                                    buffer[i3] = bb[i3][pos] & 0xFF;
                                }
                                double ave = this.AF.Average(buffer);
                                bbres[pos] = (byte)(ave + 0.5);
                                ++x;
                                ++pos;
                            }
                        }
                        break;
                    }
                    case -2: {
                        int x;
                        int y;
                        int pos = 0;
                        for (y = 0; y < height; ++y) {
                            x = 0;
                            while (x < width) {
                                for (int i4 = 0; i4 < stack.length; ++i4) {
                                    buffer[i4] = bb[i4][pos] & 0xFF;
                                }
                                Arrays.sort(buffer);
                                bbres[pos] = (byte)buffer[buffer.length >> 1];
                                ++x;
                                ++pos;
                            }
                        }
                        break;
                    }
                    case -3: {
                        int x;
                        int y;
                        int pos = 0;
                        for (y = 0; y < height; ++y) {
                            x = 0;
                            while (x < width) {
                                for (int i5 = 0; i5 < stack.length; ++i5) {
                                    buffer[i5] = bb[i5][pos] & 0xFF;
                                }
                                Arrays.sort(buffer);
                                double ave = this.AF.Average(buffer, 2, stack.length - 2);
                                bbres[pos] = (byte)(ave + 0.5);
                                ++x;
                                ++pos;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Must not occur!");
                    }
                }
                ImageIO.Write(result, resfile.getAbsolutePath() + "/" + ((File)dir).getName() + ".png", 6);
                bbres = null;
                buffer = null;
                Arrays.fill((Object[])bb, null);
                bb = null;
                Arrays.fill(stack, null);
                result = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

