/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif.old;

import algoGeo.convexhull.PseudoConvexHull;
import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import characterization.shapes.shapeIndexes.ShapeIndexesComputer;
import characterization.textures.lbp.LocalBinaryPattern;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.DZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import displays.Colors;
import displays.Display;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import listTiTi.ListNew;
import listTiTi.ListTools;
import measures.BasicMeasures;
import measures.Measures2D;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import morphee.Close;
import morphee.Dilate;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import morphee.filters.AreaOpening;
import morphee.granulometry.PatternSpectrum;
import morphee.segmentation.Skiz;
import processing.filters.ContrastEqualizer;
import processing.filters.DynamicExpansion;
import processing.filters.Invert;
import processing.reducer.LinearGLR;
import processing.thresholding.Binary;
import processing.thresholding.Huang;
import processing.thresholding.ImageThresholder;
import processing.thresholding.Li;
import processing.thresholding.Otsu;
import processing.thresholding.Renyi;
import processing.thresholding.TriangleThresholding;
import processing.zprojection.ZProjectionCMM;
import segmentation.cells.DapiMM;
import stackTiTi.StackIO;
import utils.LogFile;
import utils.memory.Allocator;

public class PartialCyclicIF {
    private Allocator allocator = Allocator.Instance();
    private String Copyright = "Software version 1.2 (2019/09/16) developed by Guillaume THIBAULT for the Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.";
    private List<RoundCycle> rclist = new LinkedList<RoundCycle>();
    private final int Magnification;
    public Display display = null;
    private ContrastEqualizer equalizer = new ContrastEqualizer();
    private final DapiMM dapi;
    private final DapiMM dapismall;
    private DistanceMapComputer dmc = new DistanceMapComputer();
    private DynamicExpansion de = new DynamicExpansion();
    private FillHole fh = new FillHole();
    private Invert invert = new Invert();
    private PseudoConvexHull pch = new PseudoConvexHull();
    private Skiz skiz = new Skiz();
    private UnionFindCcl ccl = new UnionFindCcl();
    private ZProjectionCMM zp = new ZProjectionCMM();
    private StructuringElement sedisk2 = new StructuringElement(new Object[]{2, -2});
    private StructuringElement sedisk53 = new StructuringElement(new Object[]{53, -2});
    private StructuringElement selbp8 = new StructuringElement(new Object[]{1, -13, 8});
    private StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private AreaOpening ao = new AreaOpening();
    private Binary binary = new Binary();
    private Close close = new Close();
    private Dilate dilate = new Dilate();
    private WhiteTopHat wth = new WhiteTopHat();
    private ImageThresholder[] thresholders = new ImageThresholder[4];
    private Huang huang = new Huang();
    private Li li = new Li();
    private Otsu otsu = new Otsu();
    private Renyi renyi = new Renyi();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    public final int TMA = -1;
    public final int CROPS = -2;
    public int Experiment = 0;
    public int Intensity = 0;
    public boolean improvedapi = true;
    public boolean masksegment = true;
    public boolean nucleisegment = true;
    public boolean cellsegment = true;
    public boolean freememory = true;
    public boolean easymarkers = true;
    public boolean autocrop = true;
    public boolean enhancecontrast = false;
    private LogFile log = new LogFile();
    public boolean FE_SaveImages = true;
    public boolean FE_SubtractBackground = false;
    public float FE_Rim_Size = 3.0f;
    public boolean FE_BiasedFeaturesOnly = false;
    public boolean FE_DistanceFromBorder = false;
    private int nbThreads = 1;
    private int nbFreeThreads = 0;
    private ComputeFeaturesThread[] threads = null;
    private BasicMeasures basic = null;
    private DZMfeatures dzm = null;
    private Haralick haralick = null;
    private LocalBinaryPattern lbp = null;
    private PatternSpectrum ps = null;
    private SZMfeatures szm = null;
    private ShapeIndexesComputer sic = null;

    public PartialCyclicIF(int Magnification) {
        switch (Magnification) {
            case 20: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.Magnification = Magnification;
        this.dapi = new DapiMM(Magnification, false);
        this.dapismall = new DapiMM(Magnification, true);
        this.thresholders[0] = new Li();
        this.thresholders[1] = new Huang();
        this.thresholders[2] = new Otsu();
        this.thresholders[3] = new TriangleThresholding();
    }

    public void Segment(String inputdir, int nbCPU) throws Exception {
        Object[] dirs;
        for (File file2 : dirs = new File(inputdir).listFiles(file -> file.isDirectory() && !file.getName().contains(" - Segmentation") && !file.getName().contains(" - Features"))) {
            this.Segment(file2.getAbsolutePath(), inputdir + "/" + file2.getName() + " - Segmentation/", nbCPU);
        }
        Arrays.fill(dirs, null);
        dirs = null;
    }

    public void Segment(String inputdir, String outputdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        System.out.println(this.Copyright);
        System.out.println("\n\nProcessing '" + inputdir + "'.");
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        if (this.improvedapi) {
            this.ImprovedDAPI(inputdir, outputdir);
        }
        try {
            boolean keepworking = true;
            BufferedImage imdapi = ImageIO.Read(outputdir + "/ZProjectionDAPI.png");
            if (this.masksegment) {
                keepworking &= this.FindMask(imdapi, this.enhancecontrast, outputdir, nbCPU);
            }
            if (keepworking && this.nucleisegment) {
                try {
                    BufferedImage mask = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/Nuclei Safety Mask.png"));
                    BufferedImage imnuclei = null;
                    if (this.Intensity < 0) {
                        imnuclei = ImageIO.Read(outputdir + "/ZProjectionDAPI CE.png");
                    } else {
                        imnuclei = ImageNew.Clone((BufferedImage)imdapi);
                        if (1 < this.Intensity) {
                            ImageArithmetic.Multiply(imnuclei, this.Intensity, imnuclei, 0, 0, 65535, 65535);
                        }
                    }
                    this.SegmentNuclei(imnuclei, mask, true, outputdir, nbCPU);
                    imnuclei = this.allocator.Release(imnuclei);
                    mask = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log.addNewException(e, "Cannot segment nuclei in " + inputdir);
                    keepworking = false;
                }
            }
            if (keepworking && this.cellsegment) {
                try {
                    this.SegmentCells(inputdir, outputdir, nbCPU);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log.addNewException(e, "Cannot segment cells for " + inputdir);
                    keepworking = false;
                }
            }
            this.allocator.ClearAll(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.addNewException(ex, "Cannot segment " + inputdir);
        }
        catch (Error e) {
            e.printStackTrace();
            this.log.addNewError(e, "Cannot segment " + inputdir);
        }
        System.out.println("Segmentation done. " + this.Copyright + "\n");
        this.log.Stop();
    }

    private void SegmentNuclei(BufferedImage nuclei, BufferedImage mask, boolean small, String output, int nbCPU) throws IOException, InterruptedException {
        boolean dirtybackground = true;
        int simplifytexture = 2;
        boolean equalize = false;
        boolean fillholes = true;
        boolean DeleteOnTop = true;
        boolean roi100saver = false;
        if (small) {
            this.dapismall.Segmentation(nuclei, true, 2, false, true, true, false, mask, 60, output, nbCPU);
        } else {
            this.dapi.Segmentation(nuclei, true, 2, false, true, true, false, mask, 120, output, nbCPU);
        }
        this.Rename(output);
        this.allocator.ClearAll(true);
    }

    private boolean FindMask(BufferedImage dapi, boolean ce, String outputdir, int nbCPU) throws IOException {
        BufferedImage dapimp = null;
        if (ce) {
            dapimp = this.de.FilterWithConditions(dapi, 1.0, 1.0, -1, 0, 65535, nbCPU);
            ImageIO.Write(dapimp, outputdir + "/ZProjectionDAPI CE.png", 6);
        } else {
            dapimp = dapi;
        }
        BufferedImage bin = ImageNew.Same((BufferedImage)dapimp);
        this.huang.Filter(dapimp, bin, nbCPU);
        this.li.Filter(dapimp, bin, nbCPU);
        this.otsu.Filter(dapimp, bin, nbCPU);
        this.renyi.Filter(dapimp, bin, nbCPU);
        int[] thres = new int[]{this.huang.getThreshold(0), this.li.getThreshold(0), this.otsu.getThreshold(0), this.renyi.getThreshold(0)};
        Arrays.sort(thres);
        switch (this.Experiment) {
            case -2: {
                this.binary.Filter(dapimp, thres[0], bin, nbCPU);
                break;
            }
            case -1: {
                this.binary.Filter(dapimp, 3 * (thres[1] + thres[2]) >> 2, bin, nbCPU);
                break;
            }
            default: {
                throw new IllegalStateException("Experiment not supported or not defined.");
            }
        }
        if (ce) {
            dapimp = this.allocator.Release(dapimp);
        }
        BufferedImage binao = this.ao.Filter(bin, 250, true);
        this.dilate.Filter(binao, this.sedisk2, bin, nbCPU);
        this.fh.Fill(bin, (ConnectedComponentLabeling)this.ccl, 750, true, binao);
        bin = this.allocator.Release(bin);
        ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)binao), outputdir + "/Nuclei Safety Mask.png", 6);
        if (ImageTools.isBlack((BufferedImage)binao)) {
            binao = this.allocator.Release(binao);
            this.log.addComment("No nuclei found (empty mask) for " + outputdir);
            return false;
        }
        binao = this.allocator.Release(binao);
        return true;
    }

    public void SplitSegmentations(String outputdir, String scene) throws IOException {
        int i2;
        boolean colecad = false;
        boolean colcd45 = true;
        int colunst = 2;
        String[] markers = new String[]{"EcadCKs", "CD45", "Unstained"};
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ Basins.tif");
        int[] ibbasins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        this.ccl.Label(basins, 0, true);
        int[] labels = this.ccl.Labels1D();
        int[] sizes = this.ccl.Sizes();
        this.ccl.ComputeBoundingBoxes();
        BufferedImage roi = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ ROI.png");
        if (this.ccl.ConnectedComponentsNumber() == 0) {
            ImageOperations.Fill((BufferedImage)basins, (int)0);
            ImageOperations.Fill((BufferedImage)roi, (int)0);
            for (String marker : markers) {
                ImageIO.Write(basins, outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Basins.tif", 8);
                ImageIO.Write(roi, outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Segmentation.png", 6);
                ImageIO.Write(roi, outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ ROI.png", 6);
            }
            roi = null;
            basins = null;
            return;
        }
        int width = basins.getWidth();
        int length = ibbasins.length;
        BufferedImage ecad = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - EcadCks Segmentation.png"));
        byte[] bbecad = ((DataBufferByte)ecad.getRaster().getDataBuffer()).getData();
        BufferedImage cd45 = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - CD45 Segmentation.png"));
        byte[] bbcd45 = ((DataBufferByte)cd45.getRaster().getDataBuffer()).getData();
        BufferedImage unst = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - Unstained Segmentation.png"));
        byte[] bbunst = ((DataBufferByte)unst.getRaster().getDataBuffer()).getData();
        System.arraycopy(this.ccl.Labels1D(), 0, ibbasins, 0, length);
        int[][] overlaps = new int[this.ccl.ConnectedComponentsNumber() + 1][3];
        for (int i3 = 0; i3 < labels.length; ++i3) {
            if (0 >= labels[i3]) continue;
            int label = ibbasins[i3];
            if (0 != bbecad[i3]) {
                int[] nArray = overlaps[label];
                nArray[0] = nArray[0] + 1;
            }
            if (0 != bbcd45[i3]) {
                int[] nArray = overlaps[label];
                nArray[1] = nArray[1] + 1;
            }
            if (0 == bbunst[i3]) continue;
            int[] nArray = overlaps[label];
            nArray[2] = nArray[2] + 1;
        }
        bbunst = null;
        bbcd45 = null;
        bbecad = null;
        unst = null;
        cd45 = null;
        ecad = null;
        BufferedImage imdapi = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
        Object[] dapis = new BufferedImage[]{ImageConverter.GrayToColor((BufferedImage)imdapi), ImageConverter.GrayToColor((BufferedImage)imdapi), ImageConverter.GrayToColor((BufferedImage)imdapi)};
        Object[] bass = new BufferedImage[]{ImageNew.Same((BufferedImage)basins), ImageNew.Same((BufferedImage)basins), ImageNew.Same((BufferedImage)basins)};
        Object[] rois = new BufferedImage[]{ImageNew.Same((BufferedImage)roi), ImageNew.Same((BufferedImage)roi), ImageNew.Same((BufferedImage)roi)};
        for (i2 = 1; i2 < this.ccl.ConnectedComponentsNumber() + 1; ++i2) {
            int index = this.AF.MaximumIndex(overlaps[i2]);
            if (!(0.5 < (double)overlaps[i2][index] / (double)sizes[i2])) continue;
            byte[] bbro = ((DataBufferByte)rois[index].getRaster().getDataBuffer()).getData();
            int[] ibbas = ((DataBufferInt)((BufferedImage)bass[index]).getRaster().getDataBuffer()).getData();
            int sx = this.ccl.minx()[i2];
            int sy = this.ccl.miny()[i2];
            int ex = this.ccl.maxx()[i2];
            int ey = this.ccl.maxy()[i2];
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = y * width + x;
                while (x <= ex) {
                    if (labels[pos] == i2) {
                        ibbas[pos] = i2;
                        bbro[pos] = -1;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        for (i2 = 0; i2 < markers.length; ++i2) {
            ImageComparator.Compare((BufferedImage)roi, (String)"!=", (int)200, (BufferedImage)rois[i2], (int)200, (BufferedImage)rois[i2]);
            this.ccl.Label(bass[i2], 0, true);
            System.arraycopy(this.ccl.Labels1D(), 0, ((DataBufferInt)((BufferedImage)bass[i2]).getRaster().getDataBuffer()).getData(), 0, length);
            DapiMM.Paint((BufferedImage)bass[i2], (BufferedImage)rois[i2], (BufferedImage)dapis[i2]);
            ImageIO.Write((BufferedImage)bass[i2], outputdir + "/Scene " + scene + " - Nuclei " + markers[i2] + "+ Basins.tif", 8);
            ImageIO.Write((BufferedImage)dapis[i2], outputdir + "/Scene " + scene + " - Nuclei " + markers[i2] + "+ Segmentation.png", 6);
            ImageIO.Write((BufferedImage)rois[i2], outputdir + "/Scene " + scene + " - Nuclei " + markers[i2] + "+ ROI.png", 6);
        }
        overlaps = null;
        roi = null;
        imdapi = null;
        ibbasins = null;
        basins = null;
        Arrays.fill(dapis, null);
        Arrays.fill(bass, null);
        Arrays.fill(rois, null);
        File file = new File(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ Basins.tif");
        file.delete();
        file = new File(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ ROI.png");
        file.delete();
        file = new File(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ Segmentation.png");
        file.delete();
    }

    public void MergeSegmentations(String outputdir, String scene) throws IOException {
        String marker = "EcadCKs";
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Basins.tif");
        BufferedImage roi = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ ROI.png");
        this.SortLabeling(outputdir, scene, "CD44", basins, roi);
        this.allocator.ClearAll(true);
        this.SortLabeling(outputdir, scene, "CD45", basins, roi);
        this.allocator.ClearAll(true);
        this.SortLabeling(outputdir, scene, "Unstained", basins, roi);
        this.allocator.ClearAll(true);
        this.dapi.DeleteOnTop(basins);
        this.ccl.Label(basins, 0, true);
        this.dapi.MergeSmallCCs((ConnectedComponentLabeling)this.ccl, 89);
        System.arraycopy(this.ccl.Labels1D(), 0, ((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), 0, this.ccl.Labels1D().length);
        this.ccl.Label(basins, 0, true);
        System.arraycopy(this.ccl.Labels1D(), 0, ((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), 0, this.ccl.Labels1D().length);
        ImageIO.Write(basins, outputdir + "/Scene " + scene + " - Nuclei Segmentation Basins.tif", 8);
        BufferedImage nuclei = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
        BufferedImage rgb = ImageConverter.GrayToColor((BufferedImage)nuclei);
        DapiMM.Paint(basins, roi, rgb);
        ImageIO.tag = 1;
        ImageIO.Write(rgb, outputdir + "/Scene " + scene + " - Nuclei Segmentation Full Color.png", 6);
        ImageIO.tag = 0;
        basins = null;
        roi = null;
        nuclei = null;
        rgb = this.allocator.Release(rgb);
        this.allocator.ClearAll(true);
    }

    private void SortLabeling(String outputdir, String scene, String marker, BufferedImage result, BufferedImage resroi) throws IOException {
        int pos;
        int width = result.getWidth();
        BufferedImage roi = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ ROI.png");
        byte[] bbroi = ((DataBufferByte)roi.getRaster().getDataBuffer()).getData();
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Basins.tif");
        block0 : switch (basins.getType()) {
            case 10: {
                basins = ImageConverter.ByteToInt((BufferedImage)basins);
                break;
            }
            case 11: {
                basins = ImageConverter.ShortToInt((BufferedImage)basins);
                break;
            }
            case 5: 
            case 6: {
                basins = ImageConverter.RGBtoInt((BufferedImage)basins);
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        break block0;
                    }
                }
                throw new IllegalStateException("Unsupported basins format. Must not occur.");
            }
            default: {
                throw new IllegalStateException("Unsupported basins format. Must not occur.");
            }
        }
        int[] ibbas = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        BufferedImage overlap = ImageNew.Same((BufferedImage)basins, (int)10);
        byte[] bbover = ((DataBufferByte)overlap.getRaster().getDataBuffer()).getData();
        BufferedImage modif = ImageNew.Same((BufferedImage)basins, (int)10);
        byte[] bbmodif = ((DataBufferByte)modif.getRaster().getDataBuffer()).getData();
        int[] ibres = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        byte[] bbresroi = ((DataBufferByte)resroi.getRaster().getDataBuffer()).getData();
        for (int pos2 = 0; pos2 < ibbas.length; ++pos2) {
            bbover[pos2] = (byte)((0 < ibbas[pos2] ? 1 : 0) * (0 < ibres[pos2] ? 1 : 0));
        }
        this.ccl.Label(result, 0, true);
        int[] ressizes = (int[])this.ccl.Sizes().clone();
        int[] reslabels = (int[])this.ccl.Labels1D().clone();
        int[] reslut = new int[ressizes.length];
        System.arraycopy(reslabels, 0, ibres, 0, ibres.length);
        int num = ressizes.length;
        this.ccl.Label(basins, 0, true);
        this.ccl.ComputeBoundingBoxes();
        int[] bassizes = (int[])this.ccl.Sizes().clone();
        int[] baslabels = (int[])this.ccl.Labels1D().clone();
        int[] baslut = new int[bassizes.length];
        int[] basminx = (int[])this.ccl.minx().clone();
        int[] basmaxx = (int[])this.ccl.maxx().clone();
        int[] basminy = (int[])this.ccl.miny().clone();
        int[] basmaxy = (int[])this.ccl.maxy().clone();
        if (!ImageTools.isBlack((BufferedImage)overlap)) {
            this.ccl.Label(overlap, 0, true);
            this.ccl.ComputeBoundingBoxes();
            int[] labels = this.ccl.Labels1D();
            for (int cc = 1; cc < this.ccl.ConnectedComponentsNumber(); ++cc) {
                int x;
                int i2;
                int minx = this.ccl.minx()[cc];
                int maxx = this.ccl.maxx()[cc];
                int miny = this.ccl.miny()[cc];
                int maxy = this.ccl.maxy()[cc];
                LinkedList<Integer> baslist = new LinkedList<Integer>();
                LinkedList<Integer> reslist = new LinkedList<Integer>();
                for (int y = miny; y <= maxy; ++y) {
                    int x2 = minx;
                    int pos3 = y * width + x2;
                    while (x2 <= maxx) {
                        if (labels[pos3] == cc) {
                            if (!ListTools.isInList(reslist, (int)reslabels[pos3])) {
                                reslist.add(reslabels[pos3]);
                            }
                            if (!ListTools.isInList(baslist, (int)baslabels[pos3])) {
                                baslist.add(baslabels[pos3]);
                            }
                        }
                        ++x2;
                        ++pos3;
                    }
                }
                Arrays.fill(reslut, -1);
                for (i2 = 0; i2 < reslist.size(); ++i2) {
                    reslut[((Integer)reslist.get((int)i2)).intValue()] = i2;
                }
                Arrays.fill(baslut, -1);
                for (i2 = 0; i2 < baslist.size(); ++i2) {
                    baslut[((Integer)baslist.get((int)i2)).intValue()] = i2;
                }
                int[][] counts = new int[reslist.size()][baslist.size()];
                for (int y = miny; y <= maxy; ++y) {
                    x = minx;
                    int pos4 = y * width + x;
                    while (x <= maxx) {
                        if (labels[pos4] == cc) {
                            int[] nArray = counts[reslut[reslabels[pos4]]];
                            int n = baslut[baslabels[pos4]];
                            nArray[n] = nArray[n] + 1;
                        }
                        ++x;
                        ++pos4;
                    }
                }
                double[][] basratios = new double[counts.length][counts[0].length];
                for (int y = 0; y < counts.length; ++y) {
                    for (int x3 = 0; x3 < counts[0].length; ++x3) {
                        basratios[y][x3] = (double)counts[y][x3] / (double)bassizes[(Integer)baslist.get(x3)];
                    }
                }
                for (x = 0; x < counts[0].length; ++x) {
                    int label;
                    int nbover = 0;
                    int maxpos = -1;
                    double max = 0.0;
                    for (int y = 0; y < counts.length; ++y) {
                        if (0 >= counts[y][x]) continue;
                        ++nbover;
                        if (!(max < basratios[y][x])) continue;
                        max = basratios[y][x];
                        maxpos = y;
                    }
                    if (nbover == 0 || max < 0.35) {
                        label = (Integer)baslist.get(x);
                        int inx = basminx[label];
                        int axx = basmaxx[label];
                        int iny = basminy[label];
                        int axy = basmaxy[label];
                        for (int j = iny; j <= axy; ++j) {
                            int i3 = inx;
                            int pos5 = j * width + i3;
                            while (i3 <= axx) {
                                if (baslabels[pos5] == label && (bbresroi[pos5] & 0xFF) != 255) {
                                    bbresroi[pos5] = -1;
                                    ibres[pos5] = num;
                                    bbmodif[pos5] = -1;
                                }
                                ++i3;
                                ++pos5;
                            }
                        }
                        ++num;
                        continue;
                    }
                    if (!(0.35 < max)) continue;
                    label = (Integer)baslist.get(x);
                    int lab = (Integer)reslist.get(maxpos);
                    int inx = basminx[label];
                    int axx = basmaxx[label];
                    int iny = basminy[label];
                    int axy = basmaxy[label];
                    for (int j = iny; j <= axy; ++j) {
                        int i4 = inx;
                        int pos6 = j * width + i4;
                        while (i4 <= axx) {
                            if (baslabels[pos6] == label && (bbresroi[pos6] & 0xFF) != 255) {
                                bbresroi[pos6] = -1;
                                ibres[pos6] = lab;
                                bbmodif[pos6] = -1;
                            }
                            ++i4;
                            ++pos6;
                        }
                    }
                }
                Arrays.fill((Object[])counts, null);
                counts = null;
                Arrays.fill((Object[])basratios, null);
                basratios = null;
                reslist.clear();
                baslist.clear();
            }
            labels = null;
        }
        for (pos = 0; pos < ibbas.length; ++pos) {
            if (bbover[pos] == 0) continue;
            ibbas[pos] = 0;
        }
        for (pos = 0; pos < ibbas.length; ++pos) {
            if (bbmodif[pos] == 0) continue;
            ibbas[pos] = 0;
        }
        this.ccl.Label(basins, 0, true);
        baslabels = this.ccl.Labels1D();
        for (pos = 0; pos < ibbas.length; ++pos) {
            if (baslabels[pos] == 0) continue;
            ibres[pos] = num + baslabels[pos];
            bbresroi[pos] = -1;
            bbmodif[pos] = -1;
        }
        this.ccl.Label(result, 0, true);
        System.arraycopy(this.ccl.Labels1D(), 0, ibres, 0, ibres.length);
        for (int i5 = 0; i5 < bbroi.length; ++i5) {
            if ((bbroi[i5] & 0xFF) != 200 || bbresroi[i5] != 0) continue;
            bbresroi[i5] = -56;
        }
        reslut = null;
        reslabels = null;
        ressizes = null;
        basmaxy = null;
        basminy = null;
        basmaxx = null;
        basminx = null;
        baslut = null;
        baslabels = null;
        bassizes = null;
        ibbas = null;
        ibres = null;
        bbresroi = null;
        bbroi = null;
        bbover = null;
        overlap = this.allocator.Release(overlap);
        modif = this.allocator.Release(modif);
    }

    private void Rename(String output) {
        File f = new File(output + "/Intermediate - WhiteTopHat.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - AreaOpening.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - UltimateEroded.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Watershed - Markers.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - Full Color.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/Nuclei Segmentation.png"));
        }
        f = null;
        f = new File(output + "/Segmentation - ROI.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/Nuclei ROI.png"));
        }
        f = null;
        f = new File(output + "/Watershed - Basins.tif");
        if (f.exists()) {
            f.renameTo(new File(output + "/Nuclei Basins.tif"));
        }
        f = null;
    }

    public void SegmentCells(String inputdir, String outputdir, int nbCPU) throws Exception {
        BufferedImage basins = ImageIO.Read(outputdir + "/Nuclei Basins.tif");
        int max = (int)this.IF.Maximum(basins);
        if (max == 0) {
            this.log.addComment("Cell segmentation impossible in " + outputdir + ", no nuclei found.");
            ImageIO.Write(basins, outputdir + "/Cell Basins.tif", 8);
            return;
        }
        BufferedImage imdapi = ImageIO.Read(outputdir + "/ZProjectionDAPI.png");
        float[] radii = this.FindAdaptedRadii(imdapi, basins);
        BufferedImage skizlabels = this.skiz.Filter(basins, this.sem3, true, radii, nbCPU);
        ImageIO.Write(skizlabels, outputdir + "/Cell Basins.tif", 8);
        BufferedImage dapirgb = ImageConverter.GrayToColor((BufferedImage)imdapi);
        byte[] bbrgb = ((DataBufferByte)dapirgb.getRaster().getDataBuffer()).getData();
        int width = imdapi.getWidth();
        int height = imdapi.getHeight();
        int[] ibwat = ((DataBufferInt)skizlabels.getRaster().getDataBuffer()).getData();
        int pos = 0;
        int posrgb = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (ibwat[pos] != 0) {
                    if (x == 0 || y == 0 || x == width - 1 || y == height - 1 || 0 < x && ibwat[pos - 1] < ibwat[pos] || x < width - 1 && ibwat[pos + 1] < ibwat[pos] || 0 < y && ibwat[pos - width] < ibwat[pos] || y < height - 1 && ibwat[pos + width] < ibwat[pos]) {
                        bbrgb[posrgb] = 0;
                        bbrgb[posrgb + 2] = -1;
                        bbrgb[posrgb + 1] = -1;
                    } else {
                        bbrgb[posrgb + 1] = 0;
                        bbrgb[posrgb] = 0;
                    }
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
        ImageIO.tag = 1;
        ImageIO.Write(dapirgb, outputdir + "/Cell Stainings.png", 6);
        ImageIO.tag = 0;
        bbrgb = null;
        ibwat = null;
        imdapi = this.allocator.Release(imdapi);
        dapirgb = this.allocator.Release(dapirgb);
        skizlabels = this.allocator.Release(skizlabels);
        basins = this.allocator.Release(basins);
        this.allocator.ClearAll(true);
    }

    private float[] FindAdaptedRadii(BufferedImage src, BufferedImage basins) {
        this.ccl.Label(basins, 0, true);
        float[] results = new float[this.ccl.ConnectedComponentsNumber() + 1];
        BufferedImage[] nuclei = this.ccl.SeparateComponents(src, 1, 1);
        for (int i2 = 1; i2 < nuclei.length; ++i2) {
            if (nuclei[i2] == null) continue;
            Measures2D measures = new Measures2D(nuclei[i2]);
            measures.EuclidianRadii();
            measures.MainAxes();
            results[i2] = (float)Math.max(measures.getSmallestRadius(), measures.SecondAxis02.Length() / 2.0);
            measures.Kill();
            measures = null;
        }
        nuclei = null;
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FeaturesExtraction(String inputdir, String segmentationdir, String featuresdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        System.out.println(this.Copyright + "\n");
        this.basic = new BasicMeasures();
        this.dzm = new DZMfeatures();
        this.haralick = new Haralick();
        this.lbp = new LocalBinaryPattern();
        this.ps = new PatternSpectrum();
        this.szm = new SZMfeatures();
        this.sic = new ShapeIndexesComputer();
        this.setFeaturesParameters(this.dzm, this.haralick, this.lbp, this.ps, this.szm, this.sic);
        File resfile = new File(featuresdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        resfile = null;
        this.LoadRoundsCyclesTable(inputdir);
        UnionFindCcl cellccl = new UnionFindCcl();
        this.nbThreads = this.FE_BiasedFeaturesOnly ? 1 : nbCPU;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new ComputeFeaturesThread[this.nbThreads];
            for (int i2 = 0; i2 < this.nbThreads; ++i2) {
                this.threads[i2] = new ComputeFeaturesThread(i2, this.log);
                this.threads[i2].start();
            }
            PartialCyclicIF i2 = this;
            synchronized (i2) {
                while (this.nbFreeThreads != this.nbThreads) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            BufferedImage imdapi = ImageIO.Read(segmentationdir + "/ZProjectionDAPI.png");
            BufferedImage nuclei = ImageIO.Read(segmentationdir + "/Nuclei Basins.tif");
            float[] distmap = this.FE_DistanceFromBorder ? this.ComputeDistances(imdapi, nuclei, segmentationdir, nbCPU) : null;
            this.ccl.ImportLabels(((DataBufferInt)nuclei.getRaster().getDataBuffer()).getData(), nuclei.getWidth(), nuclei.getHeight());
            this.ccl.ComputeBoundingBoxes();
            int[] nuclabels = this.ccl.Labels1D();
            int[] nucsizes = this.ccl.Sizes();
            float[] nucleipos = new float[this.ccl.ConnectedComponentsNumber() + 1];
            BufferedImage cells = ImageIO.Read(segmentationdir + "/Cell Basins.tif");
            cellccl.ImportLabels(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), cells.getWidth(), cells.getHeight());
            System.arraycopy(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), 0, cellccl.Labels1D(), 0, cellccl.Labels1D().length);
            cellccl.ComputeBoundingBoxes();
            int[] cellslabels = cellccl.Labels1D();
            int[] cellsizes = cellccl.Sizes();
            float[] cellspos = new float[cellccl.ConnectedComponentsNumber() + 1];
            float[] ringspos = new float[cellccl.ConnectedComponentsNumber() + 1];
            float[] rimpos = new float[cellccl.ConnectedComponentsNumber() + 1];
            int[] rimcount = new int[cellccl.ConnectedComponentsNumber() + 1];
            this.dmc.ComputeGrayLevel(cells, this.sem3, true);
            float[] rimdm = this.dmc.getMontanariMap1D();
            BufferedImage rgbnuclei = ImageNew.Same((BufferedImage)imdapi, (int)5);
            BufferedImage rgbcells = ImageNew.Same((BufferedImage)cells, (int)5);
            StructuringElement senuclei = null;
            StructuringElement secells = null;
            if (this.FE_SubtractBackground) {
                BufferedImage im = ImageNew.Same((BufferedImage)nuclei, (int)10);
                ImageComparator.Compare((BufferedImage)nuclei, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)im);
                this.dmc.Compute(im, this.sem3);
                int max = (int)(this.AF.Maximum(this.dmc.getMontanariMap1D()) + 0.5);
                senuclei = new StructuringElement(new Object[]{max + 7, -9});
                ImageComparator.Compare((BufferedImage)cells, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)im);
                this.dmc.Compute(im, this.sem3);
                max = (int)(this.AF.Maximum(this.dmc.getMontanariMap1D()) + 0.5);
                secells = new StructuringElement(new Object[]{max + 7, -9});
                im = this.allocator.Release(im);
            }
            for (RoundCycle rc : this.rclist) {
                int i3;
                BufferedImage staining = this.LoadImage(inputdir, rc.round, rc.cycle);
                if (this.FE_SaveImages) {
                    ImageIO.Write(staining, segmentationdir + "/" + rc.marker + ".png", 6);
                }
                BufferedImage postain = this.binary.Filter(staining, rc.minthreshold, nbCPU);
                ImageComparator.Compare((BufferedImage)staining, (String)"<=", (int)rc.maxthreshold, (BufferedImage)postain, (int)0, (BufferedImage)postain);
                short[] sbpos = ((DataBufferUShort)postain.getRaster().getDataBuffer()).getData();
                if (this.FE_SaveImages) {
                    ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)postain), segmentationdir + "/" + rc.marker + "+ Segmentation.png", 6);
                }
                ImageArithmetic.Multiply(staining, (double)rc.exposurebaseline / (double)rc.exposure, staining, 0, 0, 65535, 65535);
                if (this.FE_SaveImages) {
                    ImageIO.Write(staining, segmentationdir + "/" + rc.marker + " Normalized.png", 6);
                }
                Arrays.fill(nucleipos, 0.0f);
                for (i3 = 0; i3 < sbpos.length; ++i3) {
                    if (sbpos[i3] == 0) continue;
                    int n = nuclabels[i3];
                    nucleipos[n] = nucleipos[n] + 1.0f;
                }
                for (i3 = 0; i3 < nucleipos.length; ++i3) {
                    int n = i3;
                    nucleipos[n] = nucleipos[n] / (float)nucsizes[i3];
                }
                Arrays.fill(cellspos, 0.0f);
                for (i3 = 0; i3 < sbpos.length; ++i3) {
                    if (sbpos[i3] == 0) continue;
                    int n = cellslabels[i3];
                    cellspos[n] = cellspos[n] + 1.0f;
                }
                for (i3 = 0; i3 < cellspos.length; ++i3) {
                    int n = i3;
                    cellspos[n] = cellspos[n] / (float)cellsizes[i3];
                }
                Arrays.fill(ringspos, 0.0f);
                for (i3 = 0; i3 < sbpos.length; ++i3) {
                    if (sbpos[i3] == 0 || cellslabels[i3] == 0 || cellslabels[i3] == nuclabels[i3]) continue;
                    int n = cellslabels[i3];
                    ringspos[n] = ringspos[n] + 1.0f;
                }
                for (i3 = 0; i3 < cellspos.length; ++i3) {
                    if (cellsizes[i3] - nucsizes[i3] == 0) {
                        ringspos[i3] = 0.0f;
                        continue;
                    }
                    int n = i3;
                    ringspos[n] = ringspos[n] / (float)(cellsizes[i3] - nucsizes[i3]);
                }
                Arrays.fill(rimpos, 0.0f);
                Arrays.fill(rimcount, 0);
                for (i3 = 0; i3 < sbpos.length; ++i3) {
                    if (cellslabels[i3] == 0 || !(rimdm[i3] <= this.FE_Rim_Size)) continue;
                    int n = cellslabels[i3];
                    rimcount[n] = rimcount[n] + 1;
                    if (sbpos[i3] == 0) continue;
                    int n2 = cellslabels[i3];
                    rimpos[n2] = rimpos[n2] + 1.0f;
                }
                for (i3 = 0; i3 < cellspos.length; ++i3) {
                    if (rimcount[i3] == 0) {
                        rimpos[i3] = 0.0f;
                        continue;
                    }
                    int n = i3;
                    rimpos[n] = rimpos[n] / (float)rimcount[i3];
                }
                switch (rc.type) {
                    case "Nucleus": {
                        List<BufferedImage> nucleilist = this.SeparateNucleiCells(this.ccl, staining);
                        List<BufferedImage> bsnucleilist = null;
                        if (this.FE_SubtractBackground) {
                            BufferedImage imwth = this.wth.Filter(staining, senuclei, nbCPU);
                            bsnucleilist = this.SeparateNucleiCells(this.ccl, imwth);
                            if (this.FE_SaveImages) {
                                ImageIO.Write(imwth, segmentationdir + "/" + rc.marker + " SBnuclei.png", 6);
                            }
                            imwth = this.allocator.Release(imwth);
                        } else {
                            bsnucleilist = ListNew.Clone(nucleilist);
                        }
                        FichierTabule nucfeatures = this.ComputeFeatures(this.ccl, nucleilist, bsnucleilist, nucleipos, distmap, rc, true, nbCPU);
                        nucfeatures.Write(featuresdir + "/Nuclei - " + rc.marker + ".txt", false);
                        nucleilist.clear();
                        bsnucleilist.clear();
                        bsnucleilist = null;
                        nucleilist = null;
                        nucfeatures.Kill();
                        nucfeatures = null;
                        break;
                    }
                    case "Cell": {
                        List<BufferedImage> cellslist = this.SeparateNucleiCells(cellccl, staining);
                        List<BufferedImage> bscellslist = null;
                        if (this.FE_SubtractBackground) {
                            BufferedImage imwth = this.wth.Filter(staining, secells, nbCPU);
                            bscellslist = this.SeparateNucleiCells(cellccl, imwth);
                            if (this.FE_SaveImages) {
                                ImageIO.Write(imwth, segmentationdir + "/" + rc.marker + " SBcells.png", 6);
                            }
                            imwth = this.allocator.Release(imwth);
                        } else {
                            bscellslist = ListNew.Clone(cellslist);
                        }
                        FichierTabule cellfeatures = this.ComputeFeatures(cellccl, cellslist, bscellslist, cellspos, distmap, rc, false, nbCPU);
                        cellfeatures.Write(featuresdir + "/Cells - " + rc.marker + ".txt", false);
                        cellslist.clear();
                        bscellslist.clear();
                        bscellslist = null;
                        cellslist = null;
                        cellfeatures.Kill();
                        cellfeatures = null;
                        break;
                    }
                    case "Ring": {
                        List<BufferedImage> cellsminusnucleilist = this.SeparateCellsMinusNuclei(this.ccl, cellccl, staining);
                        List<BufferedImage> bscellsminusnucleilist = null;
                        if (this.FE_SubtractBackground) {
                            BufferedImage imwth = this.wth.Filter(staining, secells, nbCPU);
                            bscellsminusnucleilist = this.SeparateCellsMinusNuclei(this.ccl, cellccl, imwth);
                            if (this.FE_SaveImages) {
                                ImageIO.Write(imwth, segmentationdir + "/" + rc.marker + " SBcells.png", 6);
                            }
                            imwth = this.allocator.Release(imwth);
                        } else {
                            bscellsminusnucleilist = ListNew.Clone(cellsminusnucleilist);
                        }
                        FichierTabule cellminusnucleifeatures = this.ComputeFeatures(cellccl, cellsminusnucleilist, bscellsminusnucleilist, ringspos, distmap, rc, false, nbCPU);
                        cellminusnucleifeatures.Write(featuresdir + "/Ring - " + rc.marker + ".txt", false);
                        cellsminusnucleilist.clear();
                        bscellsminusnucleilist.clear();
                        bscellsminusnucleilist = null;
                        cellsminusnucleilist = null;
                        cellminusnucleifeatures.Kill();
                        cellminusnucleifeatures = null;
                        break;
                    }
                    case "Rim": {
                        List<BufferedImage> cellsrimlist = this.SeparateCellsRim(rimdm, cellccl, staining);
                        List<BufferedImage> bscellsrimlist = null;
                        if (this.FE_SubtractBackground) {
                            BufferedImage imwth = this.wth.Filter(staining, secells, nbCPU);
                            bscellsrimlist = this.SeparateCellsRim(rimdm, cellccl, imwth);
                            if (this.FE_SaveImages) {
                                ImageIO.Write(imwth, segmentationdir + "/" + rc.marker + " SBcells.png", 6);
                            }
                            imwth = this.allocator.Release(imwth);
                        } else {
                            bscellsrimlist = ListNew.Clone(cellsrimlist);
                        }
                        FichierTabule cellrimfeatures = this.ComputeFeatures(cellccl, cellsrimlist, bscellsrimlist, rimpos, distmap, rc, false, nbCPU);
                        cellrimfeatures.Write(featuresdir + "/Rim - " + rc.marker + ".txt", false);
                        cellsrimlist.clear();
                        bscellsrimlist.clear();
                        bscellsrimlist = null;
                        cellsrimlist = null;
                        cellrimfeatures.Kill();
                        cellrimfeatures = null;
                        break;
                    }
                    case "All": 
                    case "Everything": {
                        BufferedImage imwth;
                        List<BufferedImage> nuclist = this.SeparateNucleiCells(this.ccl, staining);
                        List<BufferedImage> bsnuclist = null;
                        if (this.FE_SubtractBackground) {
                            BufferedImage imwth2 = this.wth.Filter(staining, senuclei, nbCPU);
                            bsnuclist = this.SeparateNucleiCells(this.ccl, imwth2);
                            if (this.FE_SaveImages) {
                                ImageIO.Write(imwth2, segmentationdir + "/" + rc.marker + " SBnuclei.png", 6);
                            }
                            imwth2 = this.allocator.Release(imwth2);
                        } else {
                            bsnuclist = ListNew.Clone(nuclist);
                        }
                        FichierTabule nucleifeatures = this.ComputeFeatures(this.ccl, nuclist, bsnuclist, nucleipos, distmap, rc, true, nbCPU);
                        nucleifeatures.Write(featuresdir + "Nuclei - " + rc.marker + ".txt", false);
                        nuclist.clear();
                        bsnuclist.clear();
                        bsnuclist = null;
                        nuclist = null;
                        nucleifeatures.Kill();
                        nucleifeatures = null;
                        BufferedImage bufferedImage = imwth = this.FE_SubtractBackground ? this.wth.Filter(staining, secells, nbCPU) : null;
                        if (this.FE_SubtractBackground && this.FE_SaveImages) {
                            ImageIO.Write(imwth, segmentationdir + "/" + rc.marker + " SBcells.png", 6);
                        }
                        List<BufferedImage> celllist = this.SeparateNucleiCells(cellccl, staining);
                        List<BufferedImage> bscelllist = this.FE_SubtractBackground ? this.SeparateNucleiCells(cellccl, imwth) : ListNew.Clone(celllist);
                        FichierTabule cellsfeatures = this.ComputeFeatures(cellccl, celllist, bscelllist, cellspos, distmap, rc, false, nbCPU);
                        cellsfeatures.Write(featuresdir + "Cells - " + rc.marker + ".txt", false);
                        celllist.clear();
                        bscelllist.clear();
                        bscelllist = null;
                        List<BufferedImage> cellslist = null;
                        cellsfeatures.Kill();
                        cellsfeatures = null;
                        List<BufferedImage> cellsminusnuclist = this.SeparateCellsMinusNuclei(this.ccl, cellccl, staining);
                        List<BufferedImage> bscellsminusnuclist = this.FE_SubtractBackground ? this.SeparateCellsMinusNuclei(this.ccl, cellccl, imwth) : ListNew.Clone(cellsminusnuclist);
                        FichierTabule cellminusnucfeatures = this.ComputeFeatures(cellccl, cellsminusnuclist, bscellsminusnuclist, ringspos, distmap, rc, false, nbCPU);
                        cellminusnucfeatures.Write(featuresdir + "Ring - " + rc.marker + ".txt", false);
                        cellsminusnuclist.clear();
                        bscellsminusnuclist.clear();
                        bscellsminusnuclist = null;
                        cellsminusnuclist = null;
                        cellminusnucfeatures.Kill();
                        cellminusnucfeatures = null;
                        List<BufferedImage> cellrimlist = this.SeparateCellsRim(rimdm, cellccl, staining);
                        List<BufferedImage> bscellrimlist = this.FE_SubtractBackground ? this.SeparateCellsRim(rimdm, cellccl, imwth) : ListNew.Clone(cellrimlist);
                        FichierTabule cellrimfeats = this.ComputeFeatures(cellccl, cellrimlist, bscellrimlist, rimpos, distmap, rc, false, nbCPU);
                        cellrimfeats.Write(featuresdir + "/Rim - " + rc.marker + ".txt", false);
                        cellrimlist.clear();
                        bscellrimlist.clear();
                        bscellrimlist = null;
                        cellrimlist = null;
                        cellrimfeats.Kill();
                        FichierTabule cellrimfeatures = null;
                        break;
                    }
                    default: {
                        throw new Error("Unknown type '" + rc.type + "'. Must not occur, you moron!!!");
                    }
                }
                if (this.FE_SaveImages) {
                    ImageIO.tag = 1;
                    ImageConverter.GrayToColor((BufferedImage)imdapi, (BufferedImage)rgbnuclei);
                    ImageDrawer.Cells(rgbnuclei, nuclabels, nucleipos, Colors.CYAN, Colors.RED);
                    ImageIO.Write(rgbnuclei, segmentationdir + "/" + rc.marker + " Nuclei+.png", 6);
                    ImageConverter.GrayToColor((BufferedImage)staining, (BufferedImage)rgbcells);
                    ImageDrawer.Cells(rgbcells, cellslabels, cellspos, Colors.CYAN, Colors.RED);
                    ImageIO.Write(rgbcells, segmentationdir + "/" + rc.marker + " Cells+.png", 6);
                    ImageIO.tag = 0;
                }
                sbpos = null;
                postain = null;
                staining = null;
                rc = null;
            }
            Arrays.fill(nucleipos, 1.0f);
            List<BufferedImage> nucleilist = this.SeparateNucleiCells(this.ccl, imdapi);
            List<BufferedImage> bsnucleilist = null;
            if (this.FE_SubtractBackground) {
                BufferedImage imwth = this.wth.Filter(imdapi, senuclei, nbCPU);
                bsnucleilist = this.SeparateNucleiCells(this.ccl, imwth);
                imwth = this.allocator.Release(imwth);
            } else {
                bsnucleilist = ListNew.Clone(nucleilist);
            }
            FichierTabule nucfeatures = this.ComputeFeatures(this.ccl, nucleilist, bsnucleilist, nucleipos, distmap, this.rclist.get(0), true, nbCPU);
            Arrays.fill(nucfeatures.getColumnString(7), "+");
            Arrays.fill(nucfeatures.getColumnDouble(8), 1.0);
            nucfeatures.Write(featuresdir + "/DAPI.txt", false);
            nucleilist.clear();
            bsnucleilist.clear();
            bsnucleilist = null;
            nucleilist = null;
            nucfeatures.Kill();
            nucfeatures = null;
            rgbcells = null;
            rgbnuclei = null;
            cells = null;
            nuclei = null;
            imdapi = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.addNewException(ex, "Cannot extract features from " + segmentationdir);
        }
        catch (Error e) {
            e.printStackTrace();
            this.log.addNewError(e, "Cannot extract features from " + segmentationdir);
        }
        System.out.println("Features extraction done. " + this.Copyright + "\n");
        this.log.Stop();
    }

    private void setFeaturesParameters(DZMfeatures dzm, Haralick haralick, LocalBinaryPattern lbp, PatternSpectrum ps, SZMfeatures szm, ShapeIndexesComputer sic) {
        dzm.Parameters(64, 1, this.sem3.Clone(), false, false, new LinearGLR(64), 0, true);
        haralick.Parameters(new LinearGLR(64), 64, 0);
        lbp.Parameters(this.selbp8.Clone(), 2, 0);
        ps.Parameters(1, 7, 2, 0, -2);
        szm.Parameters(64, 1, new LinearGLR(64), 0, true);
        sic.Indexes[3] = null;
        sic.Indexes[5] = null;
        sic.Indexes[10] = null;
        Arrays.fill(sic.Indexes, 13, 20, null);
        sic.Indexes[22] = null;
        sic.Indexes[24] = null;
        sic.Indexes[25] = null;
    }

    private List<BufferedImage> SeparateNucleiCells(UnionFindCcl ccl, BufferedImage staining) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(ccl.ConnectedComponentsNumber() + 13);
        int width = staining.getWidth();
        int height = staining.getHeight();
        int margin = this.autocrop ? 1 : 0;
        int[] labels = ccl.Labels1D();
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        for (int i2 = 1; i2 <= ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - margin < 0 ? 0 : minx[i2] - margin;
            int sy = miny[i2] - margin < 0 ? 0 : miny[i2] - margin;
            int ex = width <= maxx[i2] + margin ? width - 1 : maxx[i2] + margin;
            int ey = height <= maxy[i2] + margin ? height - 1 : maxy[i2] + margin;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (labels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            if (!this.autocrop) {
                patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2 * margin), (int)(patch.getHeight() + 2 * margin), (int)0);
            }
            images.add(patch);
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    private List<BufferedImage> SeparateCellsMinusNuclei(UnionFindCcl nucccl, UnionFindCcl cellccl, BufferedImage staining) throws IOException {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(this.ccl.ConnectedComponentsNumber() + 13);
        int width = staining.getWidth();
        int height = staining.getHeight();
        int margin = this.autocrop ? 1 : 0;
        int[] minx = cellccl.minx();
        int[] maxx = cellccl.maxx();
        int[] miny = cellccl.miny();
        int[] maxy = cellccl.maxy();
        int[] celllabels = (int[])cellccl.Labels1D().clone();
        ArrayArithmetic.Subtract((int[])celllabels, (int[])nucccl.Labels1D(), (int[])celllabels, (int)0, (int)0);
        for (int i2 = 1; i2 <= this.ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - margin < 0 ? 0 : minx[i2] - margin;
            int sy = miny[i2] - margin < 0 ? 0 : miny[i2] - margin;
            int ex = width <= maxx[i2] + margin ? width - 1 : maxx[i2] + margin;
            int ey = height <= maxy[i2] + margin ? height - 1 : maxy[i2] + margin;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (celllabels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            if (!this.autocrop) {
                patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2), (int)(patch.getHeight() + 2), (int)0);
            }
            images.add(patch);
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    private List<BufferedImage> SeparateCellsRim(float[] dm, UnionFindCcl cellccl, BufferedImage staining) throws IOException {
        int i2;
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(this.ccl.ConnectedComponentsNumber() + 13);
        int width = staining.getWidth();
        int height = staining.getHeight();
        int margin = this.autocrop ? 1 : 0;
        int[] minx = cellccl.minx();
        int[] maxx = cellccl.maxx();
        int[] miny = cellccl.miny();
        int[] maxy = cellccl.maxy();
        int[] celllabels = (int[])cellccl.Labels1D().clone();
        for (i2 = 0; i2 < celllabels.length; ++i2) {
            if (!(dm[i2] > this.FE_Rim_Size)) continue;
            celllabels[i2] = 0;
        }
        for (i2 = 1; i2 <= this.ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - margin < 0 ? 0 : minx[i2] - margin;
            int sy = miny[i2] - margin < 0 ? 0 : miny[i2] - margin;
            int ex = width <= maxx[i2] + margin ? width - 1 : maxx[i2] + margin;
            int ey = height <= maxy[i2] + margin ? height - 1 : maxy[i2] + margin;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (celllabels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            if (!this.autocrop) {
                patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2), (int)(patch.getHeight() + 2), (int)0);
            }
            images.add(patch);
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FichierTabule ComputeFeatures(UnionFindCcl ccl, List<BufferedImage> images, List<BufferedImage> bsimages, float[] overlap, float[] distmap, RoundCycle rc, boolean nuclei, int nbCPU) throws IOException {
        int nbPS = this.ps.Features().length;
        int nbLBP = this.lbp.Features().length;
        int nbHaralick = this.haralick.Features().length;
        int nbSZM = this.szm.Features().length;
        int nbDZM = this.dzm.Features().length;
        int nbSI = this.sic.Features().length;
        int[] types = new int[27 + (this.FE_BiasedFeaturesOnly ? 0 : nbPS + nbLBP + nbHaralick + nbSZM + nbDZM + (nuclei ? nbSI + 3 : 0))];
        Arrays.fill(types, 1);
        Arrays.fill(types, 0, 5, 0);
        types[7] = 2;
        types[9] = 0;
        Arrays.fill(types, 15, 26, 0);
        FichierTabule features = new FichierTabule(ccl.ConnectedComponentsNumber() + 1, types, "");
        features.setColumnName(0, "Label");
        features.setColumnName(1, "MinX");
        features.setColumnName(2, "MinY");
        features.setColumnName(3, "MaxX");
        features.setColumnName(4, "MaxY");
        features.setColumnName(5, "CentroidX");
        features.setColumnName(6, "CentroidY");
        features.setColumnName(7, "Positive");
        features.setColumnName(8, "Overlap");
        features.setColumnName(9, "Surface");
        features.setColumnName(10, "MeanIntensity");
        features.setColumnName(11, "NormalizedMeanIntensity");
        features.setColumnName(12, "VarianceIntensity");
        features.setColumnName(13, "SkewnessIntensity");
        features.setColumnName(14, "KurtosisIntensity");
        features.setColumnName(15, "Rank01");
        features.setColumnName(16, "Rank02.5");
        features.setColumnName(17, "Rank05");
        features.setColumnName(18, "Rank10");
        features.setColumnName(19, "Rank25");
        features.setColumnName(20, "Rank50");
        features.setColumnName(21, "Rank75");
        features.setColumnName(22, "Rank90");
        features.setColumnName(23, "Rank95");
        features.setColumnName(24, "Rank97.5");
        features.setColumnName(25, "Rank99");
        features.setColumnName(26, "DistanceFromBorder");
        if (!this.FE_BiasedFeaturesOnly) {
            int i2;
            int pos = 27;
            String[] names = this.ps.FeaturesNames();
            for (i2 = 0; i2 < nbPS; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            pos += nbPS;
            names = this.lbp.FeaturesNames();
            for (i2 = 0; i2 < nbLBP; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            pos += nbLBP;
            names = this.haralick.FeaturesNames();
            for (i2 = 0; i2 < nbHaralick; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            pos += nbHaralick;
            names = this.szm.FeaturesNames();
            for (i2 = 0; i2 < nbSZM; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            pos += nbSZM;
            names = this.dzm.FeaturesNames();
            for (i2 = 0; i2 < nbDZM; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            if (nuclei) {
                pos += nbDZM;
                names = this.sic.FeaturesNames();
                for (i2 = 0; i2 < nbSI; ++i2) {
                    features.setColumnName(pos + i2, names[i2]);
                }
                features.setColumnName(pos + nbSI, "Orientation");
                features.setColumnName(pos + nbSI + 1, "Main Axis");
                features.setColumnName(pos + nbSI + 2, "Secondary Axis");
            }
        }
        features.setValue(0, 7, this.Copyright);
        int step = (features.Height() - 1) / this.nbThreads;
        this.nbFreeThreads = 0;
        int t = 0;
        for (t = 0; t < this.nbThreads - 1; ++t) {
            this.threads[t].Parameters(features, images, bsimages, t * step, (t + 1) * step, overlap, ccl, distmap, rc, nuclei);
            Object i3 = this.threads[t].lock;
            synchronized (i3) {
                this.threads[t].lock.notify();
                continue;
            }
        }
        this.threads[t].Parameters(features, images, bsimages, t * step, features.Height() - 1, overlap, ccl, distmap, rc, nuclei);
        Object i3 = this.threads[t].lock;
        synchronized (i3) {
            this.threads[t].lock.notify();
        }
        i3 = this;
        synchronized (i3) {
            while (this.nbFreeThreads != this.nbThreads) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        double[] means = features.getColumnDouble(11);
        double minmean = Double.MAX_VALUE;
        for (int i4 = 1; i4 < means.length; ++i4) {
            if (!features.getValueString(i4, 7).equals("+") || !(means[i4] < minmean)) continue;
            minmean = means[i4];
        }
        if (65536.0 < minmean) {
            minmean = rc.minthreshold;
        }
        ArrayArithmetic.Divide((double[])means, (double)minmean, (double[])means);
        means = null;
        return features;
    }

    private float[] ComputeDistances(BufferedImage zproj, BufferedImage labels, String outputdir, int nbCPU) throws IOException {
        int i2;
        BufferedImage im = ImageNew.Same((BufferedImage)labels, (int)10);
        ImageComparator.Compare((BufferedImage)labels, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)im);
        BufferedImage rgb = ImageConverter.GrayToColor((BufferedImage)im);
        BufferedImage closed = this.close.Filter(im, this.sedisk53, nbCPU);
        ImageNew.Copy((BufferedImage)closed, (BufferedImage)im);
        this.pch.Compute(im, null, nbCPU);
        BufferedImage map = this.pch.Hull();
        ImageComparator.Compare((BufferedImage)map, (String)"==", (int)4, (int)255, (int)0, (BufferedImage)map);
        this.ccl.Label(map, 0, true);
        int[] sizes = this.ccl.Sizes();
        int max = this.AF.Maximum(sizes, 1, sizes.length);
        this.ccl.DeleteSmallerThan(map, max);
        ImageComparator.Compare((BufferedImage)map, (String)"==", (int)255, (BufferedImage)im, (int)0, (BufferedImage)im);
        this.pch.Compute(im, null, nbCPU);
        ImageComparator.Compare((BufferedImage)map, (String)"==", (int)4, (int)255, (int)0, (BufferedImage)map);
        BufferedImage dilated = this.dilate.Filter(map, this.sedisk53, nbCPU);
        this.invert.Filter(dilated, dilated, nbCPU);
        BufferedImage contour = ImageOperations.Contour((BufferedImage)dilated, (boolean)true);
        this.pch.Compute(im, contour, nbCPU);
        ImageComparator.Compare((BufferedImage)map, (String)"==", (int)5, (int)255, (int)0, (BufferedImage)map);
        this.close.Filter(map, this.sedisk53, closed, nbCPU);
        this.ccl.Label(closed, 0, true);
        sizes = this.ccl.Sizes();
        max = this.AF.Maximum(sizes, 1, sizes.length);
        this.ccl.DeleteSmallerThan(closed, max);
        ImageIO.Write(closed, outputdir + "/Nuclei Contour Mask.png", 6);
        contour = ImageOperations.Contour((BufferedImage)closed, (boolean)true);
        ImageDrawer.Draw(rgb, contour, Colors.RED);
        ImageIO.Write(rgb, outputdir + "/Nuclei Contour.png", 6);
        max = (int)this.IF.Maximum(labels);
        boolean[] touching = new boolean[max + 1];
        Arrays.fill(touching, false);
        float[] distances = new float[max + 1];
        Arrays.fill(distances, Float.MAX_VALUE);
        ImageComparator.Compare((BufferedImage)contour, (String)"!=", (int)0, (int)0, (int)255, (BufferedImage)map);
        this.dmc.ComputeGrayLevel(map, this.sem3, true);
        float[] distmap = this.dmc.getMontanariMap1D();
        int[] iblabels = ((DataBufferInt)labels.getRaster().getDataBuffer()).getData();
        byte[] bbcontour = ((DataBufferByte)closed.getRaster().getDataBuffer()).getData();
        for (i2 = 0; i2 < iblabels.length; ++i2) {
            if (iblabels[i2] == 0) continue;
            int label = iblabels[i2];
            if (distmap[i2] < distances[label]) {
                distances[label] = distmap[i2];
            }
            if (bbcontour[i2] == 0) continue;
            touching[label] = true;
        }
        for (i2 = 0; i2 < touching.length; ++i2) {
            if (touching[i2]) continue;
            distances[i2] = -1.0f;
        }
        rgb = null;
        map = null;
        dilated = null;
        contour = null;
        closed = null;
        System.gc();
        return distances;
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private void ImprovedDAPI(String inputdir, String outputdir) throws Exception {
        Object[] c1s = new File(inputdir).listFiles((dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains("_c1_"));
        if (c1s == null) {
            throw new IllegalStateException("No Dapi (c1) image found.");
        }
        Arrays.sort(c1s);
        Object[] stack = StackIO.ReadImageSequence((File[])c1s);
        if (c1s.length == 1) {
            ImageIO.Write(stack[0], outputdir + "/ZProjectionDAPI.png", 6);
            Arrays.fill(c1s, null);
            Arrays.fill(stack, null);
            return;
        }
        BufferedImage reszp = ImageNew.Same((BufferedImage)stack[0]);
        this.zp.Classic((BufferedImage[])stack, 2, -9, 13, false, reszp, 4);
        ImageIO.Write(reszp, outputdir + "/ZProjectionDAPI.png", 6);
        reszp = null;
        Arrays.fill(c1s, null);
        Arrays.fill(stack, null);
    }

    private BufferedImage LoadImage(String srcdir, String round, String cycle) throws Exception {
        File[] images = new File(srcdir).listFiles(this.CreateFNF(round, cycle));
        if (images == null) {
            throw new Exception("No image found.");
        }
        if (images.length != 1) {
            throw new Exception(images.length + " image(s) found instead of 1, for '" + srcdir + "', '" + round + "', '" + cycle + "'.");
        }
        return ImageIO.Read(images[0]);
    }

    private FilenameFilter CreateFNF(String round, String cycle) {
        return (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains(round + "_") && name.contains("_" + cycle + "_");
    }

    public void LoadRoundsCyclesTable(String dir) throws Exception {
        if (!this.rclist.isEmpty()) {
            this.rclist.clear();
        }
        Scanner scan = new Scanner(new FileInputStream(dir + "/RoundsCyclesTable.txt"));
        int nb = 1;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            String[] split = line.split(" ");
            if (split.length != 8) {
                System.out.flush();
                System.err.flush();
                System.err.println("Line: '" + line + "'");
                System.err.flush();
                throw new Exception(split.length + " elements instead of 8 in line " + nb);
            }
            if (split[1].charAt(0) != 'R' && split[1].charAt(0) != 'r') {
                throw new Exception("Line " + nb + " round does not start with R or r");
            }
            if (split[2].charAt(0) != 'C' && split[2].charAt(0) != 'c') {
                throw new Exception("Line " + nb + " cycle does not start with C or c");
            }
            this.rclist.add(new RoundCycle(split[0], split[1], split[2], Integer.valueOf(split[3]), Integer.valueOf(split[4]), Integer.valueOf(split[5]), Integer.valueOf(split[6]), split[7]));
            ++nb;
            line = null;
            split = null;
        }
        System.out.println(this.rclist.size() + " lines found. Coordinates:");
        for (RoundCycle rc : this.rclist) {
            System.out.println(rc.marker + " " + rc.round + " " + rc.cycle + " " + rc.minthreshold + " " + rc.maxthreshold + " " + rc.exposurebaseline + " " + rc.exposure + " " + rc.type);
            rc = null;
        }
        Iterator<RoundCycle> iter = null;
    }

    public boolean RenameImages(String inputdir) {
        File file = new File(inputdir);
        boolean success = true;
        return success &= FilesFolders.ReplaceInName(file, "-3-ROI1", "-Scene-051_");
    }

    private class ComputeFeaturesThread
    extends Thread {
        private final BasicMeasures cft_basic;
        private final DZMfeatures cft_dzm;
        private final Haralick cft_haralick;
        private final LocalBinaryPattern cft_lbp;
        private final PatternSpectrum cft_ps;
        private final SZMfeatures cft_szm;
        private final ShapeIndexesComputer cft_sic;
        private final int nbPS;
        private final int nbLBP;
        private final int nbHaralick;
        private final int nbSZM;
        private final int nbDZM;
        private final int nbSI;
        private final ImageFeatures IFt = new ImageFeatures();
        private final LogFile log;
        private int immin = 0;
        private int immax = 0;
        private FichierTabule features = null;
        private List<BufferedImage> images = null;
        private List<BufferedImage> bsimages = null;
        private float[] overlap = null;
        private RoundCycle rc = null;
        private int[] minx = null;
        private int[] maxx = null;
        private int[] miny = null;
        private int[] maxy = null;
        private float[] distmap = null;
        private boolean nuclei = false;
        public final Object lock = new Object();
        private boolean Kill = false;

        public ComputeFeaturesThread(int number, LogFile log) {
            this.cft_basic = new BasicMeasures();
            this.cft_dzm = new DZMfeatures();
            this.cft_haralick = new Haralick();
            this.cft_lbp = new LocalBinaryPattern();
            this.cft_ps = new PatternSpectrum();
            this.cft_szm = new SZMfeatures();
            this.cft_sic = new ShapeIndexesComputer();
            PartialCyclicIF.this.setFeaturesParameters(this.cft_dzm, this.cft_haralick, this.cft_lbp, this.cft_ps, this.cft_szm, this.cft_sic);
            this.nbPS = this.cft_ps.Features().length;
            this.nbLBP = this.cft_lbp.Features().length;
            this.nbHaralick = this.cft_haralick.Features().length;
            this.nbSZM = this.cft_szm.Features().length;
            this.nbDZM = this.cft_dzm.Features().length;
            this.nbSI = this.cft_sic.Features().length;
            this.log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void Parameters(FichierTabule features, List<BufferedImage> images, List<BufferedImage> bsimages, int immin, int immax, float[] overlap, UnionFindCcl ccl, float[] distmap, RoundCycle rc, boolean nuclei) {
            this.features = features;
            this.images = images;
            this.bsimages = bsimages;
            this.immin = immin;
            this.immax = immax;
            this.overlap = overlap;
            this.distmap = distmap;
            this.rc = rc;
            this.nuclei = nuclei;
            this.minx = ccl.minx();
            this.maxx = ccl.maxx();
            this.miny = ccl.miny();
            this.maxy = ccl.maxy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        PartialCyclicIF.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int im = this.immin;
                int nb = im + 1;
                while (true) {
                    if (im >= this.immax) continue block12;
                    try {
                        BufferedImage image = this.images.get(im);
                        BufferedImage bsimage = this.bsimages.get(im);
                        this.features.setValue(nb, 0, nb);
                        this.features.setValue(nb, 1, this.minx[nb]);
                        this.features.setValue(nb, 2, this.miny[nb]);
                        this.features.setValue(nb, 3, this.maxx[nb]);
                        this.features.setValue(nb, 4, this.maxy[nb]);
                        this.features.setValue(nb, 8, this.overlap[nb]);
                        if (ImageTools.isBlack((BufferedImage)bsimage)) {
                            this.features.setValue(nb, 7, "-");
                        } else {
                            this.cft_basic.Compute(bsimage, true);
                            this.features.setValue(nb, 5, (double)this.minx[nb] + this.cft_basic.Centroid.X);
                            this.features.setValue(nb, 6, (double)this.miny[nb] + this.cft_basic.Centroid.Y);
                            this.IFt.Moments(bsimage, 0);
                            this.features.setValue(nb, 9, (int)this.IFt.Size());
                            this.features.setValue(nb, 10, this.IFt.Average());
                            this.features.setValue(nb, 11, this.IFt.Average());
                            this.features.setValue(nb, 12, this.IFt.Variance());
                            this.features.setValue(nb, 13, this.IFt.Skewness());
                            this.features.setValue(nb, 14, this.IFt.Kurtosis());
                            if ((int)this.IFt.Size() < 53) {
                                this.features.setValue(nb, 7, "-");
                            } else {
                                this.IFt.Ranks(bsimage, 0);
                                this.features.setValue(nb, 15, (int)this.IFt.Rank01());
                                this.features.setValue(nb, 16, (int)this.IFt.Rank025());
                                this.features.setValue(nb, 17, (int)this.IFt.Rank05());
                                this.features.setValue(nb, 18, (int)this.IFt.Rank10());
                                this.features.setValue(nb, 19, (int)this.IFt.Rank25());
                                this.features.setValue(nb, 20, (int)this.IFt.Rank50());
                                this.features.setValue(nb, 21, (int)this.IFt.Rank75());
                                this.features.setValue(nb, 22, (int)this.IFt.Rank90());
                                this.features.setValue(nb, 23, (int)this.IFt.Rank95());
                                this.features.setValue(nb, 24, (int)this.IFt.Rank975());
                                this.features.setValue(nb, 25, (int)this.IFt.Rank99());
                                this.features.setValue(nb, 26, this.distmap == null ? -1 : (int)this.distmap[nb]);
                                if (!PartialCyclicIF.this.FE_BiasedFeaturesOnly) {
                                    int i2;
                                    int pos = 27;
                                    this.cft_ps.Compute(bsimage, null, this.cft_ps.ForbiddenValue(), 1);
                                    double[] feat = this.cft_ps.Features();
                                    for (i2 = 0; i2 < feat.length; ++i2) {
                                        this.features.setValue(nb, pos + i2, feat[i2]);
                                    }
                                    pos += this.nbPS;
                                    this.cft_lbp.Compute(bsimage, null, this.cft_lbp.ForbiddenValue(), 1);
                                    feat = this.cft_lbp.Features();
                                    for (i2 = 0; i2 < feat.length; ++i2) {
                                        this.features.setValue(nb, pos + i2, feat[i2]);
                                    }
                                    pos += this.nbLBP;
                                    this.cft_haralick.Compute(bsimage, (BufferedImage)null, this.cft_haralick.ForbiddenValue(), 1);
                                    feat = this.cft_haralick.Features();
                                    for (i2 = 0; i2 < feat.length; ++i2) {
                                        this.features.setValue(nb, pos + i2, feat[i2]);
                                    }
                                    pos += this.nbHaralick;
                                    this.cft_szm.Compute(bsimage, null, this.cft_szm.ForbiddenValue(), 1);
                                    feat = this.cft_szm.Features();
                                    for (i2 = 0; i2 < feat.length; ++i2) {
                                        this.features.setValue(nb, pos + i2, feat[i2]);
                                    }
                                    pos += this.nbSZM;
                                    this.cft_dzm.Compute(bsimage, null, this.cft_dzm.ForbiddenValue(), 1);
                                    feat = this.cft_dzm.Features();
                                    for (i2 = 0; i2 < feat.length; ++i2) {
                                        this.features.setValue(nb, pos + i2, feat[i2]);
                                    }
                                    if (this.nuclei) {
                                        pos += this.nbDZM;
                                        this.cft_sic.Compute(bsimage, null, this.cft_sic.ForbiddenValue(), 1);
                                        feat = this.cft_sic.Features();
                                        for (i2 = 0; i2 < feat.length; ++i2) {
                                            this.features.setValue(nb, pos + i2, feat[i2]);
                                        }
                                        Measures2D measures = new Measures2D(bsimage);
                                        measures.MainAxes();
                                        this.features.setValue(nb, pos + feat.length, measures.getAnglePA(true));
                                        this.features.setValue(nb, pos + feat.length + 1, measures.MainAxis01.Length());
                                        this.features.setValue(nb, pos + feat.length + 2, measures.SecondAxis02.Length());
                                        measures.Kill();
                                        measures = null;
                                    }
                                }
                                this.IFt.Moments(image, 0);
                                if ((double)this.rc.maxthreshold <= this.IFt.Average()) {
                                    this.features.setValue(nb, 7, "x");
                                } else if (0.5f <= this.overlap[nb] || (double)this.rc.minthreshold <= this.IFt.Average()) {
                                    this.features.setValue(nb, 7, "+");
                                } else {
                                    this.features.setValue(nb, 7, "-");
                                }
                                bsimage = null;
                                image = null;
                            }
                        }
                    }
                    catch (Exception ex) {
                        try {
                            ex.printStackTrace();
                            this.log.addNewException(ex, "Cannot extract features from " + (this.nuclei ? "nucleus " : "cell/rim/ring ") + nb + " " + this.rc.marker + " " + this.rc.round + " " + this.rc.cycle);
                            this.features.setValue(nb, 7, "x");
                        }
                        catch (IOException ex1) {
                            ex1.printStackTrace();
                            System.err.println("Log file not accessible, must not occur => Abort!");
                            System.exit(0);
                        }
                    }
                    catch (Error e) {
                        try {
                            e.printStackTrace();
                            this.log.addNewError(e, "Cannot extract features from " + (this.nuclei ? "nucleus " : "cell/rim/ring ") + nb + " " + this.rc.marker + " " + this.rc.round + " " + this.rc.cycle);
                            this.features.setValue(nb, 7, "x");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            System.err.println("Log file not accessible, must not occur => Abort!");
                            System.exit(0);
                        }
                    }
                    ++im;
                    ++nb;
                }
                break;
            }
        }
    }

    private class RoundCycle {
        public final String marker;
        public final String round;
        public final String cycle;
        public final int minthreshold;
        public final int maxthreshold;
        public final int exposurebaseline;
        public final int exposure;
        public final String type;

        public RoundCycle(String marker, String round, String cycle, int minthreshold, int maxthreshold, int exposurebaseline, int exposure, String type) {
            this.marker = marker;
            this.round = round;
            this.cycle = cycle;
            this.minthreshold = minthreshold;
            this.maxthreshold = maxthreshold;
            this.exposurebaseline = exposurebaseline;
            this.exposure = exposure;
            switch (type.toLowerCase()) {
                case "ring": {
                    this.type = "Ring";
                    break;
                }
                case "cell": {
                    this.type = "Cell";
                    break;
                }
                case "nucleus": {
                    this.type = "Nucleus";
                    break;
                }
                case "rim": {
                    this.type = "Rim";
                    break;
                }
                case "all": {
                    this.type = "All";
                    break;
                }
                case "everything": {
                    this.type = "Everything";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: '" + type + "'.");
                }
            }
        }
    }
}

