/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif.old;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import displays.Colors;
import displays.Display;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import listTiTi.ListIO;
import listTiTi.ListTools;
import measures.BasicMeasures;
import measures.Measures2D;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import morphee.Dilate;
import morphee.StructuringElement;
import morphee.filters.AreaOpening;
import morphee.gradients.GradientDE;
import morphee.segmentation.Skiz;
import morphee.segmentation.watershed.Watershed;
import processing.filters.ContrastEqualizer;
import processing.filters.DynamicExpansion;
import processing.filters.gradients.Sobel;
import processing.thresholding.Binary;
import processing.thresholding.Entropy;
import processing.thresholding.Huang;
import processing.thresholding.ImageThresholder;
import processing.thresholding.Li;
import processing.thresholding.Otsu;
import processing.thresholding.Renyi;
import processing.thresholding.TriangleThresholding;
import processing.zprojection.ZProjectionCMM;
import segmentation.cells.DapiMM;
import stackTiTi.StackIO;
import utils.LogFile;
import utils.memory.Allocator;

public class GenericCyclicIF {
    private Allocator allocator = Allocator.Instance();
    private List<RoundCycle> rclist = new LinkedList<RoundCycle>();
    private final int Magnification;
    public Display display = null;
    private ContrastEqualizer equalizer = new ContrastEqualizer();
    private final DapiMM dapi;
    private final DapiMM dapismall;
    private DynamicExpansion dynexp = new DynamicExpansion();
    private FillHole fh = new FillHole();
    private GradientDE gradde = new GradientDE();
    private Skiz skiz = new Skiz();
    private Sobel sobel = new Sobel();
    private UnionFindCcl ccl = new UnionFindCcl();
    private Watershed watershed = new Watershed();
    private ZProjectionCMM zp = new ZProjectionCMM();
    private ImageThresholder[] thresholders = new ImageThresholder[4];
    private StructuringElement sedisk1 = new StructuringElement(new Object[]{1, -2});
    private StructuringElement sedisk2 = new StructuringElement(new Object[]{2, -2});
    private StructuringElement sedisk11 = new StructuringElement(new Object[]{11, -2});
    private StructuringElement sehex1 = new StructuringElement(new Object[]{1, -9});
    private StructuringElement sehex17 = new StructuringElement(new Object[]{17, -9});
    private StructuringElement sehex31 = new StructuringElement(new Object[]{31, -9});
    private StructuringElement sehex53 = new StructuringElement(new Object[]{53, -9});
    private StructuringElement sehex113 = new StructuringElement(new Object[]{113, -9});
    private StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private AreaOpening ao = new AreaOpening();
    private Binary binary = new Binary();
    private Dilate dilate = new Dilate();
    private Huang huang = new Huang();
    private Li li = new Li();
    private Otsu otsu = new Otsu();
    private Renyi renyi = new Renyi();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    public final int TMA = -1;
    public final int CROPS = -2;
    public int Experiment = 0;
    public boolean improvedapi = true;
    public boolean masksegment = true;
    public boolean markersegment = true;
    public boolean nucleisegment = true;
    public boolean cellsegment = true;
    public boolean freememory = true;
    public boolean easymarkers = true;
    public boolean autocrop = this.Experiment == -1;
    private LogFile log = new LogFile();
    public String Segment_WaitForScene = "";
    public boolean SingleWork = false;
    private float CD44radius = 30.0f;
    private float CD45radius = 7.0f;
    private float CKradius = 45.0f;
    private float UNradius = 3.0f;
    public String FE_WaitForScene = "";
    public boolean FE_SaveImages = true;
    private BasicMeasures basic = new BasicMeasures();
    public String FT_WaitForScene = "";
    private int cropBottom = -1;
    private int cropTop = -1;
    private int cropLeft = -1;
    private int cropRight = -1;

    public GenericCyclicIF(int Magnification) {
        switch (Magnification) {
            case 20: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.Magnification = Magnification;
        this.dapi = new DapiMM(Magnification, false);
        this.dapismall = new DapiMM(Magnification, true);
        this.thresholders[0] = new Li();
        this.thresholders[1] = new Huang();
        this.thresholders[2] = new Otsu();
        this.thresholders[3] = new TriangleThresholding();
    }

    public void Segment(String inputdir, String outputdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        System.out.println("\n\nProcessing '" + inputdir + "':");
        List<String> scenes = this.FindScenes(inputdir);
        System.out.print(scenes.size() + " scene(s) found: ");
        ListIO.Display(scenes, " ");
        this.LoadRoundsCyclesTable(inputdir);
        List<String> SegmentationMarkers = Arrays.asList("Ecad", "CD44", "CD45", "CK5", "CK7", "CK14", "CK19");
        this.CheckUsefulMarkersList(SegmentationMarkers);
        ListIO.Display(SegmentationMarkers, "Markers used for segmentation", " ");
        ArrayList<String> SegmentationMarkers2 = new ArrayList<String>(SegmentationMarkers);
        SegmentationMarkers2.add("Unstained");
        List<String> NormalNucleiMarkers = Arrays.asList("Ecad", "CD45", "CK5", "CK7", "CK14", "CK19");
        this.CheckUsefulMarkersList(NormalNucleiMarkers);
        ArrayList<String> NormalNucleiMarkers2 = new ArrayList<String>(NormalNucleiMarkers);
        NormalNucleiMarkers2.add("Unstained");
        List<String> SmallNucleiMarkers = Arrays.asList("CD44");
        this.CheckUsefulMarkersList(SmallNucleiMarkers);
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        if (this.improvedapi) {
            this.ImprovedDAPI(inputdir, scenes, outputdir);
        }
        boolean work = this.Segment_WaitForScene.isEmpty();
        String scene = null;
        Iterator<String> iter = scenes.iterator();
        while (iter.hasNext()) {
            try {
                boolean keepworking = true;
                scene = iter.next();
                if (!work) {
                    if (!scene.equalsIgnoreCase(this.Segment_WaitForScene)) continue;
                    work = true;
                }
                BufferedImage imdapi = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
                if (this.masksegment) {
                    keepworking &= this.FindMask(imdapi, outputdir, scene, nbCPU);
                }
                if (keepworking) {
                    keepworking &= this.FindCropSize(outputdir, scene, nbCPU);
                }
                BufferedImage unstained = ImageNew.Same((BufferedImage)imdapi);
                ImageOperations.Fill((BufferedImage)unstained, (int)65535);
                if (keepworking) {
                    this.AutoCrop(unstained);
                }
                if (keepworking && this.markersegment) {
                    try {
                        for (String markername : SegmentationMarkers) {
                            RoundCycle rc = this.FindMarker(markername);
                            BufferedImage immarker = this.LoadImage(inputdir, scene, rc.round, rc.cycle);
                            BufferedImage segmentedmarker = this.MarkersEasySegmentation(immarker, markername, outputdir, scene, nbCPU);
                            ImageComparator.Compare((BufferedImage)segmentedmarker, (String)"==", (int)0, (BufferedImage)unstained, (int)0, (BufferedImage)unstained);
                            segmentedmarker = this.allocator.Release(segmentedmarker);
                            immarker = null;
                            markername = null;
                            rc = null;
                        }
                        Iterator<String> markers = null;
                        if (this.freememory) {
                            this.allocator.ClearAll(true);
                        }
                        ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)unstained), outputdir + "/Scene " + scene + " - Unstained Segmentation.png", 6);
                        unstained = this.allocator.Release(unstained);
                        this.allocator.ClearAll(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.addNewException(e, new String[0]);
                        this.log.addComment("Cannot find/process marker image for scene " + scene);
                        keepworking = false;
                    }
                }
                if (keepworking && this.nucleisegment) {
                    try {
                        BufferedImage mask = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei Safety Mask.png"));
                        BufferedImage uns = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - Unstained Segmentation.png"));
                        for (String markername : SegmentationMarkers) {
                            BufferedImage image = ImageIO.Read(outputdir + "/Scene " + scene + " - " + markername + " Segmentation.png");
                            BufferedImage immarker = ImageConverter.BinaryToUShortGray((BufferedImage)image);
                            ImageComparator.Compare((BufferedImage)uns, (String)"!=", (int)0, (BufferedImage)uns, (BufferedImage)immarker, (BufferedImage)uns);
                            immarker = this.allocator.Release(immarker);
                            image = null;
                            markername = null;
                        }
                        Iterator<String> segmarkers = null;
                        BufferedImage maskdil = this.dilate.Filter(uns, this.sedisk11, nbCPU);
                        ImageComparator.Compare((BufferedImage)mask, (String)"<", (BufferedImage)maskdil, (BufferedImage)mask, (BufferedImage)maskdil, (BufferedImage)maskdil);
                        this.SegmentNuclei(imdapi, maskdil, false, scene, "BigNuclei", outputdir, nbCPU);
                        maskdil = this.allocator.Release(maskdil);
                        this.allocator.ClearAll(true);
                        BufferedImage smallmask = ImageNew.Same((BufferedImage)uns);
                        for (String markername : SmallNucleiMarkers) {
                            BufferedImage image = ImageIO.Read(outputdir + "/Scene " + scene + " - " + markername + " Segmentation.png");
                            BufferedImage immarker = ImageConverter.BinaryToUShortGray((BufferedImage)image);
                            ImageComparator.Compare((BufferedImage)smallmask, (String)"!=", (int)0, (BufferedImage)smallmask, (BufferedImage)immarker, (BufferedImage)smallmask);
                            immarker = this.allocator.Release(immarker);
                            image = null;
                            markername = null;
                        }
                        Iterator<String> smallmarkers = null;
                        if (!ImageTools.isBlack((BufferedImage)smallmask)) {
                            maskdil = this.dilate.Filter(smallmask, this.sedisk11, nbCPU);
                            ImageComparator.Compare((BufferedImage)mask, (String)"<", (BufferedImage)maskdil, (BufferedImage)mask, (BufferedImage)maskdil, (BufferedImage)maskdil);
                            this.SegmentNuclei(imdapi, maskdil, true, scene, "SmallNuclei", outputdir, nbCPU);
                            maskdil = this.allocator.Release(maskdil);
                        }
                        smallmask = this.allocator.Release(smallmask);
                        mask = this.allocator.Release(mask);
                        uns = this.allocator.Release(uns);
                        this.allocator.ClearAll(true);
                        this.SplitSegmentations(outputdir, scene, NormalNucleiMarkers2, "BigNuclei");
                        this.SplitSegmentations(outputdir, scene, SmallNucleiMarkers, "SmallNuclei");
                        this.allocator.ClearAll(true);
                        this.MergeSegmentations(outputdir, scene, SegmentationMarkers2);
                        this.allocator.ClearAll(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.addNewException(e, new String[0]);
                        this.log.addComment("Cannot segment nuclei for scene " + scene);
                        keepworking = false;
                    }
                }
                if (keepworking && this.cellsegment) {
                    try {
                        this.SegmentCells(inputdir, outputdir, scene, nbCPU);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.addNewException(e, new String[0]);
                        this.log.addComment("Cannot segment cells for scene " + scene);
                        keepworking = false;
                    }
                }
                scene = null;
                if (!this.SingleWork) continue;
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot segment scene " + scene);
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, new String[0]);
                this.log.addComment("Cannot segment scene " + scene);
            }
        }
        iter = null;
        this.log.Stop();
    }

    private void SegmentNuclei(BufferedImage nuclei, BufferedImage mask, boolean small, String scene, String name, String output, int nbCPU) throws IOException, InterruptedException {
        boolean dirtybackground = false;
        int simplifytexture = 2;
        boolean equalize = false;
        boolean fillholes = true;
        boolean DeleteOnTop = true;
        boolean roi100saver = false;
        if (small) {
            this.dapismall.Segmentation(nuclei, false, 2, false, true, true, false, mask, 60, output, nbCPU);
        } else {
            this.dapi.Segmentation(nuclei, false, 2, false, true, true, false, mask, 120, output, nbCPU);
        }
        this.Rename(scene, name, output);
    }

    private boolean FindMask(BufferedImage dapi, String outputdir, String scene, int nbCPU) throws IOException {
        BufferedImage gray = ImageConverter.UShortGrayToGray((BufferedImage)dapi, (boolean)true);
        BufferedImage equal = this.equalizer.Filter(gray, ContrastEqualizer.Equalization.CLAHE, nbCPU);
        BufferedImage dapimp = ImageConverter.GrayToUShort((BufferedImage)equal, (boolean)true);
        ImageIO.Write(dapimp, outputdir + "/Scene " + scene + " - ZProjectionDAPI CE.png", 6);
        gray = this.allocator.Release(gray);
        equal = this.allocator.Release(equal);
        BufferedImage bin = ImageNew.Same((BufferedImage)dapimp);
        this.huang.Filter(dapimp, bin, nbCPU);
        this.li.Filter(dapimp, bin, nbCPU);
        this.otsu.Filter(dapimp, bin, nbCPU);
        this.renyi.Filter(dapimp, bin, nbCPU);
        int[] thres = new int[]{this.huang.getThreshold(0), this.li.getThreshold(0), this.otsu.getThreshold(0), this.renyi.getThreshold(0)};
        Arrays.sort(thres);
        switch (this.Experiment) {
            case -2: {
                this.binary.Filter(dapimp, thres[0], bin, nbCPU);
                break;
            }
            case -1: {
                this.binary.Filter(dapimp, 3 * (thres[1] + thres[2]) >> 2, bin, nbCPU);
                break;
            }
            default: {
                throw new IllegalStateException("Experiment not supported or not defined.");
            }
        }
        dapimp = this.allocator.Release(dapimp);
        BufferedImage binao = this.ao.Filter(bin, 250, true);
        this.dilate.Filter(binao, this.sedisk2, bin, nbCPU);
        this.fh.Fill(bin, (ConnectedComponentLabeling)this.ccl, 750, true, binao);
        bin = this.allocator.Release(bin);
        ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)binao), outputdir + "/Scene " + scene + " - Nuclei Safety Mask.png", 6);
        if (ImageTools.isBlack((BufferedImage)binao)) {
            binao = this.allocator.Release(binao);
            this.log.addComment("No nuclei found (empty mask) in scene " + scene);
            return false;
        }
        binao = this.allocator.Release(binao);
        return true;
    }

    public void SplitSegmentations(String outputdir, String scene, List<String> markers, String Key2) throws IOException {
        int i2;
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + Key2 + "+ Basins.tif");
        int[] ibbasins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        this.ccl.Label(basins, 0, true);
        int[] labels = this.ccl.Labels1D();
        int[] sizes = this.ccl.Sizes();
        this.ccl.ComputeBoundingBoxes();
        BufferedImage roi = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + Key2 + "+ ROI.png");
        if (this.ccl.ConnectedComponentsNumber() == 0) {
            ImageOperations.Fill((BufferedImage)basins, (int)0);
            ImageOperations.Fill((BufferedImage)roi, (int)0);
            for (int i3 = 0; i3 < markers.size(); ++i3) {
                String name = markers.get(i3);
                ImageIO.Write(basins, outputdir + "/Scene " + scene + " - Nuclei " + name + "+ Basins.tif", 8);
                ImageIO.Write(roi, outputdir + "/Scene " + scene + " - Nuclei " + name + "+ Segmentation.png", 6);
                ImageIO.Write(roi, outputdir + "/Scene " + scene + " - Nuclei " + name + "+ ROI.png", 6);
                name = null;
            }
            roi = null;
            basins = null;
            return;
        }
        int width = basins.getWidth();
        int length = ibbasins.length;
        Object[] immarkers = new BufferedImage[markers.size()];
        byte[][] bbim = new byte[markers.size()][];
        for (int i4 = 0; i4 < markers.size(); ++i4) {
            immarkers[i4] = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - " + markers.get(i4) + " Segmentation.png"));
            bbim[i4] = ((DataBufferByte)immarkers[i4].getRaster().getDataBuffer()).getData();
        }
        System.arraycopy(this.ccl.Labels1D(), 0, ibbasins, 0, length);
        int[][] overlaps = new int[this.ccl.ConnectedComponentsNumber() + 1][markers.size()];
        for (int i5 = 0; i5 < labels.length; ++i5) {
            if (0 >= labels[i5]) continue;
            int label = ibbasins[i5];
            for (int m = 0; m < markers.size(); ++m) {
                if (0 == bbim[m][i5]) continue;
                int[] nArray = overlaps[label];
                int n = m;
                nArray[n] = nArray[n] + 1;
            }
        }
        Arrays.fill(immarkers, null);
        Arrays.fill((Object[])bbim, null);
        BufferedImage imdapi = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
        Object[] dapis = new BufferedImage[markers.size()];
        Object[] bass = new BufferedImage[markers.size()];
        Object[] rois = new BufferedImage[markers.size()];
        for (i2 = 0; i2 < markers.size(); ++i2) {
            dapis[i2] = ImageConverter.GrayToColor((BufferedImage)imdapi);
            bass[i2] = ImageNew.Same((BufferedImage)basins);
            rois[i2] = ImageNew.Same((BufferedImage)roi);
        }
        for (i2 = 1; i2 < this.ccl.ConnectedComponentsNumber() + 1; ++i2) {
            int index = this.AF.MaximumIndex(overlaps[i2]);
            if (!(0.5 < (double)overlaps[i2][index] / (double)sizes[i2])) continue;
            byte[] bbro = ((DataBufferByte)rois[index].getRaster().getDataBuffer()).getData();
            int[] ibbas = ((DataBufferInt)((BufferedImage)bass[index]).getRaster().getDataBuffer()).getData();
            int sx = this.ccl.minx()[i2];
            int sy = this.ccl.miny()[i2];
            int ex = this.ccl.maxx()[i2];
            int ey = this.ccl.maxy()[i2];
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = y * width + x;
                while (x <= ex) {
                    if (labels[pos] == i2) {
                        ibbas[pos] = i2;
                        bbro[pos] = -1;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        for (i2 = 0; i2 < markers.size(); ++i2) {
            ImageComparator.Compare((BufferedImage)roi, (String)"!=", (int)200, (BufferedImage)rois[i2], (int)200, (BufferedImage)rois[i2]);
            this.ccl.Label(bass[i2], 0, true);
            System.arraycopy(this.ccl.Labels1D(), 0, ((DataBufferInt)((BufferedImage)bass[i2]).getRaster().getDataBuffer()).getData(), 0, length);
            DapiMM.Paint((BufferedImage)bass[i2], (BufferedImage)rois[i2], (BufferedImage)dapis[i2]);
            String name = markers.get(i2);
            ImageIO.Write((BufferedImage)bass[i2], outputdir + "/Scene " + scene + " - Nuclei " + name + "+ Basins.tif", 8);
            ImageIO.Write((BufferedImage)dapis[i2], outputdir + "/Scene " + scene + " - Nuclei " + name + "+ Segmentation.png", 6);
            ImageIO.Write((BufferedImage)rois[i2], outputdir + "/Scene " + scene + " - Nuclei " + name + "+ ROI.png", 6);
        }
        overlaps = null;
        roi = null;
        imdapi = null;
        ibbasins = null;
        basins = null;
        Arrays.fill(dapis, null);
        Arrays.fill(bass, null);
        Arrays.fill(rois, null);
        File file = new File(outputdir + "/Scene " + scene + " - Nuclei " + Key2 + "+ Basins.tif");
        file.delete();
        file = new File(outputdir + "/Scene " + scene + " - Nuclei " + Key2 + "+ ROI.png");
        file.delete();
        file = new File(outputdir + "/Scene " + scene + " - Nuclei " + Key2 + "+ Segmentation.png");
        file.delete();
    }

    public void MergeSegmentations(String outputdir, String scene, List<String> markers) throws IOException {
        String marker = markers.get(0);
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Basins.tif");
        BufferedImage roi = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ ROI.png");
        this.Delete(outputdir, scene, marker);
        for (int i2 = 1; i2 < markers.size(); ++i2) {
            marker = markers.get(i2);
            this.SortLabeling(outputdir, scene, marker, basins, roi);
            this.allocator.ClearAll(true);
            this.Delete(outputdir, scene, marker);
        }
        this.dapi.DeleteOnTop(basins);
        this.ccl.Label(basins, 0, true);
        this.dapi.MergeSmallCCs((ConnectedComponentLabeling)this.ccl, 89);
        System.arraycopy(this.ccl.Labels1D(), 0, ((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), 0, this.ccl.Labels1D().length);
        this.ccl.Label(basins, 0, true);
        System.arraycopy(this.ccl.Labels1D(), 0, ((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), 0, this.ccl.Labels1D().length);
        ImageIO.Write(basins, outputdir + "/Scene " + scene + " - Nuclei Segmentation Basins.tif", 8);
        BufferedImage nuclei = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
        BufferedImage rgb = ImageConverter.GrayToColor((BufferedImage)nuclei);
        DapiMM.Paint(basins, roi, rgb);
        ImageIO.tag = 1;
        ImageIO.Write(rgb, outputdir + "/Scene " + scene + " - Nuclei Segmentation Full Color.png", 6);
        ImageIO.tag = 0;
        basins = null;
        roi = null;
        nuclei = null;
        rgb = this.allocator.Release(rgb);
        this.allocator.ClearAll(true);
    }

    private void SortLabeling(String outputdir, String scene, String marker, BufferedImage result, BufferedImage resroi) throws IOException {
        int pos;
        int width = result.getWidth();
        BufferedImage roi = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ ROI.png");
        byte[] bbroi = ((DataBufferByte)roi.getRaster().getDataBuffer()).getData();
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Basins.tif");
        block0 : switch (basins.getType()) {
            case 10: {
                basins = ImageConverter.ByteToInt((BufferedImage)basins);
                break;
            }
            case 11: {
                basins = ImageConverter.ShortToInt((BufferedImage)basins);
                break;
            }
            case 5: 
            case 6: {
                basins = ImageConverter.RGBtoInt((BufferedImage)basins);
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        break block0;
                    }
                }
                throw new IllegalStateException("Unsupported basins format. Must not occur.");
            }
            default: {
                throw new IllegalStateException("Unsupported basins format. Must not occur.");
            }
        }
        int[] ibbas = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        BufferedImage overlap = ImageNew.Same((BufferedImage)basins, (int)10);
        byte[] bbover = ((DataBufferByte)overlap.getRaster().getDataBuffer()).getData();
        BufferedImage modif = ImageNew.Same((BufferedImage)basins, (int)10);
        byte[] bbmodif = ((DataBufferByte)modif.getRaster().getDataBuffer()).getData();
        int[] ibres = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        byte[] bbresroi = ((DataBufferByte)resroi.getRaster().getDataBuffer()).getData();
        for (int pos2 = 0; pos2 < ibbas.length; ++pos2) {
            bbover[pos2] = (byte)((0 < ibbas[pos2] ? 1 : 0) * (0 < ibres[pos2] ? 1 : 0));
        }
        this.ccl.Label(result, 0, true);
        int[] ressizes = (int[])this.ccl.Sizes().clone();
        int[] reslabels = (int[])this.ccl.Labels1D().clone();
        int[] reslut = new int[ressizes.length];
        System.arraycopy(reslabels, 0, ibres, 0, ibres.length);
        int num = ressizes.length;
        this.ccl.Label(basins, 0, true);
        this.ccl.ComputeBoundingBoxes();
        int[] bassizes = (int[])this.ccl.Sizes().clone();
        int[] baslabels = (int[])this.ccl.Labels1D().clone();
        int[] baslut = new int[bassizes.length];
        int[] basminx = (int[])this.ccl.minx().clone();
        int[] basmaxx = (int[])this.ccl.maxx().clone();
        int[] basminy = (int[])this.ccl.miny().clone();
        int[] basmaxy = (int[])this.ccl.maxy().clone();
        if (!ImageTools.isBlack((BufferedImage)overlap)) {
            this.ccl.Label(overlap, 0, true);
            this.ccl.ComputeBoundingBoxes();
            int[] labels = this.ccl.Labels1D();
            for (int cc = 1; cc < this.ccl.ConnectedComponentsNumber(); ++cc) {
                int x;
                int i2;
                int minx = this.ccl.minx()[cc];
                int maxx = this.ccl.maxx()[cc];
                int miny = this.ccl.miny()[cc];
                int maxy = this.ccl.maxy()[cc];
                LinkedList<Integer> baslist = new LinkedList<Integer>();
                LinkedList<Integer> reslist = new LinkedList<Integer>();
                for (int y = miny; y <= maxy; ++y) {
                    int x2 = minx;
                    int pos3 = y * width + x2;
                    while (x2 <= maxx) {
                        if (labels[pos3] == cc) {
                            if (!ListTools.isInList(reslist, (int)reslabels[pos3])) {
                                reslist.add(reslabels[pos3]);
                            }
                            if (!ListTools.isInList(baslist, (int)baslabels[pos3])) {
                                baslist.add(baslabels[pos3]);
                            }
                        }
                        ++x2;
                        ++pos3;
                    }
                }
                Arrays.fill(reslut, -1);
                for (i2 = 0; i2 < reslist.size(); ++i2) {
                    reslut[((Integer)reslist.get((int)i2)).intValue()] = i2;
                }
                Arrays.fill(baslut, -1);
                for (i2 = 0; i2 < baslist.size(); ++i2) {
                    baslut[((Integer)baslist.get((int)i2)).intValue()] = i2;
                }
                int[][] counts = new int[reslist.size()][baslist.size()];
                for (int y = miny; y <= maxy; ++y) {
                    x = minx;
                    int pos4 = y * width + x;
                    while (x <= maxx) {
                        if (labels[pos4] == cc) {
                            int[] nArray = counts[reslut[reslabels[pos4]]];
                            int n = baslut[baslabels[pos4]];
                            nArray[n] = nArray[n] + 1;
                        }
                        ++x;
                        ++pos4;
                    }
                }
                double[][] basratios = new double[counts.length][counts[0].length];
                for (int y = 0; y < counts.length; ++y) {
                    for (int x3 = 0; x3 < counts[0].length; ++x3) {
                        basratios[y][x3] = (double)counts[y][x3] / (double)bassizes[(Integer)baslist.get(x3)];
                    }
                }
                for (x = 0; x < counts[0].length; ++x) {
                    int label;
                    int nbover = 0;
                    int maxpos = -1;
                    double max = 0.0;
                    for (int y = 0; y < counts.length; ++y) {
                        if (0 >= counts[y][x]) continue;
                        ++nbover;
                        if (!(max < basratios[y][x])) continue;
                        max = basratios[y][x];
                        maxpos = y;
                    }
                    if (nbover == 0 || max < 0.35) {
                        label = (Integer)baslist.get(x);
                        int inx = basminx[label];
                        int axx = basmaxx[label];
                        int iny = basminy[label];
                        int axy = basmaxy[label];
                        for (int j = iny; j <= axy; ++j) {
                            int i3 = inx;
                            int pos5 = j * width + i3;
                            while (i3 <= axx) {
                                if (baslabels[pos5] == label && (bbresroi[pos5] & 0xFF) != 255) {
                                    bbresroi[pos5] = -1;
                                    ibres[pos5] = num;
                                    bbmodif[pos5] = -1;
                                }
                                ++i3;
                                ++pos5;
                            }
                        }
                        ++num;
                        continue;
                    }
                    if (!(0.35 < max)) continue;
                    label = (Integer)baslist.get(x);
                    int lab = (Integer)reslist.get(maxpos);
                    int inx = basminx[label];
                    int axx = basmaxx[label];
                    int iny = basminy[label];
                    int axy = basmaxy[label];
                    for (int j = iny; j <= axy; ++j) {
                        int i4 = inx;
                        int pos6 = j * width + i4;
                        while (i4 <= axx) {
                            if (baslabels[pos6] == label && (bbresroi[pos6] & 0xFF) != 255) {
                                bbresroi[pos6] = -1;
                                ibres[pos6] = lab;
                                bbmodif[pos6] = -1;
                            }
                            ++i4;
                            ++pos6;
                        }
                    }
                }
                Arrays.fill((Object[])counts, null);
                counts = null;
                Arrays.fill((Object[])basratios, null);
                basratios = null;
                reslist.clear();
                baslist.clear();
            }
            labels = null;
        }
        for (pos = 0; pos < ibbas.length; ++pos) {
            if (bbover[pos] == 0) continue;
            ibbas[pos] = 0;
        }
        for (pos = 0; pos < ibbas.length; ++pos) {
            if (bbmodif[pos] == 0) continue;
            ibbas[pos] = 0;
        }
        this.ccl.Label(basins, 0, true);
        baslabels = this.ccl.Labels1D();
        for (pos = 0; pos < ibbas.length; ++pos) {
            if (baslabels[pos] == 0) continue;
            ibres[pos] = num + baslabels[pos];
            bbresroi[pos] = -1;
            bbmodif[pos] = -1;
        }
        this.ccl.Label(result, 0, true);
        System.arraycopy(this.ccl.Labels1D(), 0, ibres, 0, ibres.length);
        for (int i5 = 0; i5 < bbroi.length; ++i5) {
            if ((bbroi[i5] & 0xFF) != 200 || bbresroi[i5] != 0) continue;
            bbresroi[i5] = -56;
        }
        reslut = null;
        reslabels = null;
        ressizes = null;
        basmaxy = null;
        basminy = null;
        basmaxx = null;
        basminx = null;
        baslut = null;
        baslabels = null;
        bassizes = null;
        ibbas = null;
        ibres = null;
        bbresroi = null;
        bbroi = null;
        bbover = null;
        overlap = this.allocator.Release(overlap);
        modif = this.allocator.Release(modif);
    }

    private void Rename(String scene, String name, String output) {
        File f = new File(output + "/Intermediate - WhiteTopHat.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - AreaOpening.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - UltimateEroded.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Watershed - Markers.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - Full Color.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/Scene " + scene + " - Nuclei " + name + "+ Segmentation.png"));
        }
        f = null;
        f = new File(output + "/Segmentation - ROI.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/Scene " + scene + " - Nuclei " + name + "+ ROI.png"));
        }
        f = null;
        f = new File(output + "/Watershed - Basins.tif");
        if (f.exists()) {
            f.renameTo(new File(output + "/Scene " + scene + " - Nuclei " + name + "+ Basins.tif"));
        }
        f = null;
    }

    public void SegmentCells(String inputdir, String outputdir, String scene, int nbCPU) throws Exception {
    }

    private double[] FindAdaptedRadii(BufferedImage src, BufferedImage basins) {
        this.ccl.Label(basins, 0, true);
        double[] results = new double[this.ccl.ConnectedComponentsNumber() + 1];
        BufferedImage[] nuclei = this.ccl.SeparateComponents(src, 1, 1);
        for (int i2 = 1; i2 < nuclei.length; ++i2) {
            if (nuclei[i2] != null) {
                Measures2D measures = new Measures2D(nuclei[i2]);
                measures.EuclidianRadii();
                measures.MainAxes();
                results[i2] = Math.max(measures.getSmallestRadius(), measures.SecondAxis02.Length() / 2.0);
                measures.Kill();
                measures = null;
                continue;
            }
            results[i2] = 0.0;
        }
        nuclei = null;
        return results;
    }

    private BufferedImage MarkersEasySegmentation(BufferedImage cdx, String name, String outputdir, String scene, int nbCPU) throws IOException {
        this.AutoCrop(cdx);
        ImageIO.Write(cdx, outputdir + "/Scene " + scene + " - " + name + ".png", 6);
        RoundCycle rc = this.FindMarker(name);
        BufferedImage imthresh = this.binary.Filter(cdx, rc.minthreshold, nbCPU);
        ImageComparator.Compare((BufferedImage)cdx, (String)"<=", (int)rc.maxthreshold, (BufferedImage)imthresh, (int)0, (BufferedImage)imthresh);
        ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)imthresh), outputdir + "/Scene " + scene + " - " + name + " Segmentation.png", 6);
        return imthresh;
    }

    public void FeaturesExtraction(String inputdir, String segmentationdir, String featuresdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        File resfile = new File(featuresdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        resfile = null;
        System.out.println("\n\nProcessing '" + inputdir + "':");
        List<String> scenes = this.FindScenes2(segmentationdir);
        System.out.print(scenes.size() + " scene(s) found: ");
        ListIO.Display(scenes, " ");
        this.LoadRoundsCyclesTable(inputdir);
        UnionFindCcl cellccl = new UnionFindCcl();
        boolean work = this.FE_WaitForScene.isEmpty();
        String scene = null;
        Iterator<String> iterscenes = scenes.iterator();
        while (iterscenes.hasNext()) {
            try {
                scene = iterscenes.next();
                if (!work) {
                    if (!scene.equalsIgnoreCase(this.FE_WaitForScene)) continue;
                    work = true;
                }
                BufferedImage imdapi = ImageIO.Read(segmentationdir + "/Scene " + scene + " - ZProjectionDAPI.png");
                BufferedImage nuclei = ImageIO.Read(segmentationdir + "/Scene " + scene + " - Nuclei Segmentation Basins.tif");
                this.ccl.ImportLabels(((DataBufferInt)nuclei.getRaster().getDataBuffer()).getData(), nuclei.getWidth(), nuclei.getHeight());
                this.ccl.ComputeBoundingBoxes();
                int[] nuclabels = this.ccl.Labels1D();
                int[] nucsizes = this.ccl.Sizes();
                float[] nucleipos = new float[this.ccl.ConnectedComponentsNumber() + 1];
                BufferedImage cells = ImageIO.Read(segmentationdir + "/Scene " + scene + " - Cell Segmentation Basins.tif");
                cellccl.ImportLabels(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), cells.getWidth(), cells.getHeight());
                System.arraycopy(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), 0, cellccl.Labels1D(), 0, cellccl.Labels1D().length);
                cellccl.ComputeBoundingBoxes();
                int[] cellslabels = cellccl.Labels1D();
                int[] cellsizes = cellccl.Sizes();
                float[] cellspos = new float[cellccl.ConnectedComponentsNumber() + 1];
                float[] ringspos = new float[cellccl.ConnectedComponentsNumber() + 1];
                BufferedImage rgbnuclei = ImageNew.Same((BufferedImage)imdapi, (int)5);
                BufferedImage rgbcells = ImageNew.Same((BufferedImage)cells, (int)5);
                for (RoundCycle rc : this.rclist) {
                    int i2;
                    BufferedImage staining = this.LoadImage(inputdir, scene, rc.round, rc.cycle);
                    if (this.FE_SaveImages) {
                        ImageIO.Write(staining, segmentationdir + "/Scene " + scene + " - " + rc.marker + ".png", 6);
                    }
                    BufferedImage postain = this.binary.Filter(staining, rc.minthreshold, nbCPU);
                    ImageComparator.Compare((BufferedImage)staining, (String)"<=", (int)rc.maxthreshold, (BufferedImage)postain, (int)0, (BufferedImage)postain);
                    short[] sbpos = ((DataBufferUShort)postain.getRaster().getDataBuffer()).getData();
                    if (this.FE_SaveImages) {
                        ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)postain), segmentationdir + "/Scene " + scene + " - " + rc.marker + "+ Segmentation.png", 6);
                    }
                    ImageArithmetic.Multiply(staining, (double)rc.exposurebaseline / (double)rc.exposure, staining, 0, 0, 65535, 65535);
                    if (this.FE_SaveImages) {
                        ImageIO.Write(staining, segmentationdir + "/Scene " + scene + " - " + rc.marker + " Normalized.png", 6);
                    }
                    Arrays.fill(nucleipos, 0.0f);
                    for (i2 = 0; i2 < sbpos.length; ++i2) {
                        if (sbpos[i2] == 0) continue;
                        int n = nuclabels[i2];
                        nucleipos[n] = nucleipos[n] + 1.0f;
                    }
                    for (i2 = 0; i2 < nucleipos.length; ++i2) {
                        int n = i2;
                        nucleipos[n] = nucleipos[n] / (float)nucsizes[i2];
                    }
                    Arrays.fill(cellspos, 0.0f);
                    for (i2 = 0; i2 < sbpos.length; ++i2) {
                        if (sbpos[i2] == 0) continue;
                        int n = cellslabels[i2];
                        cellspos[n] = cellspos[n] + 1.0f;
                    }
                    for (i2 = 0; i2 < cellspos.length; ++i2) {
                        int n = i2;
                        cellspos[n] = cellspos[n] / (float)cellsizes[i2];
                    }
                    Arrays.fill(ringspos, 0.0f);
                    for (i2 = 0; i2 < sbpos.length; ++i2) {
                        if (sbpos[i2] == 0 || cellslabels[i2] == 0 || cellslabels[i2] == nuclabels[i2]) continue;
                        int n = cellslabels[i2];
                        ringspos[n] = ringspos[n] + 1.0f;
                    }
                    for (i2 = 0; i2 < cellspos.length; ++i2) {
                        if (cellsizes[i2] - nucsizes[i2] == 0) {
                            ringspos[i2] = 0.0f;
                            continue;
                        }
                        int n = i2;
                        ringspos[n] = ringspos[n] / (float)(cellsizes[i2] - nucsizes[i2]);
                    }
                    switch (rc.type) {
                        case "Nucleus": {
                            List<BufferedImage> nucleilist = this.SeparateNucleiCells(this.ccl, staining);
                            FichierTabule nucfeatures = this.ComputeFeatures(this.ccl, nucleilist, nucleipos, rc, nbCPU);
                            nucfeatures.Write(featuresdir + "/Scene " + scene + " - Nuclei - " + rc.marker + ".txt", false);
                            nucleilist.clear();
                            nucleilist = null;
                            nucfeatures.Kill();
                            nucfeatures = null;
                            break;
                        }
                        case "Cell": {
                            List<BufferedImage> cellslist = this.SeparateNucleiCells(cellccl, staining);
                            FichierTabule cellfeatures = this.ComputeFeatures(cellccl, cellslist, cellspos, rc, nbCPU);
                            cellfeatures.Write(featuresdir + "/Scene " + scene + " - Cells - " + rc.marker + ".txt", false);
                            cellslist.clear();
                            cellslist = null;
                            cellfeatures.Kill();
                            cellfeatures = null;
                            break;
                        }
                        case "Ring": {
                            List<BufferedImage> cellsminusnucleilist = this.SeparateCellsMinusNuclei(this.ccl, cellccl, staining);
                            FichierTabule cellminusnucleifeatures = this.ComputeFeatures(cellccl, cellsminusnucleilist, ringspos, rc, nbCPU);
                            cellminusnucleifeatures.Write(featuresdir + "/Scene " + scene + " - Ring - " + rc.marker + ".txt", false);
                            cellsminusnucleilist.clear();
                            cellsminusnucleilist = null;
                            cellminusnucleifeatures.Kill();
                            cellminusnucleifeatures = null;
                            break;
                        }
                        case "All": {
                            List<BufferedImage> nuclist = this.SeparateNucleiCells(this.ccl, staining);
                            FichierTabule nucleifeatures = this.ComputeFeatures(this.ccl, nuclist, nucleipos, rc, nbCPU);
                            nucleifeatures.Write(featuresdir + "/Scene " + scene + " - Nuclei - " + rc.marker + ".txt", false);
                            nuclist.clear();
                            nuclist = null;
                            nucleifeatures.Kill();
                            nucleifeatures = null;
                            List<BufferedImage> celllist = this.SeparateNucleiCells(cellccl, staining);
                            FichierTabule cellsfeatures = this.ComputeFeatures(cellccl, celllist, cellspos, rc, nbCPU);
                            cellsfeatures.Write(featuresdir + "/Scene " + scene + " - Cells - " + rc.marker + ".txt", false);
                            celllist.clear();
                            List<BufferedImage> cellslist = null;
                            cellsfeatures.Kill();
                            cellsfeatures = null;
                            List<BufferedImage> cellsminusnuclist = this.SeparateCellsMinusNuclei(this.ccl, cellccl, staining);
                            FichierTabule cellminusnucfeatures = this.ComputeFeatures(cellccl, cellsminusnuclist, ringspos, rc, nbCPU);
                            cellminusnucfeatures.Write(featuresdir + "/Scene " + scene + " - Ring - " + rc.marker + ".txt", false);
                            cellsminusnuclist.clear();
                            cellsminusnuclist = null;
                            cellminusnucfeatures.Kill();
                            cellminusnucfeatures = null;
                            break;
                        }
                        default: {
                            throw new Error("Unknown type '" + rc.type + "'. Must not occur, you moron!!!");
                        }
                    }
                    if (this.FE_SaveImages) {
                        ImageIO.tag = 1;
                        ImageConverter.GrayToColor((BufferedImage)imdapi, (BufferedImage)rgbnuclei);
                        ImageDrawer.Cells(rgbnuclei, nuclabels, nucleipos, Colors.CYAN, Colors.RED);
                        ImageIO.Write(rgbnuclei, segmentationdir + "/Scene " + scene + " - " + rc.marker + " Nuclei+.png", 6);
                        ImageConverter.GrayToColor((BufferedImage)staining, (BufferedImage)rgbcells);
                        ImageDrawer.Cells(rgbcells, cellslabels, cellspos, Colors.CYAN, Colors.RED);
                        ImageIO.Write(rgbcells, segmentationdir + "/Scene " + scene + " - " + rc.marker + " Cells+.png", 6);
                        ImageIO.tag = 0;
                    }
                    sbpos = null;
                    postain = null;
                    staining = null;
                    rc = null;
                }
                Arrays.fill(nucleipos, 1.0f);
                List<BufferedImage> nucleilist = this.SeparateNucleiCells(this.ccl, imdapi);
                FichierTabule nucfeatures = this.ComputeFeatures(this.ccl, nucleilist, nucleipos, this.rclist.get(0), nbCPU);
                Arrays.fill(nucfeatures.getColumnString(7), "+");
                Arrays.fill(nucfeatures.getColumnDouble(8), 1.0);
                nucfeatures.Write(featuresdir + "/Scene " + scene + " - DAPI.txt", false);
                nucleilist.clear();
                nucleilist = null;
                nucfeatures.Kill();
                nucfeatures = null;
                rgbcells = null;
                rgbnuclei = null;
                cells = null;
                nuclei = null;
                imdapi = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot extract features from scene " + scene);
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, new String[0]);
                this.log.addComment("Cannot extract features from scene " + scene);
            }
        }
        this.log.Stop();
    }

    private List<BufferedImage> SeparateNucleiCells(UnionFindCcl ccl, BufferedImage staining) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(ccl.ConnectedComponentsNumber() + 13);
        int width = staining.getWidth();
        int height = staining.getHeight();
        int margin = this.autocrop ? 1 : 0;
        int[] labels = ccl.Labels1D();
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        for (int i2 = 1; i2 <= ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - margin < 0 ? 0 : minx[i2] - margin;
            int sy = miny[i2] - margin < 0 ? 0 : miny[i2] - margin;
            int ex = width <= maxx[i2] + margin ? width - 1 : maxx[i2] + margin;
            int ey = height <= maxy[i2] + margin ? height - 1 : maxy[i2] + margin;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (labels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            if (!this.autocrop) {
                patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2 * margin), (int)(patch.getHeight() + 2 * margin), (int)0);
            }
            images.add(patch);
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    private List<BufferedImage> SeparateCellsMinusNuclei(UnionFindCcl nucccl, UnionFindCcl cellccl, BufferedImage staining) throws IOException {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(this.ccl.ConnectedComponentsNumber() + 13);
        int width = staining.getWidth();
        int height = staining.getHeight();
        int margin = this.autocrop ? 1 : 0;
        int[] minx = cellccl.minx();
        int[] maxx = cellccl.maxx();
        int[] miny = cellccl.miny();
        int[] maxy = cellccl.maxy();
        int[] celllabels = (int[])cellccl.Labels1D().clone();
        ArrayArithmetic.Subtract((int[])celllabels, (int[])nucccl.Labels1D(), (int[])celllabels, (int)0, (int)0);
        for (int i2 = 1; i2 <= this.ccl.ConnectedComponentsNumber(); ++i2) {
            int sx = minx[i2] - margin < 0 ? 0 : minx[i2] - margin;
            int sy = miny[i2] - margin < 0 ? 0 : miny[i2] - margin;
            int ex = width <= maxx[i2] + margin ? width - 1 : maxx[i2] + margin;
            int ey = height <= maxy[i2] + margin ? height - 1 : maxy[i2] + margin;
            BufferedImage patch = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (celllabels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            if (!this.autocrop) {
                patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2), (int)(patch.getHeight() + 2), (int)0);
            }
            images.add(patch);
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    private FichierTabule ComputeFeatures(UnionFindCcl ccl, List<BufferedImage> images, float[] overlap, RoundCycle rc, int nbCPU) {
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        int[] types = new int[15];
        Arrays.fill(types, 1);
        Arrays.fill(types, 0, 5, 0);
        types[7] = 2;
        types[9] = 0;
        FichierTabule features = new FichierTabule(ccl.ConnectedComponentsNumber() + 1, types, "");
        features.setColumnName(0, "Label");
        features.setColumnName(1, "MinX");
        features.setColumnName(2, "MinY");
        features.setColumnName(3, "MaxX");
        features.setColumnName(4, "MaxY");
        features.setColumnName(5, "CentroidX");
        features.setColumnName(6, "CentroidY");
        features.setColumnName(7, "Positive");
        features.setColumnName(8, "Overlap");
        features.setColumnName(9, "Area");
        features.setColumnName(10, "MeanIntensity");
        features.setColumnName(11, "NormalizedMeanIntensity");
        features.setColumnName(12, "VarianceIntensity");
        features.setColumnName(13, "SkewnessIntensity");
        features.setColumnName(14, "KurtosisIntensity");
        int nb = 1;
        for (BufferedImage image : images) {
            features.setValue(nb, 0, nb);
            features.setValue(nb, 1, minx[nb]);
            features.setValue(nb, 2, miny[nb]);
            features.setValue(nb, 3, maxx[nb]);
            features.setValue(nb, 4, maxy[nb]);
            features.setValue(nb, 8, overlap[nb]);
            if (ImageTools.isBlack((BufferedImage)image)) {
                features.setValue(nb, 7, "-");
                ++nb;
                continue;
            }
            this.basic.Compute(image, true);
            features.setValue(nb, 5, (double)minx[nb] + this.basic.Centroid.X);
            features.setValue(nb, 6, (double)miny[nb] + this.basic.Centroid.Y);
            this.IF.Moments(image, 0);
            features.setValue(nb, 9, (int)this.IF.Size());
            features.setValue(nb, 10, this.IF.Average());
            features.setValue(nb, 11, this.IF.Average());
            features.setValue(nb, 12, this.IF.Variance());
            features.setValue(nb, 13, this.IF.Skewness());
            features.setValue(nb, 14, this.IF.Kurtosis());
            if ((double)rc.maxthreshold <= this.IF.Average()) {
                features.setValue(nb, 7, "x");
            } else if (0.5f <= overlap[nb] || (double)rc.minthreshold <= this.IF.Average()) {
                features.setValue(nb, 7, "+");
            } else {
                features.setValue(nb, 7, "-");
            }
            ++nb;
        }
        double[] means = features.getColumnDouble(11);
        double minmean = Double.MAX_VALUE;
        for (int i2 = 1; i2 < means.length; ++i2) {
            if (!features.getValueString(i2, 7).equals("+") || !(means[i2] < minmean)) continue;
            minmean = means[i2];
        }
        if (65536.0 < minmean) {
            minmean = rc.minthreshold;
        }
        ArrayArithmetic.Divide((double[])means, (double)minmean, (double[])means);
        means = null;
        return features;
    }

    public void FindThresholds(String inputdir, String segmentationdir, String featuresdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        File resfile = new File(featuresdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        resfile = null;
        System.out.println("\n\nProcessing '" + inputdir + "':");
        List<String> scenes = this.FindScenes2(segmentationdir);
        System.out.print(scenes.size() + " scene(s) found: ");
        ListIO.Display(scenes, " ");
        this.LoadRoundsCyclesTable(inputdir);
        ImageThresholder[] methods = new ImageThresholder[]{new Entropy(), new Huang(), new Li(), new Otsu(), new Renyi(), new TriangleThresholding()};
        String[] methodnames = new String[]{"Entropy", "Huang", "Li", "Otsu", "Renyi", "Triangle", "Entropy Norm", "Huang Norm", "Li Norm", "Otsu Norm", "Renyi Norm", "Triangle Norm"};
        FichierTabule thresholds = new FichierTabule(methodnames.length, new int[]{2, 0}, "");
        thresholds.setColumnName(0, "Method");
        thresholds.setColumnName(1, "Value");
        thresholds.setColumn(0, methodnames);
        boolean work = this.FT_WaitForScene.isEmpty();
        String scene = null;
        Iterator<String> iterscenes = scenes.iterator();
        while (iterscenes.hasNext()) {
            try {
                scene = iterscenes.next();
                if (!work) {
                    if (!scene.equalsIgnoreCase(this.FT_WaitForScene)) continue;
                    work = true;
                }
                for (RoundCycle rc : this.rclist) {
                    int m;
                    BufferedImage staining = this.LoadImage(inputdir, scene, rc.round, rc.cycle);
                    BufferedImage stainingnorm = ImageNew.Same((BufferedImage)staining);
                    ImageArithmetic.Multiply(staining, (double)rc.exposurebaseline / (double)rc.exposure, stainingnorm, 0, 0, 65535, 65535);
                    staining = ImageConverter.UShortGrayToGray((BufferedImage)staining, (boolean)true);
                    stainingnorm = ImageConverter.UShortGrayToGray((BufferedImage)stainingnorm, (boolean)true);
                    BufferedImage bin = ImageNew.Same((BufferedImage)staining);
                    for (m = 0; m < methods.length; ++m) {
                        methods[m].Filter(staining, bin, nbCPU);
                        thresholds.setValue(m, 1, methods[m].getThreshold(0));
                    }
                    for (m = 0; m < methods.length; ++m) {
                        methods[m].Filter(stainingnorm, bin, nbCPU);
                        thresholds.setValue(methods.length + m, 1, methods[m].getThreshold(0));
                    }
                    thresholds.Write(featuresdir + "/Scene " + scene + " - Thresholds - " + rc.marker + ".txt", false);
                    bin = null;
                    stainingnorm = null;
                    staining = null;
                    rc = null;
                }
                System.gc();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot extract features from scene " + scene);
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, new String[0]);
                this.log.addComment("Cannot extract features from scene " + scene);
            }
        }
        thresholds.Kill();
        thresholds = null;
        this.log.Stop();
    }

    public void ImprovedDAPI(String inputdir, List<String> scenes, String outputdir) throws Exception {
        if (scenes == null) {
            scenes = this.FindScenes(inputdir);
        }
        for (String scene : scenes) {
            Object[] c1s = new File(inputdir).listFiles(this.CreateFNF(scene, 1));
            Arrays.sort(c1s);
            Object[] stack = StackIO.ReadImageSequence((File[])c1s);
            BufferedImage reszp = ImageNew.Same((BufferedImage)stack[0]);
            this.zp.Classic((BufferedImage[])stack, 2, -9, 13, false, reszp, 4);
            ImageIO.Write(reszp, outputdir + "/Scene " + scene + " - ZProjectionDAPI.png", 6);
            scene = null;
            reszp = null;
            Arrays.fill(c1s, null);
            Arrays.fill(stack, null);
        }
        Iterator<String> iter = null;
    }

    private boolean FindCropSize(String outputdir, String scene, int nbCPU) throws IOException {
        if (!this.autocrop) {
            return true;
        }
        StructuringElement[] stel = new StructuringElement[]{this.sehex113, this.sehex53, this.sehex31, this.sehex17};
        try {
            int imax;
            int nbccl;
            BufferedImage mask = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei Safety Mask.png"));
            BufferedImage imdil = ImageNew.Same((BufferedImage)mask);
            int iter = 0;
            do {
                this.dilate.Filter(mask, stel[iter++], imdil, nbCPU);
                this.ccl.Label(imdil, 0, true);
                this.ccl.DeleteOnBorder(imdil, new int[0]);
                this.ccl.Label(imdil, 0, true);
            } while ((this.ccl.ConnectedComponentsNumber() == 0 || this.AF.Maximum(this.ccl.Sizes(), 1, this.ccl.Sizes().length) < 2500000) && iter < stel.length);
            do {
                nbccl = this.ccl.ConnectedComponentsNumber();
                this.ccl.Label(imdil, 0, true);
                this.ccl.ComputeBoundingBoxes();
                imax = this.AF.MaximumIndex(this.ccl.Sizes(), 1, this.ccl.Sizes().length);
                ImageDrawer.RectangleFull(imdil, this.ccl.minx()[imax], this.ccl.miny()[imax], this.ccl.maxx()[imax], this.ccl.maxy()[imax], Colors.WHITE);
            } while (nbccl != this.ccl.ConnectedComponentsNumber());
            this.cropTop = this.ccl.miny()[imax];
            this.cropLeft = this.ccl.minx()[imax];
            this.cropBottom = mask.getHeight() - this.ccl.maxy()[imax];
            this.cropRight = mask.getWidth() - this.ccl.maxx()[imax];
            mask = this.allocator.Release(mask);
            imdil = this.allocator.Release(imdil);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.addNewException(ex, new String[0]);
            this.log.addComment("Cannot find crop size for scene " + scene);
            return false;
        }
        catch (Error e) {
            e.printStackTrace();
            this.log.addNewError(e, new String[0]);
            this.log.addComment("Cannot find crop size for scene " + scene);
            return false;
        }
        return true;
    }

    private void AutoCrop(BufferedImage image) {
        if (!this.autocrop) {
            return;
        }
        ImageDrawer.Borders(image, 0, this.cropTop, this.cropBottom, this.cropLeft, this.cropRight);
    }

    private BufferedImage LoadImage(String srcdir, String scene, int round, int cycle) throws Exception {
        File[] images = new File(srcdir).listFiles(this.CreateFNF(scene, round, cycle));
        if (images == null) {
            throw new Exception("No image found.");
        }
        if (images.length != 1) {
            throw new Exception(images.length + " image(s) found instead of 1.");
        }
        return ImageIO.Read(images[0]);
    }

    private BufferedImage LoadImage(String srcdir, String scene, String round, String cycle) throws Exception {
        File[] images = new File(srcdir).listFiles(this.CreateFNF(scene, round, cycle));
        if (images == null) {
            throw new Exception("No image found.");
        }
        if (images.length != 1) {
            throw new Exception(images.length + " image(s) found instead of 1, for '" + srcdir + "', '" + scene + "', '" + round + "', '" + cycle + "'.");
        }
        return ImageIO.Read(images[0]);
    }

    private FilenameFilter CreateFNF(String scene, int cycle) {
        String s1 = "Scene-" + scene;
        String s2 = "_c" + cycle + "_ORG";
        return (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains(s1) && name.contains(s2);
    }

    private FilenameFilter CreateFNF(String scene, int round, int cycle) {
        String s1 = "Scene-" + scene;
        String s2 = "_c" + cycle + "_ORG";
        return (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains("R" + round + "_") && name.contains(s1) && name.contains(s2);
    }

    private FilenameFilter CreateFNF(String scene, String round, String cycle) {
        String s1 = "Scene-" + scene;
        String s2 = "_" + cycle + "_ORG";
        return (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains(round + "_") && name.contains(s1) && name.contains(s2);
    }

    private List<String> FindScenes(String dir) {
        File[] images;
        LinkedList<String> scenes = new LinkedList<String>();
        for (File image : images = new File(dir).listFiles(FileNameFilters.ImagesTIF)) {
            String scene;
            int pos = image.getName().indexOf("Scene");
            if (pos < 0 || ListTools.isInList(scenes, (String)(scene = image.getName().substring(pos + 6, pos + 9)))) continue;
            scenes.add(scene);
        }
        Collections.sort(scenes);
        return scenes;
    }

    private List<String> FindScenes2(String dir) {
        File[] images;
        LinkedList<String> scenes = new LinkedList<String>();
        for (File image : images = new File(dir).listFiles(FileNameFilters.ImagesTIF)) {
            String scene;
            int pos = image.getName().indexOf("Scene ");
            if (pos < 0 || ListTools.isInList(scenes, (String)(scene = image.getName().substring(pos + 6, pos + 9)))) continue;
            scenes.add(scene);
        }
        Collections.sort(scenes);
        return scenes;
    }

    private void CounterCheckScenes(String dir, List<String> scenes) throws Exception {
        ListIterator<String> iter = scenes.listIterator();
        while (iter.hasNext()) {
            String scene = iter.next();
            File[] images = new File(dir).listFiles((f, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains("Scene " + scene));
            if (images.length > 5) continue;
            scenes.remove(scene);
        }
        iter = null;
    }

    public void LoadRoundsCyclesTable(String dir) throws Exception {
        if (!this.rclist.isEmpty()) {
            this.rclist.clear();
        }
        Scanner scan = new Scanner(new FileInputStream(dir + "/RoundsCyclesTable.txt"));
        int nb = 1;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            String[] split = line.split(" ");
            if (split.length != 8) {
                System.out.flush();
                System.err.flush();
                System.err.println("Line: '" + line + "'");
                System.err.flush();
                throw new Exception(split.length + " elements instead of 8 in line " + nb);
            }
            if (split[1].charAt(0) != 'R' && split[1].charAt(0) != 'r') {
                throw new Exception("Line " + nb + " round does not start with R or r");
            }
            if (split[2].charAt(0) != 'C' && split[2].charAt(0) != 'c') {
                throw new Exception("Line " + nb + " cycle does not start with C or c");
            }
            this.rclist.add(new RoundCycle(split[0], split[1], split[2], Integer.valueOf(split[3]), Integer.valueOf(split[4]), Integer.valueOf(split[5]), Integer.valueOf(split[6]), split[7]));
            ++nb;
            line = null;
            split = null;
        }
        System.out.println(this.rclist.size() + " lines found. Coordinates:");
        for (RoundCycle rc : this.rclist) {
            System.out.println(rc.marker + " " + rc.round + " " + rc.cycle + " " + rc.minthreshold + " " + rc.maxthreshold + " " + rc.exposurebaseline + " " + rc.exposure + " " + rc.type);
            rc = null;
        }
        Iterator<RoundCycle> iter = null;
    }

    private RoundCycle FindMarker(String marker) {
        for (RoundCycle rc : this.rclist) {
            if (rc.marker.equalsIgnoreCase(marker)) {
                return rc;
            }
            Object var3_3 = null;
        }
        return null;
    }

    private void CheckRoundCycleList(String ... markers) throws Exception {
        for (String marker : markers) {
            if (this.FindMarker(marker) != null) continue;
            throw new Exception(marker + " not found!");
        }
        System.out.println("All the markers were found.");
    }

    private void CheckUsefulMarkersList(List<String> list) throws Exception {
        int i2 = 0;
        while (i2 < list.size()) {
            String marker = list.get(i2);
            if (this.FindMarker(marker) == null) {
                list.remove(i2);
                continue;
            }
            ++i2;
        }
    }

    public void Delete(String outputdir, String scene, String marker) throws IOException {
        File file = new File(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Basins.tif");
        file.delete();
        file = new File(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ ROI.png");
        file.delete();
        file = new File(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Segmentation.png");
        file.delete();
        file = null;
    }

    public boolean Rename(String inputdir) {
        File file = new File(inputdir);
        boolean success = true;
        return success &= FilesFolders.ReplaceInName(file, "-3-ROI1", "-Scene-051_");
    }

    private class RoundCycle {
        public final String marker;
        public final String round;
        public final String cycle;
        public final int minthreshold;
        public final int maxthreshold;
        public final int exposurebaseline;
        public final int exposure;
        public final String type;

        public RoundCycle(String marker, String round, String cycle, int minthreshold, int maxthreshold, int exposurebaseline, int exposure, String type) {
            this.marker = marker;
            this.round = round;
            this.cycle = cycle;
            this.minthreshold = minthreshold;
            this.maxthreshold = maxthreshold;
            this.exposurebaseline = exposurebaseline;
            this.exposure = exposure;
            switch (type.toLowerCase()) {
                case "ring": {
                    this.type = "Ring";
                    break;
                }
                case "cell": {
                    this.type = "Cell";
                    break;
                }
                case "nucleus": {
                    this.type = "Nucleus";
                    break;
                }
                case "all": {
                    this.type = "All";
                    break;
                }
                case "everything": {
                    this.type = "Everything";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: '" + type + "'.");
                }
            }
        }
    }
}

